/*
 * Decompiled with CFR 0.152.
 */
package com.gushenge.atools.util;

import android.app.Activity;
import android.content.res.Resources;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.ColorInt;
import androidx.annotation.RequiresApi;
import androidx.core.graphics.ColorUtils;

public class AView {
    public static Boolean isLightColor(@ColorInt int color) {
        return ColorUtils.calculateLuminance((int)color) >= 0.5;
    }

    public static int getStatusBarHeight(Activity context) {
        Resources res = context.getResources();
        int resourceId = res.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return res.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    public static void setMargins(View v, int left, int top, int right, int bottom) {
        if (v.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)v.getLayoutParams();
            p.setMargins(left, top, right, bottom);
            v.setLayoutParams((ViewGroup.LayoutParams)p);
        }
    }

    public static void setStatusBar(Activity activity, Boolean bgColorLight, int NavigationBarColor) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            View decorView = window.getDecorView();
            if (bgColorLight.booleanValue()) {
                decorView.setSystemUiVisibility(9472);
            } else {
                decorView.setSystemUiVisibility(1280);
            }
            window.setStatusBarColor(0);
            window.setNavigationBarColor(NavigationBarColor);
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
        } else {
            Log.e((String)"com.gushenge.atools", (String)"\u60a8\u53ef\u80fd\u5728\u4f4e\u4e8eAndroid5.0\u7684\u8bbe\u5907\u4e2d\u4f7f\u7528\u6b64\u65b9\u6cd5\uff0c\u8bf7\u6ce8\u610f");
        }
    }

    public static void setStatusBar(Activity activity) {
        AView.setStatusBar(activity, true, -16777216);
    }

    public static void hideStatusBar(Activity context, Boolean enable) {
        if (enable.booleanValue()) {
            WindowManager.LayoutParams lp = context.getWindow().getAttributes();
            lp.flags |= 0x400;
            context.getWindow().setAttributes(lp);
            context.getWindow().addFlags(512);
        } else {
            WindowManager.LayoutParams attr2 = context.getWindow().getAttributes();
            attr2.flags &= 0x400;
            context.getWindow().setAttributes(attr2);
            context.getWindow().clearFlags(512);
        }
    }

    @RequiresApi(value=21)
    public static void fullScreen(Activity context) {
        Window windowManager = context.getWindow();
        WindowManager.LayoutParams lp = windowManager.getAttributes();
        lp.flags |= 0x400;
        windowManager.setAttributes(lp);
        View decorView = windowManager.getDecorView();
        decorView.setSystemUiVisibility(2050);
        windowManager.setStatusBarColor(0);
    }
}

