/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.widget.effective;

import android.content.Context;
import android.graphics.Point;
import android.graphics.PointF;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.WindowManager;

public class HCSGestureDetector
extends GestureDetector {
    private final String TAG = ((Object)((Object)this)).getClass().toString();
    public static final int MOVE_UNKNOWN = 0;
    public static final int LEFT_TO_RIGHT = 1;
    public static final int RIGHT_TO_LEFT = 2;
    public static final int TOP_TO_BOTTOM = 3;
    public static final int BOTTOM_TO_TOP = 4;
    OnCustomGestureListener mListener;
    PointF mPoint1Down;
    int mPoint1_ID;
    PointF mPoint2Down;
    int mPoint2_ID;
    PointF mPointMiddleDown;
    int mCurStatus;
    private int mScreenWidth;
    private int mScreenHeight;
    private static final int LEFT = 0;
    private static final int TOP = 1;
    private static final int RIGHT = 2;
    private static final int BOTTOM = 3;
    private static final int UNKNOWN = 4;
    private int mEdgeIn;
    private int mDragDirection;
    private int MAX_DISTANCE_MOVE;

    public HCSGestureDetector(Context context, OnCustomGestureListener listener) {
        super(context, (GestureDetector.OnGestureListener)listener);
        this.mListener = listener;
        this.mPoint1Down = new PointF();
        this.mPoint2Down = new PointF();
        this.mPointMiddleDown = new PointF();
        this.mPoint2_ID = 1;
        this.mPoint1_ID = 0;
        this.mCurStatus = 0;
        this.mEdgeIn = 4;
        this.mDragDirection = 0;
        if (context != null) {
            ViewConfiguration configuration = ViewConfiguration.get((Context)context);
            this.MAX_DISTANCE_MOVE = configuration.getScaledTouchSlop();
            Log.i((String)this.TAG, (String)("MAX_DISTANCE_MOVE = " + this.MAX_DISTANCE_MOVE));
            WindowManager wm = (WindowManager)context.getSystemService("window");
            if (wm != null) {
                DisplayMetrics metric = new DisplayMetrics();
                Display d = wm.getDefaultDisplay();
                d.getMetrics(metric);
                this.mScreenWidth = metric.widthPixels;
                this.mScreenHeight = metric.heightPixels;
                if (Build.VERSION.SDK_INT >= 14 && Build.VERSION.SDK_INT < 17) {
                    try {
                        this.mScreenWidth = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)d, new Object[0]);
                        this.mScreenHeight = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)d, new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (Build.VERSION.SDK_INT >= 17) {
                    try {
                        Point realSize = new Point();
                        Display.class.getMethod("getRealSize", Point.class).invoke((Object)d, realSize);
                        this.mScreenWidth = realSize.x;
                        this.mScreenHeight = realSize.y;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            Log.i((String)this.TAG, (String)("SCREEN W=" + this.mScreenWidth + ",H=" + this.mScreenHeight));
        } else {
            Log.e((String)this.TAG, (String)"context is null!");
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        switch (ev.getAction() & 0xFF) {
            case 0: {
                this.mPoint1Down.set(ev.getX(this.mPoint1_ID), ev.getY(this.mPoint1_ID));
                this.mEdgeIn = this.getEdgeIn(this.mPoint1Down);
                this.mDragDirection = 0;
                Log.i((String)this.TAG, (String)("DOWN= " + this.mPoint1Down.toString()));
                break;
            }
            case 5: {
                this.mPoint2Down.set(ev.getX(this.mPoint2_ID), ev.getY(this.mPoint2_ID));
                this.mPointMiddleDown.set((this.mPoint1Down.x + this.mPoint2Down.x) / 2.0f, (this.mPoint1Down.y + this.mPoint2Down.y) / 2.0f);
                this.mCurStatus = 0;
                this.mListener.OnDoubleFingerDown(ev);
                break;
            }
            case 2: {
                float d;
                if (ev.getPointerCount() == 2) {
                    PointF cur = this.getMiddlePoint(ev);
                    float x = cur.x - this.mPointMiddleDown.x;
                    float y = cur.y - this.mPointMiddleDown.y;
                    float d2 = (float)Math.hypot(x, y);
                    if (!(d2 > (float)this.MAX_DISTANCE_MOVE) || this.mCurStatus != 0) break;
                    if (ev.getX(this.mPoint1_ID) < this.mPoint1Down.x && ev.getX(this.mPoint2_ID) < this.mPoint2Down.x) {
                        this.mListener.OnDoubleFingerStartScroll(ev, 2);
                    } else if (ev.getX(this.mPoint1_ID) > this.mPoint1Down.x && ev.getX(this.mPoint2_ID) > this.mPoint2Down.x) {
                        this.mListener.OnDoubleFingerStartScroll(ev, 1);
                    } else if (ev.getX(this.mPoint1_ID) < this.mPoint1Down.x && ev.getX(this.mPoint2_ID) > this.mPoint2Down.x || ev.getX(this.mPoint1_ID) > this.mPoint1Down.x && ev.getX(this.mPoint2_ID) < this.mPoint2Down.x) {
                        this.mListener.OnDoubleFingerStartZoom(ev);
                    }
                    this.mCurStatus = 1;
                    break;
                }
                if (ev.getPointerCount() != 1) break;
                float x = ev.getX(this.mPoint1_ID) - this.mPoint1Down.x;
                float y = ev.getY(this.mPoint1_ID) - this.mPoint1Down.y;
                if (this.mEdgeIn != 4) {
                    if (this.mEdgeIn == 0 || this.mEdgeIn == 2) {
                        if ((double)x > 0.001) {
                            if (this.mEdgeIn == 0) {
                                this.mListener.OnSingleFingerEdgeIn(ev, 1);
                            }
                            this.mEdgeIn = 4;
                        } else if ((double)x < -0.001) {
                            if (this.mEdgeIn == 2) {
                                this.mListener.OnSingleFingerEdgeIn(ev, 2);
                            }
                            this.mEdgeIn = 4;
                        }
                    } else if (this.mEdgeIn == 1 || this.mEdgeIn == 3) {
                        if ((double)y > 0.001) {
                            if (this.mEdgeIn == 1) {
                                this.mListener.OnSingleFingerEdgeIn(ev, 3);
                            }
                            this.mEdgeIn = 4;
                        } else if ((double)y < -0.001) {
                            if (this.mEdgeIn == 3) {
                                this.mListener.OnSingleFingerEdgeIn(ev, 4);
                            }
                            this.mEdgeIn = 4;
                        }
                    }
                    Log.i((String)this.TAG, (String)("MOVE= " + ev.getX(this.mPoint1_ID) + "," + ev.getY(this.mPoint1_ID)));
                    this.mPoint1Down.set(ev.getX(this.mPoint1_ID), ev.getY(this.mPoint1_ID));
                    break;
                }
                if (this.mDragDirection != 0 || !((d = (float)Math.hypot(x, y)) > (float)this.MAX_DISTANCE_MOVE)) break;
                this.mDragDirection = Math.abs(y) > Math.abs(x) ? (y > 0.0f ? 3 : 4) : (Math.abs(y) < Math.abs(x) ? (x > 0.0f ? 1 : 2) : 0);
                this.mListener.OnSingleFingerDrag(ev, this.mDragDirection, x, y);
                break;
            }
        }
        return super.onTouchEvent(ev);
    }

    public PointF getMiddlePoint(MotionEvent event) {
        if (event.getPointerCount() < 2) {
            return new PointF(event.getX(0), event.getY(0));
        }
        return new PointF((event.getX(0) + event.getX(1)) / 2.0f, (event.getY(0) + event.getY(1)) / 2.0f);
    }

    public int getEdgeIn(PointF p1) {
        if ((double)p1.x >= -0.001 && p1.x <= (float)this.MAX_DISTANCE_MOVE) {
            return 0;
        }
        if ((double)p1.x <= (double)this.mScreenWidth - 0.001 && p1.x >= (float)(this.mScreenWidth - this.MAX_DISTANCE_MOVE)) {
            return 2;
        }
        if ((double)p1.y >= -0.001 && this.mPoint1Down.y <= (float)this.MAX_DISTANCE_MOVE) {
            return 1;
        }
        if ((double)p1.y <= (double)this.mScreenHeight - 0.001 && p1.y >= (float)(this.mScreenHeight - this.MAX_DISTANCE_MOVE)) {
            return 3;
        }
        return 4;
    }

    public static interface OnCustomGestureListener
    extends GestureDetector.OnGestureListener,
    GestureDetector.OnDoubleTapListener {
        public void OnDoubleFingerStartScroll(MotionEvent var1, int var2);

        public void OnDoubleFingerStartZoom(MotionEvent var1);

        public void OnDoubleFingerDown(MotionEvent var1);

        public void OnSingleFingerEdgeIn(MotionEvent var1, int var2);

        public boolean OnSingleFingerDrag(MotionEvent var1, int var2, float var3, float var4);
    }
}

