/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import com.guo.android_extend.R;
import com.guo.android_extend.widget.AbsHAdapterView;

public class HListView
extends AbsHAdapterView {
    Drawable mDivider;
    int mDividerWidth;
    private boolean mClipDivider;
    private boolean mIsCacheColorOpaque;
    private Paint mDividerPaint;
    Drawable mSelector;
    int mSelectorPosition = -1;
    Rect mSelectorRect = new Rect();
    private final Rect mTempRect = new Rect();

    public HListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.onCreate(context, attrs);
    }

    public HListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.onCreate(context, attrs);
    }

    public HListView(Context context) {
        super(context);
    }

    private void onCreate(Context context, AttributeSet attrs) {
        TypedArray att = context.obtainStyledAttributes(attrs, R.styleable.HListView);
        this.mSelector = att.getDrawable(R.styleable.HListView_listSelector);
        int dividerWidth = att.getDimensionPixelSize(R.styleable.HListView_dividerHeight, 0);
        if (dividerWidth != 0) {
            this.setDividerWidth(dividerWidth);
            this.mDividerPaint = new Paint();
            this.mDividerPaint.setColor(-7829368);
        }
        this.mDivider = null;
        att.recycle();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        View child;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int childWidth = 0;
        int childHeight = 0;
        int n = this.mItemCount = this.mAdapter == null ? 0 : this.mAdapter.getCount();
        if (this.mItemCount > 0 && (widthMode == 0 || heightMode == 0)) {
            child = this.obtainView(0);
            this.measureScrapChild(child, 0, heightMeasureSpec);
            childWidth = child.getMeasuredWidth();
            childHeight = child.getMeasuredHeight();
            this.mRecycledViewQueue.offer(child);
        }
        if (widthMode == 0) {
            widthSize = this.mListPadding.left + this.mListPadding.right + childWidth;
        }
        if (heightMode == 0) {
            heightSize = this.mListPadding.top + this.mListPadding.bottom + childHeight;
        }
        if (widthMode == Integer.MIN_VALUE) {
            widthSize = this.measureWidthOfChildren(heightMeasureSpec, 0, -1, widthSize, -1);
        }
        this.setMeasuredDimension(widthSize, heightSize);
        this.mWidthMeasureSpec = widthMeasureSpec;
        this.mHeightMeasureSpec = heightMeasureSpec;
        child = this.obtainView(0);
        if (child == null) {
            return;
        }
        this.measureChild(child, 0);
        this.mMaxDistanceX = this.mAdapter.getCount() * child.getMeasuredWidth() - this.getMeasuredWidth();
        this.mMaxDistanceX += (this.mAdapter.getCount() - 1) * this.mDividerWidth;
        this.mMinDistanceX = 0;
        this.mRecycledViewQueue.offer(child);
        this.mItemWidth = child.getMeasuredWidth();
        this.mItemHeight = child.getMeasuredHeight();
        this.mOverScrollDistance = this.mEnableOverScroll ? widthSize / 2 : 0;
    }

    @Override
    protected void layoutChildren() {
        boolean blockLayoutRequests = this.mBlockLayoutRequests;
        if (blockLayoutRequests) {
            return;
        }
        this.mBlockLayoutRequests = true;
        try {
            super.layoutChildren();
            this.invalidate();
            if (this.mAdapter == null) {
                this.resetList();
                this.invokeOnItemScrollListener();
                return;
            }
            boolean dataChanged = this.mDataChanged;
            if (dataChanged) {
                this.scrollTo(this.mOldCurrentX);
            }
            this.scrollSnap();
            this.invokeOnItemScrollListener();
            this.mDataChanged = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!blockLayoutRequests) {
                this.mBlockLayoutRequests = false;
            }
        }
    }

    @Override
    public ListAdapter getAdapter() {
        return this.mAdapter;
    }

    @Override
    public void setAdapter(ListAdapter adapter) {
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver((DataSetObserver)this.mDataSetObserver);
        }
        this.resetList();
        super.setAdapter(adapter);
        if (this.mAdapter != null) {
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
            this.mDataSetObserver = new AbsHAdapterView.AdapterDataSetObserver();
            this.mAdapter.registerDataSetObserver((DataSetObserver)this.mDataSetObserver);
        }
        this.scrollTo(0);
    }

    @Override
    void fillGapList(int deltaX) {
        if (deltaX <= 0) {
            int rightEdge;
            int right = this.mLastPosition + 1;
            int top = this.mListPadding.top;
            int childCount = this.getChildCount();
            View child = this.getChildAt(childCount - 1);
            int distanceRight = super.getWidth() - super.getPaddingRight();
            int n = rightEdge = child == null ? 0 : child.getRight() + this.mDividerWidth;
            while (rightEdge < distanceRight && right < this.mAdapter.getCount()) {
                this.makeAndAddView(right, rightEdge, true, top);
                rightEdge += this.mItemWidth;
                rightEdge += this.mDividerWidth;
                this.mLastPosition = right++;
            }
        } else {
            int leftEdge;
            int left = this.mFirstPosition - 1;
            int top = this.mListPadding.top;
            View child = this.getChildAt(0);
            int distanceLeft = 0 + super.getPaddingLeft();
            int n = leftEdge = child == null ? 0 : child.getLeft() - this.mDividerWidth;
            while (leftEdge > distanceLeft && left >= 0) {
                this.makeAndAddView(left, leftEdge, false, top);
                leftEdge -= this.mItemWidth;
                leftEdge -= this.mDividerWidth;
                this.mFirstPosition = left--;
            }
        }
    }

    @Override
    void recycleChildren() {
        View child = this.getChildAt(0);
        while (child != null && child.getRight() + this.mDividerWidth <= super.getPaddingLeft()) {
            this.mRecycledViewQueue.offer(child);
            this.removeViewInLayout(child);
            child = this.getChildAt(0);
            ++this.mFirstPosition;
        }
        child = this.getChildAt(this.getChildCount() - 1);
        while (child != null && child.getLeft() >= this.getWidth() - super.getPaddingRight()) {
            this.mRecycledViewQueue.offer(child);
            this.removeViewInLayout(child);
            child = this.getChildAt(this.getChildCount() - 1);
            --this.mLastPosition;
        }
    }

    private View makeAndAddView(int position, int x, boolean flowRight, int childrenTop) {
        View child = null;
        if (!this.mDataChanged && (child = this.obtainView(position)) != null) {
            this.setupChild(child, position, x, flowRight, childrenTop, true);
        }
        return child;
    }

    private void setupChild(View child, int position, int x, boolean flowRight, int childrenTop, boolean recycled) {
        ViewGroup.LayoutParams p = child.getLayoutParams();
        if (p == null) {
            p = this.generateDefaultLayoutParams();
        }
        this.addViewInLayout(child, flowRight ? -1 : 0, p, true);
        int childHeightSpec = ViewGroup.getChildMeasureSpec((int)this.mHeightMeasureSpec, (int)(this.mListPadding.top + this.mListPadding.bottom), (int)p.height);
        int lpWidth = p.width;
        int childWidthSpec = lpWidth > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpWidth, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        child.measure(childWidthSpec, childHeightSpec);
        int w = child.getMeasuredWidth();
        int h = child.getMeasuredHeight();
        int childLeft = flowRight ? x : x - w;
        int childBottom = childrenTop + h;
        int childRight = childLeft + w;
        child.layout(childLeft, childrenTop, childRight, childBottom);
    }

    public Drawable getDivider() {
        return this.mDivider;
    }

    public void setDivider(Drawable divider) {
        if (divider != null) {
            this.mDividerWidth = divider.getIntrinsicWidth();
            this.mClipDivider = divider instanceof ColorDrawable;
        } else {
            this.mDividerWidth = 0;
            this.mClipDivider = false;
        }
        this.mDivider = divider;
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void setCacheColorHint(int color) {
        boolean opaque;
        this.mIsCacheColorOpaque = opaque = color >>> 24 == 255;
        if (opaque) {
            if (this.mDividerPaint == null) {
                this.mDividerPaint = new Paint();
            }
            this.mDividerPaint.setColor(color);
        }
        super.setCacheColorHint(color);
    }

    public int getDividerWidth() {
        return this.mDividerWidth;
    }

    public void setDividerWidth(int width) {
        this.mDividerWidth = width;
        this.requestLayout();
        this.invalidate();
    }

    void drawDivider(Canvas canvas, Rect bounds, int childIndex) {
        Drawable divider = this.mDivider;
        boolean clipDivider = this.mClipDivider;
        if (!clipDivider) {
            divider.setBounds(bounds);
        } else {
            canvas.save();
            canvas.clipRect(bounds);
        }
        divider.draw(canvas);
        if (clipDivider) {
            canvas.restore();
        }
        canvas.drawRect(bounds, new Paint());
    }

    protected void dispatchDraw(Canvas canvas) {
        int dividerWidth = this.mDividerWidth;
        boolean drawDividers = dividerWidth > 0;
        int count = this.getChildCount();
        if (drawDividers && count > 0) {
            int top = this.getPaddingTop();
            int bottom = this.getBottom() - this.getTop() - this.getPaddingBottom();
            int itemCount = this.mItemCount;
            int first = this.mFirstPosition;
            this.mTempRect.top = top;
            this.mTempRect.bottom = bottom;
            this.mTempRect.left = this.getChildAt(0).getRight();
            this.mTempRect.right = this.mTempRect.left + this.mDividerWidth;
            if (this.mDivider == null && this.mDividerPaint == null && this.mIsCacheColorOpaque) {
                this.mDividerPaint = new Paint();
                this.mDividerPaint.setColor(this.getCacheColorHint());
            }
            Paint paint = this.mDividerPaint;
            if (first < itemCount - 1 && this.mTempRect.left < this.getWidth() - this.getPaddingRight()) {
                if (this.mDivider != null) {
                    this.drawDivider(canvas, this.mTempRect, -1);
                } else {
                    canvas.drawRect(this.mTempRect, paint);
                }
            }
            for (int i = 1; i < count; ++i) {
                this.mTempRect.left = this.getChildAt(i).getRight();
                this.mTempRect.right = this.mTempRect.left + this.mDividerWidth;
                if (first + i >= itemCount - 1 || this.mTempRect.left >= this.getWidth() - this.getPaddingRight()) continue;
                if (this.mDivider != null) {
                    this.drawDivider(canvas, this.mTempRect, -1);
                    continue;
                }
                canvas.drawRect(this.mTempRect, paint);
            }
        }
        super.dispatchDraw(canvas);
    }

    private void measureScrapChild(View child, int position, int heightMeasureSpec) {
        ViewGroup.LayoutParams p = child.getLayoutParams();
        if (p == null) {
            p = new ViewGroup.LayoutParams(-1, -2);
            child.setLayoutParams(p);
        }
        int childHeightSpec = ViewGroup.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.mListPadding.top + this.mListPadding.bottom), (int)p.height);
        int lpWidth = p.width;
        int childWidthSpec = lpWidth > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpWidth, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        child.measure(childWidthSpec, childHeightSpec);
    }

    final int measureWidthOfChildren(int heightMeasureSpec, int startPosition, int endPosition, int maxWidth, int disallowPartialChildPosition) {
        ListAdapter adapter = this.mAdapter;
        if (adapter == null) {
            return this.mListPadding.left + this.mListPadding.right;
        }
        int returnedWidth = this.mListPadding.left + this.mListPadding.right;
        int dividerWidth = this.mDividerWidth > 0 && this.mDivider != null ? this.mDividerWidth : 0;
        int prevHeightWithoutPartialChild = 0;
        endPosition = endPosition == -1 ? adapter.getCount() - 1 : endPosition;
        for (int i = startPosition; i <= endPosition; ++i) {
            View child = this.obtainView(i);
            this.measureScrapChild(child, i, heightMeasureSpec);
            if (i > 0) {
                returnedWidth += dividerWidth;
            }
            this.mRecycledViewQueue.offer(child);
            if ((returnedWidth += child.getMeasuredWidth()) >= maxWidth) {
                return disallowPartialChildPosition >= 0 && i > disallowPartialChildPosition && prevHeightWithoutPartialChild > 0 && returnedWidth != maxWidth ? prevHeightWithoutPartialChild : maxWidth;
            }
            if (disallowPartialChildPosition < 0 || i < disallowPartialChildPosition) continue;
            prevHeightWithoutPartialChild = returnedWidth;
        }
        return returnedWidth;
    }

    protected void measureChild(View child, int position) {
        if (child != null) {
            this.measureScrapChild(child, position, this.mHeightMeasureSpec);
        }
    }

    public void scrollTo(int x) {
        this.resetList();
        this.mNextPosX = x;
        if (this.isShown()) {
            int offset = this.mItemWidth + this.mDividerWidth;
            this.makeAndAddView(0, -offset, true, this.mListPadding.top);
        } else {
            View child = this.obtainView(0);
            this.measureChild(child, 0);
            int offset = child.getMeasuredWidth() + this.mDividerWidth;
            this.makeAndAddView(0, -offset, true, this.mListPadding.top);
        }
        this.mFirstPosition = -1;
        this.requestLayout();
    }

    public void scrollBy(int deltaX) {
        this.scrollTo(this.mNextPosX + deltaX);
    }

    public int getScroll() {
        return this.mCurrentX;
    }

    public void scrollToItem(int position) {
        if (this.mAdapter == null) {
            return;
        }
        if (position < this.mAdapter.getCount()) {
            if (this.isShown()) {
                int x = position * (this.mItemWidth + this.mDividerWidth);
                this.scrollTo(x);
            } else {
                View child = this.obtainView(0);
                this.measureChild(child, 0);
                int x = position * (child.getMeasuredWidth() + this.mDividerWidth);
                this.scrollTo(x);
                this.mRecycledViewQueue.offer(child);
            }
        }
    }

    public void scrollSmoothToItem(int position, int duration) {
        if (!this.isShown()) {
            throw new RuntimeException("Don't call scrollSmoothToItem While it's not shown!");
        }
        int x = position * (this.mItemWidth + this.mDividerWidth);
        super.scrollSmoothTo(x, duration);
    }

    public void scrollSmoothToItem(int position) {
        if (!this.isShown()) {
            throw new RuntimeException("Don't call scrollSmoothToItem While it's not shown!");
        }
        int x = position * (this.mItemWidth + this.mDividerWidth);
        super.scrollSmoothTo(x);
    }
}

