/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.widget;

import android.content.Context;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;

public class GestureDetector {
    private final String TAG = this.getClass().toString();
    private float sx;
    private float sy;
    private float mx;
    private float my;
    private float ex;
    private float ey;
    private float distance;
    private int touchMode;
    private int count_scale;
    private int count_translate;
    private GestureListener mGestureListener = null;
    public static int TOUCHMODE_ROTATE_RESTART = -2;
    public static int TOUCHMODE_DOUBLE_PRE = -1;
    public static int TOUCHMODE_NONE = 0;
    public static int TOUCHMODE_ROTATE = 1;
    public static int TOUCHMODE_DOUBLE_SCALE = 2;
    public static int TOUCHMODE_DOUBLE_MOVE = 3;
    private int MAX_DISTANCE_MOVE;
    private int MAX_DETECTED_COUNT;

    public GestureDetector(Context context) {
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.MAX_DISTANCE_MOVE = configuration.getScaledTouchSlop();
        this.MAX_DETECTED_COUNT = 3;
        Log.i((String)this.TAG, (String)("MAX_DISTANCE_MOVE = " + this.MAX_DISTANCE_MOVE));
    }

    public void setGestureListener(GestureListener gestureListener) {
        this.mGestureListener = gestureListener;
    }

    public void onTouch(View view, MotionEvent event) {
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.sx = event.getX(0);
                this.sy = event.getY(0);
                this.touchMode = TOUCHMODE_ROTATE;
                if (this.mGestureListener != null) {
                    this.mGestureListener.single_drag_prepare(this.sx, this.sy);
                }
                this.count_scale = this.MAX_DETECTED_COUNT;
                this.count_translate = this.MAX_DETECTED_COUNT;
                break;
            }
            case 5: {
                this.sx = event.getX(0);
                this.sy = event.getY(0);
                this.ex = event.getX(1);
                this.ey = event.getY(1);
                this.mx = (this.sx + this.ex) / 2.0f;
                this.my = (this.sy + this.ey) / 2.0f;
                this.distance = (float)Math.hypot(this.ex - this.sx, this.ey - this.sy);
                this.touchMode = TOUCHMODE_DOUBLE_PRE;
                break;
            }
            case 1: {
                this.touchMode = TOUCHMODE_NONE;
                break;
            }
            case 6: {
                this.touchMode = TOUCHMODE_ROTATE_RESTART;
                break;
            }
            case 2: {
                if (this.touchMode == TOUCHMODE_ROTATE) {
                    if (this.mGestureListener == null) break;
                    this.mGestureListener.single_drag_process(event.getX(0), event.getY(0));
                    break;
                }
                if (this.touchMode == TOUCHMODE_DOUBLE_PRE) {
                    float ty;
                    float tx;
                    float offset2;
                    if (event.getPointerCount() != 2) break;
                    float temp = (float)Math.hypot(event.getX(0) - event.getX(1), event.getY(0) - event.getY(1));
                    float offset1 = Math.abs(this.distance - temp);
                    if (offset1 > (float)this.MAX_DISTANCE_MOVE) {
                        --this.count_scale;
                        this.distance = temp;
                    }
                    if ((offset2 = (float)Math.hypot(this.mx - (tx = (event.getX(0) + event.getX(1)) / 2.0f), this.my - (ty = (event.getY(0) + event.getY(1)) / 2.0f))) > (float)this.MAX_DISTANCE_MOVE) {
                        --this.count_translate;
                        this.mx = tx;
                        this.my = ty;
                    }
                    if (this.count_scale == 0) {
                        this.touchMode = TOUCHMODE_DOUBLE_SCALE;
                        if (this.mGestureListener != null) {
                            this.mGestureListener.double_scale_prepare(1.0f);
                        }
                    }
                    if (this.count_translate != 0) break;
                    this.touchMode = TOUCHMODE_DOUBLE_MOVE;
                    if (this.mGestureListener == null) break;
                    this.mGestureListener.double_drag_prepare(this.mx, this.my);
                    break;
                }
                if (this.touchMode == TOUCHMODE_ROTATE_RESTART) {
                    if (this.mGestureListener != null) {
                        this.mGestureListener.single_drag_prepare(event.getX(0), event.getY(0));
                        this.mGestureListener.single_drag_process(event.getX(0), event.getY(0));
                    }
                    this.touchMode = TOUCHMODE_ROTATE;
                    break;
                }
                if (this.touchMode == TOUCHMODE_DOUBLE_SCALE) {
                    float temp = (float)Math.hypot(event.getX(0) - event.getX(1), event.getY(0) - event.getY(1));
                    float scale = temp / this.distance;
                    if (this.mGestureListener == null) break;
                    this.mGestureListener.double_scale_process(scale);
                    break;
                }
                if (this.touchMode != TOUCHMODE_DOUBLE_MOVE || this.mGestureListener == null) break;
                float tx = (event.getX(0) + event.getX(1)) / 2.0f;
                float ty = (event.getY(0) + event.getY(1)) / 2.0f;
                this.mGestureListener.double_drag_process(tx, ty);
                break;
            }
        }
    }

    public static interface GestureListener {
        public void single_drag_prepare(float var1, float var2);

        public void single_drag_process(float var1, float var2);

        public void double_scale_prepare(float var1);

        public void double_scale_process(float var1);

        public void double_drag_prepare(float var1, float var2);

        public void double_drag_process(float var1, float var2);
    }
}

