/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import com.guo.android_extend.widget.ExtOrientationDetector;
import com.guo.android_extend.widget.RotateRunable;
import com.guo.android_extend.widget.controller.AbstractController;

public class ExtImageView
extends ImageView
implements AbstractController.ControllerListener,
ExtOrientationDetector.OnOrientationListener,
Animation.AnimationListener {
    private final String TAG = this.getClass().toString();
    private Handler mHandler;
    private final int ANIMATION_TIME = 300;
    private int mCurDegree;
    private int mPreDegree;
    private float scaleX;
    private float scaleY;
    private boolean isEnableScale;
    private AbstractController mImageCtrl;

    public ExtImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.preCreate(context);
    }

    public ExtImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.preCreate(context);
    }

    public ExtImageView(Context context) {
        super(context);
        this.preCreate(context);
    }

    private void preCreate(Context context) {
        this.mHandler = new Handler();
        this.mCurDegree = 0;
        this.mPreDegree = -90;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.isEnableScale = true;
        this.mImageCtrl = null;
    }

    @Override
    public boolean OnOrientationChanged(int degree, int offset, int flag) {
        if (flag != 3 && !this.isShown()) {
            Log.i((String)this.TAG, (String)"Not Shown!");
            return false;
        }
        RotateAnimation animation = new RotateAnimation((float)offset, 0.0f, 1, 0.5f, 1, 0.5f);
        animation.setDuration(300L);
        animation.setFillAfter(true);
        this.mHandler.post((Runnable)new RotateRunable((Animation)animation, (View)this, degree));
        this.mCurDegree = degree;
        return true;
    }

    @Override
    public int getCurrentOrientationDegree() {
        return this.mCurDegree;
    }

    public void onAnimationStart(Animation animation) {
        this.setVisibility(8);
        this.setEnabled(false);
    }

    public void onAnimationEnd(Animation animation) {
        this.setVisibility(0);
        this.setEnabled(true);
    }

    public void onAnimationRepeat(Animation animation) {
    }

    protected void onDraw(Canvas canvas) {
        if (this.mImageCtrl != null && this.mCurDegree != this.mPreDegree) {
            if (this.mCurDegree == 0 || this.mCurDegree == 180) {
                this.mImageCtrl.initialize(this.getDrawable().getBounds().width(), this.getDrawable().getBounds().height(), canvas.getWidth(), canvas.getHeight());
            } else {
                this.mImageCtrl.initialize(this.getDrawable().getBounds().height(), this.getDrawable().getBounds().width(), canvas.getWidth(), canvas.getHeight());
            }
            this.mPreDegree = this.mCurDegree;
        }
        if (this.mImageCtrl != null) {
            this.mImageCtrl.beforeDraw(canvas);
        }
        canvas.save();
        canvas.scale(this.scaleX, this.scaleY, (float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
        canvas.rotate((float)(-this.mCurDegree), (float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
        super.onDraw(canvas);
        canvas.restore();
        if (this.mImageCtrl != null) {
            this.mImageCtrl.afterDraw(canvas);
        }
    }

    @Override
    public PointF getCenterPoint() {
        RectF bounds = new RectF();
        bounds.set(this.getDrawable().getBounds());
        this.getImageMatrix().mapRect(bounds);
        return new PointF(bounds.centerX(), bounds.centerY());
    }

    public void enableScale(boolean isEnable) {
        this.isEnableScale = isEnable;
    }

    public boolean setScale(float sx, float sy) {
        if (this.isEnableScale) {
            this.scaleX = sx;
            this.scaleY = sy;
            return true;
        }
        return false;
    }

    public AbstractController getImageCtrl() {
        return this.mImageCtrl;
    }

    public void setImageCtrl(AbstractController mImageCtrl) {
        this.mImageCtrl = mImageCtrl;
        this.setOnTouchListener(mImageCtrl);
    }
}

