/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.widget;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.media.ImageReader;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import com.guo.android_extend.GLES2Render;
import com.guo.android_extend.widget.Camera2Manager;
import com.guo.android_extend.widget.CameraFrameData;
import com.guo.android_extend.widget.ExtGLSurfaceView;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class Camera2GLSurfaceView
extends ExtGLSurfaceView
implements GLSurfaceView.Renderer,
Camera2Manager.OnDataListener {
    private final String TAG = this.getClass().getSimpleName();
    private Camera2Manager mCamera2Manager;
    private int mWidth;
    private int mHeight;
    private int mFormat;
    private int mRenderFormat;
    private int mDegree;
    private int mMirror;
    private boolean mDebugFPS;
    private boolean mTouchFoucs;
    private BlockingQueue<CameraFrameData> mImageRenderBuffers;
    private GLES2Render mGLES2Render;
    private OnRenderListener mOnRenderListener;
    private OnDrawListener mOnDrawListener;

    public Camera2GLSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.onCreate();
    }

    public Camera2GLSurfaceView(Context context) {
        super(context);
        this.onCreate();
    }

    private void onCreate() {
        if (this.isInEditMode()) {
            return;
        }
        this.setEGLContextClientVersion(2);
        this.setRenderer(this);
        this.setRenderMode(0);
        this.setZOrderMediaOverlay(true);
        this.mImageRenderBuffers = new LinkedBlockingQueue<CameraFrameData>();
        this.mCamera2Manager = new Camera2Manager(this.getContext());
        this.mCamera2Manager.setOnDataListener(this);
        this.mTouchFoucs = true;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mTouchFoucs && ev.getActionMasked() == 0) {
            this.mCamera2Manager.touchFocus((View)this, ev);
        }
        return super.onTouchEvent(ev);
    }

    public void setTouchFocus(boolean enable) {
        this.mTouchFoucs = enable;
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        if (this.mCamera2Manager.openCamera()) {
            this.mGLES2Render = new GLES2Render(this.mMirror, this.mDegree, this.mRenderFormat, this.mDebugFPS);
        }
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        Log.d((String)this.TAG, (String)("onSurfaceChanged! " + width + "X" + height));
        if (this.mGLES2Render != null) {
            this.mGLES2Render.setViewPort(width, height);
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        super.surfaceCreated(holder);
        Log.d((String)this.TAG, (String)"surfaceCreated");
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        super.surfaceChanged(holder, format, w, h);
        Log.d((String)this.TAG, (String)("surfaceChanged! " + w + "X" + h));
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mCamera2Manager.closeCamera();
        super.surfaceDestroyed(holder);
        Log.d((String)this.TAG, (String)"surfaceDestroyed");
    }

    public void onDrawFrame(GL10 gl) {
        CameraFrameData data = (CameraFrameData)this.mImageRenderBuffers.poll();
        if (data != null) {
            byte[] buffer = data.mData;
            if (this.mOnRenderListener != null) {
                this.mOnRenderListener.onBeforeRender(data);
            }
            this.mGLES2Render.render(buffer, this.mWidth, this.mHeight);
            if (this.mOnRenderListener != null) {
                this.mOnRenderListener.onAfterRender(data);
            }
        }
        if (this.mOnDrawListener != null) {
            this.mOnDrawListener.onDrawOverlap(this.mGLES2Render);
        }
    }

    @Override
    public void onPreviewData(CameraFrameData data) {
        if (!this.mImageRenderBuffers.offer(data)) {
            Log.e((String)this.TAG, (String)"RENDER QUEUE FULL!");
        } else {
            this.requestRender();
        }
    }

    public void setOnDrawListener(OnDrawListener lis) {
        this.mOnDrawListener = lis;
    }

    public void setOnRenderListener(OnRenderListener lis) {
        this.mOnRenderListener = lis;
    }

    public void setOnCameraListener(OnCameraListener lis) {
        this.mCamera2Manager.setOnCameraListener(lis);
    }

    public GLES2Render getGLES2Render() {
        return this.mGLES2Render;
    }

    public Camera2Manager getCamera2Manager() {
        return this.mCamera2Manager;
    }

    public void setImageConfig(int width, int height, int format) {
        this.mWidth = width;
        this.mHeight = height;
        this.mFormat = format;
        switch (format) {
            case 35: {
                this.mRenderFormat = 2049;
                break;
            }
            case 17: {
                this.mRenderFormat = 2050;
                break;
            }
            case 4: {
                this.mRenderFormat = 4;
                break;
            }
            default: {
                Log.e((String)this.TAG, (String)("Current camera preview format = " + format + ", render is not support!"));
            }
        }
    }

    public void setRenderConfig(int degree, int mirror) {
        this.mDegree = degree;
        this.mMirror = mirror;
        if (this.mGLES2Render != null) {
            this.mGLES2Render.setViewDisplay(this.mMirror, degree);
        }
    }

    @Override
    public boolean OnOrientationChanged(int degree, int offset, int flag) {
        if (this.mGLES2Render != null) {
            this.mGLES2Render.setViewDisplay(this.mMirror, degree);
        }
        return super.OnOrientationChanged(degree, offset, flag);
    }

    public void debug_print_fps(boolean show) {
        this.mDebugFPS = show;
    }

    public static interface OnCameraListener {
        public static final int EVENT_FOCUS_OVER = 0;
        public static final int EVENT_CAMERA_ERROR = 4096;

        public String[] chooseCamera(String[] var1);

        public ImageReader setupPreview(String var1, CameraCharacteristics var2, CaptureRequest.Builder var3);

        public Object onPreview(String var1, byte[] var2, int var3, int var4, int var5, long var6);

        public void onCameraEvent(String var1, int var2);
    }

    public static interface OnRenderListener {
        public void onBeforeRender(CameraFrameData var1);

        public void onAfterRender(CameraFrameData var1);
    }

    public static interface OnDrawListener {
        public void onDrawOverlap(GLES2Render var1);
    }
}

