/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.widget;

import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.OverScroller;
import android.widget.Scroller;
import java.util.LinkedList;
import java.util.Queue;

public abstract class AbsHAdapterView
extends AdapterView<ListAdapter> {
    private final String TAG = "AbsHAdapterView";
    static final int DEFAULT_DURATION_MILLIS = 250;
    static final int NO_POSITION = -1;
    static final int TOUCH_MODE_REST = -1;
    static final int TOUCH_MODE_DOWN = 0;
    static final int TOUCH_MODE_TAP = 1;
    static final int TOUCH_MODE_DONE_WAITING = 2;
    static final int TOUCH_MODE_SCROLL = 3;
    static final int TOUCH_MODE_FLING = 4;
    static final int TOUCH_MODE_OVERSCROLL = 5;
    static final int TOUCH_MODE_OVERFLING = 6;
    ListAdapter mAdapter;
    AdapterDataSetObserver mDataSetObserver;
    boolean mDataChanged;
    int mFirstPosition = 0;
    int mLastPosition = -1;
    int mItemCount;
    int mOldItemCount;
    int mSelectionLeftPadding = 0;
    int mSelectionTopPadding = 0;
    int mSelectionRightPadding = 0;
    int mSelectionBottomPadding = 0;
    Rect mListPadding = new Rect();
    int mWidthMeasureSpec = 0;
    int mHeightMeasureSpec = 0;
    int mItemWidth = 0;
    int mItemHeight = 0;
    private int mCacheColorHint;
    private FlingRunnable mFlingRunnable;
    private OverFlingRunnable mOverFlingRunnable;
    private CheckForTap mPendingCheckForTap;
    private CheckForLongPress mPendingCheckForLongPress;
    int mOverScrollDistance;
    boolean mEnableOverScroll;
    boolean mInLayout = false;
    boolean mBlockLayoutRequests = false;
    int mOldCurrentX = 0;
    int mCurrentX = 0;
    int mNextPosX = 0;
    int mMinDistanceX;
    int mMaxDistanceX;
    Queue<View> mRecycledViewQueue;
    int mTouchMode = -1;
    private int mTouchSlop;
    private int mTouchSlopSquare;
    private float mLastFocusX;
    private float mLastFocusY;
    private float mDownFocusX;
    private float mDownFocusY;
    private boolean mAlwaysInTapRegion;
    int mMotionPosition;
    private VelocityTracker mVelocityTracker;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private float mVelocityScale = 1.0f;
    private OnScrollListener mOnScrollListener;
    private int mLastScrollState = 0;

    public AbsHAdapterView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initial();
    }

    public AbsHAdapterView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initial();
    }

    public AbsHAdapterView(Context context) {
        super(context);
        this.initial();
    }

    private void initial() {
        this.mRecycledViewQueue = new LinkedList<View>();
        this.setClickable(true);
        this.setFocusableInTouchMode(true);
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mOverScrollDistance = configuration.getScaledOverscrollDistance();
        this.mTouchSlopSquare = this.mTouchSlop * this.mTouchSlop;
        this.mEnableOverScroll = false;
    }

    public View getSelectedView() {
        return null;
    }

    public void setSelection(int position) {
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mInLayout = true;
        int childCount = this.getChildCount();
        if (changed) {
            for (int i = 0; i < childCount; ++i) {
                this.getChildAt(i).forceLayout();
            }
        }
        this.layoutChildren();
        this.mInLayout = false;
    }

    public void requestLayout() {
        if (!this.mBlockLayoutRequests && !this.mInLayout) {
            super.requestLayout();
        }
    }

    protected void layoutChildren() {
    }

    void resetList() {
        if (this.mFlingRunnable != null) {
            this.mFlingRunnable.endFling();
        }
        this.removeAllViewsInLayout();
        this.mRecycledViewQueue.clear();
        this.mFirstPosition = 0;
        this.mLastPosition = -1;
        this.mCurrentX = 0;
        this.mDataChanged = false;
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mListPadding.left = this.mSelectionLeftPadding + super.getPaddingLeft();
        this.mListPadding.top = this.mSelectionTopPadding + super.getPaddingTop();
        this.mListPadding.right = this.mSelectionRightPadding + super.getPaddingRight();
        this.mListPadding.bottom = this.mSelectionBottomPadding + super.getPaddingBottom();
    }

    View obtainView(int position) {
        View child = null;
        if (this.mAdapter != null) {
            child = this.mAdapter.getView(position, this.mRecycledViewQueue.poll(), (ViewGroup)this);
        }
        return child;
    }

    public void setAdapter(ListAdapter adapter) {
        this.mAdapter = adapter;
        this.removeAllViewsInLayout();
        this.requestLayout();
    }

    public abstract ListAdapter getAdapter();

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mAdapter != null && this.mDataSetObserver == null) {
            this.mDataSetObserver = new AdapterDataSetObserver();
            this.mAdapter.registerDataSetObserver((DataSetObserver)this.mDataSetObserver);
            this.mDataChanged = true;
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mRecycledViewQueue.clear();
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver((DataSetObserver)this.mDataSetObserver);
            this.mDataSetObserver = null;
        }
    }

    public void setVelocityScale(float scale) {
        this.mVelocityScale = scale;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        float focusX = ev.getX();
        float focusY = ev.getY();
        boolean handled = true;
        switch (ev.getAction() & 0xFF) {
            case 0: {
                this.mDownFocusX = this.mLastFocusX = focusX;
                this.mDownFocusY = this.mLastFocusY = focusY;
                int motionPosition = this.pointToPosition((int)focusX, (int)focusY);
                this.mAlwaysInTapRegion = true;
                if (!this.mDataChanged) {
                    if (this.mTouchMode == 4) {
                        this.mFlingRunnable.endFling();
                    } else if (this.mTouchMode == 6) {
                        this.mOverFlingRunnable.endOverFling();
                    } else {
                        this.mPendingCheckForTap = new CheckForTap();
                        this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
                    }
                }
                this.mMotionPosition = motionPosition;
                this.mTouchMode = 0;
                break;
            }
            case 2: {
                float scrollX = this.mLastFocusX - focusX;
                float scrollY = this.mLastFocusY - focusY;
                int deltaX = (int)(focusX - this.mDownFocusX);
                int deltaY = (int)(focusY - this.mDownFocusY);
                if (this.mDataChanged) {
                    this.layoutChildren();
                }
                if (this.mAlwaysInTapRegion && this.mTouchMode == 0) {
                    int distance = deltaX * deltaX + deltaY * deltaY;
                    if (distance <= this.mTouchSlopSquare) break;
                    this.removeCallbacks(this.mPendingCheckForTap);
                    this.removeCallbacks(this.mPendingCheckForLongPress);
                    this.mTouchMode = 3;
                    this.trackMotionScroll((int)scrollX, (int)scrollY);
                    this.mLastFocusX = focusX;
                    this.mLastFocusY = focusY;
                    this.mAlwaysInTapRegion = false;
                    break;
                }
                if (!(Math.abs(scrollX) >= 1.0f) && !(Math.abs(scrollY) >= 1.0f)) break;
                this.trackMotionScroll((int)scrollX, (int)scrollY);
                this.mLastFocusX = focusX;
                this.mLastFocusY = focusY;
                break;
            }
            case 1: {
                if (this.mAlwaysInTapRegion) {
                    switch (this.mTouchMode) {
                        case 0: 
                        case 1: {
                            View child = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                            if (child != null) {
                                child.setPressed(false);
                                super.performItemClick(child, this.mMotionPosition, this.mAdapter.getItemId(this.mMotionPosition));
                                break;
                            }
                            this.mTouchMode = -1;
                            break;
                        }
                        case 2: {
                            this.mTouchMode = -1;
                            break;
                        }
                        default: {
                            Log.e((String)"AbsHAdapterView", (String)("error mode =" + this.mTouchMode));
                            break;
                        }
                    }
                } else {
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    int pointerId = ev.getPointerId(0);
                    velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                    float velocityY = velocityTracker.getYVelocity(pointerId) * this.mVelocityScale;
                    float velocityX = velocityTracker.getXVelocity(pointerId) * this.mVelocityScale;
                    if (Math.abs(velocityY) > (float)this.mMinimumVelocity || Math.abs(velocityX) > (float)this.mMinimumVelocity) {
                        this.mFlingRunnable = new FlingRunnable();
                        this.mFlingRunnable.startFling(velocityX, velocityY);
                    } else if (this.checkOverScroll()) {
                        this.mOverFlingRunnable = new OverFlingRunnable();
                        this.mOverFlingRunnable.startOverFling(this.mCurrentX, 0, this.mMinDistanceX, this.mMaxDistanceX, 0, 0);
                    } else {
                        this.mTouchMode = -1;
                        this.reportScrollStateChange(0);
                    }
                }
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
                this.removeCallbacks(this.mPendingCheckForLongPress);
                this.removeCallbacks(this.mPendingCheckForTap);
                break;
            }
            case 3: {
                this.cancel();
            }
        }
        return handled;
    }

    private void cancel() {
        this.removeCallbacks(this.mPendingCheckForTap);
        this.removeCallbacks(this.mPendingCheckForLongPress);
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        this.mAlwaysInTapRegion = false;
        if (this.mTouchMode == 4 || this.mTouchMode == 3) {
            this.reportScrollStateChange(0);
        }
        this.mTouchMode = -1;
    }

    public int pointToPosition(int x, int y) {
        int count = super.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0 || child.getLeft() >= x || x >= child.getRight() || this.mListPadding.top >= y || y >= this.getHeight() - this.mListPadding.bottom) continue;
            return this.mFirstPosition + i;
        }
        return -1;
    }

    boolean trackMotionScroll(int deltaX, int deltaY) {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return true;
        }
        if (this.mTouchMode == 3) {
            this.mNextPosX += deltaX;
            this.mBlockLayoutRequests = true;
            this.scrollSnap();
            this.mBlockLayoutRequests = false;
            this.invalidate();
            this.reportScrollStateChange(1);
            this.invokeOnItemScrollListener();
            if (this.checkOverScroll()) {
                this.mTouchMode = 5;
            }
        } else if (this.mTouchMode == 5) {
            float per = 0.0f;
            if (this.mNextPosX < this.mMinDistanceX) {
                int dst = this.mOverScrollDistance - (this.mMinDistanceX - this.mNextPosX);
                per = (float)dst / (float)this.mOverScrollDistance;
            } else if (this.mNextPosX > this.mMaxDistanceX) {
                int dst = this.mNextPosX - this.mMaxDistanceX;
                per = (float)(this.mOverScrollDistance - dst) / (float)this.mOverScrollDistance;
            } else {
                throw new RuntimeException("exception from HListView TOUCH_MODE_OVERSCROLL");
            }
            deltaX = (int)((float)deltaX * per);
            this.mNextPosX += deltaX;
            this.mBlockLayoutRequests = true;
            this.scrollSnap();
            this.mBlockLayoutRequests = false;
            this.invalidate();
            this.mTouchMode = this.checkOverScroll() ? 5 : 3;
        }
        return false;
    }

    abstract void recycleChildren();

    abstract void fillGapList(int var1);

    protected boolean checkOverScroll() {
        if (this.mEnableOverScroll) {
            if (this.mNextPosX <= this.mMinDistanceX) {
                return true;
            }
            if (this.mNextPosX >= this.mMaxDistanceX) {
                return true;
            }
        }
        return false;
    }

    public void enableOverScroll(boolean enable) {
        this.mEnableOverScroll = enable;
        super.requestLayout();
    }

    public boolean isOverScrollEnable() {
        return this.mEnableOverScroll;
    }

    protected boolean scrollSnap() {
        boolean isEnd = false;
        if (this.mNextPosX <= this.mMinDistanceX - this.mOverScrollDistance) {
            this.mNextPosX = this.mMinDistanceX - this.mOverScrollDistance;
            isEnd = true;
        }
        if (this.mNextPosX >= this.mMaxDistanceX + this.mOverScrollDistance) {
            this.mNextPosX = this.mMaxDistanceX + this.mOverScrollDistance;
            isEnd = true;
        }
        int offsetX = this.mCurrentX - this.mNextPosX;
        this.offsetChildrenLeftAndRight(offsetX);
        this.fillGapList(offsetX);
        this.recycleChildren();
        this.mCurrentX = this.mNextPosX;
        return isEnd;
    }

    public void offsetChildrenLeftAndRight(int offset) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View v = this.getChildAt(i);
            v.layout(v.getLeft() + offset, v.getTop(), v.getRight() + offset, v.getBottom());
            this.invalidate();
        }
    }

    protected boolean canAnimate() {
        return this.getLayoutAnimation() != null && this.mItemCount > 0;
    }

    boolean performLongPress(View child, int longPressPosition, long longPressId) {
        boolean handled = false;
        if (super.getOnItemLongClickListener() != null) {
            handled = super.getOnItemLongClickListener().onItemLongClick((AdapterView)this, child, longPressPosition, longPressId);
        }
        if (handled) {
            this.performHapticFeedback(0);
        }
        return handled;
    }

    public void setOnScrollListener(OnScrollListener l) {
        this.mOnScrollListener = l;
        this.invokeOnItemScrollListener();
    }

    void invokeOnItemScrollListener() {
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll(this, this.mFirstPosition, this.getChildCount(), this.mItemCount);
        }
        this.onScrollChanged(0, 0, 0, 0);
    }

    void reportScrollStateChange(int newState) {
        if (newState != this.mLastScrollState && this.mOnScrollListener != null) {
            this.mLastScrollState = newState;
            this.mOnScrollListener.onScrollStateChanged(this, newState);
        }
    }

    public void scrollSmoothTo(int x, int duration) {
        if (this.mFlingRunnable != null) {
            this.mFlingRunnable.endFling();
        }
        this.mFlingRunnable = new FlingRunnable();
        this.mFlingRunnable.startScroll(x - this.mCurrentX, 0.0f, duration);
        this.reportScrollStateChange(2);
    }

    public void scrollSmoothTo(int x) {
        this.scrollSmoothTo(x, 250);
    }

    public void setCacheColorHint(int color) {
        if (color != this.mCacheColorHint) {
            this.mCacheColorHint = color;
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.getChildAt(i).setDrawingCacheBackgroundColor(color);
            }
        }
    }

    public int getSolidColor() {
        return this.mCacheColorHint;
    }

    public int getCacheColorHint() {
        return this.mCacheColorHint;
    }

    private class CheckForLongPress
    implements Runnable {
        private CheckForLongPress() {
        }

        @Override
        public void run() {
            int motionPosition = AbsHAdapterView.this.mMotionPosition;
            View child = AbsHAdapterView.this.getChildAt(motionPosition - AbsHAdapterView.this.mFirstPosition);
            if (child != null) {
                int longPressPosition = AbsHAdapterView.this.mMotionPosition;
                long longPressId = AbsHAdapterView.this.mAdapter.getItemId(AbsHAdapterView.this.mMotionPosition);
                boolean handled = false;
                if (!AbsHAdapterView.this.mDataChanged) {
                    handled = AbsHAdapterView.this.performLongPress(child, longPressPosition, longPressId);
                }
                if (handled) {
                    AbsHAdapterView.this.mTouchMode = -1;
                    child.setPressed(false);
                } else {
                    AbsHAdapterView.this.mTouchMode = 2;
                }
            }
        }
    }

    private class CheckForTap
    implements Runnable {
        private CheckForTap() {
        }

        @Override
        public void run() {
            View child;
            if (AbsHAdapterView.this.mTouchMode == 0 && (child = AbsHAdapterView.this.getChildAt(AbsHAdapterView.this.mMotionPosition - AbsHAdapterView.this.mFirstPosition)) != null && !child.hasFocusable()) {
                if (!AbsHAdapterView.this.mDataChanged) {
                    child.setPressed(true);
                    AbsHAdapterView.this.layoutChildren();
                    int longPressTimeout = ViewConfiguration.getLongPressTimeout();
                    boolean longClickable = AbsHAdapterView.this.isLongClickable();
                    if (longClickable) {
                        if (AbsHAdapterView.this.mPendingCheckForLongPress == null) {
                            AbsHAdapterView.this.mPendingCheckForLongPress = new CheckForLongPress();
                        }
                        AbsHAdapterView.this.postDelayed(AbsHAdapterView.this.mPendingCheckForLongPress, longPressTimeout);
                    } else {
                        AbsHAdapterView.this.mTouchMode = 1;
                    }
                } else {
                    AbsHAdapterView.this.mTouchMode = 2;
                }
            }
        }
    }

    class FlingRunnable
    implements Runnable {
        private final Scroller mScroller;

        public FlingRunnable() {
            this.mScroller = new Scroller(AbsHAdapterView.this.getContext());
        }

        public FlingRunnable(Scroller scroller) {
            this.mScroller = scroller;
        }

        @Override
        public void run() {
            if (AbsHAdapterView.this.mTouchMode == 4 || AbsHAdapterView.this.mTouchMode == 3) {
                if (AbsHAdapterView.this.mDataChanged) {
                    AbsHAdapterView.this.layoutChildren();
                }
                if (this.mScroller.computeScrollOffset()) {
                    AbsHAdapterView.this.mNextPosX = this.mScroller.getCurrX();
                }
                AbsHAdapterView.this.mBlockLayoutRequests = true;
                AbsHAdapterView.this.scrollSnap();
                AbsHAdapterView.this.mBlockLayoutRequests = false;
                AbsHAdapterView.this.invalidate();
                if (AbsHAdapterView.this.checkOverScroll()) {
                    AbsHAdapterView.this.mFlingRunnable.endFling();
                    AbsHAdapterView.this.mOverFlingRunnable = new OverFlingRunnable();
                    AbsHAdapterView.this.mOverFlingRunnable.startOverFling(AbsHAdapterView.this.mCurrentX, 0, AbsHAdapterView.this.mMinDistanceX, AbsHAdapterView.this.mMaxDistanceX, 0, 0);
                    return;
                }
                if (this.mScroller.isFinished()) {
                    AbsHAdapterView.this.mTouchMode = -1;
                    AbsHAdapterView.this.reportScrollStateChange(0);
                } else {
                    AbsHAdapterView.this.mFlingRunnable = new FlingRunnable(this.mScroller);
                    AbsHAdapterView.this.post(AbsHAdapterView.this.mFlingRunnable);
                    AbsHAdapterView.this.reportScrollStateChange(2);
                    AbsHAdapterView.this.invokeOnItemScrollListener();
                }
            }
        }

        public void startFling(float velocityX, float velocityY) {
            AbsHAdapterView.this.mTouchMode = 4;
            this.mScroller.fling(AbsHAdapterView.this.mNextPosX, 0, (int)(-velocityX), 0, AbsHAdapterView.this.mMinDistanceX - AbsHAdapterView.this.mOverScrollDistance, AbsHAdapterView.this.mMaxDistanceX + AbsHAdapterView.this.mOverScrollDistance, 0, 0);
            AbsHAdapterView.this.post(this);
        }

        public void startScroll(float deltaX, float deltaY, int duration) {
            AbsHAdapterView.this.mTouchMode = 4;
            this.mScroller.startScroll(AbsHAdapterView.this.mNextPosX, 0, (int)deltaX, 0, duration);
            AbsHAdapterView.this.post(this);
        }

        public void endFling() {
            this.mScroller.forceFinished(true);
            AbsHAdapterView.this.removeCallbacks(this);
            AbsHAdapterView.this.removeCallbacks(AbsHAdapterView.this.mFlingRunnable);
        }
    }

    class OverFlingRunnable
    implements Runnable {
        private final OverScroller mOverScroller;

        public OverFlingRunnable() {
            this.mOverScroller = new OverScroller(AbsHAdapterView.this.getContext());
        }

        public OverFlingRunnable(OverScroller overscroller) {
            this.mOverScroller = overscroller;
        }

        @Override
        public void run() {
            if (AbsHAdapterView.this.mTouchMode == 6 || AbsHAdapterView.this.mTouchMode == 5) {
                if (AbsHAdapterView.this.mDataChanged) {
                    AbsHAdapterView.this.layoutChildren();
                }
                if (this.mOverScroller.computeScrollOffset()) {
                    AbsHAdapterView.this.mNextPosX = this.mOverScroller.getCurrX();
                }
                AbsHAdapterView.this.mBlockLayoutRequests = true;
                AbsHAdapterView.this.scrollSnap();
                AbsHAdapterView.this.mBlockLayoutRequests = false;
                AbsHAdapterView.this.invalidate();
                if (this.mOverScroller.isFinished()) {
                    AbsHAdapterView.this.mTouchMode = -1;
                    AbsHAdapterView.this.reportScrollStateChange(0);
                } else {
                    AbsHAdapterView.this.mOverFlingRunnable = new OverFlingRunnable(this.mOverScroller);
                    AbsHAdapterView.this.post(AbsHAdapterView.this.mOverFlingRunnable);
                    AbsHAdapterView.this.reportScrollStateChange(2);
                    AbsHAdapterView.this.invokeOnItemScrollListener();
                }
            }
        }

        public void startOverFling(int startX, int startY, int minX, int maxX, int minY, int maxY) {
            AbsHAdapterView.this.mTouchMode = 6;
            this.mOverScroller.springBack(startX, startY, minX, maxX, minY, maxY);
            AbsHAdapterView.this.post(this);
        }

        public void endOverFling() {
            this.mOverScroller.forceFinished(true);
            AbsHAdapterView.this.removeCallbacks(this);
            AbsHAdapterView.this.removeCallbacks(AbsHAdapterView.this.mOverFlingRunnable);
        }
    }

    class AdapterDataSetObserver
    extends DataSetObserver {
        private Parcelable mInstanceState = null;

        AdapterDataSetObserver() {
        }

        public void onChanged() {
            AbsHAdapterView.this.mDataChanged = true;
            AbsHAdapterView.this.mOldItemCount = AbsHAdapterView.this.mItemCount;
            AbsHAdapterView.this.mItemCount = AbsHAdapterView.this.getAdapter().getCount();
            AbsHAdapterView.this.mOldCurrentX = 0;
            if (AbsHAdapterView.this.getAdapter().hasStableIds() && this.mInstanceState != null && AbsHAdapterView.this.mOldItemCount == 0 && AbsHAdapterView.this.mItemCount > 0) {
                AbsHAdapterView.this.onRestoreInstanceState(this.mInstanceState);
                this.mInstanceState = null;
            }
            AbsHAdapterView.this.requestLayout();
        }

        public void onInvalidated() {
            AbsHAdapterView.this.mDataChanged = true;
            if (AbsHAdapterView.this.getAdapter().hasStableIds()) {
                this.mInstanceState = AbsHAdapterView.this.onSaveInstanceState();
            }
            AbsHAdapterView.this.mOldCurrentX = AbsHAdapterView.this.mCurrentX;
            AbsHAdapterView.this.mOldItemCount = AbsHAdapterView.this.mItemCount;
            AbsHAdapterView.this.mItemCount = 0;
            AbsHAdapterView.this.requestLayout();
        }

        public void clearSavedState() {
            this.mInstanceState = null;
        }
    }

    public static interface OnScrollListener {
        public static final int SCROLL_STATE_IDLE = 0;
        public static final int SCROLL_STATE_TOUCH_SCROLL = 1;
        public static final int SCROLL_STATE_FLING = 2;

        public void onScrollStateChanged(AbsHAdapterView var1, int var2);

        public void onScroll(AbsHAdapterView var1, int var2, int var3, int var4);
    }
}

