/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.tools;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogcatHelper {
    private static LogcatHelper INSTANCE = null;
    private static String PATH_LOGCAT;
    private LogDumper mLogDumper = null;
    private int mPId;
    private Context mContext;
    private boolean isInitial;

    public static void d(String tag, String content) {
        Log.d((String)tag, (String)content);
    }

    public static void e(String tag, String content) {
        Log.e((String)tag, (String)content);
    }

    public static void v(String tag, String content) {
        Log.v((String)tag, (String)content);
    }

    public void setupLogPath(Context context, String subPath) {
        if (!this.isInitial) {
            PATH_LOGCAT = Environment.getExternalStorageState().equals("mounted") ? Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + subPath : context.getFilesDir().getAbsolutePath() + File.separator + subPath;
            File file = new File(PATH_LOGCAT);
            if (!file.exists()) {
                file.mkdirs();
            }
            this.isInitial = true;
        }
    }

    public static LogcatHelper getInstance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new LogcatHelper(context);
        }
        return INSTANCE;
    }

    private LogcatHelper(Context context) {
        this.mContext = context;
        this.mPId = android.os.Process.myPid();
        this.isInitial = false;
    }

    public void start() {
        this.setupLogPath(this.mContext, this.mContext.getPackageName());
        if (this.mLogDumper == null) {
            this.mLogDumper = new LogDumper(String.valueOf(this.mPId), PATH_LOGCAT);
        }
        this.mLogDumper.start();
    }

    public void stop() {
        if (this.mLogDumper != null) {
            this.mLogDumper.stopLogs();
            this.mLogDumper = null;
        }
    }

    private class LogDumper
    extends Thread {
        private Process logcatProc;
        private BufferedReader mReader = null;
        private boolean mRunning = true;
        String cmds = null;
        private String mPID;
        private FileOutputStream out = null;

        public LogDumper(String pid, String dir) {
            this.mPID = pid;
            try {
                this.out = new FileOutputStream(new File(dir, "dump-" + System.currentTimeMillis() + ".log"));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            this.cmds = "logcat *:e *:i *:d | grep \"(" + this.mPID + ")\"";
        }

        public void stopLogs() {
            this.mRunning = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.logcatProc = Runtime.getRuntime().exec(this.cmds);
                this.mReader = new BufferedReader(new InputStreamReader(this.logcatProc.getInputStream()), 1024);
                String line = null;
                while (this.mRunning && (line = this.mReader.readLine()) != null) {
                    if (!this.mRunning) {
                        break;
                    }
                    if (line.length() == 0 || this.out == null || !line.contains(this.mPID)) continue;
                    SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String date1 = format1.format(new Date(System.currentTimeMillis()));
                    this.out.write((date1 + "  " + line + "\n").getBytes());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (this.logcatProc != null) {
                    this.logcatProc.destroy();
                    this.logcatProc = null;
                }
                if (this.mReader != null) {
                    try {
                        this.mReader.close();
                        this.mReader = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    this.out = null;
                }
            }
        }
    }
}

