/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.java.network.udp;

import com.guo.android_extend.java.AbsLoop;
import com.guo.android_extend.java.network.udp.UDPDataProtocol;
import com.guo.android_extend.tools.LogcatHelper;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class UDPTransponder {
    private String TAG = this.getClass().getSimpleName();
    public static final int UDP_PORT_R = 4200;
    public static final int UDP_PORT_S = 4201;
    public static final int BUFFER_LENGTH = 8192;
    private InetAddress mInetAddress;
    private boolean isBroadcast;
    private Receiver mReceiver;
    private Deliver mDeliver;
    private UDPDataProtocol mUDPDataProtocol;
    private int mDelay;

    public UDPTransponder(InetAddress inetAddress, boolean isBroadcast) {
        this.mInetAddress = inetAddress;
        this.isBroadcast = isBroadcast;
        this.mUDPDataProtocol = null;
        this.mDelay = 1000;
    }

    public void setUDPDataProtocol(UDPDataProtocol protocol) {
        this.mUDPDataProtocol = protocol;
    }

    public boolean startReceiver() {
        if (this.mReceiver != null) {
            this.mReceiver.shutdown();
        }
        if (!this.isBroadcast) {
            this.mReceiver = new Receiver(this.mInetAddress, true);
            this.mReceiver.start();
        } else {
            this.mReceiver = new Receiver();
            this.mReceiver.start();
        }
        return true;
    }

    public void stopReceiver() {
        if (this.mReceiver != null) {
            this.mReceiver.shutdown();
            this.mReceiver = null;
        }
    }

    public boolean startDeliver(int time) {
        this.mDelay = time;
        return this.startDeliver();
    }

    public boolean startDeliver() {
        if (this.mDeliver != null) {
            this.mDeliver.shutdown();
        }
        if (!this.isBroadcast) {
            this.mDeliver = new Deliver(this.mInetAddress, true);
            this.mDeliver.start();
        } else {
            this.mDeliver = new Deliver(this.mInetAddress);
            this.mDeliver.start();
        }
        return true;
    }

    public void stopDeliver() {
        if (this.mDeliver != null) {
            this.mDeliver.shutdown();
            this.mDeliver = null;
        }
    }

    class Deliver
    extends AbsLoop {
        private DatagramSocket mDatagramSocket;
        private InetAddress mInetAddress;
        private boolean isMuliticast;

        public Deliver(InetAddress mInetAddress, boolean isMulticast) {
            this.mInetAddress = mInetAddress;
            this.isMuliticast = isMulticast;
        }

        public Deliver(InetAddress mInetAddress) {
            this(mInetAddress, false);
        }

        @Override
        public void setup() {
            try {
                if (this.isMuliticast) {
                    this.mDatagramSocket = new MulticastSocket(4201);
                } else {
                    this.mDatagramSocket = new DatagramSocket(4201);
                    this.mDatagramSocket.setBroadcast(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void loop() {
            try {
                Deliver deliver = this;
                synchronized (deliver) {
                    this.wait(1000L);
                }
                if (UDPTransponder.this.mUDPDataProtocol != null) {
                    byte[] data = UDPTransponder.this.mUDPDataProtocol.packaged();
                    DatagramPacket send = new DatagramPacket(data, data.length, this.mInetAddress, 4200);
                    this.mDatagramSocket.send(send);
                } else {
                    LogcatHelper.e(UDPTransponder.this.TAG, "UDPDataProtocol NULL! broadcast fail!");
                }
            }
            catch (Exception e) {
                LogcatHelper.e(UDPTransponder.this.TAG, e.getCause().getMessage());
            }
        }

        @Override
        public void over() {
            if (this.mDatagramSocket != null) {
                this.mDatagramSocket.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            super.shutdown();
            try {
                Deliver deliver = this;
                synchronized (deliver) {
                    this.notifyAll();
                }
                this.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class Receiver
    extends AbsLoop {
        private boolean isMuliticast;
        private InetAddress mInetAddress;
        private DatagramSocket mDatagramSocket;
        private byte[] mBuffer;

        public Receiver(InetAddress mInetAddress, boolean isMuliticast) {
            this.mInetAddress = mInetAddress;
            this.isMuliticast = isMuliticast;
        }

        public Receiver() {
            this(null, false);
        }

        @Override
        public void setup() {
            try {
                if (this.isMuliticast) {
                    this.mDatagramSocket = new MulticastSocket(4200);
                    MulticastSocket server = (MulticastSocket)this.mDatagramSocket;
                    server.joinGroup(this.mInetAddress);
                } else {
                    this.mDatagramSocket = new DatagramSocket(4200);
                    this.mDatagramSocket.setBroadcast(true);
                }
                this.mBuffer = new byte[8192];
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void loop() {
            try {
                Receiver receiver = this;
                synchronized (receiver) {
                    this.wait(UDPTransponder.this.mDelay);
                }
                DatagramPacket receive = new DatagramPacket(this.mBuffer, this.mBuffer.length);
                this.mDatagramSocket.receive(receive);
                String info = receive.getAddress().toString();
                String ip = info.substring(1, info.length());
                if (UDPTransponder.this.mUDPDataProtocol != null) {
                    UDPTransponder.this.mUDPDataProtocol.parsed(ip, receive.getData(), receive.getLength());
                } else {
                    LogcatHelper.e(UDPTransponder.this.TAG, "UDPDataProtocol NULL! IP:" + ip);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void over() {
            if (this.mDatagramSocket != null) {
                this.mDatagramSocket.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            super.shutdown();
            try {
                Receiver receiver = this;
                synchronized (receiver) {
                    this.notifyAll();
                }
                this.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

