/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.java.network.socket.Transfer;

import com.guo.android_extend.java.AbsLoop;
import com.guo.android_extend.java.network.socket.Data.AbsTransmitter;
import com.guo.android_extend.tools.LogcatHelper;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class Sender
extends AbsLoop {
    private String TAG = this.getClass().getSimpleName();
    private static final int BUFFER_LENGTH = 8192;
    private static final int QUEUE_MAX_SIZE = 8;
    private BlockingQueue<AbsTransmitter> mTaskQueue;
    private DataOutputStream mDataWrite;
    private Socket mSocket;
    private byte[] mBuffer;
    private OnSenderListener mOnSenderListener;

    public Sender(Socket mSocket, int max_queue) {
        this.mTaskQueue = new LinkedBlockingQueue<AbsTransmitter>(max_queue);
        this.mBuffer = new byte[8192];
        this.mSocket = mSocket;
        this.mOnSenderListener = null;
    }

    public Sender(Socket mSocket) {
        this(mSocket, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean post(AbsTransmitter object) {
        boolean success = this.mTaskQueue.offer(object);
        Sender sender = this;
        synchronized (sender) {
            this.notifyAll();
        }
        return success;
    }

    public void setOnSenderListener(OnSenderListener tl) {
        this.mOnSenderListener = tl;
    }

    @Override
    public void setup() {
        try {
            this.mDataWrite = new DataOutputStream(this.mSocket.getOutputStream());
        }
        catch (Exception e) {
            LogcatHelper.e(this.TAG, "setup:" + e.getCause().getMessage());
            if (this.mOnSenderListener != null) {
                this.mOnSenderListener.onException(3);
            }
            return;
        }
        if (this.mOnSenderListener != null) {
            this.mOnSenderListener.onSendInitial(this.mSocket, this.mDataWrite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loop() {
        AbsTransmitter data = (AbsTransmitter)this.mTaskQueue.poll();
        if (data != null) {
            data.setOnSenderListener(this.mOnSenderListener);
            int ex = data.send(this.mDataWrite, this.mBuffer);
            if (ex != 0 && this.mOnSenderListener != null) {
                this.mOnSenderListener.onException(ex);
            }
        } else {
            Sender sender = this;
            synchronized (sender) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void over() {
        block3: {
            if (this.mOnSenderListener != null) {
                this.mOnSenderListener.onSendDestroy(this.mSocket);
            }
            try {
                this.mDataWrite.close();
            }
            catch (IOException e) {
                LogcatHelper.e(this.TAG, "over:" + e.getMessage());
                if (this.mOnSenderListener == null) break block3;
                this.mOnSenderListener.onException(5);
            }
        }
    }

    public static interface OnSenderListener {
        public void onException(int var1);

        public void onSendProcess(AbsTransmitter var1, int var2, int var3);

        public void onSendInitial(Socket var1, DataOutputStream var2);

        public void onSendDestroy(Socket var1);
    }
}

