/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.java.network;

import java.io.File;

public class NetWorkFile {
    protected String mLocalDir;
    protected String mUrl;

    public NetWorkFile(String mLocalDir, String mUrl) {
        this.mLocalDir = mLocalDir;
        this.mUrl = mUrl;
    }

    public void setLocalDir(String mLocalDir) {
        this.mLocalDir = mLocalDir;
    }

    public void setUrl(String mUrl) {
        this.mUrl = mUrl;
    }

    public synchronized String getRemoteFileName() {
        String fileName = null;
        try {
            String[] temp = this.mUrl.replaceAll("////", "/").split("/");
            if (temp.length > 1) {
                fileName = temp[temp.length - 1];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileName;
    }

    public synchronized String getLocalFile() {
        String localFile = null;
        String fileName = this.getRemoteFileName();
        if (this.mLocalDir == null) {
            return fileName;
        }
        localFile = this.mLocalDir.endsWith("/") ? this.mLocalDir + fileName : this.mLocalDir + "/" + fileName;
        return localFile;
    }

    public String createCacheFile() {
        String fileName = this.getRemoteFileName();
        fileName = this.mLocalDir.endsWith("/") ? this.mLocalDir + fileName + "_cache" : this.mLocalDir + "/" + fileName + "_cache";
        try {
            File dir = new File(this.mLocalDir);
            dir.mkdirs();
            File file = new File(fileName);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileName;
    }
}

