/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.device;

public class Serial {
    private final String TAG = this.getClass().getSimpleName();
    public static final int TYPE_SERIAL = 0;
    public static final int TYPE_USB_SERIAL = 1;
    private static final int TYPE_FREE_SERIAL = 2;
    public static final int MAX_RECEIVE_SIZE = 255;
    public static final int MAX_RECEIVE_TIMEOUT = 1;
    private long mHandle;
    private byte[] mReceive;

    private native long initSerial(int var1, byte[] var2, int var3);

    private native int setSerial(long var1, int var3, int var4, byte var5, int var6, int var7, int var8);

    private native int sendData(long var1, byte[] var3, int var4);

    private native int receiveData(long var1, byte[] var3, int var4, int var5);

    private native int uninitSerial(long var1);

    public Serial(String dev) {
        this.mHandle = this.initSerial(-1, dev.getBytes(), 2);
        if (this.mHandle == 0L) {
            throw new RuntimeException("Open Serial device error!");
        }
        this.mReceive = new byte[255];
    }

    public Serial(int port, int type) {
        this.mHandle = this.initSerial(port, null, type);
        if (this.mHandle == 0L) {
            throw new RuntimeException("Open Serial device error!");
        }
        this.mReceive = new byte[255];
    }

    public boolean setConfig(int rate, int data_bits, byte parity, int stop_bits, int vtime, int vmin) {
        return 0 == this.setSerial(this.mHandle, rate, data_bits, parity, stop_bits, vtime, vmin);
    }

    public boolean send(byte[] data) {
        if (this.mHandle != 0L) {
            this.sendData(this.mHandle, data, data.length);
            return true;
        }
        return false;
    }

    public byte[] receive() {
        int size;
        if (this.mHandle != 0L && (size = this.receiveData(this.mHandle, this.mReceive, 255, 1)) > 0) {
            byte[] raw = new byte[size];
            for (int i = 0; i < raw.length; ++i) {
                raw[i] = this.mReceive[i];
            }
            return raw;
        }
        return null;
    }

    public void destroy() {
        if (this.mHandle != 0L) {
            this.uninitSerial(this.mHandle);
        }
    }

    static {
        System.loadLibrary("serial");
    }
}

