/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.widget.effective;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import com.guo.android_extend.widget.effective.HCSListView;

public abstract class HCSEffectAdapter
extends BaseAdapter
implements HCSListView.OnItemScrollListener {
    private final String TAG = this.getClass().toString();
    private final int ANIMATION_TIME = 200;
    private final int ANIMATION_DELETE_TIME = 350;
    private ACTION mCurAction;
    private Animation mAniOut;
    private Animation mAniIn;
    public float SCAEL_PERCENT = 0.5f;
    private float PRE_XY = 0.3f;
    private int mMaxY;
    private int mMinY;
    private int mCurY;
    private int mMaxX;
    private int mMinX;
    private int mCurX;
    private int mCenterID;
    private int mOffSetLeft;
    private int mOffSetRight;
    protected Context mContext;
    protected HCSListView mHLV;

    public HCSEffectAdapter(HCSListView context) {
        this.mHLV = context;
        this.mContext = this.mHLV.getContext();
        this.mCurAction = ACTION.NONE;
        this.mCenterID = 0;
        this.mAniOut = new ScaleAnimation(1.0f + this.SCAEL_PERCENT, 1.0f, 1.0f + this.SCAEL_PERCENT, 1.0f, 1, 0.5f, 1, 0.5f);
        this.mAniOut.setFillAfter(true);
        this.mAniOut.setDuration(200L);
        this.mAniIn = new ScaleAnimation(this.SCAEL_PERCENT, 1.0f, this.SCAEL_PERCENT, 1.0f, 1, 0.5f, 1, 0.5f);
        this.mAniIn.setFillAfter(true);
        this.mAniIn.setDuration(200L);
    }

    public abstract void frashViewList();

    public abstract void scaleView(View var1, float var2);

    public abstract void animaView(View var1, Animation var2);

    public abstract void animaClearView(View var1);

    public abstract int removeView(View var1);

    protected void dialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        builder.setMessage((CharSequence)"remove");
        builder.setTitle((CharSequence)"confirm");
        builder.setPositiveButton((CharSequence)"yes", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                int id = HCSEffectAdapter.this.removeView(HCSEffectAdapter.this.mHLV.getChildAt(HCSEffectAdapter.this.mCenterID));
                HCSEffectAdapter.this.endDelYAnimation(HCSEffectAdapter.this.mHLV);
                HCSEffectAdapter.this.mHLV.setSelection(id);
                HCSEffectAdapter.this.frashViewList();
            }
        });
        builder.setNegativeButton((CharSequence)"cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                HCSEffectAdapter.this.startDelAnimation(HCSEffectAdapter.this.mHLV, false);
            }
        });
        builder.create().show();
    }

    @Override
    public void OnScrollCenter(AdapterView<ListAdapter> adp, View v, int pos, float percent) {
        Log.i((String)this.TAG, (String)("OnScrollCenter percent = " + percent + "mCenterID = " + pos));
        this.mCenterID = pos;
    }

    @Override
    public void OnScrollStart(AdapterView<ListAdapter> adp) {
        Log.i((String)this.TAG, (String)("OnScrollStart mCenterID =" + this.mCenterID));
        this.mCurAction = ACTION.SCROLL;
        View v = adp.getChildAt(this.mCenterID);
        this.scaleView(v, this.SCAEL_PERCENT);
        this.animaView(v, this.mAniOut);
        for (int j = 0; j < adp.getChildCount(); ++j) {
            v = adp.getChildAt(j);
            if (j == this.mCenterID) continue;
            this.animaClearView(v);
        }
    }

    @Override
    public void OnScrollEnd(AdapterView<ListAdapter> adp, int pos) {
        Log.i((String)this.TAG, (String)("OnScrollEnd mCenterID = " + pos + "mCurAction=" + (Object)((Object)this.mCurAction)));
        if (this.mCurAction == ACTION.DRAG_DEL_ING) {
            return;
        }
        if (this.mCurAction == ACTION.DRAG_DEL_END) {
            this.endDelXAnimation(adp);
        }
        this.mCurAction = ACTION.NONE;
        if (pos >= adp.getChildCount()) {
            --pos;
        }
        View v = adp.getChildAt(pos);
        this.scaleView(v, 1.0f);
        this.animaView(v, this.mAniIn);
        for (int i = 0; i < adp.getChildCount(); ++i) {
            v = adp.getChildAt(i);
            if (i == pos) continue;
            this.animaClearView(v);
        }
        this.mMaxY = (int)((float)v.getTop() + (float)v.getHeight() * 0.4f);
        this.mMinY = 0;
        this.mCurY = 0;
        this.mMaxX = (int)((float)v.getWidth() * 0.4f);
        this.mMinX = 0;
        this.mCurX = 0;
    }

    @Override
    public boolean OnDraging(AdapterView<ListAdapter> adp, float dx, float dy) {
        if (dy <= 0.0f && this.mCurY == this.mMinY || dy >= 0.0f && this.mCurY == this.mMaxY || this.mCenterID == -1) {
            return false;
        }
        if (this.mCurAction != ACTION.NONE && this.mCurAction != ACTION.DRAG_DEL_ING) {
            return false;
        }
        this.mCurAction = ACTION.DRAG_DEL_ING;
        int mTemp1 = (int)(dy * this.PRE_XY);
        int mTemp2 = (int)dy;
        if (mTemp1 < 0) {
            if (this.mCurX + mTemp1 >= this.mMinX) {
                this.mCurX += mTemp1;
            } else {
                mTemp1 = this.mMinX - this.mCurX;
                this.mCurX = this.mMinX;
            }
        } else if (this.mCurX + mTemp1 <= this.mMaxX) {
            this.mCurX += mTemp1;
        } else {
            mTemp1 = this.mMaxX - this.mCurX;
            this.mCurX = this.mMaxX;
        }
        if (mTemp2 < 0) {
            if (this.mCurY + mTemp2 >= this.mMinY) {
                this.mCurY += mTemp2;
            } else {
                mTemp2 = this.mMinY - this.mCurY;
                this.mCurY = this.mMinY;
            }
        } else if (this.mCurY + mTemp2 <= this.mMaxY) {
            this.mCurY += mTemp2;
        } else {
            mTemp2 = this.mMaxY - this.mCurY;
            this.mCurY = this.mMaxY;
        }
        boolean left = false;
        for (int i = 0; i < adp.getChildCount(); ++i) {
            View v = adp.getChildAt(i);
            if (i == this.mCenterID) {
                if (Build.VERSION.SDK_INT > 10) {
                    v.setTop(v.getTop() - mTemp2);
                } else {
                    v.layout(v.getLeft(), v.getTop() - mTemp2, v.getRight(), v.getBottom());
                }
                left = true;
                continue;
            }
            if (left) {
                if (Build.VERSION.SDK_INT > 10) {
                    v.setLeft(v.getLeft() - mTemp1);
                    v.setRight(v.getRight() - mTemp1);
                    continue;
                }
                v.layout(v.getLeft() - mTemp1, v.getTop(), v.getRight() - mTemp1, v.getBottom());
                continue;
            }
            if (Build.VERSION.SDK_INT > 10) {
                v.setLeft(v.getLeft() + mTemp1);
                v.setRight(v.getRight() + mTemp1);
                continue;
            }
            v.layout(v.getLeft() + mTemp1, v.getTop(), v.getRight() + mTemp1, v.getBottom());
        }
        return true;
    }

    @Override
    public boolean OnDragingOver(AdapterView<ListAdapter> adp) {
        this.startDelAnimation(adp, this.mCurY * 2 >= this.mMaxY);
        return true;
    }

    public void startDelAnimation(AdapterView<ListAdapter> adp, boolean isOpen) {
        int mTemp2;
        int mTemp1;
        int ani_time = 350 * this.mCurY / this.mMaxY;
        if (isOpen) {
            mTemp1 = this.mMaxX - this.mCurX;
            mTemp2 = this.mMaxY - this.mCurY;
            this.mCurY = this.mMaxY;
            this.mCurX = this.mMaxX;
        } else {
            mTemp1 = this.mMinX - this.mCurX;
            mTemp2 = this.mMinY - this.mCurY;
            this.mCurY = this.mMinY;
            this.mCurX = this.mMinX;
        }
        this.mCurAction = ACTION.DRAG_DEL_ING;
        TranslateAnimation mAniOut = new TranslateAnimation(0, 0.0f, 0, 0.0f, 0, (float)mTemp2, 0, 0.0f);
        mAniOut.setFillAfter(true);
        mAniOut.setDuration((long)ani_time);
        TranslateAnimation mAniLeft = new TranslateAnimation(0, (float)mTemp1, 0, 0.0f, 0, 0.0f, 0, 0.0f);
        mAniLeft.setFillAfter(true);
        mAniLeft.setDuration((long)ani_time);
        TranslateAnimation mAniRight = new TranslateAnimation(0, (float)(-mTemp1), 0, 0.0f, 0, 0.0f, 0, 0.0f);
        mAniRight.setFillAfter(true);
        mAniRight.setDuration((long)ani_time);
        boolean left = false;
        for (int i = 0; i < adp.getChildCount(); ++i) {
            View v = adp.getChildAt(i);
            if (i == this.mCenterID) {
                if (Build.VERSION.SDK_INT > 10) {
                    v.setTop(v.getTop() - mTemp2);
                } else {
                    v.layout(v.getLeft(), v.getTop() - mTemp2, v.getRight(), v.getBottom());
                }
                v.startAnimation((Animation)mAniOut);
                left = true;
                continue;
            }
            if (left) {
                if (Build.VERSION.SDK_INT > 10) {
                    v.setLeft(v.getLeft() - mTemp1);
                    v.setRight(v.getRight() - mTemp1);
                } else {
                    v.layout(v.getLeft() - mTemp1, v.getTop(), v.getRight() - mTemp1, v.getBottom());
                }
                v.startAnimation((Animation)mAniLeft);
                continue;
            }
            if (Build.VERSION.SDK_INT > 10) {
                v.setLeft(v.getLeft() + mTemp1);
                v.setRight(v.getRight() + mTemp1);
            } else {
                v.layout(v.getLeft() + mTemp1, v.getTop(), v.getRight() + mTemp1, v.getBottom());
            }
            v.startAnimation((Animation)mAniRight);
        }
        if (this.mCurY == this.mMaxY) {
            this.dialog();
        }
    }

    public void endDelXAnimation(AdapterView<ListAdapter> adp) {
        TranslateAnimation mAniRight;
        int offset;
        int ani_time = 350 * this.mCurX / this.mMaxX;
        if (this.mOffSetLeft != -1) {
            offset = this.mOffSetLeft;
            mAniRight = new TranslateAnimation(0, (float)(-offset), 0, 0.0f, 0, 0.0f, 0, 0.0f);
            mAniRight.setFillAfter(true);
            mAniRight.setDuration((long)ani_time);
            Log.i((String)this.TAG, (String)("mCenterID = " + this.mCenterID + ",Count=" + adp.getChildCount()));
            for (int i = this.mCenterID; i < adp.getChildCount(); ++i) {
                View v = adp.getChildAt(i);
                v.setVisibility(8);
                if (Build.VERSION.SDK_INT > 10) {
                    v.setLeft(v.getLeft() + offset);
                    v.setRight(v.getRight() + offset);
                } else {
                    v.layout(v.getLeft() + offset, v.getTop(), v.getRight() + offset, v.getBottom());
                }
                v.setVisibility(0);
                v.startAnimation((Animation)mAniRight);
            }
            int mTemp1 = this.mMinX - this.mCurX;
            TranslateAnimation mAniLeft = new TranslateAnimation(0, (float)(-mTemp1), 0, 0.0f, 0, 0.0f, 0, 0.0f);
            mAniLeft.setFillAfter(true);
            mAniLeft.setDuration((long)ani_time);
            for (int i = 0; i < this.mCenterID; ++i) {
                View v = adp.getChildAt(i);
                v.setVisibility(8);
                if (Build.VERSION.SDK_INT > 10) {
                    v.setLeft(v.getLeft() - mTemp1);
                    v.setRight(v.getRight() - mTemp1);
                } else {
                    v.layout(v.getLeft() - mTemp1, v.getTop(), v.getRight() - mTemp1, v.getBottom());
                }
                v.setVisibility(0);
                v.startAnimation((Animation)mAniLeft);
            }
        }
        if (this.mOffSetRight != -1) {
            offset = 0;
            mAniRight = new TranslateAnimation(0, (float)(-this.mOffSetRight), 0, 0.0f, 0, 0.0f, 0, 0.0f);
            mAniRight.setFillAfter(true);
            mAniRight.setDuration((long)ani_time);
            for (int i = 0; i <= this.mCenterID; ++i) {
                View v = adp.getChildAt(i);
                v.setVisibility(8);
                if (Build.VERSION.SDK_INT > 10) {
                    v.setLeft(v.getLeft() + offset);
                    v.setRight(v.getRight() + offset);
                } else {
                    v.layout(v.getLeft() + offset, v.getTop(), v.getRight() + offset, v.getBottom());
                }
                v.setVisibility(0);
                v.startAnimation((Animation)mAniRight);
            }
        }
        this.mCurX = this.mMinX;
        this.mCenterID = -1;
    }

    public void endDelYAnimation(AdapterView<ListAdapter> adp) {
        int ani_time = 350 * this.mCurY / this.mMaxY;
        View center = adp.getChildAt(this.mCenterID);
        View left = null;
        View right = null;
        if (this.mCenterID > 0) {
            left = adp.getChildAt(this.mCenterID - 1);
        }
        if (this.mCenterID + 1 < adp.getChildCount()) {
            right = adp.getChildAt(this.mCenterID + 1);
        }
        if (this.mCenterID + 1 >= adp.getChildCount()) {
            --this.mCenterID;
        }
        int mTemp2 = this.mMaxY;
        TranslateAnimation mAni = new TranslateAnimation(0, 0.0f, 0, 0.0f, 0, (float)mTemp2, 0, 0.0f);
        mAni.setFillAfter(true);
        mAni.setDuration((long)ani_time);
        if (Build.VERSION.SDK_INT > 10) {
            center.setTop(center.getTop() - mTemp2);
        } else {
            center.layout(center.getLeft(), center.getTop() - mTemp2, center.getRight(), center.getBottom());
        }
        center.startAnimation((Animation)mAni);
        this.mOffSetLeft = -1;
        this.mOffSetRight = -1;
        if (right != null) {
            this.mOffSetLeft = center.getLeft() - right.getLeft();
        } else if (left != null) {
            this.mOffSetRight = center.getLeft() - left.getLeft();
        }
        this.mCurY = this.mMinY;
        this.mCurAction = ACTION.DRAG_DEL_END;
    }

    private static enum ACTION {
        NONE,
        DRAG_MOVE,
        DRAG_DEL_ING,
        DRAG_DEL_END,
        SCROLL,
        FLUSH;

    }
}

