/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.widget.controller;

import android.content.Context;
import android.graphics.Canvas;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import com.guo.android_extend.widget.controller.AbstractController;

public class ImageController
extends AbstractController {
    private final String TAG = this.getClass().toString();
    float mCurScale = 1.0f;
    float mDefOffsetX;
    float mDefOffsetY;
    float mCurOffsetX;
    float mCurOffsetY;
    float mMotionOffsetX;
    float mMotionOffsetY;
    float mOffsetX;
    float mOffsetY;
    float mDownOffsetX;
    float mDownOffsetY;
    float mWorldWidth = -1.0f;
    float mWorldHeight = -1.0f;
    float mImageWidth;
    float mImageHeight;
    float mStepX;
    float mStepY;
    float mAnimationOffsetX;
    float mAnimationOffsetY;
    float mAnimationStartX;
    float mAnimationStartY;
    float mStepScale;
    float mAnimationScale;
    private STATUS mScaleStatus;
    private STATUS mOffsetXStatus;
    private STATUS mOffsetYStatus;
    private float MAX_STEP = 10.0f;
    private MODE mMode = MODE.IDEL;
    private int MAX_DISTANCE_MOVE;
    private int MAX_DOUBLE_TAP_TIME;
    private MotionEvent mCurrentDownEvent;
    private MotionEvent mPreviousUpEvent;
    private float LIMIT_SCALE_MIN;
    private float LIMIT_SCALE_MAX;
    private float MIN_SCALE = 0.5f;
    private float NORMAL_SCALE = 1.0f;
    private float MAX_SCALE = 2.0f;
    private float[] mScales = null;
    private int mCurLevel = 0;

    public ImageController(AbstractController.ControllerListener mListener) {
        super(mListener);
        this.mScaleStatus = STATUS.IDEL;
        this.mOffsetXStatus = STATUS.IDEL;
        this.mOffsetYStatus = STATUS.IDEL;
    }

    public ImageController(Context context, AbstractController.ControllerListener mListener) {
        this(mListener);
        ViewConfiguration config = ViewConfiguration.get((Context)context);
        this.MAX_DISTANCE_MOVE = config.getScaledTouchSlop();
        Log.i((String)this.TAG, (String)("MAX_DISTANCE_MOVE = " + this.MAX_DISTANCE_MOVE));
        this.MAX_DOUBLE_TAP_TIME = ViewConfiguration.getDoubleTapTimeout();
        Log.i((String)this.TAG, (String)("MAX_DOUBLE_TAP_TIME = " + this.MAX_DOUBLE_TAP_TIME));
    }

    @Override
    public void beforeDraw(Canvas canvas) {
        if (this.mMode == MODE.ANIMATION) {
            boolean finshX = this.calculateOffsetX();
            boolean finshY = this.calculateOffsetY();
            boolean finshScale = this.calculateScale();
            if (finshScale && finshX && finshY) {
                this.mMode = MODE.IDEL;
            }
            this.mListener.invalidate();
            canvas.save();
            canvas.translate(this.mAnimationOffsetX - this.mAnimationStartX + this.mOffsetX, this.mAnimationOffsetY - this.mAnimationStartY + this.mOffsetY);
            canvas.scale(this.mAnimationScale, this.mAnimationScale, this.mCurPointMidd.x, this.mCurPointMidd.y);
        } else {
            canvas.save();
            canvas.translate(this.mOffsetX, this.mOffsetY);
            canvas.scale(this.mCurScale, this.mCurScale, this.mCurPointMidd.x, this.mCurPointMidd.y);
        }
    }

    @Override
    public void afterDraw(Canvas canvas) {
        canvas.restore();
    }

    protected void initialInnerData() {
        this.mCurOffsetX = this.mDefOffsetX;
        this.mCurOffsetY = this.mDefOffsetY;
        this.mMotionOffsetX = this.mCurOffsetX;
        this.mMotionOffsetY = this.mCurOffsetY;
        this.mOffsetX = 0.0f;
        this.mOffsetY = 0.0f;
        this.mScales[0] = this.mCurScale;
        this.mCurPointMidd.set(this.mWorldWidth / 2.0f, this.mWorldHeight / 2.0f);
    }

    protected void uninitialInnerData() {
        this.mWorldWidth = -1.0f;
        this.mImageHeight = -1.0f;
        this.mScales = null;
    }

    private void initOffsetAnimation(float scale) {
        float w = this.mImageWidth * scale;
        float h = this.mImageHeight * scale;
        this.mDefOffsetX = (this.mWorldWidth - this.mImageWidth * scale) / 2.0f;
        this.mDefOffsetY = (this.mWorldHeight - this.mImageHeight * scale) / 2.0f;
        this.mAnimationOffsetX = this.mMotionOffsetX;
        this.mAnimationOffsetY = this.mMotionOffsetY;
        if (w <= this.mWorldWidth + 0.001f && h <= this.mWorldHeight + 0.001f) {
            this.mStepX = -(this.mMotionOffsetX - this.mDefOffsetX) / this.MAX_STEP;
            this.mStepY = -(this.mMotionOffsetY - this.mDefOffsetY) / this.MAX_STEP;
            this.mMode = MODE.ANIMATION;
            this.mMotionOffsetX = this.mDefOffsetX;
            this.mMotionOffsetY = this.mDefOffsetY;
            this.mOffsetX = 0.0f;
            this.mOffsetY = 0.0f;
        } else {
            if (w > this.mWorldWidth) {
                if (this.mMotionOffsetX > 0.0f) {
                    this.mStepX = -(this.mMotionOffsetX - 0.0f) / this.MAX_STEP;
                    this.mMode = MODE.ANIMATION;
                    this.mMotionOffsetX = 0.0f;
                    this.mOffsetX = -this.mDefOffsetX;
                } else if (this.mMotionOffsetX < this.mWorldWidth - w) {
                    this.mStepX = -(this.mMotionOffsetX - (this.mWorldWidth - w)) / this.MAX_STEP;
                    this.mMode = MODE.ANIMATION;
                    this.mMotionOffsetX = this.mWorldWidth - w;
                    this.mOffsetX = this.mDefOffsetX;
                }
            } else {
                this.mStepX = -(this.mMotionOffsetX - this.mDefOffsetX) / this.MAX_STEP;
                this.mMode = MODE.ANIMATION;
                this.mMotionOffsetX = this.mDefOffsetX;
                this.mOffsetX = 0.0f;
            }
            if (h > this.mWorldHeight) {
                if (this.mMotionOffsetY > 0.0f) {
                    this.mStepY = -(this.mMotionOffsetY - 0.0f) / this.MAX_STEP;
                    this.mMode = MODE.ANIMATION;
                    this.mMotionOffsetY = 0.0f;
                    this.mOffsetY = -this.mDefOffsetY;
                } else if (this.mMotionOffsetY < this.mWorldHeight - h) {
                    this.mStepY = -(this.mMotionOffsetY - (this.mWorldHeight - h)) / this.MAX_STEP;
                    this.mMode = MODE.ANIMATION;
                    this.mMotionOffsetY = this.mWorldHeight - h;
                    this.mOffsetY = this.mDefOffsetY;
                }
            } else {
                this.mStepY = -(this.mMotionOffsetY - this.mDefOffsetY) / this.MAX_STEP;
                this.mMode = MODE.ANIMATION;
                this.mMotionOffsetY = this.mDefOffsetY;
                this.mOffsetY = 0.0f;
            }
        }
        this.mAnimationStartX = this.mMotionOffsetX;
        this.mAnimationStartY = this.mMotionOffsetY;
    }

    private STATUS checkLimitScaleStatus(float scale) {
        if (scale > this.MAX_SCALE && scale - this.MAX_SCALE > 0.001f) {
            return STATUS.DECREASE;
        }
        if (scale < this.MIN_SCALE && this.MAX_SCALE - scale > 0.001f) {
            return STATUS.INCREASE;
        }
        return STATUS.IDEL;
    }

    private STATUS checkStatus(float start, float end) {
        if (Math.abs(start - end) < 0.001f) {
            return STATUS.IDEL;
        }
        if (start > end) {
            return STATUS.DECREASE;
        }
        return STATUS.INCREASE;
    }

    private void initScaleAnimation(float start, float end) {
        this.mAnimationScale = start;
        this.mStepScale = (end - start) / this.MAX_STEP;
        this.mMode = MODE.ANIMATION;
        this.mCurScale = end;
    }

    private void fixScaleOffsetAnimation(float start, float end) {
        this.mMotionOffsetX -= this.mImageWidth * (end - start) / 2.0f;
        this.mMotionOffsetY -= this.mImageHeight * (end - start) / 2.0f;
    }

    private boolean calculateScale() {
        boolean finshScale = true;
        if (this.mScaleStatus == STATUS.DECREASE) {
            this.mAnimationScale += this.mStepScale;
            if (this.mAnimationScale <= this.mCurScale) {
                this.mAnimationScale = this.mCurScale;
            } else {
                finshScale = false;
            }
        } else if (this.mScaleStatus == STATUS.INCREASE) {
            this.mAnimationScale += this.mStepScale;
            if (this.mAnimationScale >= this.mCurScale) {
                this.mAnimationScale = this.mCurScale;
            } else {
                finshScale = false;
            }
        }
        return finshScale;
    }

    private boolean calculateOffsetX() {
        boolean finsh = true;
        if (this.mOffsetXStatus == STATUS.DECREASE) {
            this.mAnimationOffsetX += this.mStepX;
            if (this.mAnimationOffsetX <= this.mMotionOffsetX) {
                this.mAnimationOffsetX = this.mMotionOffsetX;
            } else {
                finsh = false;
            }
        } else if (this.mOffsetXStatus == STATUS.INCREASE) {
            this.mAnimationOffsetX += this.mStepX;
            if (this.mAnimationOffsetX >= this.mMotionOffsetX) {
                this.mAnimationOffsetX = this.mMotionOffsetX;
            } else {
                finsh = false;
            }
        }
        return finsh;
    }

    private boolean calculateOffsetY() {
        boolean finsh = true;
        if (this.mOffsetYStatus == STATUS.DECREASE) {
            this.mAnimationOffsetY += this.mStepY;
            if (this.mAnimationOffsetY <= this.mMotionOffsetY) {
                this.mAnimationOffsetY = this.mMotionOffsetY;
            } else {
                finsh = false;
            }
        } else if (this.mOffsetYStatus == STATUS.INCREASE) {
            this.mAnimationOffsetY += this.mStepY;
            if (this.mAnimationOffsetY >= this.mMotionOffsetY) {
                this.mAnimationOffsetY = this.mMotionOffsetY;
            } else {
                finsh = false;
            }
        }
        return finsh;
    }

    private boolean isConsideredDoubleTap(MotionEvent firstDown, MotionEvent firstUp, MotionEvent secondDown) {
        int deltaY;
        if (secondDown.getEventTime() - firstUp.getEventTime() > (long)this.MAX_DOUBLE_TAP_TIME) {
            return false;
        }
        int deltaX = (int)firstUp.getX() - (int)secondDown.getX();
        return deltaX * deltaX + (deltaY = (int)firstUp.getY() - (int)secondDown.getY()) * deltaY < this.MAX_DISTANCE_MOVE * this.MAX_DISTANCE_MOVE;
    }

    private void initDoubleClick() {
        float fitin = Math.min(this.mWorldWidth / this.mImageWidth, this.mWorldHeight / this.mImageHeight);
        if (Math.abs(fitin - this.MIN_SCALE) < 0.001f || Math.abs(fitin - this.NORMAL_SCALE) < 0.001f || Math.abs(fitin - this.MAX_SCALE) < 0.001f) {
            this.mScales = Math.abs(this.MIN_SCALE - this.NORMAL_SCALE) < 0.001f || Math.abs(this.MAX_SCALE - this.NORMAL_SCALE) < 0.001f ? new float[]{1.0f, this.MIN_SCALE, this.MAX_SCALE} : new float[]{1.0f, this.MIN_SCALE, this.NORMAL_SCALE, this.MAX_SCALE};
        } else if (fitin < this.MIN_SCALE) {
            this.MIN_SCALE = fitin;
            this.mScales = Math.abs(this.MIN_SCALE - this.NORMAL_SCALE) < 0.001f || Math.abs(this.MAX_SCALE - this.NORMAL_SCALE) < 0.001f ? new float[]{1.0f, this.MIN_SCALE, this.MAX_SCALE} : new float[]{1.0f, this.MIN_SCALE, this.NORMAL_SCALE, this.MAX_SCALE};
        } else if (fitin > this.MAX_SCALE) {
            this.MAX_SCALE = fitin;
            this.mScales = Math.abs(this.MIN_SCALE - this.NORMAL_SCALE) < 0.001f || Math.abs(this.MAX_SCALE - this.NORMAL_SCALE) < 0.001f ? new float[]{1.0f, this.MIN_SCALE, this.MAX_SCALE} : new float[]{1.0f, this.MIN_SCALE, this.NORMAL_SCALE, this.MAX_SCALE};
        } else {
            this.mScales = Math.abs(this.MIN_SCALE - this.NORMAL_SCALE) < 0.001f || Math.abs(this.MAX_SCALE - this.NORMAL_SCALE) < 0.001f ? new float[]{1.0f, this.MIN_SCALE, this.MAX_SCALE, fitin} : new float[]{1.0f, this.MIN_SCALE, this.NORMAL_SCALE, this.MAX_SCALE, fitin};
        }
    }

    protected void doDoubleClick() {
        ++this.mCurLevel;
        if (this.mCurLevel >= this.mScales.length) {
            this.mCurLevel = 1;
        }
        this.scaleTo(this.mScales[this.mCurLevel]);
    }

    protected void doTouchDown(MotionEvent event) {
        this.mCurrentDownEvent = MotionEvent.obtain((MotionEvent)event);
        this.mCurPointDown.set(event.getX(0), event.getY(0));
        this.mDownOffsetX = this.mOffsetX;
        this.mDownOffsetY = this.mOffsetY;
        this.mCurOffsetX = this.mMotionOffsetX;
        this.mCurOffsetY = this.mMotionOffsetY;
        this.mMode = MODE.PRE_DRAG;
    }

    protected void doScalePre(MotionEvent event) {
        this.mPreDistance = this.getDistance(event);
        this.mCurPointMidd.set(this.mListener.getCenterPoint());
        this.mCurLevel = 0;
        this.mScales[0] = this.mCurScale;
        this.mMode = MODE.SCALE;
    }

    protected void doScale(MotionEvent event) {
        this.mCurScale = this.mScales[0] * this.getDistance(event) / this.mPreDistance;
        this.mCurScale = Math.min(this.LIMIT_SCALE_MAX, this.mCurScale);
        this.mCurScale = Math.max(this.LIMIT_SCALE_MIN, this.mCurScale);
        this.mListener.invalidate();
    }

    protected void doScaleOver() {
        this.mScaleStatus = this.checkLimitScaleStatus(this.mCurScale);
        if (this.mScaleStatus == STATUS.DECREASE) {
            this.initScaleAnimation(this.mCurScale, this.MAX_SCALE);
        } else if (this.mScaleStatus == STATUS.INCREASE) {
            this.initScaleAnimation(this.mCurScale, this.MIN_SCALE);
        } else {
            this.mAnimationScale = this.mCurScale;
        }
        this.fixScaleOffsetAnimation(this.mScales[0], this.mCurScale);
        this.initOffsetAnimation(this.mCurScale);
        this.mOffsetXStatus = this.checkStatus(this.mAnimationOffsetX, this.mMotionOffsetX);
        this.mOffsetYStatus = this.checkStatus(this.mAnimationOffsetY, this.mMotionOffsetY);
        if (this.mMode != MODE.ANIMATION) {
            this.mMode = MODE.IDEL;
        }
    }

    protected void doDrag(MotionEvent event) {
        this.mMotionOffsetX = this.mCurOffsetX + event.getX(0) - this.mCurPointDown.x;
        this.mMotionOffsetY = this.mCurOffsetY + event.getY(0) - this.mCurPointDown.y;
        this.mOffsetX = this.mDownOffsetX + event.getX(0) - this.mCurPointDown.x;
        this.mOffsetY = this.mDownOffsetY + event.getY(0) - this.mCurPointDown.y;
        this.mListener.invalidate();
    }

    protected void doDragOver() {
        this.mScaleStatus = STATUS.IDEL;
        this.mAnimationScale = this.mCurScale;
        this.initOffsetAnimation(this.mCurScale);
        this.mOffsetXStatus = this.checkStatus(this.mAnimationOffsetX, this.mMotionOffsetX);
        this.mOffsetYStatus = this.checkStatus(this.mAnimationOffsetY, this.mMotionOffsetY);
        if (this.mMode != MODE.ANIMATION) {
            this.mMode = MODE.IDEL;
        }
    }

    public void scaleTo(float scale) {
        this.mScaleStatus = this.checkStatus(this.mCurScale, scale);
        if (this.mScaleStatus != STATUS.IDEL) {
            this.initScaleAnimation(this.mCurScale, scale);
        } else {
            this.mAnimationScale = this.mCurScale;
        }
        this.fixScaleOffsetAnimation(this.mAnimationScale, this.mCurScale);
        this.initOffsetAnimation(this.mCurScale);
        this.mOffsetXStatus = this.checkStatus(this.mAnimationOffsetX, this.mMotionOffsetX);
        this.mOffsetYStatus = this.checkStatus(this.mAnimationOffsetY, this.mMotionOffsetY);
        this.mListener.invalidate();
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction() & 0xFF) {
            case 0: {
                if (this.mMode != MODE.IDEL) break;
                if (this.mPreviousUpEvent != null && this.mCurrentDownEvent != null && this.isConsideredDoubleTap(this.mCurrentDownEvent, this.mPreviousUpEvent, event)) {
                    this.doDoubleClick();
                    break;
                }
                this.doTouchDown(event);
                break;
            }
            case 5: {
                if (this.mMode == MODE.ANIMATION || event.getPointerCount() != 2) break;
                this.doScalePre(event);
                break;
            }
            case 2: {
                if (this.mMode == MODE.PRE_DRAG && event.getPointerCount() == 1) {
                    float y;
                    float x = event.getX(0) - this.mCurPointDown.x;
                    float d = (float)Math.hypot(x, y = event.getY(0) - this.mCurPointDown.y);
                    if (!(d > (float)this.MAX_DISTANCE_MOVE)) break;
                    this.mMode = MODE.DRAG;
                    break;
                }
                if (this.mMode == MODE.DRAG && event.getPointerCount() == 1) {
                    this.doDrag(event);
                    break;
                }
                if (this.mMode != MODE.SCALE || event.getPointerCount() != 2) break;
                this.doScale(event);
                break;
            }
            case 1: 
            case 3: {
                if (this.mMode == MODE.SCALE) {
                    this.mMode = MODE.IDEL;
                } else if (this.mMode == MODE.DRAG) {
                    this.doDragOver();
                } else if (this.mMode == MODE.PRE_DRAG) {
                    this.mMode = MODE.IDEL;
                }
                this.mPreviousUpEvent = MotionEvent.obtain((MotionEvent)event);
                this.mListener.invalidate();
                break;
            }
            case 6: {
                if (this.mMode == MODE.SCALE) {
                    this.doScaleOver();
                } else {
                    Log.e((String)this.TAG, (String)("ACTION_POINTER_UP error mMode =" + (Object)((Object)this.mMode)));
                }
                this.mListener.invalidate();
                break;
            }
            default: {
                this.mMode = MODE.IDEL;
            }
        }
        return true;
    }

    @Override
    public void initialize(float imageWidth, float imageHeight, float worldWidth, float worldHeight) {
        this.mWorldWidth = worldWidth;
        this.mWorldHeight = worldHeight;
        this.mImageWidth = imageWidth;
        this.mImageHeight = imageHeight;
        this.mDefOffsetX = (this.mWorldWidth - this.mImageWidth * this.mCurScale) / 2.0f;
        this.mDefOffsetY = (this.mWorldHeight - this.mImageHeight * this.mCurScale) / 2.0f;
        this.initDoubleClick();
        this.LIMIT_SCALE_MIN = Math.min(this.MIN_SCALE - 0.25f, 0.125f);
        this.LIMIT_SCALE_MAX = this.MAX_SCALE + 0.5f;
        this.initialInnerData();
    }

    public void setDefaultScale(float scale) {
        this.mCurScale = scale;
    }

    public boolean setDefaultLimit(float max, float min) {
        if (max >= min) {
            this.getClass();
            if (min > 0.001f) {
                this.MIN_SCALE = min;
                this.MAX_SCALE = max;
                return true;
            }
        }
        return false;
    }

    private static enum MODE {
        IDEL,
        PRE_DRAG,
        DRAG,
        SCALE,
        ANIMATION;

    }

    private static enum STATUS {
        IDEL,
        INCREASE,
        DECREASE;

    }
}

