/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.RelativeLayout;
import com.guo.android_extend.widget.ExtOrientationDetector;
import com.guo.android_extend.widget.RotateRunable;
import com.guo.android_extend.widget.controller.TouchController;

public class ExtRelativeLayout
extends RelativeLayout
implements ExtOrientationDetector.OnOrientationListener,
Animation.AnimationListener {
    private final String TAG = this.getClass().toString();
    private Handler mHandler;
    private final int ANIMATION_TIME = 300;
    private int mCurDegree;
    private float scaleX;
    private float scaleY;
    private TouchController mTouchController;
    private TouchController.OnDispatchTouchEventListener mOnDispatchTouchEventListener;

    public ExtRelativeLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.preCreate(context);
    }

    public ExtRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.preCreate(context);
    }

    public ExtRelativeLayout(Context context) {
        super(context);
        this.preCreate(context);
    }

    private void preCreate(Context context) {
        if (this.isInEditMode()) {
            return;
        }
        this.mOnDispatchTouchEventListener = null;
        this.mTouchController = new TouchController();
        this.mHandler = new Handler();
        this.mCurDegree = 0;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
    }

    @Override
    public boolean OnOrientationChanged(int degree, int offset, int flag) {
        if (flag != 3 && !this.isShown()) {
            Log.i((String)this.TAG, (String)"Not Shown!");
            return false;
        }
        RotateAnimation animation = new RotateAnimation((float)offset, 0.0f, 1, 0.5f, 1, 0.5f);
        animation.setDuration(300L);
        animation.setFillAfter(true);
        this.mHandler.post((Runnable)new RotateRunable((Animation)animation, (View)this, degree));
        this.mCurDegree = degree;
        return true;
    }

    public void onAnimationStart(Animation animation) {
        this.setVisibility(8);
        this.setEnabled(false);
    }

    public void onAnimationEnd(Animation animation) {
        this.setVisibility(0);
        this.setEnabled(true);
    }

    public void onAnimationRepeat(Animation animation) {
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.scale(this.scaleX, this.scaleY, (float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
        canvas.rotate((float)(-this.mCurDegree), (float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
    }

    @Override
    public int getCurrentOrientationDegree() {
        return this.mCurDegree;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        MotionEvent newEvent = ev;
        if (this.mTouchController != null) {
            newEvent = this.mTouchController.obtainTouchEvent(ev, this.getWidth(), this.getHeight(), this.mCurDegree);
        }
        if (this.mOnDispatchTouchEventListener != null) {
            this.mOnDispatchTouchEventListener.onDispatchTouchEvent((View)this, ev);
        }
        return super.dispatchTouchEvent(newEvent);
    }

    public void setScale(float sx, float sy) {
        this.scaleX = sx;
        this.scaleY = sy;
    }

    public void setTouchControllerListener(TouchController controller) {
        this.mTouchController = controller;
    }

    public void setOnDispatchTouchEventListener(TouchController.OnDispatchTouchEventListener listener) {
        this.mOnDispatchTouchEventListener = listener;
    }
}

