/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.image;

import android.graphics.Bitmap;

public class ImageConverter {
    private final String TAG = this.getClass().getSimpleName();
    public static final int CP_MJPEG = 40960;
    public static final int CP_PNG = 45056;
    public static final int CP_RGBA8888 = 1;
    public static final int CP_RGB565 = 4;
    public static final int CP_RGBA4444 = 7;
    public static final int CP_PAF_NV21 = 2050;
    public static final int CP_PAF_NV12 = 2049;
    public static final int CP_PAF_YUYV = 1281;
    public static final int CP_PAF_I420 = 1537;
    public static final int CP_PAF_BGR24 = 513;
    private int handle = -1;

    private native int image_init(int var1, int var2, int var3);

    private native int image_convert(int var1, Bitmap var2, byte[] var3);

    private native int image_uninit(int var1);

    public boolean initial(int width, int height, int format) {
        this.handle = this.image_init(width, height, format);
        return this.handle != -1;
    }

    public boolean convert(Bitmap src, byte[] data) {
        return 0 == this.image_convert(this.handle, src, data);
    }

    public void destroy() {
        if (this.handle != -1) {
            this.image_uninit(this.handle);
        }
    }

    public static int calcImageSize(int w, int h, int format) {
        switch (format) {
            case 2049: 
            case 2050: {
                return w * h * 3 / 2;
            }
            case 4: 
            case 7: 
            case 1281: {
                return w * h * 2;
            }
            case 1: 
            case 40960: {
                return w * h * 4;
            }
        }
        return 0;
    }

    static {
        System.loadLibrary("image");
    }
}

