/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.network.udp;

import android.content.Context;
import android.net.DhcpInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.util.Log;
import com.guo.android_extend.java.AbsLoop;
import com.guo.android_extend.network.udp.UDPDataProtocol;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class UDPTransponder {
    private String TAG = this.getClass().getSimpleName();
    public static final int UDP_PORT_R = 4200;
    public static final int UDP_PORT_S = 4201;
    public static final int BUFFER_LENGTH = 8192;
    private InetAddress mInetAddress;
    private Context mContext;
    private Receiver mReceiver;
    private Deliver mDeliver;
    private UDPDataProtocol mUDPDataProtocol;
    private int mDelay;

    public UDPTransponder(Context mContext) {
        this.mContext = mContext;
        this.mUDPDataProtocol = null;
        this.mDelay = 1000;
    }

    public void setUDPDataProtocol(UDPDataProtocol protocol) {
        this.mUDPDataProtocol = protocol;
    }

    private void debug_print(WifiManager wifiManager) {
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        DhcpInfo dhcpInfo = wifiManager.getDhcpInfo();
        Log.d((String)this.TAG, (String)("AP=" + dhcpInfo.ipAddress + ",MS=" + dhcpInfo.netmask));
        String wifiProperty = "\u5f53\u524d\u8fde\u63a5Wifi\u4fe1\u606f\u5982\u4e0b\uff1a" + wifiInfo.getSSID() + '\n' + "ip:" + this.FormatString(dhcpInfo.ipAddress) + '\n' + "mask:" + this.FormatString(dhcpInfo.netmask) + '\n' + "netgate:" + this.FormatString(dhcpInfo.gateway) + '\n' + "dns:" + this.FormatString(dhcpInfo.dns1);
        Log.d((String)this.TAG, (String)wifiProperty);
        try {
            Log.d((String)this.TAG, (String)("test:" + this.getBroadcastAddress(dhcpInfo.ipAddress, dhcpInfo.netmask)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String FormatString(int value) {
        return String.format("%d.%d.%d.%d", value & 0xFF, value >> 8 & 0xFF, value >> 16 & 0xFF, value >> 24 & 0xFF);
    }

    private InetAddress getBroadcastAddress(int ip, int mask) throws Exception {
        int broadcast = ip & mask | ~mask;
        byte[] quads = new byte[4];
        for (int k = 0; k < 4; ++k) {
            quads[k] = (byte)(broadcast >> k * 8 & 0xFF);
        }
        return InetAddress.getByAddress(quads);
    }

    public boolean multicastLAN() {
        try {
            this.mInetAddress = InetAddress.getByName("224.0.0.5");
            Log.d((String)this.TAG, (String)("multicast=" + this.mInetAddress));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public boolean broadcastLAN() {
        try {
            WifiManager wifiManager = (WifiManager)this.mContext.getSystemService("wifi");
            DhcpInfo dhcpInfo = wifiManager.getDhcpInfo();
            this.debug_print(wifiManager);
            this.mInetAddress = dhcpInfo.ipAddress == 0 ? InetAddress.getByName("192.168.43.255") : this.getBroadcastAddress(dhcpInfo.ipAddress, dhcpInfo.netmask);
            Log.d((String)this.TAG, (String)("broadcast=" + this.mInetAddress));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public boolean startReceiver() {
        if (this.mReceiver != null) {
            this.mReceiver.shutdown();
        }
        if (this.multicastLAN()) {
            this.mReceiver = new Receiver(this.mInetAddress, true);
            this.mReceiver.start();
        } else {
            this.mReceiver = new Receiver();
            this.mReceiver.start();
        }
        return true;
    }

    public void stopReceiver() {
        if (this.mReceiver != null) {
            this.mReceiver.shutdown();
            this.mReceiver = null;
        }
    }

    public boolean startDeliver(int time) {
        this.mDelay = time;
        return this.startDeliver();
    }

    public boolean startDeliver() {
        if (this.mDeliver != null) {
            this.mDeliver.shutdown();
        }
        if (this.multicastLAN()) {
            this.mDeliver = new Deliver(this.mInetAddress, true);
            this.mDeliver.start();
            return true;
        }
        if (this.broadcastLAN()) {
            this.mDeliver = new Deliver(this.mInetAddress);
            this.mDeliver.start();
            return true;
        }
        return false;
    }

    public void stopDeliver() {
        if (this.mDeliver != null) {
            this.mDeliver.shutdown();
            this.mDeliver = null;
        }
    }

    class Deliver
    extends AbsLoop {
        private DatagramSocket mDatagramSocket;
        private InetAddress mInetAddress;
        private boolean isMuliticast;

        public Deliver(InetAddress mInetAddress, boolean isMulticast) {
            this.mInetAddress = mInetAddress;
            this.isMuliticast = isMulticast;
        }

        public Deliver(InetAddress mInetAddress) {
            this(mInetAddress, false);
        }

        @Override
        public void setup() {
            try {
                if (this.isMuliticast) {
                    this.mDatagramSocket = new MulticastSocket(4201);
                } else {
                    this.mDatagramSocket = new DatagramSocket(4201);
                    this.mDatagramSocket.setBroadcast(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void loop() {
            try {
                Deliver deliver = this;
                synchronized (deliver) {
                    this.wait(1000L);
                }
                if (UDPTransponder.this.mUDPDataProtocol != null) {
                    byte[] data = UDPTransponder.this.mUDPDataProtocol.packaged();
                    DatagramPacket send = new DatagramPacket(data, data.length, this.mInetAddress, 4200);
                    this.mDatagramSocket.send(send);
                } else {
                    Log.e((String)UDPTransponder.this.TAG, (String)"UDPDataProtocol NULL! broadcast fail!");
                }
            }
            catch (Exception e) {
                Log.e((String)UDPTransponder.this.TAG, (String)e.getCause().getMessage());
            }
        }

        @Override
        public void over() {
            if (this.mDatagramSocket != null) {
                this.mDatagramSocket.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            super.shutdown();
            try {
                Deliver deliver = this;
                synchronized (deliver) {
                    this.notifyAll();
                }
                this.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class Receiver
    extends AbsLoop {
        private boolean isMuliticast;
        private InetAddress mInetAddress;
        private DatagramSocket mDatagramSocket;
        private byte[] mBuffer;

        public Receiver(InetAddress mInetAddress, boolean isMuliticast) {
            this.mInetAddress = mInetAddress;
            this.isMuliticast = isMuliticast;
        }

        public Receiver() {
            this(null, false);
        }

        @Override
        public void setup() {
            try {
                if (this.isMuliticast) {
                    this.mDatagramSocket = new MulticastSocket(4200);
                    MulticastSocket server = (MulticastSocket)this.mDatagramSocket;
                    server.joinGroup(this.mInetAddress);
                } else {
                    this.mDatagramSocket = new DatagramSocket(4200);
                    this.mDatagramSocket.setBroadcast(true);
                }
                this.mBuffer = new byte[8192];
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void loop() {
            try {
                Receiver receiver = this;
                synchronized (receiver) {
                    this.wait(UDPTransponder.this.mDelay);
                }
                DatagramPacket receive = new DatagramPacket(this.mBuffer, this.mBuffer.length);
                this.mDatagramSocket.receive(receive);
                String info = receive.getAddress().toString();
                String ip = info.substring(1, info.length());
                if (UDPTransponder.this.mUDPDataProtocol != null) {
                    UDPTransponder.this.mUDPDataProtocol.parsed(ip, receive.getData(), receive.getLength());
                } else {
                    Log.e((String)UDPTransponder.this.TAG, (String)("UDPDataProtocol NULL! IP:" + ip));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void over() {
            if (this.mDatagramSocket != null) {
                this.mDatagramSocket.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            super.shutdown();
            try {
                Receiver receiver = this;
                synchronized (receiver) {
                    this.notifyAll();
                }
                this.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

