/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.device;

import android.os.Handler;
import android.os.Message;
import com.guo.android_extend.device.Video;
import com.guo.android_extend.image.ImageConverter;
import com.guo.android_extend.java.AbsLoop;
import com.guo.android_extend.tools.FrameHelper;
import java.util.LinkedList;

public class VideoClient
extends AbsLoop {
    private final String TAG = this.getClass().getSimpleName();
    public static final int VIDEO_CODE = 20480;
    public static final int START_MSG = 20481;
    private Video mVideo;
    private Handler mHandler;
    private int mPreviewWidth;
    private int mPreviewHeight;
    private int mFormat;
    private FrameHelper mFrameHelper;
    private int mCameraID;
    private LinkedList<byte[]> mBufferQueue;
    private OnCameraListener mOnCameraListener;
    private boolean isPreviewStart;

    public VideoClient(Handler handle, int port) {
        this.mHandler = handle;
        this.mPreviewWidth = 640;
        this.mPreviewHeight = 480;
        this.mFormat = 2050;
        this.mCameraID = port;
        try {
            this.mVideo = new Video(port);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Create VideoClient ERROR");
        }
        this.mFrameHelper = new FrameHelper();
        this.mBufferQueue = new LinkedList();
        int size = ImageConverter.calcImageSize(this.mPreviewWidth, this.mPreviewHeight, this.mFormat);
        this.mBufferQueue.clear();
        this.mBufferQueue.add(new byte[size]);
        this.isPreviewStart = false;
    }

    public void setPreviewSize(int w, int h) {
        this.mPreviewWidth = w;
        this.mPreviewHeight = h;
    }

    public void setPreviewFormat(int format) {
        this.mFormat = format;
    }

    @Override
    public void setup() {
        Message msg = new Message();
        msg.what = 20480;
        msg.arg1 = 20481;
        this.mHandler.sendMessage(msg);
        int size = ImageConverter.calcImageSize(this.mPreviewWidth, this.mPreviewHeight, this.mFormat);
        this.mBufferQueue.clear();
        this.mBufferQueue.add(new byte[size]);
        this.mVideo.setVideo(this.mPreviewWidth, this.mPreviewHeight, this.mFormat);
    }

    @Override
    public void loop() {
        byte[] data = this.mBufferQueue.poll();
        int size = this.mVideo.readFrame(data);
        if (this.mOnCameraListener != null && this.isPreviewStart) {
            this.mOnCameraListener.onPreview(data, size, this.mCameraID);
        }
        this.mBufferQueue.offer(data);
        this.mFrameHelper.printFPS();
    }

    @Override
    public void over() {
        this.mVideo.destroy();
        this.mBufferQueue.clear();
    }

    public void addCallbackBuffer(byte[] data) {
        this.mBufferQueue.offer(data);
    }

    public void startPreview() {
        this.isPreviewStart = true;
    }

    public void stopPreview() {
        this.isPreviewStart = false;
    }

    public void setOnCameraListener(OnCameraListener l) {
        this.mOnCameraListener = l;
    }

    public static interface OnCameraListener {
        public void onPreview(byte[] var1, int var2, int var3);
    }
}

