/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.cache;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import com.guo.android_extend.cache.BitmapStructure;
import com.guo.android_extend.java.LRULinkedHashMap;
import java.lang.ref.SoftReference;
import java.util.HashMap;

public class BitmapCache<T> {
    private HashMap<T, SoftReference<Bitmap>> mCacheMap;
    private int mCacheHandle;
    private int CACHE_SIZE;
    private boolean USE_JVM_MEMORY;

    private native int cache_init(int var1);

    private native int cache_put(int var1, int var2, Bitmap var3);

    private native Bitmap cache_get(int var1, int var2);

    private native Bitmap cache_get(int var1, int var2, int var3);

    private native int cache_search(int var1, int var2, BitmapStructure var3);

    private native int cache_copy(int var1, int var2, Bitmap var3);

    private native int cache_uninit(int var1);

    public BitmapCache(int CacheSize, boolean useJVMMemory) {
        this.CACHE_SIZE = CacheSize;
        this.USE_JVM_MEMORY = useJVMMemory;
        if (this.USE_JVM_MEMORY) {
            this.mCacheMap = new LRULinkedHashMap<T, SoftReference<Bitmap>>(this.CACHE_SIZE, 0.75f, true);
        } else {
            this.mCacheHandle = this.cache_init(this.CACHE_SIZE);
        }
    }

    public synchronized boolean putBitmap(T id, Bitmap bitmap) {
        if (this.USE_JVM_MEMORY) {
            return this.mCacheMap.put(id, new SoftReference<Bitmap>(bitmap)) == null;
        }
        return this.cache_put(this.mCacheHandle, id.hashCode(), bitmap) == 0;
    }

    public synchronized Bitmap getBitmap(T id) {
        if (this.USE_JVM_MEMORY) {
            if (this.mCacheMap.containsKey(id)) {
                return this.mCacheMap.get(id).get();
            }
        } else {
            return this.cache_get(this.mCacheHandle, id.hashCode());
        }
        return null;
    }

    public synchronized Bitmap getBitmap(T id, Bitmap.Config config) {
        if (this.USE_JVM_MEMORY) {
            if (this.mCacheMap.containsKey(id)) {
                return this.mCacheMap.get(id).get();
            }
        } else {
            int format = BitmapStructure.Config2NativeFormat(config);
            return this.cache_get(this.mCacheHandle, id.hashCode(), format);
        }
        return null;
    }

    public synchronized boolean queryBitmap(T id, BitmapStructure info) {
        if (this.USE_JVM_MEMORY) {
            Bitmap bitmap;
            if (this.mCacheMap.containsKey(id) && (bitmap = this.mCacheMap.get(id).get()) != null) {
                info.setInfo(bitmap.getWidth(), bitmap.getHeight(), bitmap.getConfig());
                return true;
            }
            return false;
        }
        return 0 == this.cache_search(this.mCacheHandle, id.hashCode(), info);
    }

    public synchronized boolean copyBitmap(T id, Bitmap out) {
        if (this.USE_JVM_MEMORY) {
            Bitmap bitmap;
            if (this.mCacheMap.containsKey(id) && (bitmap = this.mCacheMap.get(id).get()) != null) {
                Canvas cvs = new Canvas(out);
                cvs.drawBitmap(bitmap, 0.0f, 0.0f, null);
                return true;
            }
            return false;
        }
        return 0 == this.cache_copy(this.mCacheHandle, id.hashCode(), out);
    }

    public synchronized void destroy() {
        if (this.USE_JVM_MEMORY) {
            this.mCacheMap.clear();
        } else {
            this.cache_uninit(this.mCacheHandle);
            this.mCacheHandle = 0;
        }
    }

    static {
        System.loadLibrary("cache");
    }
}

