/*
 * Decompiled with CFR 0.152.
 */
package com.guo.android_extend.tools;

import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.view.MotionEvent;
import android.view.View;
import java.util.ArrayList;

public class CameraHelper {
    public static int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    public static Rect cameraTapArea(int centerX, int centerY, float coefficient) {
        float focusAreaSize = 200.0f;
        int halfAreaSize = Float.valueOf(focusAreaSize * coefficient).intValue() / 2;
        int left = CameraHelper.clamp(centerX - halfAreaSize, -1000, 1000);
        int top = CameraHelper.clamp(centerY - halfAreaSize, -1000, 1000);
        int right = CameraHelper.clamp(centerX + halfAreaSize, -1000, 1000);
        int bottom = CameraHelper.clamp(centerY + halfAreaSize, -1000, 1000);
        RectF rectF = new RectF((float)left, (float)top, (float)right, (float)bottom);
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    public static void touchFocus(Camera camera1, Camera camera2, MotionEvent event, View view, Camera.AutoFocusCallback callback) {
        ArrayList<Camera.Area> meteringAreas;
        ArrayList<Camera.Area> focusAreas;
        Camera.Parameters parameters1 = camera1.getParameters();
        Camera.Parameters parameters2 = camera2.getParameters();
        int centerX = (int)((double)(event.getX() / (float)view.getWidth()) * 2000.0) - 1000;
        int centerY = (int)((double)(event.getY() / (float)view.getHeight()) * 2000.0) - 1000;
        Rect focusRect = CameraHelper.cameraTapArea(centerX, centerY, 1.0f);
        Rect meteringRect = CameraHelper.cameraTapArea(centerX, centerY, 1.5f);
        if (parameters1.getMaxNumFocusAreas() > 0) {
            focusAreas = new ArrayList<Camera.Area>();
            focusAreas.add(new Camera.Area(focusRect, 600));
            parameters1.setFocusAreas(focusAreas);
        }
        if (parameters1.getMaxNumMeteringAreas() > 0) {
            meteringAreas = new ArrayList<Camera.Area>();
            meteringAreas.add(new Camera.Area(meteringRect, 600));
            parameters1.setMeteringAreas(meteringAreas);
        }
        if (parameters2.getMaxNumFocusAreas() > 0) {
            focusAreas = new ArrayList();
            focusAreas.add(new Camera.Area(focusRect, 600));
            parameters2.setFocusAreas(focusAreas);
        }
        if (parameters2.getMaxNumMeteringAreas() > 0) {
            meteringAreas = new ArrayList();
            meteringAreas.add(new Camera.Area(meteringRect, 600));
            parameters2.setMeteringAreas(meteringAreas);
        }
        parameters1.setFocusMode("auto");
        camera1.cancelAutoFocus();
        parameters2.setFocusMode("auto");
        camera2.cancelAutoFocus();
        try {
            camera1.setParameters(parameters1);
            camera2.setParameters(parameters2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        camera1.autoFocus(callback);
        camera2.autoFocus(callback);
    }

    public static void touchFocus(Camera camera, MotionEvent event, View view, Camera.AutoFocusCallback callback) {
        Camera.Parameters parameters = camera.getParameters();
        Camera.Size size = parameters.getPreviewSize();
        int centerX = (int)((double)(event.getX() / (float)view.getWidth()) * 2000.0) - 1000;
        int centerY = (int)((double)(event.getY() / (float)view.getHeight()) * 2000.0) - 1000;
        Rect focusRect = CameraHelper.cameraTapArea(centerX, centerY, 1.0f);
        Rect meteringRect = CameraHelper.cameraTapArea(centerX, centerY, 1.5f);
        if (parameters.getMaxNumFocusAreas() > 0) {
            ArrayList<Camera.Area> focusAreas = new ArrayList<Camera.Area>();
            focusAreas.add(new Camera.Area(focusRect, 600));
            parameters.setFocusAreas(focusAreas);
        }
        if (parameters.getMaxNumMeteringAreas() > 0) {
            ArrayList<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
            meteringAreas.add(new Camera.Area(meteringRect, 600));
            parameters.setMeteringAreas(meteringAreas);
        }
        parameters.setFocusMode("auto");
        camera.cancelAutoFocus();
        try {
            camera.setParameters(parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        camera.autoFocus(callback);
    }

    public static void lockfocus(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        parameters.setFocusMode("fixed");
        try {
            camera.setParameters(parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unlockfocus(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        parameters.setFocusMode("auto");
        try {
            camera.setParameters(parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void lockAeAwb(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        if (parameters.isAutoExposureLockSupported()) {
            parameters.setAutoExposureLock(true);
        }
        if (parameters.isAutoWhiteBalanceLockSupported()) {
            parameters.setAutoWhiteBalanceLock(true);
        }
        try {
            camera.setParameters(parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unlockAeAwb(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        if (parameters.isAutoExposureLockSupported()) {
            parameters.setAutoExposureLock(false);
        }
        if (parameters.isAutoWhiteBalanceLockSupported()) {
            parameters.setAutoWhiteBalanceLock(false);
        }
        try {
            camera.setParameters(parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

