/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.ui.drawable;

import com.guidebee.game.graphics.Batch;
import com.guidebee.game.graphics.TextureRegion;
import com.guidebee.game.ui.drawable.BaseDrawable;
import com.guidebee.game.ui.drawable.TransformDrawable;

public class TextureRegionDrawable
extends BaseDrawable
implements TransformDrawable {
    private TextureRegion region;

    public TextureRegionDrawable() {
    }

    public TextureRegionDrawable(TextureRegion region) {
        this.setRegion(region);
    }

    public TextureRegionDrawable(TextureRegionDrawable drawable) {
        super(drawable);
        this.setRegion(drawable.region);
    }

    @Override
    public void draw(Batch batch, float x, float y, float width, float height) {
        batch.draw(this.region, x, y, width, height);
    }

    @Override
    public void draw(Batch batch, float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
        batch.draw(this.region, x, y, originX, originY, width, height, scaleX, scaleY, rotation);
    }

    public void setRegion(TextureRegion region) {
        this.region = region;
        this.setMinWidth(region.getRegionWidth());
        this.setMinHeight(region.getRegionHeight());
    }

    public TextureRegion getRegion() {
        return this.region;
    }
}

