/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.ui.actions;

import com.guidebee.game.ui.UIComponent;
import com.guidebee.game.ui.actions.Action;
import com.guidebee.game.ui.actions.tween.BaseTween;
import com.guidebee.game.ui.actions.tween.Tween;
import com.guidebee.game.ui.actions.tween.TweenAccessor;
import com.guidebee.game.ui.actions.tween.TweenManager;

public class TweenAction
extends Action {
    public static final int POSITION_X = 1;
    public static final int POSITION_Y = 2;
    public static final int POSITION_XY = 3;
    public static final int SCALE_X = 4;
    public static final int SCALE_Y = 5;
    public static final int SCALE_XY = 6;
    public static final int ALPHA = 7;
    public static final int ROTATION = 8;
    private final BaseTween<UIComponent> tween;
    private final TweenManager tweenManager = new TweenManager();

    public TweenAction(BaseTween tween) {
        this.tween = tween;
    }

    public void start() {
        this.tween.start(this.tweenManager);
    }

    public BaseTween getTween() {
        return this.tween;
    }

    @Override
    public boolean act(float delta) {
        this.tweenManager.update(delta);
        return this.tween.isFinished();
    }

    static {
        Tween.registerAccessor(UIComponent.class, new ComponentAccessor());
    }

    static class ComponentAccessor
    implements TweenAccessor<UIComponent> {
        ComponentAccessor() {
        }

        @Override
        public int getValues(UIComponent target, int tweenType, float[] returnValues) {
            switch (tweenType) {
                case 1: {
                    returnValues[0] = target.getX();
                    return 1;
                }
                case 2: {
                    returnValues[0] = target.getY();
                    return 1;
                }
                case 3: {
                    returnValues[0] = target.getX();
                    returnValues[1] = target.getY();
                    return 2;
                }
                case 4: {
                    returnValues[0] = target.getScaleX();
                    return 1;
                }
                case 5: {
                    returnValues[0] = target.getScaleY();
                    return 1;
                }
                case 6: {
                    returnValues[0] = target.getScaleX();
                    returnValues[1] = target.getScaleY();
                    return 2;
                }
                case 7: {
                    returnValues[0] = target.getColor().r;
                    return 1;
                }
                case 8: {
                    returnValues[0] = target.getRotation();
                    return 1;
                }
            }
            return -1;
        }

        @Override
        public void setValues(UIComponent target, int tweenType, float[] newValues) {
            switch (tweenType) {
                case 1: {
                    target.setX(newValues[0]);
                    break;
                }
                case 2: {
                    target.setY(newValues[0]);
                    break;
                }
                case 3: {
                    target.setX(newValues[0]);
                    target.setY(newValues[1]);
                    break;
                }
                case 4: {
                    target.setScaleX(newValues[0]);
                    break;
                }
                case 5: {
                    target.setScaleY(newValues[0]);
                    break;
                }
                case 6: {
                    target.setScaleX(newValues[0]);
                    target.setScaleY(newValues[1]);
                    break;
                }
                case 7: {
                    target.setAlpha(newValues[0]);
                    break;
                }
                case 8: {
                    target.setRotation(newValues[0]);
                }
            }
        }
    }
}

