/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.ui.actions;

import com.guidebee.game.graphics.Color;
import com.guidebee.game.ui.EventListener;
import com.guidebee.game.ui.Touchable;
import com.guidebee.game.ui.UIComponent;
import com.guidebee.game.ui.actions.Action;
import com.guidebee.game.ui.actions.AddAction;
import com.guidebee.game.ui.actions.AddListenerAction;
import com.guidebee.game.ui.actions.AfterAction;
import com.guidebee.game.ui.actions.AlphaAction;
import com.guidebee.game.ui.actions.ColorAction;
import com.guidebee.game.ui.actions.DelayAction;
import com.guidebee.game.ui.actions.LayoutAction;
import com.guidebee.game.ui.actions.MoveByAction;
import com.guidebee.game.ui.actions.MoveToAction;
import com.guidebee.game.ui.actions.ParallelAction;
import com.guidebee.game.ui.actions.RemoveAction;
import com.guidebee.game.ui.actions.RemoveComponentAction;
import com.guidebee.game.ui.actions.RemoveListenerAction;
import com.guidebee.game.ui.actions.RepeatAction;
import com.guidebee.game.ui.actions.RotateByAction;
import com.guidebee.game.ui.actions.RotateToAction;
import com.guidebee.game.ui.actions.RunnableAction;
import com.guidebee.game.ui.actions.ScaleByAction;
import com.guidebee.game.ui.actions.ScaleToAction;
import com.guidebee.game.ui.actions.SequenceAction;
import com.guidebee.game.ui.actions.SizeByAction;
import com.guidebee.game.ui.actions.SizeToAction;
import com.guidebee.game.ui.actions.TimeScaleAction;
import com.guidebee.game.ui.actions.TouchableAction;
import com.guidebee.game.ui.actions.VisibleAction;
import com.guidebee.math.Interpolation;
import com.guidebee.utils.Pool;
import com.guidebee.utils.Pools;

public class Actions {
    public static <T extends Action> T action(Class<T> type) {
        Pool<T> pool = Pools.get(type);
        Action action = (Action)pool.obtain();
        action.setPool(pool);
        return (T)action;
    }

    public static AddAction addAction(Action action) {
        AddAction addAction = Actions.action(AddAction.class);
        addAction.setAction(action);
        return addAction;
    }

    public static AddAction addAction(Action action, UIComponent targetComponent) {
        AddAction addAction = Actions.action(AddAction.class);
        addAction.setTargetComponent(targetComponent);
        addAction.setAction(action);
        return addAction;
    }

    public static RemoveAction removeAction(Action action) {
        RemoveAction removeAction = Actions.action(RemoveAction.class);
        removeAction.setAction(action);
        return removeAction;
    }

    public static RemoveAction removeAction(Action action, UIComponent targetComponent) {
        RemoveAction removeAction = Actions.action(RemoveAction.class);
        removeAction.setTargetComponent(targetComponent);
        removeAction.setAction(action);
        return removeAction;
    }

    public static MoveToAction moveTo(float x, float y) {
        return Actions.moveTo(x, y, 0.0f, null);
    }

    public static MoveToAction moveTo(float x, float y, float duration) {
        return Actions.moveTo(x, y, duration, null);
    }

    public static MoveToAction moveTo(float x, float y, float duration, Interpolation interpolation) {
        MoveToAction action = Actions.action(MoveToAction.class);
        action.setPosition(x, y);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static MoveByAction moveBy(float amountX, float amountY) {
        return Actions.moveBy(amountX, amountY, 0.0f, null);
    }

    public static MoveByAction moveBy(float amountX, float amountY, float duration) {
        return Actions.moveBy(amountX, amountY, duration, null);
    }

    public static MoveByAction moveBy(float amountX, float amountY, float duration, Interpolation interpolation) {
        MoveByAction action = Actions.action(MoveByAction.class);
        action.setAmount(amountX, amountY);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static SizeToAction sizeTo(float x, float y) {
        return Actions.sizeTo(x, y, 0.0f, null);
    }

    public static SizeToAction sizeTo(float x, float y, float duration) {
        return Actions.sizeTo(x, y, duration, null);
    }

    public static SizeToAction sizeTo(float x, float y, float duration, Interpolation interpolation) {
        SizeToAction action = Actions.action(SizeToAction.class);
        action.setSize(x, y);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static SizeByAction sizeBy(float amountX, float amountY) {
        return Actions.sizeBy(amountX, amountY, 0.0f, null);
    }

    public static SizeByAction sizeBy(float amountX, float amountY, float duration) {
        return Actions.sizeBy(amountX, amountY, duration, null);
    }

    public static SizeByAction sizeBy(float amountX, float amountY, float duration, Interpolation interpolation) {
        SizeByAction action = Actions.action(SizeByAction.class);
        action.setAmount(amountX, amountY);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static ScaleToAction scaleTo(float x, float y) {
        return Actions.scaleTo(x, y, 0.0f, null);
    }

    public static ScaleToAction scaleTo(float x, float y, float duration) {
        return Actions.scaleTo(x, y, duration, null);
    }

    public static ScaleToAction scaleTo(float x, float y, float duration, Interpolation interpolation) {
        ScaleToAction action = Actions.action(ScaleToAction.class);
        action.setScale(x, y);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static ScaleByAction scaleBy(float amountX, float amountY) {
        return Actions.scaleBy(amountX, amountY, 0.0f, null);
    }

    public static ScaleByAction scaleBy(float amountX, float amountY, float duration) {
        return Actions.scaleBy(amountX, amountY, duration, null);
    }

    public static ScaleByAction scaleBy(float amountX, float amountY, float duration, Interpolation interpolation) {
        ScaleByAction action = Actions.action(ScaleByAction.class);
        action.setAmount(amountX, amountY);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static RotateToAction rotateTo(float rotation) {
        return Actions.rotateTo(rotation, 0.0f, null);
    }

    public static RotateToAction rotateTo(float rotation, float duration) {
        return Actions.rotateTo(rotation, duration, null);
    }

    public static RotateToAction rotateTo(float rotation, float duration, Interpolation interpolation) {
        RotateToAction action = Actions.action(RotateToAction.class);
        action.setRotation(rotation);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static RotateByAction rotateBy(float rotationAmount) {
        return Actions.rotateBy(rotationAmount, 0.0f, null);
    }

    public static RotateByAction rotateBy(float rotationAmount, float duration) {
        return Actions.rotateBy(rotationAmount, duration, null);
    }

    public static RotateByAction rotateBy(float rotationAmount, float duration, Interpolation interpolation) {
        RotateByAction action = Actions.action(RotateByAction.class);
        action.setAmount(rotationAmount);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static ColorAction color(Color color) {
        return Actions.color(color, 0.0f, null);
    }

    public static ColorAction color(Color color, float duration) {
        return Actions.color(color, duration, null);
    }

    public static ColorAction color(Color color, float duration, Interpolation interpolation) {
        ColorAction action = Actions.action(ColorAction.class);
        action.setEndColor(color);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static AlphaAction alpha(float a) {
        return Actions.alpha(a, 0.0f, null);
    }

    public static AlphaAction alpha(float a, float duration) {
        return Actions.alpha(a, duration, null);
    }

    public static AlphaAction alpha(float a, float duration, Interpolation interpolation) {
        AlphaAction action = Actions.action(AlphaAction.class);
        action.setAlpha(a);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static AlphaAction fadeOut(float duration) {
        return Actions.alpha(0.0f, duration, null);
    }

    public static AlphaAction fadeOut(float duration, Interpolation interpolation) {
        AlphaAction action = Actions.action(AlphaAction.class);
        action.setAlpha(0.0f);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static AlphaAction fadeIn(float duration) {
        return Actions.alpha(1.0f, duration, null);
    }

    public static AlphaAction fadeIn(float duration, Interpolation interpolation) {
        AlphaAction action = Actions.action(AlphaAction.class);
        action.setAlpha(1.0f);
        action.setDuration(duration);
        action.setInterpolation(interpolation);
        return action;
    }

    public static VisibleAction show() {
        return Actions.visible(true);
    }

    public static VisibleAction hide() {
        return Actions.visible(false);
    }

    public static VisibleAction visible(boolean visible) {
        VisibleAction action = Actions.action(VisibleAction.class);
        action.setVisible(visible);
        return action;
    }

    public static TouchableAction touchable(Touchable touchable) {
        TouchableAction action = Actions.action(TouchableAction.class);
        action.setTouchable(touchable);
        return action;
    }

    public static RemoveComponentAction removeComponent() {
        return Actions.action(RemoveComponentAction.class);
    }

    public static RemoveComponentAction removeComponent(UIComponent removeComponent) {
        RemoveComponentAction action = Actions.action(RemoveComponentAction.class);
        action.setRemoveComponent(removeComponent);
        return action;
    }

    public static DelayAction delay(float duration) {
        DelayAction action = Actions.action(DelayAction.class);
        action.setDuration(duration);
        return action;
    }

    public static DelayAction delay(float duration, Action delayedAction) {
        DelayAction action = Actions.action(DelayAction.class);
        action.setDuration(duration);
        action.setAction(delayedAction);
        return action;
    }

    public static TimeScaleAction timeScale(float scale, Action scaledAction) {
        TimeScaleAction action = Actions.action(TimeScaleAction.class);
        action.setScale(scale);
        action.setAction(scaledAction);
        return action;
    }

    public static SequenceAction sequence(Action action1) {
        SequenceAction action = Actions.action(SequenceAction.class);
        action.addAction(action1);
        return action;
    }

    public static SequenceAction sequence(Action action1, Action action2) {
        SequenceAction action = Actions.action(SequenceAction.class);
        action.addAction(action1);
        action.addAction(action2);
        return action;
    }

    public static SequenceAction sequence(Action action1, Action action2, Action action3) {
        SequenceAction action = Actions.action(SequenceAction.class);
        action.addAction(action1);
        action.addAction(action2);
        action.addAction(action3);
        return action;
    }

    public static SequenceAction sequence(Action action1, Action action2, Action action3, Action action4) {
        SequenceAction action = Actions.action(SequenceAction.class);
        action.addAction(action1);
        action.addAction(action2);
        action.addAction(action3);
        action.addAction(action4);
        return action;
    }

    public static SequenceAction sequence(Action action1, Action action2, Action action3, Action action4, Action action5) {
        SequenceAction action = Actions.action(SequenceAction.class);
        action.addAction(action1);
        action.addAction(action2);
        action.addAction(action3);
        action.addAction(action4);
        action.addAction(action5);
        return action;
    }

    public static SequenceAction sequence(Action ... actions) {
        SequenceAction action = Actions.action(SequenceAction.class);
        int n = actions.length;
        for (int i = 0; i < n; ++i) {
            action.addAction(actions[i]);
        }
        return action;
    }

    public static SequenceAction sequence() {
        return Actions.action(SequenceAction.class);
    }

    public static ParallelAction parallel(Action action1) {
        ParallelAction action = Actions.action(ParallelAction.class);
        action.addAction(action1);
        return action;
    }

    public static ParallelAction parallel(Action action1, Action action2) {
        ParallelAction action = Actions.action(ParallelAction.class);
        action.addAction(action1);
        action.addAction(action2);
        return action;
    }

    public static ParallelAction parallel(Action action1, Action action2, Action action3) {
        ParallelAction action = Actions.action(ParallelAction.class);
        action.addAction(action1);
        action.addAction(action2);
        action.addAction(action3);
        return action;
    }

    public static ParallelAction parallel(Action action1, Action action2, Action action3, Action action4) {
        ParallelAction action = Actions.action(ParallelAction.class);
        action.addAction(action1);
        action.addAction(action2);
        action.addAction(action3);
        action.addAction(action4);
        return action;
    }

    public static ParallelAction parallel(Action action1, Action action2, Action action3, Action action4, Action action5) {
        ParallelAction action = Actions.action(ParallelAction.class);
        action.addAction(action1);
        action.addAction(action2);
        action.addAction(action3);
        action.addAction(action4);
        action.addAction(action5);
        return action;
    }

    public static ParallelAction parallel(Action ... actions) {
        ParallelAction action = Actions.action(ParallelAction.class);
        int n = actions.length;
        for (int i = 0; i < n; ++i) {
            action.addAction(actions[i]);
        }
        return action;
    }

    public static ParallelAction parallel() {
        return Actions.action(ParallelAction.class);
    }

    public static RepeatAction repeat(int count, Action repeatedAction) {
        RepeatAction action = Actions.action(RepeatAction.class);
        action.setCount(count);
        action.setAction(repeatedAction);
        return action;
    }

    public static RepeatAction forever(Action repeatedAction) {
        RepeatAction action = Actions.action(RepeatAction.class);
        action.setCount(-1);
        action.setAction(repeatedAction);
        return action;
    }

    public static RunnableAction run(Runnable runnable) {
        RunnableAction action = Actions.action(RunnableAction.class);
        action.setRunnable(runnable);
        return action;
    }

    public static LayoutAction layout(boolean enabled) {
        LayoutAction action = Actions.action(LayoutAction.class);
        action.setLayoutEnabled(enabled);
        return action;
    }

    public static AfterAction after(Action action) {
        AfterAction afterAction = Actions.action(AfterAction.class);
        afterAction.setAction(action);
        return afterAction;
    }

    public static AddListenerAction addListener(EventListener listener, boolean capture) {
        AddListenerAction addAction = Actions.action(AddListenerAction.class);
        addAction.setListener(listener);
        addAction.setCapture(capture);
        return addAction;
    }

    public static AddListenerAction addListener(EventListener listener, boolean capture, UIComponent targetComponent) {
        AddListenerAction addAction = Actions.action(AddListenerAction.class);
        addAction.setTargetComponent(targetComponent);
        addAction.setListener(listener);
        addAction.setCapture(capture);
        return addAction;
    }

    public static RemoveListenerAction removeListener(EventListener listener, boolean capture) {
        RemoveListenerAction addAction = Actions.action(RemoveListenerAction.class);
        addAction.setListener(listener);
        addAction.setCapture(capture);
        return addAction;
    }

    public static RemoveListenerAction removeListener(EventListener listener, boolean capture, UIComponent targetComponent) {
        RemoveListenerAction addAction = Actions.action(RemoveListenerAction.class);
        addAction.setTargetComponent(targetComponent);
        addAction.setListener(listener);
        addAction.setCapture(capture);
        return addAction;
    }
}

