/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.ui;

import com.guidebee.game.GameEngine;
import com.guidebee.game.InputProcessor;
import com.guidebee.game.ScreenAdapter;
import com.guidebee.game.camera.viewports.ScalingViewport;
import com.guidebee.game.camera.viewports.ScreenViewport;
import com.guidebee.game.graphics.Batch;
import com.guidebee.game.graphics.TextureAtlas;
import com.guidebee.game.ui.Skin;
import com.guidebee.game.ui.Table;
import com.guidebee.game.ui.UIWindow;
import com.guidebee.game.ui.Widget;
import com.guidebee.game.ui.WidgetGroup;

public class Window
extends ScreenAdapter {
    private UIWindow window;
    private Table table = new Table();
    private static final String TEXTURE_SKIN_UI = "skin/default/uiskin.atlas";
    private static final String SKIN_UI = "skin/default/uiskin.json";
    public static Skin defaultSkin = new Skin(GameEngine.files.internal("skin/default/uiskin.json"), new TextureAtlas("skin/default/uiskin.atlas"));
    private InputProcessor savedInputProcessor = null;

    public void addComponent(Widget component) {
        this.table.addComponent(component);
    }

    public void addComponent(WidgetGroup component) {
        this.table.addComponent(component);
    }

    public Window(int width, int height) {
        this.window = new UIWindow(new ScalingViewport(width, height));
        this.table.setFillParent(true);
        this.window.addComponent(this.table);
    }

    public Window() {
        this.window = new UIWindow(new ScreenViewport());
    }

    @Override
    public void show() {
        this.savedInputProcessor = GameEngine.input.getInputProcessor();
        GameEngine.input.setInputProcessor(this.window);
    }

    @Override
    public void hide() {
        GameEngine.input.setInputProcessor(this.savedInputProcessor);
    }

    public Batch getBatch() {
        return this.window.getBatch();
    }

    public float getWidth() {
        return this.window.getWidth();
    }

    public float getHeight() {
        return this.window.getHeight();
    }

    @Override
    public void render(float delta) {
        GameEngine.graphics.clearScreen(0.0f, 0.0f, 0.0f, 1.0f);
        this.window.act();
        this.window.draw();
    }

    @Override
    public void dispose() {
        this.window.dispose();
    }
}

