/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.ui;

import com.guidebee.game.graphics.Batch;
import com.guidebee.game.ui.Layout;
import com.guidebee.game.ui.UIComponent;
import com.guidebee.game.ui.UIContainer;
import com.guidebee.game.ui.UIWindow;

public class Widget
extends UIComponent
implements Layout {
    private boolean needsLayout = true;
    private boolean fillParent;
    private boolean layoutEnabled = true;

    @Override
    public float getMinWidth() {
        return this.getPrefWidth();
    }

    @Override
    public float getMinHeight() {
        return this.getPrefHeight();
    }

    @Override
    public float getPrefWidth() {
        return 0.0f;
    }

    @Override
    public float getPrefHeight() {
        return 0.0f;
    }

    @Override
    public float getMaxWidth() {
        return 0.0f;
    }

    @Override
    public float getMaxHeight() {
        return 0.0f;
    }

    @Override
    public void setLayoutEnabled(boolean enabled) {
        this.layoutEnabled = enabled;
        if (enabled) {
            this.invalidateHierarchy();
        }
    }

    @Override
    public void validate() {
        if (!this.layoutEnabled) {
            return;
        }
        UIContainer parent = this.getParent();
        if (this.fillParent && parent != null) {
            float parentHeight;
            float parentWidth;
            UIWindow window = this.getWindow();
            if (window != null && parent == window.getRoot()) {
                parentWidth = window.getWidth();
                parentHeight = window.getHeight();
            } else {
                parentWidth = parent.getWidth();
                parentHeight = parent.getHeight();
            }
            this.setSize(parentWidth, parentHeight);
        }
        if (!this.needsLayout) {
            return;
        }
        this.needsLayout = false;
        this.layout();
    }

    public boolean needsLayout() {
        return this.needsLayout;
    }

    @Override
    public void invalidate() {
        this.needsLayout = true;
    }

    @Override
    public void invalidateHierarchy() {
        if (!this.layoutEnabled) {
            return;
        }
        this.invalidate();
        UIContainer parent = this.getParent();
        if (parent instanceof Layout) {
            ((Layout)((Object)parent)).invalidateHierarchy();
        }
    }

    @Override
    protected void sizeChanged() {
        this.invalidate();
    }

    @Override
    public void pack() {
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.validate();
    }

    @Override
    public void setFillParent(boolean fillParent) {
        this.fillParent = fillParent;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.validate();
    }

    @Override
    public void layout() {
    }
}

