/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.ui;

import com.guidebee.game.ui.Layout;
import com.guidebee.game.ui.UIComponent;

public abstract class Value {
    public static final Fixed zero = new Fixed(0.0f);
    public static Value minWidth = new Value(){

        @Override
        public float get(UIComponent context) {
            if (context instanceof Layout) {
                return ((Layout)((Object)context)).getMinWidth();
            }
            return context == null ? 0.0f : context.getWidth();
        }
    };
    public static Value minHeight = new Value(){

        @Override
        public float get(UIComponent context) {
            if (context instanceof Layout) {
                return ((Layout)((Object)context)).getMinHeight();
            }
            return context == null ? 0.0f : context.getHeight();
        }
    };
    public static Value prefWidth = new Value(){

        @Override
        public float get(UIComponent context) {
            if (context instanceof Layout) {
                return ((Layout)((Object)context)).getPrefWidth();
            }
            return context == null ? 0.0f : context.getWidth();
        }
    };
    public static Value prefHeight = new Value(){

        @Override
        public float get(UIComponent context) {
            if (context instanceof Layout) {
                return ((Layout)((Object)context)).getPrefHeight();
            }
            return context == null ? 0.0f : context.getHeight();
        }
    };
    public static Value maxWidth = new Value(){

        @Override
        public float get(UIComponent context) {
            if (context instanceof Layout) {
                return ((Layout)((Object)context)).getMaxWidth();
            }
            return context == null ? 0.0f : context.getWidth();
        }
    };
    public static Value maxHeight = new Value(){

        @Override
        public float get(UIComponent context) {
            if (context instanceof Layout) {
                return ((Layout)((Object)context)).getMaxHeight();
            }
            return context == null ? 0.0f : context.getHeight();
        }
    };

    public abstract float get(UIComponent var1);

    public static Value percentWidth(final float percent) {
        return new Value(){

            @Override
            public float get(UIComponent component) {
                return component.getWidth() * percent;
            }
        };
    }

    public static Value percentHeight(final float percent) {
        return new Value(){

            @Override
            public float get(UIComponent component) {
                return component.getHeight() * percent;
            }
        };
    }

    public static Value percentWidth(final float percent, final UIComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null.");
        }
        return new Value(){

            @Override
            public float get(UIComponent context) {
                return component.getWidth() * percent;
            }
        };
    }

    public static Value percentHeight(final float percent, final UIComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("component cannot be null.");
        }
        return new Value(){

            @Override
            public float get(UIComponent context) {
                return component.getHeight() * percent;
            }
        };
    }

    public static class Fixed
    extends Value {
        private final float value;

        public Fixed(float value) {
            this.value = value;
        }

        @Override
        public float get(UIComponent context) {
            return this.value;
        }
    }
}

