/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.ui;

import com.guidebee.game.GameEngine;
import com.guidebee.game.InputAdapter;
import com.guidebee.game.camera.Camera;
import com.guidebee.game.camera.OrthographicCamera;
import com.guidebee.game.camera.viewports.ScalingViewport;
import com.guidebee.game.camera.viewports.Viewport;
import com.guidebee.game.graphics.Batch;
import com.guidebee.game.graphics.Color;
import com.guidebee.game.graphics.ShapeRenderer;
import com.guidebee.game.graphics.SpriteBatch;
import com.guidebee.game.ui.EventListener;
import com.guidebee.game.ui.FocusListener;
import com.guidebee.game.ui.InputEvent;
import com.guidebee.game.ui.Table;
import com.guidebee.game.ui.UIComponent;
import com.guidebee.game.ui.UIContainer;
import com.guidebee.game.ui.actions.Action;
import com.guidebee.math.Matrix4;
import com.guidebee.math.Vector2;
import com.guidebee.math.geometry.Rectangle;
import com.guidebee.utils.Disposable;
import com.guidebee.utils.Pool;
import com.guidebee.utils.Pools;
import com.guidebee.utils.Scaling;
import com.guidebee.utils.collections.Array;
import com.guidebee.utils.collections.SnapshotArray;

public class UIWindow
extends InputAdapter
implements Disposable {
    private static final Vector2 componentCoords = new Vector2();
    static boolean debug;
    private Viewport viewport;
    private final Batch batch;
    private boolean ownsBatch;
    private final UIContainer root;
    private final Vector2 windowCoords = new Vector2();
    private final UIComponent[] pointerOverComponents = new UIComponent[20];
    private final boolean[] pointerTouched = new boolean[20];
    private final int[] pointerScreenX = new int[20];
    private final int[] pointerScreenY = new int[20];
    private int mouseScreenX;
    private int mouseScreenY;
    private UIComponent mouseOverComponent;
    private UIComponent keyboardFocus;
    private UIComponent scrollFocus;
    private final SnapshotArray<TouchFocus> touchFocuses = new SnapshotArray(true, 4, TouchFocus.class);
    private ShapeRenderer debugShapes;
    private boolean debugInvisible;
    private boolean debugAll;
    private boolean debugUnderMouse;
    private boolean debugParentUnderMouse;
    private Table.Debug debugTableUnderMouse = Table.Debug.none;
    private final Color debugColor = new Color(0.0f, 1.0f, 0.0f, 0.85f);
    private Object userObject;

    public UIWindow() {
        this(new ScalingViewport(Scaling.stretch, GameEngine.graphics.getWidth(), GameEngine.graphics.getHeight(), new OrthographicCamera()), new SpriteBatch());
        this.ownsBatch = true;
    }

    public UIWindow(Viewport viewport) {
        this(viewport, new SpriteBatch());
        this.ownsBatch = true;
    }

    public UIWindow(Viewport viewport, Batch batch) {
        if (viewport == null) {
            throw new IllegalArgumentException("viewport cannot be null.");
        }
        if (batch == null) {
            throw new IllegalArgumentException("batch cannot be null.");
        }
        this.viewport = viewport;
        this.batch = batch;
        this.root = new UIContainer();
        this.root.setWindow(this);
        viewport.update(GameEngine.graphics.getWidth(), GameEngine.graphics.getHeight(), true);
    }

    public void drawExtra(Batch batch) {
    }

    public void resetCamera() {
        Camera camera = this.viewport.getCamera();
        camera.update();
        this.batch.setProjectionMatrix(camera.combined);
    }

    public void draw() {
        Camera camera = this.viewport.getCamera();
        camera.update();
        if (!this.root.isVisible()) {
            return;
        }
        Batch batch = this.batch;
        if (batch != null) {
            batch.setProjectionMatrix(camera.combined);
            batch.begin();
            this.root.draw(batch, 1.0f);
            this.drawExtra(batch);
            batch.end();
        }
        if (debug) {
            this.drawDebug();
        }
    }

    public <T extends UIComponent> T findComponent(String name) {
        return this.root.findComponent(name);
    }

    private void drawDebug() {
        if (this.debugShapes == null) {
            this.debugShapes = new ShapeRenderer();
            this.debugShapes.setAutoShapeType(true);
        }
        if (this.debugUnderMouse || this.debugParentUnderMouse || this.debugTableUnderMouse != Table.Debug.none) {
            this.screenToWindowCoordinates(this.windowCoords.set(GameEngine.input.getX(), GameEngine.input.getY()));
            UIComponent component = this.hit(this.windowCoords.x, this.windowCoords.y, true);
            if (component == null) {
                return;
            }
            if (this.debugParentUnderMouse && component.parent != null) {
                component = component.parent;
            }
            if (this.debugTableUnderMouse == Table.Debug.none) {
                component.setDebug(true);
            } else {
                while (component != null && !(component instanceof Table)) {
                    component = component.parent;
                }
                if (component == null) {
                    return;
                }
                ((Table)component).debug(this.debugTableUnderMouse);
            }
            if (this.debugAll && component instanceof UIContainer) {
                ((UIContainer)component).debugAll();
            }
            this.disableDebug(this.root, component);
        } else if (this.debugAll) {
            this.root.debugAll();
        }
        GameEngine.gl.glEnable(3042);
        this.debugShapes.setProjectionMatrix(this.viewport.getCamera().combined);
        this.debugShapes.begin();
        this.root.drawDebug(this.debugShapes);
        this.debugShapes.end();
    }

    private void disableDebug(UIComponent component, UIComponent except) {
        if (component == except) {
            return;
        }
        component.setDebug(false);
        if (component instanceof UIContainer) {
            SnapshotArray<UIComponent> children = ((UIContainer)component).children;
            int n = children.size;
            for (int i = 0; i < n; ++i) {
                this.disableDebug((UIComponent)children.get(i), except);
            }
        }
    }

    public void act() {
        this.act(Math.min(GameEngine.graphics.getDeltaTime(), 0.033333335f));
    }

    public void act(float delta) {
        int n = this.pointerOverComponents.length;
        for (int pointer = 0; pointer < n; ++pointer) {
            UIComponent overLast = this.pointerOverComponents[pointer];
            if (!this.pointerTouched[pointer]) {
                if (overLast == null) continue;
                this.pointerOverComponents[pointer] = null;
                this.screenToWindowCoordinates(this.windowCoords.set(this.pointerScreenX[pointer], this.pointerScreenY[pointer]));
                InputEvent event = Pools.obtain(InputEvent.class);
                event.setType(InputEvent.Type.exit);
                event.setWindow(this);
                event.setWindowX(this.windowCoords.x);
                event.setWindowY(this.windowCoords.y);
                event.setRelatedComponent(overLast);
                event.setPointer(pointer);
                overLast.fire(event);
                Pools.free(event);
                continue;
            }
            this.pointerOverComponents[pointer] = this.fireEnterAndExit(overLast, this.pointerScreenX[pointer], this.pointerScreenY[pointer], pointer);
        }
        this.root.act(delta);
    }

    private UIComponent fireEnterAndExit(UIComponent overLast, int screenX, int screenY, int pointer) {
        this.screenToWindowCoordinates(this.windowCoords.set(screenX, screenY));
        UIComponent over = this.hit(this.windowCoords.x, this.windowCoords.y, true);
        if (over == overLast) {
            return overLast;
        }
        InputEvent event = Pools.obtain(InputEvent.class);
        event.setWindow(this);
        event.setWindowX(this.windowCoords.x);
        event.setWindowY(this.windowCoords.y);
        event.setPointer(pointer);
        if (overLast != null) {
            event.setType(InputEvent.Type.exit);
            event.setRelatedComponent(over);
            overLast.fire(event);
        }
        if (over != null) {
            event.setType(InputEvent.Type.enter);
            event.setRelatedComponent(overLast);
            over.fire(event);
        }
        Pools.free(event);
        return over;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (screenX < this.viewport.getScreenX() || screenX >= this.viewport.getScreenX() + this.viewport.getScreenWidth()) {
            return false;
        }
        if (GameEngine.graphics.getHeight() - screenY < this.viewport.getScreenY() || GameEngine.graphics.getHeight() - screenY >= this.viewport.getScreenY() + this.viewport.getScreenHeight()) {
            return false;
        }
        this.pointerTouched[pointer] = true;
        this.pointerScreenX[pointer] = screenX;
        this.pointerScreenY[pointer] = screenY;
        this.screenToWindowCoordinates(this.windowCoords.set(screenX, screenY));
        InputEvent event = Pools.obtain(InputEvent.class);
        event.setType(InputEvent.Type.touchDown);
        event.setWindow(this);
        event.setWindowX(this.windowCoords.x);
        event.setWindowY(this.windowCoords.y);
        event.setPointer(pointer);
        event.setButton(button);
        UIComponent target = this.hit(this.windowCoords.x, this.windowCoords.y, true);
        if (target == null) {
            target = this.root;
        }
        target.fire(event);
        boolean handled = event.isHandled();
        Pools.free(event);
        return handled;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        this.pointerScreenX[pointer] = screenX;
        this.pointerScreenY[pointer] = screenY;
        this.mouseScreenX = screenX;
        this.mouseScreenY = screenY;
        if (this.touchFocuses.size == 0) {
            return false;
        }
        this.screenToWindowCoordinates(this.windowCoords.set(screenX, screenY));
        InputEvent event = Pools.obtain(InputEvent.class);
        event.setType(InputEvent.Type.touchDragged);
        event.setWindow(this);
        event.setWindowX(this.windowCoords.x);
        event.setWindowY(this.windowCoords.y);
        event.setPointer(pointer);
        SnapshotArray<TouchFocus> touchFocuses = this.touchFocuses;
        TouchFocus[] focuses = touchFocuses.begin();
        int n = touchFocuses.size;
        for (int i = 0; i < n; ++i) {
            TouchFocus focus = focuses[i];
            if (focus.pointer != pointer) continue;
            event.setTarget(focus.target);
            event.setListenerComponent(focus.listenerComponent);
            if (!focus.listener.handle(event)) continue;
            event.handle();
        }
        touchFocuses.end();
        boolean handled = event.isHandled();
        Pools.free(event);
        return handled;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        this.pointerTouched[pointer] = false;
        this.pointerScreenX[pointer] = screenX;
        this.pointerScreenY[pointer] = screenY;
        if (this.touchFocuses.size == 0) {
            return false;
        }
        this.screenToWindowCoordinates(this.windowCoords.set(screenX, screenY));
        InputEvent event = Pools.obtain(InputEvent.class);
        event.setType(InputEvent.Type.touchUp);
        event.setWindow(this);
        event.setWindowX(this.windowCoords.x);
        event.setWindowY(this.windowCoords.y);
        event.setPointer(pointer);
        event.setButton(button);
        SnapshotArray<TouchFocus> touchFocuses = this.touchFocuses;
        TouchFocus[] focuses = touchFocuses.begin();
        int n = touchFocuses.size;
        for (int i = 0; i < n; ++i) {
            TouchFocus focus = focuses[i];
            if (focus.pointer != pointer || focus.button != button || !touchFocuses.removeValue(focus, true)) continue;
            event.setTarget(focus.target);
            event.setListenerComponent(focus.listenerComponent);
            if (focus.listener.handle(event)) {
                event.handle();
            }
            Pools.free(focus);
        }
        touchFocuses.end();
        boolean handled = event.isHandled();
        Pools.free(event);
        return handled;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        if (screenX < this.viewport.getScreenX() || screenX >= this.viewport.getScreenX() + this.viewport.getScreenWidth()) {
            return false;
        }
        if (GameEngine.graphics.getHeight() - screenY < this.viewport.getScreenY() || GameEngine.graphics.getHeight() - screenY >= this.viewport.getScreenY() + this.viewport.getScreenHeight()) {
            return false;
        }
        this.mouseScreenX = screenX;
        this.mouseScreenY = screenY;
        this.screenToWindowCoordinates(this.windowCoords.set(screenX, screenY));
        InputEvent event = Pools.obtain(InputEvent.class);
        event.setWindow(this);
        event.setType(InputEvent.Type.mouseMoved);
        event.setWindowX(this.windowCoords.x);
        event.setWindowY(this.windowCoords.y);
        UIComponent target = this.hit(this.windowCoords.x, this.windowCoords.y, true);
        if (target == null) {
            target = this.root;
        }
        target.fire(event);
        boolean handled = event.isHandled();
        Pools.free(event);
        return handled;
    }

    @Override
    public boolean scrolled(int amount) {
        UIComponent target = this.scrollFocus == null ? this.root : this.scrollFocus;
        this.screenToWindowCoordinates(this.windowCoords.set(this.mouseScreenX, this.mouseScreenY));
        InputEvent event = Pools.obtain(InputEvent.class);
        event.setWindow(this);
        event.setType(InputEvent.Type.scrolled);
        event.setScrollAmount(amount);
        event.setWindowX(this.windowCoords.x);
        event.setWindowY(this.windowCoords.y);
        target.fire(event);
        boolean handled = event.isHandled();
        Pools.free(event);
        return handled;
    }

    @Override
    public boolean keyDown(int keyCode) {
        UIComponent target = this.keyboardFocus == null ? this.root : this.keyboardFocus;
        InputEvent event = Pools.obtain(InputEvent.class);
        event.setWindow(this);
        event.setType(InputEvent.Type.keyDown);
        event.setKeyCode(keyCode);
        target.fire(event);
        boolean handled = event.isHandled();
        Pools.free(event);
        return handled;
    }

    @Override
    public boolean keyUp(int keyCode) {
        UIComponent target = this.keyboardFocus == null ? this.root : this.keyboardFocus;
        InputEvent event = Pools.obtain(InputEvent.class);
        event.setWindow(this);
        event.setType(InputEvent.Type.keyUp);
        event.setKeyCode(keyCode);
        target.fire(event);
        boolean handled = event.isHandled();
        Pools.free(event);
        return handled;
    }

    @Override
    public boolean keyTyped(char character) {
        UIComponent target = this.keyboardFocus == null ? this.root : this.keyboardFocus;
        InputEvent event = Pools.obtain(InputEvent.class);
        event.setWindow(this);
        event.setType(InputEvent.Type.keyTyped);
        event.setCharacter(character);
        target.fire(event);
        boolean handled = event.isHandled();
        Pools.free(event);
        return handled;
    }

    public void addTouchFocus(EventListener listener, UIComponent listenerComponent, UIComponent target, int pointer, int button) {
        TouchFocus focus = Pools.obtain(TouchFocus.class);
        focus.listenerComponent = listenerComponent;
        focus.target = target;
        focus.listener = listener;
        focus.pointer = pointer;
        focus.button = button;
        this.touchFocuses.add(focus);
    }

    public void removeTouchFocus(EventListener listener, UIComponent listenerComponent, UIComponent target, int pointer, int button) {
        SnapshotArray<TouchFocus> touchFocuses = this.touchFocuses;
        for (int i = touchFocuses.size - 1; i >= 0; --i) {
            TouchFocus focus = (TouchFocus)touchFocuses.get(i);
            if (focus.listener != listener || focus.listenerComponent != listenerComponent || focus.target != target || focus.pointer != pointer || focus.button != button) continue;
            touchFocuses.removeIndex(i);
            Pools.free(focus);
        }
    }

    public void cancelTouchFocus() {
        this.cancelTouchFocus(null, null);
    }

    public void cancelTouchFocus(EventListener listener, UIComponent component) {
        InputEvent event = Pools.obtain(InputEvent.class);
        event.setWindow(this);
        event.setType(InputEvent.Type.touchUp);
        event.setWindowX(-2.1474836E9f);
        event.setWindowY(-2.1474836E9f);
        SnapshotArray<TouchFocus> touchFocuses = this.touchFocuses;
        TouchFocus[] items = touchFocuses.begin();
        int n = touchFocuses.size;
        for (int i = 0; i < n; ++i) {
            TouchFocus focus = items[i];
            if (focus.listener == listener && focus.listenerComponent == component || !touchFocuses.removeValue(focus, true)) continue;
            event.setTarget(focus.target);
            event.setListenerComponent(focus.listenerComponent);
            event.setPointer(focus.pointer);
            event.setButton(focus.button);
            focus.listener.handle(event);
        }
        touchFocuses.end();
        Pools.free(event);
    }

    public void addComponent(UIComponent component) {
        this.root.addComponent(component);
    }

    public void addAction(Action action) {
        this.root.addAction(action);
    }

    public Array<UIComponent> getComponents() {
        return this.root.children;
    }

    public boolean addListener(EventListener listener) {
        return this.root.addListener(listener);
    }

    public boolean removeListener(EventListener listener) {
        return this.root.removeListener(listener);
    }

    public boolean addCaptureListener(EventListener listener) {
        return this.root.addCaptureListener(listener);
    }

    public boolean removeCaptureListener(EventListener listener) {
        return this.root.removeCaptureListener(listener);
    }

    public void clear() {
        this.unfocusAll();
        this.root.clear();
    }

    public void unfocusAll() {
        this.scrollFocus = null;
        this.keyboardFocus = null;
        this.cancelTouchFocus();
    }

    public void unfocus(UIComponent component) {
        if (this.scrollFocus != null && this.scrollFocus.isDescendantOf(component)) {
            this.scrollFocus = null;
        }
        if (this.keyboardFocus != null && this.keyboardFocus.isDescendantOf(component)) {
            this.keyboardFocus = null;
        }
    }

    public void setKeyboardFocus(UIComponent component) {
        if (this.keyboardFocus == component) {
            return;
        }
        FocusListener.FocusEvent event = Pools.obtain(FocusListener.FocusEvent.class);
        event.setWindow(this);
        event.setType(FocusListener.FocusEvent.Type.keyboard);
        UIComponent oldKeyboardFocus = this.keyboardFocus;
        if (oldKeyboardFocus != null) {
            event.setFocused(false);
            event.setRelatedComponent(component);
            oldKeyboardFocus.fire(event);
        }
        if (!event.isCancelled()) {
            this.keyboardFocus = component;
            if (component != null) {
                event.setFocused(true);
                event.setRelatedComponent(oldKeyboardFocus);
                component.fire(event);
                if (event.isCancelled()) {
                    this.setKeyboardFocus(oldKeyboardFocus);
                }
            }
        }
        Pools.free(event);
    }

    public UIComponent getKeyboardFocus() {
        return this.keyboardFocus;
    }

    public void setScrollFocus(UIComponent component) {
        if (this.scrollFocus == component) {
            return;
        }
        FocusListener.FocusEvent event = Pools.obtain(FocusListener.FocusEvent.class);
        event.setWindow(this);
        event.setType(FocusListener.FocusEvent.Type.scroll);
        UIComponent oldScrollFocus = this.keyboardFocus;
        if (oldScrollFocus != null) {
            event.setFocused(false);
            event.setRelatedComponent(component);
            oldScrollFocus.fire(event);
        }
        if (!event.isCancelled()) {
            this.scrollFocus = component;
            if (component != null) {
                event.setFocused(true);
                event.setRelatedComponent(oldScrollFocus);
                component.fire(event);
                if (event.isCancelled()) {
                    this.setScrollFocus(oldScrollFocus);
                }
            }
        }
        Pools.free(event);
    }

    public UIComponent getScrollFocus() {
        return this.scrollFocus;
    }

    public Batch getBatch() {
        return this.batch;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public void setViewport(Viewport viewport) {
        this.viewport = viewport;
    }

    public float getWidth() {
        return this.viewport.getWorldWidth();
    }

    public float getHeight() {
        return this.viewport.getWorldHeight();
    }

    public Camera getCamera() {
        return this.viewport.getCamera();
    }

    public UIContainer getRoot() {
        return this.root;
    }

    public UIComponent hit(float windowX, float windowY, boolean touchable) {
        this.root.parentToLocalCoordinates(componentCoords.set(windowX, windowY));
        return this.root.hit(UIWindow.componentCoords.x, UIWindow.componentCoords.y, touchable);
    }

    public Vector2 screenToWindowCoordinates(Vector2 screenCoords) {
        this.viewport.unproject(screenCoords);
        return screenCoords;
    }

    public Vector2 windowToScreenCoordinates(Vector2 windowCoords) {
        this.viewport.project(windowCoords);
        windowCoords.y = (float)this.viewport.getScreenHeight() - windowCoords.y;
        return windowCoords;
    }

    public Vector2 toScreenCoordinates(Vector2 coords, Matrix4 transformMatrix) {
        return this.viewport.toScreenCoordinates(coords, transformMatrix);
    }

    public void calculateScissors(Rectangle localRect, Rectangle scissorRect) {
        this.viewport.calculateScissors(this.batch.getTransformMatrix(), localRect, scissorRect);
        Matrix4 transformMatrix = this.debugShapes != null && this.debugShapes.isDrawing() ? this.debugShapes.getTransformMatrix() : this.batch.getTransformMatrix();
        this.viewport.calculateScissors(transformMatrix, localRect, scissorRect);
    }

    public Color getDebugColor() {
        return this.debugColor;
    }

    public void setDebugInvisible(boolean debugInvisible) {
        this.debugInvisible = debugInvisible;
    }

    public void setDebugAll(boolean debugAll) {
        if (this.debugAll == debugAll) {
            return;
        }
        this.debugAll = debugAll;
        if (debugAll) {
            debug = true;
        } else {
            this.root.setDebug(false, true);
        }
    }

    public void setDebugUnderMouse(boolean debugUnderMouse) {
        if (this.debugUnderMouse == debugUnderMouse) {
            return;
        }
        this.debugUnderMouse = debugUnderMouse;
        if (debugUnderMouse) {
            debug = true;
        } else {
            this.root.setDebug(false, true);
        }
    }

    public void setDebugParentUnderMouse(boolean debugParentUnderMouse) {
        if (this.debugParentUnderMouse == debugParentUnderMouse) {
            return;
        }
        this.debugParentUnderMouse = debugParentUnderMouse;
        if (debugParentUnderMouse) {
            debug = true;
        } else {
            this.root.setDebug(false, true);
        }
    }

    public void setDebugTableUnderMouse(Table.Debug debugTableUnderMouse) {
        if (debugTableUnderMouse == null) {
            debugTableUnderMouse = Table.Debug.none;
        }
        if (this.debugTableUnderMouse == debugTableUnderMouse) {
            return;
        }
        this.debugTableUnderMouse = debugTableUnderMouse;
        if (debugTableUnderMouse != Table.Debug.none) {
            debug = true;
        } else {
            this.root.setDebug(false, true);
        }
    }

    public void setDebugTableUnderMouse(boolean debugTableUnderMouse) {
        this.setDebugTableUnderMouse(debugTableUnderMouse ? Table.Debug.all : Table.Debug.none);
    }

    @Override
    public void dispose() {
        this.clear();
        if (this.ownsBatch) {
            this.batch.dispose();
        }
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public static final class TouchFocus
    implements Pool.Poolable {
        EventListener listener;
        UIComponent listenerComponent;
        UIComponent target;
        int pointer;
        int button;

        @Override
        public void reset() {
            this.listenerComponent = null;
            this.listener = null;
        }
    }
}

