/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.ui;

import com.guidebee.game.graphics.Batch;
import com.guidebee.game.graphics.ShapeRenderer;
import com.guidebee.game.ui.Cullable;
import com.guidebee.game.ui.Touchable;
import com.guidebee.game.ui.UIComponent;
import com.guidebee.game.ui.UIWindow;
import com.guidebee.math.Matrix3;
import com.guidebee.math.Matrix4;
import com.guidebee.math.Vector2;
import com.guidebee.math.geometry.Rectangle;
import com.guidebee.utils.collections.SnapshotArray;

public class UIContainer
extends UIComponent
implements Cullable {
    private static final Vector2 tmp = new Vector2();
    final SnapshotArray<UIComponent> children = new SnapshotArray(true, 4, UIComponent.class);
    private final Matrix3 localTransform = new Matrix3();
    private final Matrix3 worldTransform = new Matrix3();
    private final Matrix4 computedTransform = new Matrix4();
    private final Matrix4 oldTransform = new Matrix4();
    boolean transform = true;
    private Rectangle cullingArea;

    public UIContainer() {
        this(UIContainer.class.getName());
    }

    public UIContainer(String name) {
        super(name);
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        UIComponent[] components = this.children.begin();
        int n = this.children.size;
        for (int i = 0; i < n; ++i) {
            components[i].act(delta);
        }
        this.children.end();
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.transform) {
            this.applyTransform(batch, this.computeTransform());
        }
        this.drawChildren(batch, parentAlpha);
        if (this.transform) {
            this.resetTransform(batch);
        }
    }

    protected void drawChildren(Batch batch, float parentAlpha) {
        parentAlpha *= this.color.a;
        SnapshotArray<UIComponent> children = this.children;
        UIComponent[] components = children.begin();
        Rectangle cullingArea = this.cullingArea;
        if (cullingArea != null) {
            float cullLeft = cullingArea.x;
            float cullRight = cullLeft + cullingArea.width;
            float cullBottom = cullingArea.y;
            float cullTop = cullBottom + cullingArea.height;
            if (this.transform) {
                int n = children.size;
                for (int i = 0; i < n; ++i) {
                    UIComponent child = components[i];
                    if (!child.isVisible()) continue;
                    float cx = child.x;
                    float cy = child.y;
                    if (!(cx <= cullRight) || !(cy <= cullTop) || !(cx + child.width >= cullLeft) || !(cy + child.height >= cullBottom)) continue;
                    child.draw(batch, parentAlpha);
                }
                batch.flush();
            } else {
                float offsetX = this.x;
                float offsetY = this.y;
                this.x = 0.0f;
                this.y = 0.0f;
                int n = children.size;
                for (int i = 0; i < n; ++i) {
                    UIComponent child = components[i];
                    if (!child.isVisible()) continue;
                    float cx = child.x;
                    float cy = child.y;
                    if (!(cx <= cullRight) || !(cy <= cullTop) || !(cx + child.width >= cullLeft) || !(cy + child.height >= cullBottom)) continue;
                    child.x = cx + offsetX;
                    child.y = cy + offsetY;
                    child.draw(batch, parentAlpha);
                    child.x = cx;
                    child.y = cy;
                }
                this.x = offsetX;
                this.y = offsetY;
            }
        } else if (this.transform) {
            int n = children.size;
            for (int i = 0; i < n; ++i) {
                UIComponent child = components[i];
                if (!child.isVisible()) continue;
                child.draw(batch, parentAlpha);
            }
            batch.flush();
        } else {
            float offsetX = this.x;
            float offsetY = this.y;
            this.x = 0.0f;
            this.y = 0.0f;
            int n = children.size;
            for (int i = 0; i < n; ++i) {
                UIComponent child = components[i];
                if (!child.isVisible()) continue;
                float cx = child.x;
                float cy = child.y;
                child.x = cx + offsetX;
                child.y = cy + offsetY;
                child.draw(batch, parentAlpha);
                child.x = cx;
                child.y = cy;
            }
            this.x = offsetX;
            this.y = offsetY;
        }
        children.end();
    }

    @Override
    public void drawDebug(ShapeRenderer shapes) {
        this.drawDebugBounds(shapes);
        if (this.transform) {
            this.applyTransform(shapes, this.computeTransform());
        }
        this.drawDebugChildren(shapes);
        if (this.transform) {
            this.resetTransform(shapes);
        }
    }

    protected void drawDebugChildren(ShapeRenderer shapes) {
        SnapshotArray<UIComponent> children = this.children;
        UIComponent[] components = children.begin();
        if (this.transform) {
            int n = children.size;
            for (int i = 0; i < n; ++i) {
                UIComponent child = components[i];
                if (!child.isVisible()) continue;
                child.drawDebug(shapes);
            }
            shapes.flush();
        } else {
            float offsetX = this.x;
            float offsetY = this.y;
            this.x = 0.0f;
            this.y = 0.0f;
            int n = children.size;
            for (int i = 0; i < n; ++i) {
                UIComponent child = components[i];
                if (!child.isVisible()) continue;
                float cx = child.x;
                float cy = child.y;
                child.x = cx + offsetX;
                child.y = cy + offsetY;
                child.drawDebug(shapes);
                child.x = cx;
                child.y = cy;
            }
            this.x = offsetX;
            this.y = offsetY;
        }
        children.end();
    }

    protected Matrix4 computeTransform() {
        Matrix3 worldTransform = this.worldTransform;
        Matrix3 localTransform = this.localTransform;
        float originX = this.originX;
        float originY = this.originY;
        float rotation = this.rotation;
        float scaleX = this.scaleX;
        float scaleY = this.scaleY;
        if (originX != 0.0f || originY != 0.0f) {
            localTransform.setToTranslation(originX, originY);
        } else {
            localTransform.idt();
        }
        if (rotation != 0.0f) {
            localTransform.rotate(rotation);
        }
        if (scaleX != 1.0f || scaleY != 1.0f) {
            localTransform.scale(scaleX, scaleY);
        }
        if (originX != 0.0f || originY != 0.0f) {
            localTransform.translate(-originX, -originY);
        }
        localTransform.trn(this.x, this.y);
        UIContainer parentUIContainer = this.parent;
        while (parentUIContainer != null && !parentUIContainer.transform) {
            parentUIContainer = parentUIContainer.parent;
        }
        if (parentUIContainer != null) {
            worldTransform.set(parentUIContainer.worldTransform);
            worldTransform.mul(localTransform);
        } else {
            worldTransform.set(localTransform);
        }
        this.computedTransform.set(worldTransform);
        return this.computedTransform;
    }

    protected void applyTransform(Batch batch, Matrix4 transform) {
        this.oldTransform.set(batch.getTransformMatrix());
        batch.setTransformMatrix(transform);
    }

    protected void resetTransform(Batch batch) {
        batch.setTransformMatrix(this.oldTransform);
    }

    protected void applyTransform(ShapeRenderer shapes, Matrix4 transform) {
        this.oldTransform.set(shapes.getTransformMatrix());
        shapes.setTransformMatrix(transform);
    }

    protected void resetTransform(ShapeRenderer shapes) {
        shapes.setTransformMatrix(this.oldTransform);
    }

    @Override
    public void setCullingArea(Rectangle cullingArea) {
        this.cullingArea = cullingArea;
    }

    @Override
    public UIComponent hit(float x, float y, boolean touchable) {
        if (touchable && this.getTouchable() == Touchable.disabled) {
            return null;
        }
        Vector2 point = tmp;
        UIComponent[] childrenArray = (UIComponent[])this.children.items;
        for (int i = this.children.size - 1; i >= 0; --i) {
            UIComponent child = childrenArray[i];
            if (!child.isVisible()) continue;
            child.parentToLocalCoordinates(point.set(x, y));
            UIComponent hit = child.hit(point.x, point.y, touchable);
            if (hit == null) continue;
            return hit;
        }
        return super.hit(x, y, touchable);
    }

    protected void childrenChanged() {
    }

    public void addComponent(UIComponent component) {
        component.remove();
        this.children.add(component);
        component.setParent(this);
        component.setWindow(this.getWindow());
        this.childrenChanged();
    }

    public void addComponentAt(int index, UIComponent component) {
        component.remove();
        if (index >= this.children.size) {
            this.children.add(component);
        } else {
            this.children.insert(index, component);
        }
        component.setParent(this);
        component.setWindow(this.getWindow());
        this.childrenChanged();
    }

    public void addComponentBefore(UIComponent componentBefore, UIComponent component) {
        component.remove();
        int index = this.children.indexOf(componentBefore, true);
        this.children.insert(index, component);
        component.setParent(this);
        component.setWindow(this.getWindow());
        this.childrenChanged();
    }

    public void addComponentAfter(UIComponent componentAfter, UIComponent component) {
        component.remove();
        int index = this.children.indexOf(componentAfter, true);
        if (index == this.children.size) {
            this.children.add(component);
        } else {
            this.children.insert(index + 1, component);
        }
        component.setParent(this);
        component.setWindow(this.getWindow());
        this.childrenChanged();
    }

    public boolean removeComponent(UIComponent component) {
        if (!this.children.removeValue(component, true)) {
            return false;
        }
        UIWindow window = this.getWindow();
        if (window != null) {
            window.unfocus(component);
        }
        component.setParent(null);
        component.setWindow(null);
        this.childrenChanged();
        return true;
    }

    public void clearChildren() {
        UIComponent[] components = this.children.begin();
        int n = this.children.size;
        for (int i = 0; i < n; ++i) {
            UIComponent child = components[i];
            child.setWindow(null);
            child.setParent(null);
        }
        this.children.end();
        this.children.clear();
        this.childrenChanged();
    }

    @Override
    public void clear() {
        super.clear();
        this.clearChildren();
    }

    public <T extends UIComponent> T findComponent(String name) {
        int i;
        SnapshotArray<UIComponent> children = this.children;
        int n = children.size;
        for (i = 0; i < n; ++i) {
            if (!name.equals(((UIComponent)children.get(i)).getName())) continue;
            return (T)((UIComponent)children.get(i));
        }
        n = children.size;
        for (i = 0; i < n; ++i) {
            T component;
            UIComponent child = (UIComponent)children.get(i);
            if (!(child instanceof UIContainer) || (component = ((UIContainer)child).findComponent(name)) == null) continue;
            return component;
        }
        return null;
    }

    @Override
    protected void setWindow(UIWindow window) {
        super.setWindow(window);
        UIComponent[] childrenArray = (UIComponent[])this.children.items;
        int n = this.children.size;
        for (int i = 0; i < n; ++i) {
            childrenArray[i].setWindow(window);
        }
    }

    public boolean swapComponent(int first, int second) {
        int maxIndex = this.children.size;
        if (first < 0 || first >= maxIndex) {
            return false;
        }
        if (second < 0 || second >= maxIndex) {
            return false;
        }
        this.children.swap(first, second);
        return true;
    }

    public boolean swapComponent(UIComponent first, UIComponent second) {
        int firstIndex = this.children.indexOf(first, true);
        int secondIndex = this.children.indexOf(second, true);
        if (firstIndex == -1 || secondIndex == -1) {
            return false;
        }
        this.children.swap(firstIndex, secondIndex);
        return true;
    }

    public SnapshotArray<UIComponent> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.size > 0;
    }

    public void setTransform(boolean transform) {
        this.transform = transform;
    }

    public boolean isTransform() {
        return this.transform;
    }

    public Vector2 localToDescendantCoordinates(UIComponent descendant, Vector2 localCoords) {
        UIContainer parent = descendant.parent;
        if (parent == null) {
            throw new IllegalArgumentException("Child is not a descendant: " + descendant);
        }
        if (parent != this) {
            this.localToDescendantCoordinates(parent, localCoords);
        }
        descendant.parentToLocalCoordinates(localCoords);
        return localCoords;
    }

    public void setDebug(boolean enabled, boolean recursively) {
        this.setDebug(enabled);
        if (recursively) {
            for (UIComponent child : this.children) {
                if (child instanceof UIContainer) {
                    ((UIContainer)child).setDebug(enabled, recursively);
                    continue;
                }
                child.setDebug(enabled);
            }
        }
    }

    public UIContainer debugAll() {
        this.setDebug(true, true);
        return this;
    }

    public void print() {
        this.print("");
    }

    private void print(String indent) {
        UIComponent[] components = this.children.begin();
        int n = this.children.size;
        for (int i = 0; i < n; ++i) {
            System.out.println(indent + components[i]);
            if (!(components[i] instanceof UIContainer)) continue;
            ((UIContainer)components[i]).print(indent + "|  ");
        }
        this.children.end();
    }
}

