/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.ui;

import com.guidebee.game.graphics.Batch;
import com.guidebee.game.graphics.BitmapFont;
import com.guidebee.game.graphics.Color;
import com.guidebee.game.ui.Button;
import com.guidebee.game.ui.Cell;
import com.guidebee.game.ui.Label;
import com.guidebee.game.ui.Skin;
import com.guidebee.game.ui.drawable.Drawable;

public class TextButton
extends Button {
    private final Label label;
    private TextButtonStyle style;

    public TextButton(String text, Skin skin) {
        this(text, skin.get(TextButtonStyle.class));
        this.setSkin(skin);
    }

    public TextButton(String text, Skin skin, String styleName) {
        this(text, skin.get(styleName, TextButtonStyle.class));
        this.setSkin(skin);
    }

    public TextButton(String text, TextButtonStyle style2) {
        this.setStyle(style2);
        this.style = style2;
        this.label = new Label((CharSequence)text, new Label.LabelStyle(style2.font, style2.fontColor));
        this.label.setAlignment(1);
        this.add(this.label).expand().fill();
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    @Override
    public void setStyle(Button.ButtonStyle style2) {
        if (style2 == null) {
            throw new NullPointerException("style cannot be null");
        }
        if (!(style2 instanceof TextButtonStyle)) {
            throw new IllegalArgumentException("style must be a TextButtonStyle.");
        }
        super.setStyle(style2);
        this.style = (TextButtonStyle)style2;
        if (this.label != null) {
            TextButtonStyle textButtonStyle = (TextButtonStyle)style2;
            Label.LabelStyle labelStyle = this.label.getStyle();
            labelStyle.font = textButtonStyle.font;
            labelStyle.fontColor = textButtonStyle.fontColor;
            this.label.setStyle(labelStyle);
        }
    }

    @Override
    public TextButtonStyle getStyle() {
        return this.style;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Color fontColor = this.isDisabled && this.style.disabledFontColor != null ? this.style.disabledFontColor : (this.isPressed() && this.style.downFontColor != null ? this.style.downFontColor : (this.isChecked && this.style.checkedFontColor != null ? (this.isOver() && this.style.checkedOverFontColor != null ? this.style.checkedOverFontColor : this.style.checkedFontColor) : (this.isOver() && this.style.overFontColor != null ? this.style.overFontColor : this.style.fontColor)));
        if (fontColor != null) {
            this.label.getStyle().fontColor = fontColor;
        }
        super.draw(batch, parentAlpha);
    }

    public Label getLabel() {
        return this.label;
    }

    public Cell getLabelCell() {
        return this.getCell(this.label);
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public CharSequence getText() {
        return this.label.getText();
    }

    public static class TextButtonStyle
    extends Button.ButtonStyle {
        public BitmapFont font;
        public Color fontColor;
        public Color downFontColor;
        public Color overFontColor;
        public Color checkedFontColor;
        public Color checkedOverFontColor;
        public Color disabledFontColor;

        public TextButtonStyle() {
        }

        public TextButtonStyle(Drawable up, Drawable down, Drawable checked, BitmapFont font) {
            super(up, down, checked);
            this.font = font;
        }

        public TextButtonStyle(TextButtonStyle style2) {
            super(style2);
            this.font = style2.font;
            if (style2.fontColor != null) {
                this.fontColor = new Color(style2.fontColor);
            }
            if (style2.downFontColor != null) {
                this.downFontColor = new Color(style2.downFontColor);
            }
            if (style2.overFontColor != null) {
                this.overFontColor = new Color(style2.overFontColor);
            }
            if (style2.checkedFontColor != null) {
                this.checkedFontColor = new Color(style2.checkedFontColor);
            }
            if (style2.checkedOverFontColor != null) {
                this.checkedFontColor = new Color(style2.checkedOverFontColor);
            }
            if (style2.disabledFontColor != null) {
                this.disabledFontColor = new Color(style2.disabledFontColor);
            }
        }
    }
}

