/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.ui;

import com.guidebee.game.graphics.Batch;
import com.guidebee.game.graphics.BitmapFont;
import com.guidebee.game.graphics.Color;
import com.guidebee.game.graphics.Font;
import com.guidebee.game.ui.ChangeListener;
import com.guidebee.game.ui.ClickListener;
import com.guidebee.game.ui.Disableable;
import com.guidebee.game.ui.InputEvent;
import com.guidebee.game.ui.InputListener;
import com.guidebee.game.ui.List;
import com.guidebee.game.ui.ScrollPane;
import com.guidebee.game.ui.Selection;
import com.guidebee.game.ui.Skin;
import com.guidebee.game.ui.Touchable;
import com.guidebee.game.ui.UIComponent;
import com.guidebee.game.ui.UIWindow;
import com.guidebee.game.ui.Widget;
import com.guidebee.game.ui.actions.Action;
import com.guidebee.game.ui.actions.Actions;
import com.guidebee.game.ui.drawable.Drawable;
import com.guidebee.math.Interpolation;
import com.guidebee.math.Vector2;
import com.guidebee.utils.Pools;
import com.guidebee.utils.collections.Array;
import com.guidebee.utils.collections.OrderedSet;

public class SelectBox<T>
extends Widget
implements Disableable {
    static final Vector2 tmpCoords = new Vector2();
    SelectBoxStyle style;
    final Array<T> items = new Array();
    T selected;
    private final Font.TextBounds bounds = new Font.TextBounds();
    ListScroll scroll;
    Selection<T> selection;
    UIComponent previousScrollFocus;
    private float prefWidth;
    private float prefHeight;
    private ClickListener clickListener;
    int maxListCount;
    boolean disabled;

    public SelectBox(Skin skin) {
        this(skin.get(SelectBoxStyle.class));
    }

    public SelectBox(Skin skin, String styleName) {
        this(skin.get(styleName, SelectBoxStyle.class));
    }

    public SelectBox(SelectBoxStyle style2) {
        this.setStyle(style2);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
        this.scroll = new ListScroll();
        this.selection = this.scroll.list.getSelection();
        this.clickListener = new ClickListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (pointer == 0 && button != 0) {
                    return false;
                }
                if (SelectBox.this.disabled) {
                    return false;
                }
                SelectBox.this.showList();
                return true;
            }
        };
        this.addListener(this.clickListener);
    }

    public void setMaxListCount(int maxListCount) {
        this.maxListCount = maxListCount;
    }

    public int getMaxListCount() {
        return this.maxListCount;
    }

    @Override
    protected void setWindow(UIWindow window) {
        if (window == null) {
            this.hideList();
        }
        super.setWindow(window);
    }

    public void setStyle(SelectBoxStyle style2) {
        if (style2 == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style2;
        this.invalidateHierarchy();
    }

    public SelectBoxStyle getStyle() {
        return this.style;
    }

    public void setItems(T ... newItems) {
        if (newItems == null) {
            throw new IllegalArgumentException("newItems cannot be null.");
        }
        this.items.clear();
        this.items.addAll(newItems);
        this.scroll.list.setItems(this.items);
        this.invalidateHierarchy();
    }

    public void setItems(Array<T> newItems) {
        if (newItems == null) {
            throw new IllegalArgumentException("newItems cannot be null.");
        }
        this.items.clear();
        this.items.addAll(newItems);
        this.scroll.list.setItems(this.items);
        this.invalidateHierarchy();
    }

    public Array<T> getItems() {
        return this.items;
    }

    @Override
    public void layout() {
        Drawable bg = this.style.background;
        BitmapFont font = this.style.font;
        this.prefHeight = Math.max(bg.getTopHeight() + bg.getBottomHeight() + font.getCapHeight() - font.getDescent() * 2.0f, bg.getMinHeight());
        float maxItemWidth = 0.0f;
        for (int i = 0; i < this.items.size; ++i) {
            maxItemWidth = Math.max(font.getBounds((CharSequence)this.items.get((int)i).toString()).width, maxItemWidth);
        }
        this.prefWidth = bg.getLeftWidth() + bg.getRightWidth() + maxItemWidth;
        List.ListStyle listStyle = this.style.listStyle;
        ScrollPane.ScrollPaneStyle scrollStyle = this.style.scrollStyle;
        this.prefWidth = Math.max(this.prefWidth, maxItemWidth + (scrollStyle.background == null ? 0.0f : scrollStyle.background.getLeftWidth() + scrollStyle.background.getRightWidth()) + listStyle.selection.getLeftWidth() + listStyle.selection.getRightWidth() + Math.max(this.style.scrollStyle.vScroll != null ? this.style.scrollStyle.vScroll.getMinWidth() : 0.0f, this.style.scrollStyle.vScrollKnob != null ? this.style.scrollStyle.vScrollKnob.getMinWidth() : 0.0f));
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        T selected;
        this.validate();
        Drawable background = this.disabled && this.style.backgroundDisabled != null ? this.style.backgroundDisabled : (this.scroll.hasParent() && this.style.backgroundOpen != null ? this.style.backgroundOpen : (this.clickListener.isOver() && this.style.backgroundOver != null ? this.style.backgroundOver : this.style.background));
        BitmapFont font = this.style.font;
        Color fontColor = this.disabled && this.style.disabledFontColor != null ? this.style.disabledFontColor : this.style.fontColor;
        Color color = this.getColor();
        float x = this.getX();
        float y = this.getY();
        float width = this.getWidth();
        float height = this.getHeight();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        background.draw(batch, x, y, width, height);
        T t = selected = this.selected != null ? this.selected : this.selection.first();
        if (selected != null) {
            float availableWidth = width - background.getLeftWidth() - background.getRightWidth();
            String string2 = selected.toString();
            int numGlyphs = font.computeVisibleGlyphs(string2, 0, string2.length(), availableWidth);
            this.bounds.set(font.getBounds(string2));
            float textY = (int)((height -= background.getBottomHeight() + background.getTopHeight()) / 2.0f + background.getBottomHeight() + this.bounds.height / 2.0f);
            font.setColor(fontColor.r, fontColor.g, fontColor.b, fontColor.a * parentAlpha);
            font.draw(batch, string2, x + background.getLeftWidth(), y + textY, 0, numGlyphs);
        }
    }

    public Selection<T> getSelection() {
        return this.selection;
    }

    public T getSelected() {
        return this.selection.first();
    }

    public void setSelected(T item) {
        if (this.items.contains(item, false)) {
            this.selection.set(item);
        } else if (this.items.size > 0) {
            this.selection.set(this.items.first());
        } else {
            this.selection.clear();
        }
    }

    public int getSelectedIndex() {
        OrderedSet<T> selected = this.selection.items();
        return selected.size == 0 ? -1 : this.items.indexOf(selected.first(), false);
    }

    public void setSelectedIndex(int index) {
        this.selection.set(this.items.get(index));
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (disabled && !this.disabled) {
            this.hideList();
        }
        this.disabled = disabled;
    }

    @Override
    public float getPrefWidth() {
        this.validate();
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        this.validate();
        return this.prefHeight;
    }

    public void showList() {
        this.selected = this.selection.first();
        this.scroll.list.setTouchable(Touchable.enabled);
        this.scroll.show(this.getWindow());
    }

    public void hideList() {
        if (!this.scroll.hasParent()) {
            return;
        }
        this.selected = null;
        this.scroll.list.setTouchable(Touchable.disabled);
        UIWindow window = this.scroll.getWindow();
        if (window != null) {
            UIComponent component;
            if (this.previousScrollFocus != null && this.previousScrollFocus.getWindow() == null) {
                this.previousScrollFocus = null;
            }
            if ((component = window.getScrollFocus()) == null || component.isDescendantOf(this.scroll)) {
                window.setScrollFocus(this.previousScrollFocus);
            }
        }
        this.scroll.addAction(Actions.sequence((Action)Actions.fadeOut(0.15f, Interpolation.fade), (Action)Actions.removeComponent()));
    }

    public List getList() {
        return this.scroll.list;
    }

    public ScrollPane getScrollPane() {
        return this.scroll;
    }

    public static class SelectBoxStyle {
        public BitmapFont font;
        public Color fontColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public Color disabledFontColor;
        public Drawable background;
        public ScrollPane.ScrollPaneStyle scrollStyle;
        public List.ListStyle listStyle;
        public Drawable backgroundOver;
        public Drawable backgroundOpen;
        public Drawable backgroundDisabled;

        public SelectBoxStyle() {
        }

        public SelectBoxStyle(BitmapFont font, Color fontColor, Drawable background, ScrollPane.ScrollPaneStyle scrollStyle, List.ListStyle listStyle) {
            this.font = font;
            this.fontColor.set(fontColor);
            this.background = background;
            this.scrollStyle = scrollStyle;
            this.listStyle = listStyle;
        }

        public SelectBoxStyle(SelectBoxStyle style2) {
            this.font = style2.font;
            this.fontColor.set(style2.fontColor);
            if (style2.disabledFontColor != null) {
                this.disabledFontColor = new Color(style2.disabledFontColor);
            }
            this.background = style2.background;
            this.backgroundOver = style2.backgroundOver;
            this.backgroundOpen = style2.backgroundOpen;
            this.backgroundDisabled = style2.backgroundDisabled;
            this.scrollStyle = new ScrollPane.ScrollPaneStyle(style2.scrollStyle);
            this.listStyle = new List.ListStyle(style2.listStyle);
        }
    }

    class ListScroll
    extends ScrollPane {
        final List<T> list;
        final Vector2 screenCoords;

        public ListScroll() {
            super(null, SelectBox.this.style.scrollStyle);
            this.screenCoords = new Vector2();
            this.setOverscroll(false, false);
            this.setFadeScrollBars(false);
            this.list = new List(SelectBox.this.style.listStyle);
            this.setWidget(this.list);
            this.list.addListener(new InputListener(){

                @Override
                public boolean mouseMoved(InputEvent event, float x, float y) {
                    ListScroll.this.list.setSelectedIndex(Math.min(SelectBox.this.items.size - 1, (int)((ListScroll.this.list.getHeight() - y) / ListScroll.this.list.getItemHeight())));
                    return true;
                }
            });
            this.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    if (event.getTarget() == ListScroll.this.list) {
                        return true;
                    }
                    SelectBox.this.setSelected(SelectBox.this.selected);
                    SelectBox.this.hideList();
                    return false;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                    if (ListScroll.this.hit(x, y, true) == ListScroll.this.list) {
                        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
                        SelectBox.this.fire(changeEvent);
                        Pools.free(changeEvent);
                        SelectBox.this.hideList();
                    }
                }
            });
        }

        public void show(UIWindow window) {
            Drawable listBackground;
            window.addComponent(this);
            SelectBox.this.localToWindowCoordinates(tmpCoords.set(0.0f, 0.0f));
            this.screenCoords.set(tmpCoords);
            float itemHeight = this.list.getItemHeight();
            float height = itemHeight * (float)(SelectBox.this.maxListCount <= 0 ? SelectBox.this.items.size : Math.min(SelectBox.this.maxListCount, SelectBox.this.items.size));
            Drawable scrollPaneBackground = this.getStyle().background;
            if (scrollPaneBackground != null) {
                height += scrollPaneBackground.getTopHeight() + scrollPaneBackground.getBottomHeight();
            }
            if ((listBackground = this.list.getStyle().background) != null) {
                height += listBackground.getTopHeight() + listBackground.getBottomHeight();
            }
            float heightBelow = SelectBox.tmpCoords.y;
            float heightAbove = window.getCamera().viewportHeight - SelectBox.tmpCoords.y - SelectBox.this.getHeight();
            boolean below = true;
            if (height > heightBelow) {
                if (heightAbove > heightBelow) {
                    below = false;
                    height = Math.min(height, heightAbove);
                } else {
                    height = heightBelow;
                }
            }
            if (below) {
                this.setY(SelectBox.tmpCoords.y - height);
            } else {
                this.setY(SelectBox.tmpCoords.y + SelectBox.this.getHeight());
            }
            this.setX(SelectBox.tmpCoords.x);
            this.setWidth(SelectBox.this.getWidth());
            this.setHeight(height);
            this.validate();
            this.scrollToCenter(0.0f, this.list.getHeight() - (float)SelectBox.this.getSelectedIndex() * itemHeight - itemHeight / 2.0f, 0.0f, 0.0f);
            this.updateVisualScroll();
            this.clearActions();
            this.getColor().a = 0.0f;
            Actions.addAction(Actions.fadeIn(0.3f, Interpolation.fade));
            SelectBox.this.previousScrollFocus = null;
            UIComponent component = window.getScrollFocus();
            if (component != null && !component.isDescendantOf(this)) {
                SelectBox.this.previousScrollFocus = component;
            }
            window.setScrollFocus(this);
        }

        @Override
        public UIComponent hit(float x, float y, boolean touchable) {
            UIComponent component = super.hit(x, y, touchable);
            return component != null ? component : this;
        }

        @Override
        public void act(float delta) {
            super.act(delta);
            SelectBox.this.localToWindowCoordinates(tmpCoords.set(0.0f, 0.0f));
            if (SelectBox.tmpCoords.x != this.screenCoords.x || SelectBox.tmpCoords.y != this.screenCoords.y) {
                SelectBox.this.hideList();
            }
        }
    }
}

