/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.ui;

import com.guidebee.game.graphics.Batch;
import com.guidebee.game.graphics.BitmapFont;
import com.guidebee.game.graphics.Color;
import com.guidebee.game.ui.Button;
import com.guidebee.game.ui.Cell;
import com.guidebee.game.ui.Image;
import com.guidebee.game.ui.Label;
import com.guidebee.game.ui.Skin;
import com.guidebee.game.ui.TextButton;
import com.guidebee.game.ui.drawable.Drawable;
import com.guidebee.utils.Scaling;

public class ImageTextButton
extends Button {
    private final Image image;
    private final Label label;
    private ImageTextButtonStyle style;

    public ImageTextButton(String text, Skin skin) {
        this(text, skin.get(ImageTextButtonStyle.class));
        this.setSkin(skin);
    }

    public ImageTextButton(String text, Skin skin, String styleName) {
        this(text, skin.get(styleName, ImageTextButtonStyle.class));
        this.setSkin(skin);
    }

    public ImageTextButton(String text, ImageTextButtonStyle style2) {
        super(style2);
        this.style = style2;
        this.defaults().space(3.0f);
        this.image = new Image();
        this.image.setScaling(Scaling.fit);
        this.add(this.image);
        this.label = new Label((CharSequence)text, new Label.LabelStyle(style2.font, style2.fontColor));
        this.label.setAlignment(1);
        this.add(this.label);
        this.setStyle(style2);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    @Override
    public void setStyle(Button.ButtonStyle style2) {
        if (!(style2 instanceof ImageTextButtonStyle)) {
            throw new IllegalArgumentException("style must be a ImageTextButtonStyle.");
        }
        super.setStyle(style2);
        this.style = (ImageTextButtonStyle)style2;
        if (this.image != null) {
            this.updateImage();
        }
        if (this.label != null) {
            ImageTextButtonStyle textButtonStyle = (ImageTextButtonStyle)style2;
            Label.LabelStyle labelStyle = this.label.getStyle();
            labelStyle.font = textButtonStyle.font;
            labelStyle.fontColor = textButtonStyle.fontColor;
            this.label.setStyle(labelStyle);
        }
    }

    @Override
    public ImageTextButtonStyle getStyle() {
        return this.style;
    }

    private void updateImage() {
        boolean isPressed = this.isPressed();
        if (this.isDisabled && this.style.imageDisabled != null) {
            this.image.setDrawable(this.style.imageDisabled);
        } else if (isPressed && this.style.imageDown != null) {
            this.image.setDrawable(this.style.imageDown);
        } else if (this.isChecked && this.style.imageChecked != null) {
            this.image.setDrawable(this.style.imageCheckedOver != null && this.isOver() ? this.style.imageCheckedOver : this.style.imageChecked);
        } else if (this.isOver() && this.style.imageOver != null) {
            this.image.setDrawable(this.style.imageOver);
        } else if (this.style.imageUp != null) {
            this.image.setDrawable(this.style.imageUp);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.updateImage();
        Color fontColor = this.isDisabled && this.style.disabledFontColor != null ? this.style.disabledFontColor : (this.isPressed() && this.style.downFontColor != null ? this.style.downFontColor : (this.isChecked && this.style.checkedFontColor != null ? (this.isOver() && this.style.checkedOverFontColor != null ? this.style.checkedOverFontColor : this.style.checkedFontColor) : (this.isOver() && this.style.overFontColor != null ? this.style.overFontColor : this.style.fontColor)));
        if (fontColor != null) {
            this.label.getStyle().fontColor = fontColor;
        }
        super.draw(batch, parentAlpha);
    }

    public Image getImage() {
        return this.image;
    }

    public Cell getImageCell() {
        return this.getCell(this.image);
    }

    public Label getLabel() {
        return this.label;
    }

    public Cell getLabelCell() {
        return this.getCell(this.label);
    }

    public void setText(CharSequence text) {
        this.label.setText(text);
    }

    public CharSequence getText() {
        return this.label.getText();
    }

    public static class ImageTextButtonStyle
    extends TextButton.TextButtonStyle {
        public Drawable imageUp;
        public Drawable imageDown;
        public Drawable imageOver;
        public Drawable imageChecked;
        public Drawable imageCheckedOver;
        public Drawable imageDisabled;

        public ImageTextButtonStyle() {
        }

        public ImageTextButtonStyle(Drawable up, Drawable down, Drawable checked, BitmapFont font) {
            super(up, down, checked, font);
        }

        public ImageTextButtonStyle(ImageTextButtonStyle style2) {
            super(style2);
            if (style2.imageUp != null) {
                this.imageUp = style2.imageUp;
            }
            if (style2.imageDown != null) {
                this.imageDown = style2.imageDown;
            }
            if (style2.imageOver != null) {
                this.imageOver = style2.imageOver;
            }
            if (style2.imageChecked != null) {
                this.imageChecked = style2.imageChecked;
            }
            if (style2.imageCheckedOver != null) {
                this.imageCheckedOver = style2.imageCheckedOver;
            }
            if (style2.imageDisabled != null) {
                this.imageDisabled = style2.imageDisabled;
            }
        }

        public ImageTextButtonStyle(TextButton.TextButtonStyle style2) {
            super(style2);
        }
    }
}

