/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.ui;

import com.guidebee.game.graphics.Batch;
import com.guidebee.game.ui.Button;
import com.guidebee.game.ui.Cell;
import com.guidebee.game.ui.Image;
import com.guidebee.game.ui.Skin;
import com.guidebee.game.ui.drawable.Drawable;
import com.guidebee.utils.Scaling;

public class ImageButton
extends Button {
    private final Image image = new Image();
    private ImageButtonStyle style;

    public ImageButton(Skin skin) {
        this(skin.get(ImageButtonStyle.class));
    }

    public ImageButton(Skin skin, String styleName) {
        this(skin.get(styleName, ImageButtonStyle.class));
    }

    public ImageButton(ImageButtonStyle style2) {
        super(style2);
        this.image.setScaling(Scaling.fit);
        this.add(this.image);
        this.setStyle(style2);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    public ImageButton(Drawable imageUp) {
        this(new ImageButtonStyle(null, null, null, imageUp, null, null));
    }

    public ImageButton(Drawable imageUp, Drawable imageDown) {
        this(new ImageButtonStyle(null, null, null, imageUp, imageDown, null));
    }

    public ImageButton(Drawable imageUp, Drawable imageDown, Drawable imageChecked) {
        this(new ImageButtonStyle(null, null, null, imageUp, imageDown, imageChecked));
    }

    @Override
    public void setStyle(Button.ButtonStyle style2) {
        if (!(style2 instanceof ImageButtonStyle)) {
            throw new IllegalArgumentException("style must be an ImageButtonStyle.");
        }
        super.setStyle(style2);
        this.style = (ImageButtonStyle)style2;
        if (this.image != null) {
            this.updateImage();
        }
    }

    @Override
    public ImageButtonStyle getStyle() {
        return this.style;
    }

    private void updateImage() {
        boolean isPressed = this.isPressed();
        if (this.isDisabled && this.style.imageDisabled != null) {
            this.image.setDrawable(this.style.imageDisabled);
        } else if (isPressed && this.style.imageDown != null) {
            this.image.setDrawable(this.style.imageDown);
        } else if (this.isChecked && this.style.imageChecked != null) {
            this.image.setDrawable(this.style.imageCheckedOver != null && this.isOver() ? this.style.imageCheckedOver : this.style.imageChecked);
        } else if (this.isOver() && this.style.imageOver != null) {
            this.image.setDrawable(this.style.imageOver);
        } else if (this.style.imageUp != null) {
            this.image.setDrawable(this.style.imageUp);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.updateImage();
        super.draw(batch, parentAlpha);
    }

    public Image getImage() {
        return this.image;
    }

    public Cell getImageCell() {
        return this.getCell(this.image);
    }

    public static class ImageButtonStyle
    extends Button.ButtonStyle {
        public Drawable imageUp;
        public Drawable imageDown;
        public Drawable imageOver;
        public Drawable imageChecked;
        public Drawable imageCheckedOver;
        public Drawable imageDisabled;

        public ImageButtonStyle() {
        }

        public ImageButtonStyle(Drawable up, Drawable down, Drawable checked, Drawable imageUp, Drawable imageDown, Drawable imageChecked) {
            super(up, down, checked);
            this.imageUp = imageUp;
            this.imageDown = imageDown;
            this.imageChecked = imageChecked;
        }

        public ImageButtonStyle(ImageButtonStyle style2) {
            super(style2);
            this.imageUp = style2.imageUp;
            this.imageDown = style2.imageDown;
            this.imageOver = style2.imageOver;
            this.imageChecked = style2.imageChecked;
            this.imageCheckedOver = style2.imageCheckedOver;
            this.imageDisabled = style2.imageDisabled;
        }

        public ImageButtonStyle(Button.ButtonStyle style2) {
            super(style2);
        }
    }
}

