/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.ui;

import com.guidebee.game.input.GestureDetector;
import com.guidebee.game.ui.Event;
import com.guidebee.game.ui.EventListener;
import com.guidebee.game.ui.InputEvent;
import com.guidebee.game.ui.UIComponent;
import com.guidebee.math.Vector2;

public class GestureListener
implements EventListener {
    static final Vector2 tmpCoords = new Vector2();
    private final GestureDetector detector;
    InputEvent event;
    UIComponent component;
    UIComponent touchDownTarget;

    public GestureListener() {
        this(20.0f, 0.4f, 1.1f, 0.15f);
    }

    public GestureListener(float halfTapSquareSize, float tapCountInterval, float longPressDuration, float maxFlingDelay) {
        this.detector = new GestureDetector(halfTapSquareSize, tapCountInterval, longPressDuration, maxFlingDelay, new GestureDetector.GestureAdapter(){
            private final Vector2 initialPointer1 = new Vector2();
            private final Vector2 initialPointer2 = new Vector2();
            private final Vector2 pointer1 = new Vector2();
            private final Vector2 pointer2 = new Vector2();

            @Override
            public boolean tap(float windowX, float windowY, int count, int button) {
                GestureListener.this.component.windowToLocalCoordinates(tmpCoords.set(windowX, windowY));
                GestureListener.this.tap(GestureListener.this.event, GestureListener.tmpCoords.x, GestureListener.tmpCoords.y, count, button);
                return true;
            }

            @Override
            public boolean longPress(float windowX, float windowY) {
                GestureListener.this.component.windowToLocalCoordinates(tmpCoords.set(windowX, windowY));
                return GestureListener.this.longPress(GestureListener.this.component, GestureListener.tmpCoords.x, GestureListener.tmpCoords.y);
            }

            @Override
            public boolean fling(float velocityX, float velocityY, int button) {
                GestureListener.this.fling(GestureListener.this.event, velocityX, velocityY, button);
                return true;
            }

            @Override
            public boolean pan(float windowX, float windowY, float deltaX, float deltaY) {
                GestureListener.this.component.windowToLocalCoordinates(tmpCoords.set(windowX, windowY));
                GestureListener.this.pan(GestureListener.this.event, GestureListener.tmpCoords.x, GestureListener.tmpCoords.y, deltaX, deltaY);
                return true;
            }

            @Override
            public boolean zoom(float initialDistance, float distance) {
                GestureListener.this.zoom(GestureListener.this.event, initialDistance, distance);
                return true;
            }

            @Override
            public boolean pinch(Vector2 windowInitialPointer1, Vector2 windowInitialPointer2, Vector2 windowPointer1, Vector2 windowPointer2) {
                GestureListener.this.component.windowToLocalCoordinates(this.initialPointer1.set(windowInitialPointer1));
                GestureListener.this.component.windowToLocalCoordinates(this.initialPointer2.set(windowInitialPointer2));
                GestureListener.this.component.windowToLocalCoordinates(this.pointer1.set(windowPointer1));
                GestureListener.this.component.windowToLocalCoordinates(this.pointer2.set(windowPointer2));
                GestureListener.this.pinch(GestureListener.this.event, this.initialPointer1, this.initialPointer2, this.pointer1, this.pointer2);
                return true;
            }
        });
    }

    @Override
    public boolean handle(Event e) {
        if (!(e instanceof InputEvent)) {
            return false;
        }
        InputEvent event = (InputEvent)e;
        switch (event.getType()) {
            case touchDown: {
                this.component = event.getListenerComponent();
                this.touchDownTarget = event.getTarget();
                this.detector.touchDown(event.getWindowX(), event.getWindowY(), event.getPointer(), event.getButton());
                this.component.windowToLocalCoordinates(tmpCoords.set(event.getWindowX(), event.getWindowY()));
                this.touchDown(event, GestureListener.tmpCoords.x, GestureListener.tmpCoords.y, event.getPointer(), event.getButton());
                return true;
            }
            case touchUp: {
                if (event.isTouchFocusCancel()) {
                    return false;
                }
                this.event = event;
                this.component = event.getListenerComponent();
                this.detector.touchUp(event.getWindowX(), event.getWindowY(), event.getPointer(), event.getButton());
                this.component.windowToLocalCoordinates(tmpCoords.set(event.getWindowX(), event.getWindowY()));
                this.touchUp(event, GestureListener.tmpCoords.x, GestureListener.tmpCoords.y, event.getPointer(), event.getButton());
                return true;
            }
            case touchDragged: {
                this.event = event;
                this.component = event.getListenerComponent();
                this.detector.touchDragged(event.getWindowX(), event.getWindowY(), event.getPointer());
                return true;
            }
        }
        return false;
    }

    public void touchDown(InputEvent event, float x, float y, int pointer, int button) {
    }

    public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
    }

    public void tap(InputEvent event, float x, float y, int count, int button) {
    }

    public boolean longPress(UIComponent component, float x, float y) {
        return false;
    }

    public void fling(InputEvent event, float velocityX, float velocityY, int button) {
    }

    public void pan(InputEvent event, float x, float y, float deltaX, float deltaY) {
    }

    public void zoom(InputEvent event, float initialDistance, float distance) {
    }

    public void pinch(InputEvent event, Vector2 initialPointer1, Vector2 initialPointer2, Vector2 pointer1, Vector2 pointer2) {
    }

    public GestureDetector getGestureDetector() {
        return this.detector;
    }

    public UIComponent getTouchDownTarget() {
        return this.touchDownTarget;
    }
}

