/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.ui;

import com.guidebee.game.ui.ChangeListener;
import com.guidebee.game.ui.EventListener;
import com.guidebee.game.ui.GameControllerListener;
import com.guidebee.game.ui.ImageButton;
import com.guidebee.game.ui.Touchpad;
import com.guidebee.game.ui.UIComponent;
import com.guidebee.game.ui.WidgetGroup;
import com.guidebee.game.ui.drawable.TextureRegionDrawable;
import com.guidebee.math.MathUtils;
import com.guidebee.utils.collections.DelayedRemovalArray;

public class GameController
extends WidgetGroup {
    private final DelayedRemovalArray<GameControllerListener> listeners = new DelayedRemovalArray(0);
    private final Touchpad touchpad;
    private final ImageButton shootButton;
    private final ImageButton powerButton;

    public GameController(TextureRegionDrawable touchBackground, TextureRegionDrawable touchKnob, TextureRegionDrawable buttonA, TextureRegionDrawable buttonAPressed, TextureRegionDrawable buttonB, TextureRegionDrawable buttonBPressed) {
        Touchpad.TouchpadStyle touchpadStyle = new Touchpad.TouchpadStyle();
        touchpadStyle.background = touchBackground;
        touchpadStyle.knob = touchKnob;
        int regionWidth = touchBackground.getRegion().getRegionWidth();
        int regionHeight = touchBackground.getRegion().getRegionHeight();
        this.touchpad = new Touchpad((float)(regionWidth / 4), touchpadStyle);
        this.touchpad.setBounds(0.0f, 0.0f, regionWidth, regionHeight);
        this.shootButton = new ImageButton(buttonA, buttonAPressed);
        this.powerButton = new ImageButton(buttonB, buttonBPressed);
        this.addComponent(this.touchpad);
        this.addComponent(this.shootButton);
        this.addComponent(this.powerButton);
        this.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, UIComponent component) {
                for (GameControllerListener listener : GameController.this.listeners) {
                    if (component == GameController.this.touchpad) {
                        GameControllerListener.Direction direction = GameController.this.getDirection(GameController.this.touchpad);
                        if (direction == GameControllerListener.Direction.NONE) continue;
                        listener.KnobMoved(GameController.this.touchpad, GameController.this.getDirection(GameController.this.touchpad));
                        continue;
                    }
                    if (component == GameController.this.shootButton) {
                        listener.ButtonPressed(GameControllerListener.GameButton.BUTTON_A);
                        continue;
                    }
                    if (component != GameController.this.powerButton) continue;
                    listener.ButtonPressed(GameControllerListener.GameButton.BUTTON_B);
                }
            }
        });
    }

    private GameControllerListener.Direction getDirection(Touchpad touchpad) {
        float knobY = touchpad.getKnobPercentY();
        float konbX = touchpad.getKnobPercentX();
        if ((double)knobY != 0.0 || (double)konbX != 0.0) {
            float alpha = MathUtils.atan2(knobY, konbX) * 57.295776f;
            if ((double)alpha >= -22.5 & alpha < 0.0f) {
                return GameControllerListener.Direction.EAST;
            }
            if (alpha >= 0.0f & (double)alpha < 22.5) {
                return GameControllerListener.Direction.EAST;
            }
            if ((double)alpha >= 22.5 && (double)alpha < 67.5) {
                return GameControllerListener.Direction.NORTHEAST;
            }
            if ((double)alpha >= 67.5 && (double)alpha < 112.5) {
                return GameControllerListener.Direction.NORTH;
            }
            if ((double)alpha >= 112.5 && (double)alpha < 157.5) {
                return GameControllerListener.Direction.NORTHWEST;
            }
            if ((double)alpha >= 157.5 && alpha < 180.0f) {
                return GameControllerListener.Direction.WEST;
            }
            if ((double)alpha <= -157.5 && alpha > -180.0f) {
                return GameControllerListener.Direction.WEST;
            }
            if ((double)alpha <= -112.5 && (double)alpha > -157.5) {
                return GameControllerListener.Direction.SOUTHWEST;
            }
            if ((double)alpha <= -67.5 && (double)alpha > -112.5) {
                return GameControllerListener.Direction.SOUTH;
            }
            if ((double)alpha <= -22.5 && (double)alpha > -67.5) {
                return GameControllerListener.Direction.SOUTHEAST;
            }
        }
        return GameControllerListener.Direction.NONE;
    }

    @Override
    public void layout() {
        float height = this.touchpad.getHeight();
        float width = this.getParent().getWidth();
        this.shootButton.setX(width - 2.0f * this.shootButton.getWidth());
        this.shootButton.setY(height / 2.0f - this.shootButton.getHeight() / 2.0f);
        this.powerButton.setX(width - this.powerButton.getWidth());
        this.powerButton.setY(height / 2.0f - this.powerButton.getHeight() / 2.0f);
    }

    public boolean addGameControllerListener(GameControllerListener listener) {
        if (!this.listeners.contains(listener, true)) {
            this.listeners.add(listener);
            return true;
        }
        return false;
    }

    public boolean removeGameControllerListener(GameControllerListener listener) {
        return this.listeners.removeValue(listener, true);
    }

    public void clearGameControllerListeners() {
        this.listeners.clear();
    }

    @Override
    public boolean addListener(EventListener listener) {
        boolean ret = this.touchpad.addListener(listener);
        if (this.shootButton.isVisible()) {
            ret &= this.shootButton.addListener(listener);
        }
        if (this.powerButton.isVisible()) {
            ret &= this.powerButton.addListener(listener);
        }
        return ret;
    }

    public void setDeadzone(float deadzoneRadius) {
        this.touchpad.setDeadzone(deadzoneRadius);
    }

    public float getKnobX() {
        return this.touchpad.getKnobX();
    }

    public float getKnobY() {
        return this.touchpad.getKnobY();
    }

    public float getKnobPercentX() {
        return this.touchpad.getKnobPercentX();
    }

    public float getKnobPercentY() {
        return this.touchpad.getKnobPercentY();
    }

    @Override
    public void setAlpha(float a) {
        this.touchpad.setColor(1.0f, 1.0f, 1.0f, a);
        this.shootButton.setColor(1.0f, 1.0f, 1.0f, a);
        this.powerButton.setColor(1.0f, 1.0f, 1.0f, a);
    }

    public boolean isButtonAPressed() {
        return this.shootButton.isPressed();
    }

    public boolean isButtonBPressed() {
        return this.powerButton.isPressed();
    }

    public void setButtonAVisible(boolean visible) {
        this.shootButton.setVisible(visible);
    }

    public void setButtonBVisible(boolean visible) {
        this.powerButton.setVisible(visible);
    }
}

