/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.ui;

import com.guidebee.game.ui.Event;
import com.guidebee.game.ui.EventListener;
import com.guidebee.game.ui.UIComponent;

public abstract class FocusListener
implements EventListener {
    @Override
    public boolean handle(Event event) {
        if (!(event instanceof FocusEvent)) {
            return false;
        }
        FocusEvent focusEvent = (FocusEvent)event;
        switch (focusEvent.getType()) {
            case keyboard: {
                this.keyboardFocusChanged(focusEvent, event.getTarget(), focusEvent.isFocused());
                break;
            }
            case scroll: {
                this.scrollFocusChanged(focusEvent, event.getTarget(), focusEvent.isFocused());
            }
        }
        return false;
    }

    public void keyboardFocusChanged(FocusEvent event, UIComponent component, boolean focused) {
    }

    public void scrollFocusChanged(FocusEvent event, UIComponent component, boolean focused) {
    }

    public static class FocusEvent
    extends Event {
        private boolean focused;
        private Type type;
        private UIComponent relatedComponent;

        @Override
        public void reset() {
            super.reset();
            this.relatedComponent = null;
        }

        public boolean isFocused() {
            return this.focused;
        }

        public void setFocused(boolean focused) {
            this.focused = focused;
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type focusType) {
            this.type = focusType;
        }

        public UIComponent getRelatedComponent() {
            return this.relatedComponent;
        }

        public void setRelatedComponent(UIComponent relatedComponent) {
            this.relatedComponent = relatedComponent;
        }

        public static enum Type {
            keyboard,
            scroll;

        }
    }
}

