/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.ui;

import com.guidebee.game.ui.DragListener;
import com.guidebee.game.ui.EventListener;
import com.guidebee.game.ui.InputEvent;
import com.guidebee.game.ui.Touchable;
import com.guidebee.game.ui.UIComponent;
import com.guidebee.game.ui.UIWindow;
import com.guidebee.math.Vector2;
import com.guidebee.utils.collections.Array;
import com.guidebee.utils.collections.ObjectMap;

public class DragAndDrop {
    static final Vector2 tmpVector = new Vector2();
    Payload payload;
    UIComponent dragComponent;
    Target target;
    boolean isValidTarget;
    Array<Target> targets = new Array();
    ObjectMap<Source, DragListener> sourceListeners = new ObjectMap();
    private float tapSquareSize = 8.0f;
    private int button;
    float dragComponentX = 14.0f;
    float dragComponentY = -20.0f;
    float touchOffsetX;
    float touchOffsetY;
    long dragStartTime;
    int dragTime = 250;
    int activePointer = -1;

    public void addSource(final Source source) {
        DragListener listener = new DragListener(){

            @Override
            public void dragStart(InputEvent event, float x, float y, int pointer) {
                if (DragAndDrop.this.activePointer != -1) {
                    event.stop();
                    return;
                }
                DragAndDrop.this.activePointer = pointer;
                DragAndDrop.this.dragStartTime = System.currentTimeMillis();
                DragAndDrop.this.payload = source.dragStart(event, this.getTouchDownX(), this.getTouchDownY(), pointer);
                event.stop();
            }

            @Override
            public void drag(InputEvent event, float x, float y, int pointer) {
                if (DragAndDrop.this.payload == null) {
                    return;
                }
                if (pointer != DragAndDrop.this.activePointer) {
                    return;
                }
                UIWindow window = event.getWindow();
                Touchable dragComponentTouchable = null;
                if (DragAndDrop.this.dragComponent != null) {
                    dragComponentTouchable = DragAndDrop.this.dragComponent.getTouchable();
                    DragAndDrop.this.dragComponent.setTouchable(Touchable.disabled);
                }
                Target newTarget = null;
                DragAndDrop.this.isValidTarget = false;
                float windowX = event.getWindowX() + DragAndDrop.this.touchOffsetX;
                float windowY = event.getWindowY() + DragAndDrop.this.touchOffsetY;
                UIComponent hit = event.getWindow().hit(windowX, windowY, true);
                if (hit == null) {
                    hit = event.getWindow().hit(windowX, windowY, false);
                }
                if (hit != null) {
                    int n = DragAndDrop.this.targets.size;
                    for (int i = 0; i < n; ++i) {
                        Target target = DragAndDrop.this.targets.get(i);
                        if (!target.component.isAscendantOf(hit)) continue;
                        newTarget = target;
                        target.component.windowToLocalCoordinates(tmpVector.set(windowX, windowY));
                        DragAndDrop.this.isValidTarget = target.drag(source, DragAndDrop.this.payload, DragAndDrop.tmpVector.x, DragAndDrop.tmpVector.y, pointer);
                        break;
                    }
                }
                if (newTarget != DragAndDrop.this.target) {
                    if (DragAndDrop.this.target != null) {
                        DragAndDrop.this.target.reset(source, DragAndDrop.this.payload);
                    }
                    DragAndDrop.this.target = newTarget;
                }
                if (DragAndDrop.this.dragComponent != null) {
                    DragAndDrop.this.dragComponent.setTouchable(dragComponentTouchable);
                }
                UIComponent component = null;
                if (DragAndDrop.this.target != null) {
                    UIComponent uIComponent = component = DragAndDrop.this.isValidTarget ? DragAndDrop.this.payload.validDragComponent : DragAndDrop.this.payload.invalidDragComponent;
                }
                if (component == null) {
                    component = DragAndDrop.this.payload.dragComponent;
                }
                if (component == null) {
                    return;
                }
                if (DragAndDrop.this.dragComponent != component) {
                    if (DragAndDrop.this.dragComponent != null) {
                        DragAndDrop.this.dragComponent.remove();
                    }
                    DragAndDrop.this.dragComponent = component;
                    window.addComponent(component);
                }
                float componentX = event.getWindowX() + DragAndDrop.this.dragComponentX;
                float componentY = event.getWindowY() + DragAndDrop.this.dragComponentY - component.getHeight();
                if (componentX < 0.0f) {
                    componentX = 0.0f;
                }
                if (componentY < 0.0f) {
                    componentY = 0.0f;
                }
                if (componentX + component.getWidth() > window.getWidth()) {
                    componentX = window.getWidth() - component.getWidth();
                }
                if (componentY + component.getHeight() > window.getHeight()) {
                    componentY = window.getHeight() - component.getHeight();
                }
                component.setPosition(componentX, componentY);
            }

            @Override
            public void dragStop(InputEvent event, float x, float y, int pointer) {
                if (pointer != DragAndDrop.this.activePointer) {
                    return;
                }
                DragAndDrop.this.activePointer = -1;
                if (DragAndDrop.this.payload == null) {
                    return;
                }
                if (System.currentTimeMillis() - DragAndDrop.this.dragStartTime < (long)DragAndDrop.this.dragTime) {
                    DragAndDrop.this.isValidTarget = false;
                }
                if (DragAndDrop.this.dragComponent != null) {
                    DragAndDrop.this.dragComponent.remove();
                }
                if (DragAndDrop.this.isValidTarget) {
                    float windowX = event.getWindowX() + DragAndDrop.this.touchOffsetX;
                    float windowY = event.getWindowY() + DragAndDrop.this.touchOffsetY;
                    DragAndDrop.this.target.component.windowToLocalCoordinates(tmpVector.set(windowX, windowY));
                    DragAndDrop.this.target.drop(source, DragAndDrop.this.payload, DragAndDrop.tmpVector.x, DragAndDrop.tmpVector.y, pointer);
                }
                source.dragStop(event, x, y, pointer, DragAndDrop.this.payload, DragAndDrop.this.isValidTarget ? DragAndDrop.this.target : null);
                if (DragAndDrop.this.target != null) {
                    DragAndDrop.this.target.reset(source, DragAndDrop.this.payload);
                }
                DragAndDrop.this.payload = null;
                DragAndDrop.this.target = null;
                DragAndDrop.this.isValidTarget = false;
                DragAndDrop.this.dragComponent = null;
            }
        };
        listener.setTapSquareSize(this.tapSquareSize);
        listener.setButton(this.button);
        source.component.addCaptureListener(listener);
        this.sourceListeners.put(source, listener);
    }

    public void removeSource(Source source) {
        DragListener dragListener = this.sourceListeners.remove(source);
        source.component.removeCaptureListener(dragListener);
    }

    public void addTarget(Target target) {
        this.targets.add(target);
    }

    public void removeTarget(Target target) {
        this.targets.removeValue(target, true);
    }

    public void clear() {
        this.targets.clear();
        for (ObjectMap.Entry<Source, DragListener> entry : this.sourceListeners.entries()) {
            ((Source)entry.key).component.removeCaptureListener((EventListener)entry.value);
        }
        this.sourceListeners.clear();
    }

    public void setTapSquareSize(float halfTapSquareSize) {
        this.tapSquareSize = halfTapSquareSize;
    }

    public void setButton(int button) {
        this.button = button;
    }

    public void setDragComponentPosition(float dragComponentX, float dragComponentY) {
        this.dragComponentX = dragComponentX;
        this.dragComponentY = dragComponentY;
    }

    public void setTouchOffset(float touchOffsetX, float touchOffsetY) {
        this.touchOffsetX = touchOffsetX;
        this.touchOffsetY = touchOffsetY;
    }

    public boolean isDragging() {
        return this.payload != null;
    }

    public UIComponent getDragComponent() {
        return this.dragComponent;
    }

    public void setDragTime(int dragMillis) {
        this.dragTime = dragMillis;
    }

    public static class Payload {
        UIComponent dragComponent;
        UIComponent validDragComponent;
        UIComponent invalidDragComponent;
        Object object;

        public void setDragComponent(UIComponent dragComponent) {
            this.dragComponent = dragComponent;
        }

        public UIComponent getDragComponent() {
            return this.dragComponent;
        }

        public void setValidDragComponent(UIComponent validDragComponent) {
            this.validDragComponent = validDragComponent;
        }

        public UIComponent getValidDragComponent() {
            return this.validDragComponent;
        }

        public void setInvalidDragComponent(UIComponent invalidDragComponent) {
            this.invalidDragComponent = invalidDragComponent;
        }

        public UIComponent getInvalidDragComponent() {
            return this.invalidDragComponent;
        }

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object object) {
            this.object = object;
        }
    }

    public static abstract class Target {
        final UIComponent component;

        public Target(UIComponent component) {
            if (component == null) {
                throw new IllegalArgumentException("component cannot be null.");
            }
            this.component = component;
            UIWindow window = component.getWindow();
            if (window != null && component == window.getRoot()) {
                throw new IllegalArgumentException("The window root cannot be a drag and drop target.");
            }
        }

        public abstract boolean drag(Source var1, Payload var2, float var3, float var4, int var5);

        public void reset(Source source, Payload payload) {
        }

        public abstract void drop(Source var1, Payload var2, float var3, float var4, int var5);

        public UIComponent getComponent() {
            return this.component;
        }
    }

    public static abstract class Source {
        final UIComponent component;

        public Source(UIComponent component) {
            if (component == null) {
                throw new IllegalArgumentException("component cannot be null.");
            }
            this.component = component;
        }

        public abstract Payload dragStart(InputEvent var1, float var2, float var3, int var4);

        public void dragStop(InputEvent event, float x, float y, int pointer, Payload payload, Target target) {
        }

        public UIComponent getComponent() {
            return this.component;
        }
    }
}

