/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.ui;

import com.guidebee.game.graphics.Batch;
import com.guidebee.game.graphics.BitmapFont;
import com.guidebee.game.graphics.Color;
import com.guidebee.game.ui.Button;
import com.guidebee.game.ui.Cell;
import com.guidebee.game.ui.Image;
import com.guidebee.game.ui.Label;
import com.guidebee.game.ui.Skin;
import com.guidebee.game.ui.TextButton;
import com.guidebee.game.ui.drawable.Drawable;

public class CheckBox
extends TextButton {
    private Image image;
    private Cell imageCell;
    private CheckBoxStyle style;

    public CheckBox(String text, Skin skin) {
        this(text, skin.get(CheckBoxStyle.class));
    }

    public CheckBox(String text, Skin skin, String styleName) {
        this(text, skin.get(styleName, CheckBoxStyle.class));
    }

    public CheckBox(String text, CheckBoxStyle style2) {
        super(text, style2);
        this.clearChildren();
        this.image = new Image(style2.checkboxOff);
        this.imageCell = this.add(this.image);
        Label label = this.getLabel();
        this.add(label);
        label.setAlignment(8);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    @Override
    public void setStyle(Button.ButtonStyle style2) {
        if (!(style2 instanceof CheckBoxStyle)) {
            throw new IllegalArgumentException("style must be a CheckBoxStyle.");
        }
        super.setStyle(style2);
        this.style = (CheckBoxStyle)style2;
    }

    @Override
    public CheckBoxStyle getStyle() {
        return this.style;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Drawable checkbox = null;
        if (this.isDisabled) {
            checkbox = this.isChecked && this.style.checkboxOnDisabled != null ? this.style.checkboxOnDisabled : this.style.checkboxOffDisabled;
        }
        if (checkbox == null) {
            checkbox = this.isChecked && this.style.checkboxOn != null ? this.style.checkboxOn : (this.isOver() && this.style.checkboxOver != null && !this.isDisabled ? this.style.checkboxOver : this.style.checkboxOff);
        }
        this.image.setDrawable(checkbox);
        super.draw(batch, parentAlpha);
    }

    public Image getImage() {
        return this.image;
    }

    public Cell getImageCell() {
        return this.imageCell;
    }

    public static class CheckBoxStyle
    extends TextButton.TextButtonStyle {
        public Drawable checkboxOn;
        public Drawable checkboxOff;
        public Drawable checkboxOver;
        public Drawable checkboxOnDisabled;
        public Drawable checkboxOffDisabled;

        public CheckBoxStyle() {
        }

        public CheckBoxStyle(Drawable checkboxOff, Drawable checkboxOn, BitmapFont font, Color fontColor) {
            this.checkboxOff = checkboxOff;
            this.checkboxOn = checkboxOn;
            this.font = font;
            this.fontColor = fontColor;
        }

        public CheckBoxStyle(CheckBoxStyle style2) {
            this.checkboxOff = style2.checkboxOff;
            this.checkboxOn = style2.checkboxOn;
            this.checkboxOver = style2.checkboxOver;
            this.checkboxOffDisabled = style2.checkboxOffDisabled;
            this.checkboxOnDisabled = style2.checkboxOnDisabled;
            this.font = style2.font;
            this.fontColor = new Color(style2.fontColor);
        }
    }
}

