/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.ui;

import com.guidebee.game.graphics.Batch;
import com.guidebee.game.ui.ButtonGroup;
import com.guidebee.game.ui.ChangeListener;
import com.guidebee.game.ui.ClickListener;
import com.guidebee.game.ui.Disableable;
import com.guidebee.game.ui.InputEvent;
import com.guidebee.game.ui.Skin;
import com.guidebee.game.ui.Table;
import com.guidebee.game.ui.Touchable;
import com.guidebee.game.ui.UIComponent;
import com.guidebee.game.ui.drawable.Drawable;
import com.guidebee.utils.Pools;
import com.guidebee.utils.collections.SnapshotArray;

public class Button
extends Table
implements Disableable {
    private ButtonStyle style;
    boolean isChecked;
    boolean isDisabled;
    ButtonGroup buttonGroup;
    private ClickListener clickListener;

    public Button(Skin skin) {
        super(skin);
        this.initialize();
        this.setStyle(skin.get(ButtonStyle.class));
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    public Button(Skin skin, String styleName) {
        super(skin);
        this.initialize();
        this.setStyle(skin.get(styleName, ButtonStyle.class));
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    public Button(UIComponent child, Skin skin, String styleName) {
        this(child, skin.get(styleName, ButtonStyle.class));
    }

    public Button(UIComponent child, ButtonStyle style2) {
        this.initialize();
        this.add(child);
        this.setStyle(style2);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    public Button(ButtonStyle style2) {
        this.initialize();
        this.setStyle(style2);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    public Button() {
        this.initialize();
    }

    private void initialize() {
        this.setTouchable(Touchable.enabled);
        this.clickListener = new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (Button.this.isDisabled) {
                    return;
                }
                Button.this.setChecked(!Button.this.isChecked);
            }
        };
        this.addListener(this.clickListener);
    }

    public Button(Drawable up) {
        this(new ButtonStyle(up, null, null));
    }

    public Button(Drawable up, Drawable down) {
        this(new ButtonStyle(up, down, null));
    }

    public Button(Drawable up, Drawable down, Drawable checked) {
        this(new ButtonStyle(up, down, checked));
    }

    public Button(UIComponent child, Skin skin) {
        this(child, skin.get(ButtonStyle.class));
    }

    public void setChecked(boolean isChecked) {
        if (this.isChecked == isChecked) {
            return;
        }
        if (this.buttonGroup != null && !this.buttonGroup.canCheck(this, isChecked)) {
            return;
        }
        this.isChecked = isChecked;
        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
        if (this.fire(changeEvent)) {
            this.isChecked = !isChecked;
        }
        Pools.free(changeEvent);
    }

    public void toggle() {
        this.setChecked(!this.isChecked);
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public boolean isPressed() {
        return this.clickListener.isVisualPressed();
    }

    public boolean isOver() {
        return this.clickListener.isOver();
    }

    public ClickListener getClickListener() {
        return this.clickListener;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    @Override
    public void setDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public void setStyle(ButtonStyle style2) {
        if (style2 == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style2;
        Drawable background = style2.up;
        if (background == null && (background = style2.down) == null) {
            background = style2.checked;
        }
        if (background != null) {
            this.padBottom(background.getBottomHeight());
            this.padTop(background.getTopHeight());
            this.padLeft(background.getLeftWidth());
            this.padRight(background.getRightWidth());
        }
        this.invalidateHierarchy();
    }

    public ButtonStyle getStyle() {
        return this.style;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        int i;
        this.validate();
        Drawable background = null;
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        if (this.isPressed() && !this.isDisabled) {
            background = this.style.down == null ? this.style.up : this.style.down;
            offsetX = this.style.pressedOffsetX;
            offsetY = this.style.pressedOffsetY;
        } else {
            background = this.isDisabled && this.style.disabled != null ? this.style.disabled : (this.isChecked && this.style.checked != null ? (this.isOver() && this.style.checkedOver != null ? this.style.checkedOver : this.style.checked) : (this.isOver() && this.style.over != null ? this.style.over : this.style.up));
            offsetX = this.style.unpressedOffsetX;
            offsetY = this.style.unpressedOffsetY;
        }
        this.setBackground(background, false);
        SnapshotArray<UIComponent> children = this.getChildren();
        for (i = 0; i < children.size; ++i) {
            ((UIComponent)children.get(i)).moveBy(offsetX, offsetY);
        }
        super.draw(batch, parentAlpha);
        for (i = 0; i < children.size; ++i) {
            ((UIComponent)children.get(i)).moveBy(-offsetX, -offsetY);
        }
    }

    @Override
    public float getPrefWidth() {
        float width = super.getPrefWidth();
        if (this.style.up != null) {
            width = Math.max(width, this.style.up.getMinWidth());
        }
        if (this.style.down != null) {
            width = Math.max(width, this.style.down.getMinWidth());
        }
        if (this.style.checked != null) {
            width = Math.max(width, this.style.checked.getMinWidth());
        }
        return width;
    }

    @Override
    public float getPrefHeight() {
        float height = super.getPrefHeight();
        if (this.style.up != null) {
            height = Math.max(height, this.style.up.getMinHeight());
        }
        if (this.style.down != null) {
            height = Math.max(height, this.style.down.getMinHeight());
        }
        if (this.style.checked != null) {
            height = Math.max(height, this.style.checked.getMinHeight());
        }
        return height;
    }

    @Override
    public float getMinWidth() {
        return this.getPrefWidth();
    }

    @Override
    public float getMinHeight() {
        return this.getPrefHeight();
    }

    public static class ButtonStyle {
        public Drawable up;
        public Drawable down;
        public Drawable over;
        public Drawable checked;
        public Drawable checkedOver;
        public Drawable disabled;
        public float pressedOffsetX;
        public float pressedOffsetY;
        public float unpressedOffsetX;
        public float unpressedOffsetY;

        public ButtonStyle() {
        }

        public ButtonStyle(Drawable up, Drawable down, Drawable checked) {
            this.up = up;
            this.down = down;
            this.checked = checked;
        }

        public ButtonStyle(ButtonStyle style2) {
            this.up = style2.up;
            this.down = style2.down;
            this.over = style2.over;
            this.checked = style2.checked;
            this.checkedOver = style2.checkedOver;
            this.disabled = style2.disabled;
            this.pressedOffsetX = style2.pressedOffsetX;
            this.pressedOffsetY = style2.pressedOffsetY;
            this.unpressedOffsetX = style2.unpressedOffsetX;
            this.unpressedOffsetY = style2.unpressedOffsetY;
        }
    }
}

