/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.scene;

import com.guidebee.drawing.geometry.Area;
import com.guidebee.drawing.geometry.Polygon;
import com.guidebee.game.Collidable;
import com.guidebee.game.GameEngine;
import com.guidebee.game.InputAdapter;
import com.guidebee.game.camera.Camera;
import com.guidebee.game.camera.OrthographicCamera;
import com.guidebee.game.camera.viewports.ScalingViewport;
import com.guidebee.game.camera.viewports.Viewport;
import com.guidebee.game.engine.maps.tiled.renderers.IsometricTiledMapRenderer;
import com.guidebee.game.engine.maps.tiled.renderers.OrthogonalTiledMapRenderer;
import com.guidebee.game.entity.Entity;
import com.guidebee.game.entity.EntityEngine;
import com.guidebee.game.entity.Role;
import com.guidebee.game.entity.directors.Director;
import com.guidebee.game.entity.utils.ImmutableArray;
import com.guidebee.game.graphics.Batch;
import com.guidebee.game.graphics.Color;
import com.guidebee.game.graphics.SpriteBatch;
import com.guidebee.game.physics.Body;
import com.guidebee.game.physics.Contact;
import com.guidebee.game.physics.ContactFilter;
import com.guidebee.game.physics.ContactImpulse;
import com.guidebee.game.physics.ContactListener;
import com.guidebee.game.physics.Filter;
import com.guidebee.game.physics.Fixture;
import com.guidebee.game.physics.Manifold;
import com.guidebee.game.physics.World;
import com.guidebee.game.scene.Actor;
import com.guidebee.game.scene.Group;
import com.guidebee.game.scene.InternalStage;
import com.guidebee.game.scene.Scenery;
import com.guidebee.game.scene.collision.Collision;
import com.guidebee.game.scene.collision.CollisionListener;
import com.guidebee.game.scene.collision.SensorListener;
import com.guidebee.game.ui.GameController;
import com.guidebee.game.ui.Stack;
import com.guidebee.game.ui.Table;
import com.guidebee.game.ui.UIComponent;
import com.guidebee.game.ui.UIContainer;
import com.guidebee.game.ui.Widget;
import com.guidebee.game.ui.WidgetGroup;
import com.guidebee.game.ui.actions.Action;
import com.guidebee.math.Matrix4;
import com.guidebee.math.Vector2;
import com.guidebee.math.geometry.Rectangle;
import com.guidebee.utils.Disposable;
import com.guidebee.utils.Scaling;
import com.guidebee.utils.collections.Array;
import com.guidebee.utils.collections.SnapshotArray;

public class Stage
extends InputAdapter
implements Disposable {
    private final Stack stack = new Stack();
    private final Table tableGameControl = new Table();
    protected Array<Body> bodiesTobeDeleted = new Array();
    protected EntityEngine entityEngine;
    protected World world;
    protected InternalStage internalStage;
    protected InternalStage internalStageHUD;
    protected CollisionListener collisionListener = null;
    protected SensorListener sensorListener = null;
    protected ContactMonitor contactMonitor = new ContactMonitor();
    protected Scenery scenery;
    protected int collisionType = 1;

    public Stage() {
        this(new ScalingViewport(Scaling.stretch, GameEngine.graphics.getWidth(), GameEngine.graphics.getHeight(), new OrthographicCamera()), new SpriteBatch());
    }

    public Stage(Viewport viewport) {
        this(viewport, new SpriteBatch());
    }

    public Stage(Viewport viewport, Batch batch) {
        this.internalStage = new InternalStage(viewport, batch, this);
        this.internalStageHUD = new InternalStage(viewport, batch, null);
        this.entityEngine = new EntityEngine();
        this.internalStage.setUserObject(this);
        this.entityEngine.setUserObject(this);
        this.stack.setFillParent(true);
        this.internalStageHUD.addComponent(this.stack);
        this.tableGameControl.setFillParent(true);
        this.stack.add(this.tableGameControl);
        this.tableGameControl.toFront();
    }

    public void drawExtra(Batch batch) {
    }

    public void setGameController(GameController gameController) {
        this.tableGameControl.addComponent(gameController);
    }

    public void removeGameController() {
        this.tableGameControl.clear();
    }

    protected void performNoneBox2DCollisionChecking() {
        int allOtherTypes;
        if (this.collisionListener != null && (this.collisionType & (allOtherTypes = 7)) != 0) {
            Array<Collidable> collidables = this.getAllCollidables();
            Stage.collisionQuery((Collidable[])collidables.toArray(Collidable.class), this.collisionType, this.collisionListener);
        }
    }

    public void setSensorListener(SensorListener listener) {
        boolean existingMonitor = this.sensorListener != null || this.collisionListener != null;
        this.sensorListener = listener;
        if (!existingMonitor && listener != null) {
            this.world.setContactListener(this.contactMonitor);
        }
    }

    public void setCollisionListener(CollisionListener listener) {
        this.setCollisionListener(listener, 4);
    }

    public void setCollisionListener(CollisionListener listener, int type) {
        if (listener == null) {
            this.collisionListener = null;
            if (this.world != null) {
                this.world.setContactListener(null);
            }
        }
        if ((type & 8) == 8 && this.world != null) {
            this.world.setContactListener(this.contactMonitor);
            this.world.setContactFilter(new ContactFilter(){

                @Override
                public boolean shouldCollide(Fixture fixtureA, Fixture fixtureB) {
                    Filter filterA = fixtureA.getFilterData();
                    Filter filterB = fixtureB.getFilterData();
                    if (filterA.groupIndex == filterB.groupIndex && filterA.groupIndex != 0) {
                        return filterA.groupIndex > 0;
                    }
                    boolean collide = (filterA.maskBits & filterB.categoryBits) != 0 && (filterA.categoryBits & filterB.maskBits) != 0;
                    return collide;
                }
            });
        }
        this.collisionListener = listener;
        this.collisionType = type;
    }

    public <T extends Actor> T findActor(String name) {
        Object actor = this.internalStage.findComponent(name);
        if (actor != null) {
            return (T)((Actor)((UIComponent)actor).getUserObject());
        }
        return null;
    }

    public void addHUDComponent(Widget widget) {
        this.internalStageHUD.addComponent(widget);
    }

    public void addHUDComponent(WidgetGroup widgetGroup) {
        this.internalStageHUD.addComponent(widgetGroup);
    }

    public void setScenery(Scenery scenery) {
        this.scenery = scenery;
        if (scenery.mapType == Scenery.MapType.OrthogonalTiled) {
            scenery.tiledMapRenderer = new OrthogonalTiledMapRenderer(scenery.tiledMap, this.getBatch());
            scenery.tiledMapRenderer.setView((OrthographicCamera)this.getCamera());
        } else if (scenery.mapType == Scenery.MapType.IsometricTiled) {
            scenery.tiledMapRenderer = new IsometricTiledMapRenderer(scenery.tiledMap, this.getBatch());
        }
    }

    public Array<Collidable> getAllCollidables() {
        Array<Collidable> collidables = new Array<Collidable>(false, 32);
        Array<Actor> actors = this.getActors();
        for (Actor actor : actors) {
            if (!actor.isEnabled()) continue;
            if (actor instanceof Group) {
                this.getAllCollidables((Group)actor, collidables);
                continue;
            }
            collidables.add(actor);
        }
        Array<Collidable> tiles = this.getAllMapCollidables();
        collidables.addAll(tiles);
        return collidables;
    }

    protected Array<Collidable> getAllMapCollidables() {
        Array<Collidable> collidables = new Array<Collidable>(false, 32);
        if (this.scenery != null) {
            Array<Collidable> tiles = this.scenery.getAllCollidables();
            collidables.addAll(tiles);
        }
        return collidables;
    }

    protected void getAllCollidables(Group group, Array<Collidable> collidables) {
        SnapshotArray<Actor> actors = group.getChildren();
        for (Actor actor : actors) {
            if (!actor.isEnabled()) continue;
            if (actor instanceof Group) {
                this.getAllCollidables((Group)actor, collidables);
                continue;
            }
            collidables.add(actor);
        }
    }

    public void act() {
        this.act(Math.min(GameEngine.graphics.getDeltaTime(), 0.033333335f));
    }

    public void act(float delta) {
        if (this.world != null) {
            this.world.step(delta, GameEngine.VelocityIterations, GameEngine.positionIterations);
            for (Body body : this.bodiesTobeDeleted) {
                this.world.destroyBody(body);
            }
            this.bodiesTobeDeleted.clear();
        }
        this.internalStage.act(delta);
        this.performNoneBox2DCollisionChecking();
        this.entityEngine.update(delta);
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        boolean ret = this.internalStageHUD.touchDown(screenX, screenY, pointer, button);
        if (!ret) {
            ret = this.internalStage.touchDown(screenX, screenY, pointer, button);
        }
        return ret;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        boolean ret = this.internalStageHUD.touchDragged(screenX, screenY, pointer);
        if (!ret) {
            ret = this.internalStage.touchDragged(screenX, screenY, pointer);
        }
        return ret;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        boolean ret = this.internalStageHUD.touchUp(screenX, screenY, pointer, button);
        if (!ret) {
            ret = this.internalStage.touchUp(screenX, screenY, pointer, button);
        }
        return ret;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        boolean ret = this.internalStageHUD.mouseMoved(screenX, screenY);
        if (!ret) {
            ret = this.internalStage.mouseMoved(screenX, screenY);
        }
        return ret;
    }

    @Override
    public boolean scrolled(int amount) {
        boolean ret = this.internalStageHUD.scrolled(amount);
        if (!ret) {
            ret = this.internalStage.scrolled(amount);
        }
        return ret;
    }

    @Override
    public boolean keyDown(int keyCode) {
        boolean ret = this.internalStageHUD.keyDown(keyCode);
        if (!ret) {
            ret = this.internalStage.keyDown(keyCode);
        }
        return ret;
    }

    @Override
    public boolean keyUp(int keyCode) {
        boolean ret = this.internalStageHUD.keyUp(keyCode);
        if (!ret) {
            ret = this.internalStage.keyUp(keyCode);
        }
        return ret;
    }

    @Override
    public boolean keyTyped(char character) {
        boolean ret = this.internalStageHUD.keyTyped(character);
        if (!ret) {
            ret = this.internalStage.keyTyped(character);
        }
        return ret;
    }

    public void addActor(Actor actor) {
        if (actor instanceof Group) {
            Group group = (Group)actor;
            this.internalStage.addComponent(group.internalGroup);
        } else {
            this.internalStage.addComponent(actor.internalActor);
        }
        this.entityEngine.addEntity(actor.entity);
    }

    public void addAction(Action action) {
        this.internalStage.addAction(action);
    }

    public Array<Actor> getActors() {
        Array<UIComponent> internalActors = this.internalStage.getComponents();
        Array<Actor> actors = null;
        if (internalActors != null) {
            actors = new Array<Actor>();
            for (UIComponent actor : internalActors) {
                actors.add((Actor)actor.getUserObject());
            }
        }
        return actors;
    }

    public void addDirector(Director director) {
        this.entityEngine.addDirector(director);
    }

    public void removeDirector(Director director) {
        this.entityEngine.removeDirector(director);
    }

    public <T extends Director> T getDirector(Class<T> directorType) {
        return this.entityEngine.getDirector(directorType);
    }

    public ImmutableArray<Director> getDirectors() {
        return this.entityEngine.getDirectors();
    }

    public ImmutableArray<Actor> geActorsFor(Role role) {
        ImmutableArray<Entity> entities = this.entityEngine.getEntitiesFor(role);
        ImmutableArray actors = null;
        if (entities != null) {
            Array<Actor> internalActors = new Array<Actor>();
            for (int i = 0; i < entities.size(); ++i) {
                Entity entity = entities.get(i);
                internalActors.add((Actor)entity.getUserObject());
            }
            actors = new ImmutableArray(internalActors);
        }
        return actors;
    }

    public void initWorld() {
        if (this.world != null) {
            this.world.dispose();
        }
        GameEngine.world = this.world = new World(new Vector2(0.0f, -10.0f), true);
    }

    public void setWorld(World world) {
        if (this.world != null) {
            this.world.dispose();
        }
        GameEngine.world = this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    public void clear() {
        this.entityEngine.removeAllEntities();
        this.internalStage.clear();
    }

    public void clearHUDComponents() {
        this.internalStageHUD.clear();
    }

    public void unfocusAll() {
        this.internalStage.unfocusAll();
    }

    public void unfocus(Actor actor) {
        this.internalStage.unfocus(actor.internalActor);
    }

    public void setKeyboardFocus(Actor actor) {
        this.internalStage.setKeyboardFocus(actor.internalActor);
    }

    public Actor getKeyboardFocus() {
        UIComponent actor = this.internalStage.getKeyboardFocus();
        if (actor != null) {
            return (Actor)actor.getUserObject();
        }
        return null;
    }

    public void setScrollFocus(Actor actor) {
        this.internalStage.setScrollFocus(actor.internalActor);
    }

    public Actor getScrollFocus() {
        UIComponent actor = this.internalStage.getScrollFocus();
        if (actor != null) {
            return (Actor)actor.getUserObject();
        }
        return null;
    }

    public Batch getBatch() {
        return this.internalStage.getBatch();
    }

    public Viewport getViewport() {
        return this.internalStage.getViewport();
    }

    public void setViewport(Viewport viewport) {
        this.internalStage.setViewport(viewport);
    }

    public float getWidth() {
        return this.internalStage.getWidth();
    }

    public float getHeight() {
        return this.internalStage.getHeight();
    }

    public Camera getCamera() {
        return this.internalStage.getCamera();
    }

    public Group getRoot() {
        UIContainer UIContainer2 = this.internalStage.getRoot();
        if (UIContainer2 != null) {
            return (Group)UIContainer2.getUserObject();
        }
        return null;
    }

    public Actor hit(float stageX, float stageY) {
        UIComponent actor = this.internalStage.hit(stageX, stageY, true);
        if (actor != null) {
            return (Actor)actor.getUserObject();
        }
        return null;
    }

    public Vector2 screenToStageCoordinates(Vector2 screenCoords) {
        return this.internalStage.screenToWindowCoordinates(screenCoords);
    }

    public Vector2 stageToScreenCoordinates(Vector2 stageCoords) {
        return this.internalStage.windowToScreenCoordinates(stageCoords);
    }

    public Vector2 toScreenCoordinates(Vector2 coords, Matrix4 transformMatrix) {
        return this.internalStage.toScreenCoordinates(coords, transformMatrix);
    }

    public void calculateScissors(Rectangle localRect, Rectangle scissorRect) {
        this.internalStage.calculateScissors(localRect, scissorRect);
    }

    public Color getDebugColor() {
        return this.internalStage.getDebugColor();
    }

    public void setDebugInvisible(boolean debugInvisible) {
        this.internalStage.setDebugInvisible(debugInvisible);
    }

    public void setDebugAll(boolean debugAll) {
        this.internalStage.setDebugAll(debugAll);
    }

    public void setDebugUnderMouse(boolean debugUnderMouse) {
        this.internalStage.setDebugUnderMouse(debugUnderMouse);
    }

    public void setDebugParentUnderMouse(boolean debugParentUnderMouse) {
        this.internalStage.setDebugParentUnderMouse(debugParentUnderMouse);
    }

    public void setDebugTableUnderMouse(Table.Debug debugTableUnderMouse) {
        this.internalStage.setDebugTableUnderMouse(debugTableUnderMouse);
    }

    public void draw() {
        this.internalStage.resetCamera();
        if (this.scenery != null) {
            this.scenery.renderBackgroundLayers();
        }
        this.internalStage.draw();
        if (this.scenery != null) {
            this.scenery.renderForegroundLayers();
        }
        this.internalStageHUD.draw();
    }

    public void setDebugTableUnderMouse(boolean debugTableUnderMouse) {
        this.internalStage.setDebugTableUnderMouse(debugTableUnderMouse);
    }

    @Override
    public void dispose() {
        this.internalStageHUD.setUserObject(null);
        this.internalStage.dispose();
        this.internalStageHUD.dispose();
        if (this.world != null) {
            this.world.dispose();
        }
    }

    public static final void collisionQuery(Collidable[] collidables, int collisionType, CollisionListener collisionListener) {
        if (collisionListener != null) {
            for (int i = 0; i < collidables.length - 1; ++i) {
                for (int j = i + 1; j < collidables.length; ++j) {
                    Collidable obj1 = collidables[i];
                    Collidable obj2 = collidables[j];
                    if (!Stage.collisionQuery(obj1, obj2, collisionType)) continue;
                    Collision collision = new Collision(obj1, obj2, collisionType);
                    collisionListener.collisionDetected(collision);
                }
            }
        }
    }

    public static final boolean collisionQuery(Collidable collidable, Collidable otherCollidable) {
        return Stage.collisionQuery(collidable, otherCollidable, 4);
    }

    public static final boolean collisionQuery(Collidable collidable, Collidable otherCollidable, int collisionType) {
        boolean result = true;
        if (collidable.isEnabled() && otherCollidable.isEnabled()) {
            if ((collisionType & 1) == 1) {
                result &= collidable.getBoundingAABB().overlaps(otherCollidable.getBoundingAABB());
            }
            if ((collisionType & 4) == 4) {
                result &= collidable.getBoundingCircle().overlaps(otherCollidable.getBoundingCircle());
            }
            if ((collisionType & 2) == 2 || (collisionType & 8) == 8) {
                float[] vertices1 = collidable.getBoundingPolygon().getVertices();
                float[] vertices2 = otherCollidable.getBoundingPolygon().getVertices();
                int[] xpoints1 = new int[vertices1.length / 2];
                int[] xpoints2 = new int[vertices1.length / 2];
                int[] ypoints1 = new int[vertices1.length / 2];
                int[] ypoints2 = new int[vertices1.length / 2];
                for (int i = 0; i < vertices1.length / 2; ++i) {
                    xpoints1[i] = Math.round(vertices1[i * 2]);
                    ypoints1[i] = Math.round(vertices1[i * 2 + 1]);
                    xpoints2[i] = Math.round(vertices2[i * 2]);
                    ypoints2[i] = Math.round(vertices2[i * 2 + 1]);
                }
                Polygon polygon1 = new Polygon(xpoints1, ypoints1, xpoints1.length);
                Polygon polygon2 = new Polygon(xpoints2, ypoints2, xpoints2.length);
                Area area1 = new Area(polygon1);
                Area area2 = new Area(polygon2);
                area1.intersect(area2);
                result &= !area1.isEmpty();
            }
        } else {
            result = false;
        }
        return result;
    }

    private class ContactMonitor
    implements ContactListener {
        private ContactMonitor() {
        }

        @Override
        public void beginContact(Contact contact) {
            if (Stage.this.sensorListener != null) {
                Stage.this.sensorListener.beginContact(contact);
            }
        }

        @Override
        public void endContact(Contact contact) {
            if (Stage.this.sensorListener != null) {
                Stage.this.sensorListener.endContact(contact);
            }
        }

        @Override
        public void preSolve(Contact contact, Manifold oldManifold) {
        }

        @Override
        public void postSolve(Contact contact, ContactImpulse impulse) {
            Fixture fixture1 = contact.getFixtureA();
            Fixture fixture2 = contact.getFixtureB();
            if (fixture1 != null && fixture2 != null && contact.isTouching()) {
                Collision collision = new Collision(contact);
                if (Stage.this.collisionListener != null) {
                    Stage.this.collisionListener.collisionDetected(collision);
                }
            }
        }
    }
}

