/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.entity.directors;

import com.guidebee.game.entity.Entity;
import com.guidebee.game.entity.EntityEngine;
import com.guidebee.game.entity.Role;
import com.guidebee.game.entity.directors.Director;
import com.guidebee.game.entity.utils.ImmutableArray;

public abstract class IteratingDirector
extends Director {
    private Role role;
    private ImmutableArray<Entity> entities;

    public IteratingDirector(Role role) {
        this(role, 0);
    }

    public IteratingDirector(Role role, int priority) {
        super(priority);
        this.role = role;
    }

    @Override
    public void addedToEngine(EntityEngine entityEngine) {
        this.entities = entityEngine.getEntitiesFor(this.role);
    }

    @Override
    public void removedFromEngine(EntityEngine entityEngine) {
        this.entities = null;
    }

    @Override
    public void direct(float deltaTime) {
        for (int i = 0; i < this.entities.size(); ++i) {
            this.processEntity(this.entities.get(i), deltaTime);
        }
    }

    protected abstract void processEntity(Entity var1, float var2);
}

