/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.platform.svg;

import android.graphics.Matrix;
import android.util.Log;
import com.guidebee.game.engine.platform.svg.CSSParser;
import com.guidebee.game.engine.platform.svg.IntegerParser;
import com.guidebee.game.engine.platform.svg.NumberParser;
import com.guidebee.game.engine.platform.svg.PreserveAspectRatio;
import com.guidebee.game.engine.platform.svg.SVG;
import com.guidebee.game.engine.platform.svg.SVGParseException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

public class SVGParser
extends DefaultHandler2 {
    private static final String TAG = "SVGParser";
    private static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    private static final String XLINK_NAMESPACE = "http://www.w3.org/1999/xlink";
    private static final String FEATURE_STRING_PREFIX = "http://www.w3.org/TR/SVG11/feature#";
    private SVG svgDocument = null;
    private SVG.SvgContainer currentElement = null;
    private boolean ignoring = false;
    private int ignoreDepth;
    private boolean inMetadataElement = false;
    private SVGElem metadataTag = null;
    private StringBuilder metadataElementContents = null;
    private boolean inStyleElement = false;
    private StringBuilder styleElementContents = null;
    private Set<String> supportedFormats = null;
    private static final String NONE = "none";
    private static final String CURRENTCOLOR = "currentColor";
    private static final String VALID_DISPLAY_VALUES = "|inline|block|list-item|run-in|compact|marker|table|inline-table|table-row-group|table-header-group|table-footer-group|table-row|table-column-group|table-column|table-cell|table-caption|none|";
    private static final String VALID_VISIBILITY_VALUES = "|visible|hidden|collapse|";

    protected void setSupportedFormats(String[] mimeTypes) {
        this.supportedFormats = new HashSet<String>(mimeTypes.length);
        Collections.addAll(this.supportedFormats, mimeTypes);
    }

    protected SVG parse(InputStream is) throws SVGParseException {
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        try {
            is.mark(3);
            int firstTwoBytes = is.read() + (is.read() << 8);
            is.reset();
            if (firstTwoBytes == 35615) {
                is = new GZIPInputStream(is);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser sp = spf.newSAXParser();
            XMLReader xr = sp.getXMLReader();
            xr.setContentHandler(this);
            xr.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            xr.parse(new InputSource(is));
        }
        catch (IOException e) {
            throw new SVGParseException("File error", e);
        }
        catch (ParserConfigurationException e) {
            throw new SVGParseException("XML Parser problem", e);
        }
        catch (SAXException e) {
            throw new SVGParseException("SVG parse error: " + e.getMessage(), e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Exception thrown closing input stream");
            }
        }
        return this.svgDocument;
    }

    @Override
    public void startDocument() throws SAXException {
        this.svgDocument = new SVG();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.ignoring) {
            ++this.ignoreDepth;
            return;
        }
        if (!SVG_NAMESPACE.equals(uri) && !"".equals(uri)) {
            return;
        }
        SVGElem elem = SVGElem.fromString(localName);
        switch (elem) {
            case svg: {
                this.svg(attributes);
                break;
            }
            case g: 
            case a: {
                this.g(attributes);
                break;
            }
            case defs: {
                this.defs(attributes);
                break;
            }
            case use: {
                this.use(attributes);
                break;
            }
            case path: {
                this.path(attributes);
                break;
            }
            case rect: {
                this.rect(attributes);
                break;
            }
            case circle: {
                this.circle(attributes);
                break;
            }
            case ellipse: {
                this.ellipse(attributes);
                break;
            }
            case line: {
                this.line(attributes);
                break;
            }
            case polyline: {
                this.polyline(attributes);
                break;
            }
            case polygon: {
                this.polygon(attributes);
                break;
            }
            case text: {
                this.text(attributes);
                break;
            }
            case tspan: {
                this.tspan(attributes);
                break;
            }
            case tref: {
                this.tref(attributes);
                break;
            }
            case SWITCH: {
                this.zwitch(attributes);
                break;
            }
            case symbol: {
                this.symbol(attributes);
                break;
            }
            case marker: {
                this.marker(attributes);
                break;
            }
            case linearGradient: {
                this.linearGradient(attributes);
                break;
            }
            case radialGradient: {
                this.radialGradient(attributes);
                break;
            }
            case stop: {
                this.stop(attributes);
                break;
            }
            case title: 
            case desc: {
                this.inMetadataElement = true;
                this.metadataTag = elem;
                break;
            }
            case clipPath: {
                this.clipPath(attributes);
                break;
            }
            case textPath: {
                this.textPath(attributes);
                break;
            }
            case pattern: {
                this.pattern(attributes);
                break;
            }
            case image: {
                this.image(attributes);
                break;
            }
            case view: {
                this.view(attributes);
                break;
            }
            case mask: {
                this.mask(attributes);
                break;
            }
            case style: {
                this.style(attributes);
                break;
            }
            case solidColor: {
                this.solidColor(attributes);
                break;
            }
            default: {
                this.ignoring = true;
                this.ignoreDepth = 1;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.ignoring) {
            return;
        }
        if (this.inMetadataElement) {
            if (this.metadataElementContents == null) {
                this.metadataElementContents = new StringBuilder(length);
            }
            this.metadataElementContents.append(ch, start, length);
            return;
        }
        if (this.inStyleElement) {
            if (this.styleElementContents == null) {
                this.styleElementContents = new StringBuilder(length);
            }
            this.styleElementContents.append(ch, start, length);
            return;
        }
        if (this.currentElement instanceof SVG.TextContainer) {
            SVG.SvgObject previousSibling;
            SVG.SvgConditionalContainer parent = (SVG.SvgConditionalContainer)this.currentElement;
            int numOlderSiblings = parent.children.size();
            SVG.SvgObject svgObject = previousSibling = numOlderSiblings == 0 ? null : parent.children.get(numOlderSiblings - 1);
            if (previousSibling instanceof SVG.TextSequence) {
                ((SVG.TextSequence)previousSibling).text = ((SVG.TextSequence)previousSibling).text + new String(ch, start, length);
            } else {
                ((SVG.SvgConditionalContainer)this.currentElement).addChild(new SVG.TextSequence(new String(ch, start, length)));
            }
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.ignoring) {
            return;
        }
        if (this.inStyleElement) {
            if (this.styleElementContents == null) {
                this.styleElementContents = new StringBuilder(length);
            }
            this.styleElementContents.append(ch, start, length);
            return;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.ignoring && --this.ignoreDepth == 0) {
            this.ignoring = false;
            return;
        }
        if (!SVG_NAMESPACE.equals(uri) && !"".equals(uri)) {
            return;
        }
        switch (SVGElem.fromString(localName)) {
            case title: 
            case desc: {
                this.inMetadataElement = false;
                if (this.metadataTag == SVGElem.title) {
                    this.svgDocument.setTitle(this.metadataElementContents.toString());
                } else if (this.metadataTag == SVGElem.desc) {
                    this.svgDocument.setDesc(this.metadataElementContents.toString());
                }
                this.metadataElementContents.setLength(0);
                return;
            }
            case style: {
                if (this.styleElementContents == null) break;
                this.inStyleElement = false;
                this.parseCSSStyleSheet(this.styleElementContents.toString());
                this.styleElementContents.setLength(0);
                return;
            }
            case svg: 
            case g: 
            case defs: 
            case use: 
            case text: 
            case tspan: 
            case SWITCH: 
            case symbol: 
            case marker: 
            case linearGradient: 
            case radialGradient: 
            case stop: 
            case clipPath: 
            case textPath: 
            case pattern: 
            case image: 
            case view: 
            case mask: 
            case solidColor: {
                this.currentElement = ((SVG.SvgObject)((Object)this.currentElement)).parent;
                break;
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    private void dumpNode(SVG.SvgObject elem, String indent) {
        Log.d((String)TAG, (String)(indent + elem));
        if (elem instanceof SVG.SvgConditionalContainer) {
            indent = indent + "  ";
            for (SVG.SvgObject child : ((SVG.SvgConditionalContainer)elem).children) {
                this.dumpNode(child, indent);
            }
        }
    }

    private void debug(String format, Object ... args) {
    }

    private void svg(Attributes attributes) throws SAXException {
        this.debug("<svg>", new Object[0]);
        SVG.Svg obj = new SVG.Svg();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesViewBox(obj, attributes);
        this.parseAttributesSVG(obj, attributes);
        if (this.currentElement == null) {
            this.svgDocument.setRootElement(obj);
        } else {
            this.currentElement.addChild(obj);
        }
        this.currentElement = obj;
    }

    private void parseAttributesSVG(SVG.Svg obj, Attributes attributes) throws SAXException {
        block7: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x: {
                    obj.x = SVGParser.parseLength(val);
                    continue block7;
                }
                case y: {
                    obj.y = SVGParser.parseLength(val);
                    continue block7;
                }
                case width: {
                    obj.width = SVGParser.parseLength(val);
                    if (!obj.width.isNegative()) continue block7;
                    throw new SAXException("Invalid <svg> element. width cannot be negative");
                }
                case height: {
                    obj.height = SVGParser.parseLength(val);
                    if (!obj.height.isNegative()) continue block7;
                    throw new SAXException("Invalid <svg> element. height cannot be negative");
                }
                case version: {
                    obj.version = val;
                    continue block7;
                }
            }
        }
    }

    private void g(Attributes attributes) throws SAXException {
        this.debug("<g>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Group obj = new SVG.Group();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void defs(Attributes attributes) throws SAXException {
        this.debug("<defs>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Defs obj = new SVG.Defs();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void use(Attributes attributes) throws SAXException {
        this.debug("<use>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Use obj = new SVG.Use();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesUse(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesUse(SVG.Use obj, Attributes attributes) throws SAXException {
        block7: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x: {
                    obj.x = SVGParser.parseLength(val);
                    continue block7;
                }
                case y: {
                    obj.y = SVGParser.parseLength(val);
                    continue block7;
                }
                case width: {
                    obj.width = SVGParser.parseLength(val);
                    if (!obj.width.isNegative()) continue block7;
                    throw new SAXException("Invalid <use> element. width cannot be negative");
                }
                case height: {
                    obj.height = SVGParser.parseLength(val);
                    if (!obj.height.isNegative()) continue block7;
                    throw new SAXException("Invalid <use> element. height cannot be negative");
                }
                case href: {
                    if (!XLINK_NAMESPACE.equals(attributes.getURI(i))) continue block7;
                    obj.href = val;
                    continue block7;
                }
            }
        }
    }

    private void image(Attributes attributes) throws SAXException {
        this.debug("<image>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Image obj = new SVG.Image();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesImage(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesImage(SVG.Image obj, Attributes attributes) throws SAXException {
        block8: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x: {
                    obj.x = SVGParser.parseLength(val);
                    continue block8;
                }
                case y: {
                    obj.y = SVGParser.parseLength(val);
                    continue block8;
                }
                case width: {
                    obj.width = SVGParser.parseLength(val);
                    if (!obj.width.isNegative()) continue block8;
                    throw new SAXException("Invalid <use> element. width cannot be negative");
                }
                case height: {
                    obj.height = SVGParser.parseLength(val);
                    if (!obj.height.isNegative()) continue block8;
                    throw new SAXException("Invalid <use> element. height cannot be negative");
                }
                case href: {
                    if (!XLINK_NAMESPACE.equals(attributes.getURI(i))) continue block8;
                    obj.href = val;
                    continue block8;
                }
                case preserveAspectRatio: {
                    SVGParser.parsePreserveAspectRatio(obj, val);
                    continue block8;
                }
            }
        }
    }

    private void path(Attributes attributes) throws SAXException {
        this.debug("<path>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Path obj = new SVG.Path();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesPath(obj, attributes);
        this.currentElement.addChild(obj);
    }

    private void parseAttributesPath(SVG.Path obj, Attributes attributes) throws SAXException {
        block4: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case d: {
                    obj.d = SVGParser.parsePath(val);
                    continue block4;
                }
                case pathLength: {
                    obj.pathLength = Float.valueOf(SVGParser.parseFloat(val));
                    if (!(obj.pathLength.floatValue() < 0.0f)) continue block4;
                    throw new SAXException("Invalid <path> element. pathLength cannot be negative");
                }
            }
        }
    }

    private void rect(Attributes attributes) throws SAXException {
        this.debug("<rect>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Rect obj = new SVG.Rect();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesRect(obj, attributes);
        this.currentElement.addChild(obj);
    }

    private void parseAttributesRect(SVG.Rect obj, Attributes attributes) throws SAXException {
        block8: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x: {
                    obj.x = SVGParser.parseLength(val);
                    continue block8;
                }
                case y: {
                    obj.y = SVGParser.parseLength(val);
                    continue block8;
                }
                case width: {
                    obj.width = SVGParser.parseLength(val);
                    if (!obj.width.isNegative()) continue block8;
                    throw new SAXException("Invalid <rect> element. width cannot be negative");
                }
                case height: {
                    obj.height = SVGParser.parseLength(val);
                    if (!obj.height.isNegative()) continue block8;
                    throw new SAXException("Invalid <rect> element. height cannot be negative");
                }
                case rx: {
                    obj.rx = SVGParser.parseLength(val);
                    if (!obj.rx.isNegative()) continue block8;
                    throw new SAXException("Invalid <rect> element. rx cannot be negative");
                }
                case ry: {
                    obj.ry = SVGParser.parseLength(val);
                    if (!obj.ry.isNegative()) continue block8;
                    throw new SAXException("Invalid <rect> element. ry cannot be negative");
                }
            }
        }
    }

    private void circle(Attributes attributes) throws SAXException {
        this.debug("<circle>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Circle obj = new SVG.Circle();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesCircle(obj, attributes);
        this.currentElement.addChild(obj);
    }

    private void parseAttributesCircle(SVG.Circle obj, Attributes attributes) throws SAXException {
        block5: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case cx: {
                    obj.cx = SVGParser.parseLength(val);
                    continue block5;
                }
                case cy: {
                    obj.cy = SVGParser.parseLength(val);
                    continue block5;
                }
                case r: {
                    obj.r = SVGParser.parseLength(val);
                    if (!obj.r.isNegative()) continue block5;
                    throw new SAXException("Invalid <circle> element. r cannot be negative");
                }
            }
        }
    }

    private void ellipse(Attributes attributes) throws SAXException {
        this.debug("<ellipse>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Ellipse obj = new SVG.Ellipse();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesEllipse(obj, attributes);
        this.currentElement.addChild(obj);
    }

    private void parseAttributesEllipse(SVG.Ellipse obj, Attributes attributes) throws SAXException {
        block6: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case cx: {
                    obj.cx = SVGParser.parseLength(val);
                    continue block6;
                }
                case cy: {
                    obj.cy = SVGParser.parseLength(val);
                    continue block6;
                }
                case rx: {
                    obj.rx = SVGParser.parseLength(val);
                    if (!obj.rx.isNegative()) continue block6;
                    throw new SAXException("Invalid <ellipse> element. rx cannot be negative");
                }
                case ry: {
                    obj.ry = SVGParser.parseLength(val);
                    if (!obj.ry.isNegative()) continue block6;
                    throw new SAXException("Invalid <ellipse> element. ry cannot be negative");
                }
            }
        }
    }

    private void line(Attributes attributes) throws SAXException {
        this.debug("<line>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Line obj = new SVG.Line();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesLine(obj, attributes);
        this.currentElement.addChild(obj);
    }

    private void parseAttributesLine(SVG.Line obj, Attributes attributes) throws SAXException {
        block6: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x1: {
                    obj.x1 = SVGParser.parseLength(val);
                    continue block6;
                }
                case y1: {
                    obj.y1 = SVGParser.parseLength(val);
                    continue block6;
                }
                case x2: {
                    obj.x2 = SVGParser.parseLength(val);
                    continue block6;
                }
                case y2: {
                    obj.y2 = SVGParser.parseLength(val);
                    continue block6;
                }
            }
        }
    }

    private void polyline(Attributes attributes) throws SAXException {
        this.debug("<polyline>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.PolyLine obj = new SVG.PolyLine();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesPolyLine(obj, attributes, "polyline");
        this.currentElement.addChild(obj);
    }

    private void parseAttributesPolyLine(SVG.PolyLine obj, Attributes attributes, String tag) throws SAXException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (SVGAttr.fromString(attributes.getLocalName(i)) != SVGAttr.points) continue;
            TextScanner scan = new TextScanner(attributes.getValue(i));
            ArrayList<Float> points = new ArrayList<Float>();
            scan.skipWhitespace();
            while (!scan.empty()) {
                float x = scan.nextFloat();
                if (Float.isNaN(x)) {
                    throw new SAXException("Invalid <" + tag + "> points attribute. Non-coordinate content found in list.");
                }
                scan.skipCommaWhitespace();
                float y = scan.nextFloat();
                if (Float.isNaN(y)) {
                    throw new SAXException("Invalid <" + tag + "> points attribute. There should be an even number of coordinates.");
                }
                scan.skipCommaWhitespace();
                points.add(Float.valueOf(x));
                points.add(Float.valueOf(y));
            }
            obj.points = new float[points.size()];
            int j = 0;
            Iterator iterator = points.iterator();
            while (iterator.hasNext()) {
                float f = ((Float)iterator.next()).floatValue();
                obj.points[j++] = f;
            }
        }
    }

    private void polygon(Attributes attributes) throws SAXException {
        this.debug("<polygon>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Polygon obj = new SVG.Polygon();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesPolyLine(obj, attributes, "polygon");
        this.currentElement.addChild(obj);
    }

    private void text(Attributes attributes) throws SAXException {
        this.debug("<text>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Text obj = new SVG.Text();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesTextPosition(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesTextPosition(SVG.TextPositionedContainer obj, Attributes attributes) throws SAXException {
        block6: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x: {
                    obj.x = SVGParser.parseLengthList(val);
                    continue block6;
                }
                case y: {
                    obj.y = SVGParser.parseLengthList(val);
                    continue block6;
                }
                case dx: {
                    obj.dx = SVGParser.parseLengthList(val);
                    continue block6;
                }
                case dy: {
                    obj.dy = SVGParser.parseLengthList(val);
                    continue block6;
                }
            }
        }
    }

    private void tspan(Attributes attributes) throws SAXException {
        this.debug("<tspan>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        if (!(this.currentElement instanceof SVG.TextContainer)) {
            throw new SAXException("Invalid document. <tspan> elements are only valid inside <text> or other <tspan> elements.");
        }
        SVG.TSpan obj = new SVG.TSpan();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesTextPosition(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
        if (obj.parent instanceof SVG.TextRoot) {
            obj.setTextRoot((SVG.TextRoot)((Object)obj.parent));
        } else {
            obj.setTextRoot(((SVG.TextChild)((Object)obj.parent)).getTextRoot());
        }
    }

    private void tref(Attributes attributes) throws SAXException {
        this.debug("<tref>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        if (!(this.currentElement instanceof SVG.TextContainer)) {
            throw new SAXException("Invalid document. <tref> elements are only valid inside <text> or <tspan> elements.");
        }
        SVG.TRef obj = new SVG.TRef();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesTRef(obj, attributes);
        this.currentElement.addChild(obj);
        if (obj.parent instanceof SVG.TextRoot) {
            obj.setTextRoot((SVG.TextRoot)((Object)obj.parent));
        } else {
            obj.setTextRoot(((SVG.TextChild)((Object)obj.parent)).getTextRoot());
        }
    }

    private void parseAttributesTRef(SVG.TRef obj, Attributes attributes) throws SAXException {
        block3: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case href: {
                    if (!XLINK_NAMESPACE.equals(attributes.getURI(i))) continue block3;
                    obj.href = val;
                    continue block3;
                }
            }
        }
    }

    private void zwitch(Attributes attributes) throws SAXException {
        this.debug("<switch>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Switch obj = new SVG.Switch();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesConditional(SVG.SvgConditional obj, Attributes attributes) throws SAXException {
        block7: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case requiredFeatures: {
                    obj.setRequiredFeatures(SVGParser.parseRequiredFeatures(val));
                    continue block7;
                }
                case requiredExtensions: {
                    obj.setRequiredExtensions(val);
                    continue block7;
                }
                case systemLanguage: {
                    obj.setSystemLanguage(SVGParser.parseSystemLanguage(val));
                    continue block7;
                }
                case requiredFormats: {
                    obj.setRequiredFormats(SVGParser.parseRequiredFormats(val));
                    continue block7;
                }
                case requiredFonts: {
                    List<String> fonts = SVGParser.parseFontFamily(val);
                    HashSet<String> fontSet = fonts != null ? new HashSet<String>(fonts) : new HashSet(0);
                    obj.setRequiredFonts(fontSet);
                    continue block7;
                }
            }
        }
    }

    private void symbol(Attributes attributes) throws SAXException {
        this.debug("<symbol>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Symbol obj = new SVG.Symbol();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesViewBox(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void marker(Attributes attributes) throws SAXException {
        this.debug("<marker>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Marker obj = new SVG.Marker();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesViewBox(obj, attributes);
        this.parseAttributesMarker(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesMarker(SVG.Marker obj, Attributes attributes) throws SAXException {
        block8: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case refX: {
                    obj.refX = SVGParser.parseLength(val);
                    continue block8;
                }
                case refY: {
                    obj.refY = SVGParser.parseLength(val);
                    continue block8;
                }
                case markerWidth: {
                    obj.markerWidth = SVGParser.parseLength(val);
                    if (!obj.markerWidth.isNegative()) continue block8;
                    throw new SAXException("Invalid <marker> element. markerWidth cannot be negative");
                }
                case markerHeight: {
                    obj.markerHeight = SVGParser.parseLength(val);
                    if (!obj.markerHeight.isNegative()) continue block8;
                    throw new SAXException("Invalid <marker> element. markerHeight cannot be negative");
                }
                case markerUnits: {
                    if ("strokeWidth".equals(val)) {
                        obj.markerUnitsAreUser = false;
                        continue block8;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.markerUnitsAreUser = true;
                        continue block8;
                    }
                    throw new SAXException("Invalid value for attribute markerUnits");
                }
                case orient: {
                    if ("auto".equals(val)) {
                        obj.orient = Float.valueOf(Float.NaN);
                        continue block8;
                    }
                    obj.orient = Float.valueOf(SVGParser.parseFloat(val));
                    continue block8;
                }
            }
        }
    }

    private void linearGradient(Attributes attributes) throws SAXException {
        this.debug("<linearGradiant>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.SvgLinearGradient obj = new SVG.SvgLinearGradient();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesGradient(obj, attributes);
        this.parseAttributesLinearGradient(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesGradient(SVG.GradientElement obj, Attributes attributes) throws SAXException {
        block8: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case gradientUnits: {
                    if ("objectBoundingBox".equals(val)) {
                        obj.gradientUnitsAreUser = false;
                        continue block8;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.gradientUnitsAreUser = true;
                        continue block8;
                    }
                    throw new SAXException("Invalid value for attribute gradientUnits");
                }
                case gradientTransform: {
                    obj.gradientTransform = this.parseTransformList(val);
                    continue block8;
                }
                case spreadMethod: {
                    try {
                        obj.spreadMethod = SVG.GradientSpread.valueOf(val);
                        continue block8;
                    }
                    catch (IllegalArgumentException e) {
                        throw new SAXException("Invalid spreadMethod attribute. \"" + val + "\" is not a valid value.");
                    }
                }
                case href: {
                    if (!XLINK_NAMESPACE.equals(attributes.getURI(i))) continue block8;
                    obj.href = val;
                    continue block8;
                }
            }
        }
    }

    private void parseAttributesLinearGradient(SVG.SvgLinearGradient obj, Attributes attributes) throws SAXException {
        block6: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case x1: {
                    obj.x1 = SVGParser.parseLength(val);
                    continue block6;
                }
                case y1: {
                    obj.y1 = SVGParser.parseLength(val);
                    continue block6;
                }
                case x2: {
                    obj.x2 = SVGParser.parseLength(val);
                    continue block6;
                }
                case y2: {
                    obj.y2 = SVGParser.parseLength(val);
                    continue block6;
                }
            }
        }
    }

    private void radialGradient(Attributes attributes) throws SAXException {
        this.debug("<radialGradient>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.SvgRadialGradient obj = new SVG.SvgRadialGradient();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesGradient(obj, attributes);
        this.parseAttributesRadialGradient(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesRadialGradient(SVG.SvgRadialGradient obj, Attributes attributes) throws SAXException {
        block7: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case cx: {
                    obj.cx = SVGParser.parseLength(val);
                    continue block7;
                }
                case cy: {
                    obj.cy = SVGParser.parseLength(val);
                    continue block7;
                }
                case r: {
                    obj.r = SVGParser.parseLength(val);
                    if (!obj.r.isNegative()) continue block7;
                    throw new SAXException("Invalid <radialGradient> element. r cannot be negative");
                }
                case fx: {
                    obj.fx = SVGParser.parseLength(val);
                    continue block7;
                }
                case fy: {
                    obj.fy = SVGParser.parseLength(val);
                    continue block7;
                }
            }
        }
    }

    private void stop(Attributes attributes) throws SAXException {
        this.debug("<stop>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        if (!(this.currentElement instanceof SVG.GradientElement)) {
            throw new SAXException("Invalid document. <stop> elements are only valid inside <linearGradiant> or <radialGradient> elements.");
        }
        SVG.Stop obj = new SVG.Stop();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesStop(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesStop(SVG.Stop obj, Attributes attributes) throws SAXException {
        block3: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case offset: {
                    obj.offset = this.parseGradiantOffset(val);
                    continue block3;
                }
            }
        }
    }

    private Float parseGradiantOffset(String val) throws SAXException {
        if (val.length() == 0) {
            throw new SAXException("Invalid offset value in <stop> (empty string)");
        }
        int end = val.length();
        boolean isPercent = false;
        if (val.charAt(val.length() - 1) == '%') {
            --end;
            isPercent = true;
        }
        try {
            float scalar = SVGParser.parseFloat(val, 0, end);
            if (isPercent) {
                scalar /= 100.0f;
            }
            return Float.valueOf(scalar < 0.0f ? 0.0f : (scalar > 100.0f ? 100.0f : scalar));
        }
        catch (NumberFormatException e) {
            throw new SAXException("Invalid offset value in <stop>: " + val, e);
        }
    }

    private void solidColor(Attributes attributes) throws SAXException {
        this.debug("<solidColor>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.SolidColor obj = new SVG.SolidColor();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void clipPath(Attributes attributes) throws SAXException {
        this.debug("<clipPath>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.ClipPath obj = new SVG.ClipPath();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesTransform(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesClipPath(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesClipPath(SVG.ClipPath obj, Attributes attributes) throws SAXException {
        block3: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case clipPathUnits: {
                    if ("objectBoundingBox".equals(val)) {
                        obj.clipPathUnitsAreUser = false;
                        continue block3;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.clipPathUnitsAreUser = true;
                        continue block3;
                    }
                    throw new SAXException("Invalid value for attribute clipPathUnits");
                }
            }
        }
    }

    private void textPath(Attributes attributes) throws SAXException {
        this.debug("<textPath>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.TextPath obj = new SVG.TextPath();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesTextPath(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
        if (obj.parent instanceof SVG.TextRoot) {
            obj.setTextRoot((SVG.TextRoot)((Object)obj.parent));
        } else {
            obj.setTextRoot(((SVG.TextChild)((Object)obj.parent)).getTextRoot());
        }
    }

    private void parseAttributesTextPath(SVG.TextPath obj, Attributes attributes) throws SAXException {
        block4: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case href: {
                    if (!XLINK_NAMESPACE.equals(attributes.getURI(i))) continue block4;
                    obj.href = val;
                    continue block4;
                }
                case startOffset: {
                    obj.startOffset = SVGParser.parseLength(val);
                    continue block4;
                }
            }
        }
    }

    private void pattern(Attributes attributes) throws SAXException {
        this.debug("<pattern>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Pattern obj = new SVG.Pattern();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesViewBox(obj, attributes);
        this.parseAttributesPattern(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesPattern(SVG.Pattern obj, Attributes attributes) throws SAXException {
        block10: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case patternUnits: {
                    if ("objectBoundingBox".equals(val)) {
                        obj.patternUnitsAreUser = false;
                        continue block10;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.patternUnitsAreUser = true;
                        continue block10;
                    }
                    throw new SAXException("Invalid value for attribute patternUnits");
                }
                case patternContentUnits: {
                    if ("objectBoundingBox".equals(val)) {
                        obj.patternContentUnitsAreUser = false;
                        continue block10;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.patternContentUnitsAreUser = true;
                        continue block10;
                    }
                    throw new SAXException("Invalid value for attribute patternContentUnits");
                }
                case patternTransform: {
                    obj.patternTransform = this.parseTransformList(val);
                    continue block10;
                }
                case x: {
                    obj.x = SVGParser.parseLength(val);
                    continue block10;
                }
                case y: {
                    obj.y = SVGParser.parseLength(val);
                    continue block10;
                }
                case width: {
                    obj.width = SVGParser.parseLength(val);
                    if (!obj.width.isNegative()) continue block10;
                    throw new SAXException("Invalid <pattern> element. width cannot be negative");
                }
                case height: {
                    obj.height = SVGParser.parseLength(val);
                    if (!obj.height.isNegative()) continue block10;
                    throw new SAXException("Invalid <pattern> element. height cannot be negative");
                }
                case href: {
                    if (!XLINK_NAMESPACE.equals(attributes.getURI(i))) continue block10;
                    obj.href = val;
                    continue block10;
                }
            }
        }
    }

    private void view(Attributes attributes) throws SAXException {
        this.debug("<view>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.View obj = new SVG.View();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesViewBox(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void mask(Attributes attributes) throws SAXException {
        this.debug("<mask>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        SVG.Mask obj = new SVG.Mask();
        obj.document = this.svgDocument;
        obj.parent = this.currentElement;
        this.parseAttributesCore(obj, attributes);
        this.parseAttributesStyle(obj, attributes);
        this.parseAttributesConditional(obj, attributes);
        this.parseAttributesMask(obj, attributes);
        this.currentElement.addChild(obj);
        this.currentElement = obj;
    }

    private void parseAttributesMask(SVG.Mask obj, Attributes attributes) throws SAXException {
        block8: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case maskUnits: {
                    if ("objectBoundingBox".equals(val)) {
                        obj.maskUnitsAreUser = false;
                        continue block8;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.maskUnitsAreUser = true;
                        continue block8;
                    }
                    throw new SAXException("Invalid value for attribute maskUnits");
                }
                case maskContentUnits: {
                    if ("objectBoundingBox".equals(val)) {
                        obj.maskContentUnitsAreUser = false;
                        continue block8;
                    }
                    if ("userSpaceOnUse".equals(val)) {
                        obj.maskContentUnitsAreUser = true;
                        continue block8;
                    }
                    throw new SAXException("Invalid value for attribute maskContentUnits");
                }
                case x: {
                    obj.x = SVGParser.parseLength(val);
                    continue block8;
                }
                case y: {
                    obj.y = SVGParser.parseLength(val);
                    continue block8;
                }
                case width: {
                    obj.width = SVGParser.parseLength(val);
                    if (!obj.width.isNegative()) continue block8;
                    throw new SAXException("Invalid <mask> element. width cannot be negative");
                }
                case height: {
                    obj.height = SVGParser.parseLength(val);
                    if (!obj.height.isNegative()) continue block8;
                    throw new SAXException("Invalid <mask> element. height cannot be negative");
                }
            }
        }
    }

    private void parseAttributesCore(SVG.SvgElementBase obj, Attributes attributes) throws SAXException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String qname = attributes.getQName(i);
            if (qname.equals("id") || qname.equals("xml:id")) {
                obj.id = attributes.getValue(i).trim();
                break;
            }
            if (!qname.equals("xml:space")) continue;
            String val = attributes.getValue(i).trim();
            if ("default".equals(val)) {
                obj.spacePreserve = Boolean.FALSE;
                break;
            }
            if ("preserve".equals(val)) {
                obj.spacePreserve = Boolean.TRUE;
                break;
            }
            throw new SAXException("Invalid value for \"xml:space\" attribute: " + val);
        }
    }

    private void parseAttributesStyle(SVG.SvgElementBase obj, Attributes attributes) throws SAXException {
        block4: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            if (val.length() == 0) continue;
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case style: {
                    SVGParser.parseStyle(obj, val);
                    continue block4;
                }
                case CLASS: {
                    obj.classNames = CSSParser.parseClassAttribute(val);
                    continue block4;
                }
                default: {
                    if (obj.baseStyle == null) {
                        obj.baseStyle = new SVG.Style();
                    }
                    SVGParser.processStyleProperty(obj.baseStyle, attributes.getLocalName(i), attributes.getValue(i).trim());
                }
            }
        }
    }

    private static void parseStyle(SVG.SvgElementBase obj, String style2) throws SAXException {
        TextScanner scan = new TextScanner(style2.replaceAll("/\\*.*?\\*/", ""));
        while (true) {
            String propertyName = scan.nextToken(':');
            scan.skipWhitespace();
            if (!scan.consume(':')) break;
            scan.skipWhitespace();
            String propertyValue = scan.nextToken(';');
            if (propertyValue == null) break;
            scan.skipWhitespace();
            if (!scan.empty() && !scan.consume(';')) continue;
            if (obj.style == null) {
                obj.style = new SVG.Style();
            }
            SVGParser.processStyleProperty(obj.style, propertyName, propertyValue);
            scan.skipWhitespace();
        }
    }

    protected static void processStyleProperty(SVG.Style style2, String localName, String val) throws SAXException {
        if (val.length() == 0) {
            return;
        }
        if (val.equals("inherit")) {
            return;
        }
        switch (SVGAttr.fromString(localName)) {
            case fill: {
                style2.fill = SVGParser.parsePaintSpecifier(val, "fill");
                style2.specifiedFlags |= 1L;
                break;
            }
            case fill_rule: {
                style2.fillRule = SVGParser.parseFillRule(val);
                style2.specifiedFlags |= 2L;
                break;
            }
            case fill_opacity: {
                style2.fillOpacity = Float.valueOf(SVGParser.parseOpacity(val));
                style2.specifiedFlags |= 4L;
                break;
            }
            case stroke: {
                style2.stroke = SVGParser.parsePaintSpecifier(val, "stroke");
                style2.specifiedFlags |= 8L;
                break;
            }
            case stroke_opacity: {
                style2.strokeOpacity = Float.valueOf(SVGParser.parseOpacity(val));
                style2.specifiedFlags |= 0x10L;
                break;
            }
            case stroke_width: {
                style2.strokeWidth = SVGParser.parseLength(val);
                style2.specifiedFlags |= 0x20L;
                break;
            }
            case stroke_linecap: {
                style2.strokeLineCap = SVGParser.parseStrokeLineCap(val);
                style2.specifiedFlags |= 0x40L;
                break;
            }
            case stroke_linejoin: {
                style2.strokeLineJoin = SVGParser.parseStrokeLineJoin(val);
                style2.specifiedFlags |= 0x80L;
                break;
            }
            case stroke_miterlimit: {
                style2.strokeMiterLimit = Float.valueOf(SVGParser.parseFloat(val));
                style2.specifiedFlags |= 0x100L;
                break;
            }
            case stroke_dasharray: {
                style2.strokeDashArray = NONE.equals(val) ? null : SVGParser.parseStrokeDashArray(val);
                style2.specifiedFlags |= 0x200L;
                break;
            }
            case stroke_dashoffset: {
                style2.strokeDashOffset = SVGParser.parseLength(val);
                style2.specifiedFlags |= 0x400L;
                break;
            }
            case opacity: {
                style2.opacity = Float.valueOf(SVGParser.parseOpacity(val));
                style2.specifiedFlags |= 0x800L;
                break;
            }
            case color: {
                style2.color = SVGParser.parseColour(val);
                style2.specifiedFlags |= 0x1000L;
                break;
            }
            case font: {
                SVGParser.parseFont(style2, val);
                break;
            }
            case font_family: {
                style2.fontFamily = SVGParser.parseFontFamily(val);
                style2.specifiedFlags |= 0x2000L;
                break;
            }
            case font_size: {
                style2.fontSize = SVGParser.parseFontSize(val);
                style2.specifiedFlags |= 0x4000L;
                break;
            }
            case font_weight: {
                style2.fontWeight = SVGParser.parseFontWeight(val);
                style2.specifiedFlags |= 0x8000L;
                break;
            }
            case font_style: {
                style2.fontStyle = SVGParser.parseFontStyle(val);
                style2.specifiedFlags |= 0x10000L;
                break;
            }
            case text_decoration: {
                style2.textDecoration = SVGParser.parseTextDecoration(val);
                style2.specifiedFlags |= 0x20000L;
                break;
            }
            case direction: {
                style2.direction = SVGParser.parseTextDirection(val);
                style2.specifiedFlags |= 0x1000000000L;
                break;
            }
            case text_anchor: {
                style2.textAnchor = SVGParser.parseTextAnchor(val);
                style2.specifiedFlags |= 0x40000L;
                break;
            }
            case overflow: {
                style2.overflow = SVGParser.parseOverflow(val);
                style2.specifiedFlags |= 0x80000L;
                break;
            }
            case marker: {
                style2.markerMid = style2.markerStart = SVGParser.parseFunctionalIRI(val, localName);
                style2.markerEnd = style2.markerStart;
                style2.specifiedFlags |= 0xE00000L;
                break;
            }
            case marker_start: {
                style2.markerStart = SVGParser.parseFunctionalIRI(val, localName);
                style2.specifiedFlags |= 0x200000L;
                break;
            }
            case marker_mid: {
                style2.markerMid = SVGParser.parseFunctionalIRI(val, localName);
                style2.specifiedFlags |= 0x400000L;
                break;
            }
            case marker_end: {
                style2.markerEnd = SVGParser.parseFunctionalIRI(val, localName);
                style2.specifiedFlags |= 0x800000L;
                break;
            }
            case display: {
                if (val.indexOf(124) >= 0 || VALID_DISPLAY_VALUES.indexOf('|' + val + '|') == -1) {
                    throw new SAXException("Invalid value for \"display\" attribute: " + val);
                }
                style2.display = !val.equals(NONE);
                style2.specifiedFlags |= 0x1000000L;
                break;
            }
            case visibility: {
                if (val.indexOf(124) >= 0 || VALID_VISIBILITY_VALUES.indexOf('|' + val + '|') == -1) {
                    throw new SAXException("Invalid value for \"visibility\" attribute: " + val);
                }
                style2.visibility = val.equals("visible");
                style2.specifiedFlags |= 0x2000000L;
                break;
            }
            case stop_color: {
                style2.stopColor = val.equals(CURRENTCOLOR) ? SVG.CurrentColor.getInstance() : SVGParser.parseColour(val);
                style2.specifiedFlags |= 0x4000000L;
                break;
            }
            case stop_opacity: {
                style2.stopOpacity = Float.valueOf(SVGParser.parseOpacity(val));
                style2.specifiedFlags |= 0x8000000L;
                break;
            }
            case clip: {
                style2.clip = SVGParser.parseClip(val);
                style2.specifiedFlags |= 0x100000L;
                break;
            }
            case clip_path: {
                style2.clipPath = SVGParser.parseFunctionalIRI(val, localName);
                style2.specifiedFlags |= 0x10000000L;
                break;
            }
            case clip_rule: {
                style2.clipRule = SVGParser.parseFillRule(val);
                style2.specifiedFlags |= 0x20000000L;
                break;
            }
            case mask: {
                style2.mask = SVGParser.parseFunctionalIRI(val, localName);
                style2.specifiedFlags |= 0x40000000L;
                break;
            }
            case solid_color: {
                style2.solidColor = val.equals(CURRENTCOLOR) ? SVG.CurrentColor.getInstance() : SVGParser.parseColour(val);
                style2.specifiedFlags |= 0x80000000L;
                break;
            }
            case solid_opacity: {
                style2.solidOpacity = Float.valueOf(SVGParser.parseOpacity(val));
                style2.specifiedFlags |= 0x100000000L;
                break;
            }
            case viewport_fill: {
                style2.viewportFill = val.equals(CURRENTCOLOR) ? SVG.CurrentColor.getInstance() : SVGParser.parseColour(val);
                style2.specifiedFlags |= 0x200000000L;
                break;
            }
            case viewport_fill_opacity: {
                style2.viewportFillOpacity = Float.valueOf(SVGParser.parseOpacity(val));
                style2.specifiedFlags |= 0x400000000L;
                break;
            }
            case vector_effect: {
                style2.vectorEffect = SVGParser.parseVectorEffect(val);
                style2.specifiedFlags |= 0x800000000L;
                break;
            }
        }
    }

    private void parseAttributesViewBox(SVG.SvgViewBoxContainer obj, Attributes attributes) throws SAXException {
        block4: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case viewBox: {
                    obj.viewBox = SVGParser.parseViewBox(val);
                    continue block4;
                }
                case preserveAspectRatio: {
                    SVGParser.parsePreserveAspectRatio(obj, val);
                    continue block4;
                }
            }
        }
    }

    private void parseAttributesTransform(SVG.HasTransform obj, Attributes attributes) throws SAXException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (SVGAttr.fromString(attributes.getLocalName(i)) != SVGAttr.transform) continue;
            obj.setTransform(this.parseTransformList(attributes.getValue(i)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Matrix parseTransformList(String val) throws SAXException {
        Matrix matrix = new Matrix();
        TextScanner scan = new TextScanner(val);
        scan.skipWhitespace();
        while (!scan.empty()) {
            float ang;
            String cmd = scan.nextFunction();
            if (cmd == null) {
                throw new SAXException("Bad transform function encountered in transform list: " + val);
            }
            if (cmd.equals("matrix")) {
                scan.skipWhitespace();
                float a = scan.nextFloat();
                scan.skipCommaWhitespace();
                float b = scan.nextFloat();
                scan.skipCommaWhitespace();
                float c = scan.nextFloat();
                scan.skipCommaWhitespace();
                float d = scan.nextFloat();
                scan.skipCommaWhitespace();
                float e = scan.nextFloat();
                scan.skipCommaWhitespace();
                float f = scan.nextFloat();
                scan.skipWhitespace();
                if (Float.isNaN(f) || !scan.consume(')')) {
                    throw new SAXException("Invalid transform list: " + val);
                }
                Matrix m = new Matrix();
                m.setValues(new float[]{a, c, e, b, d, f, 0.0f, 0.0f, 1.0f});
                matrix.preConcat(m);
            } else if (cmd.equals("translate")) {
                scan.skipWhitespace();
                float tx = scan.nextFloat();
                float ty = scan.possibleNextFloat();
                scan.skipWhitespace();
                if (Float.isNaN(tx) || !scan.consume(')')) {
                    throw new SAXException("Invalid transform list: " + val);
                }
                if (Float.isNaN(ty)) {
                    matrix.preTranslate(tx, 0.0f);
                } else {
                    matrix.preTranslate(tx, ty);
                }
            } else if (cmd.equals("scale")) {
                scan.skipWhitespace();
                float sx = scan.nextFloat();
                float sy = scan.possibleNextFloat();
                scan.skipWhitespace();
                if (Float.isNaN(sx) || !scan.consume(')')) {
                    throw new SAXException("Invalid transform list: " + val);
                }
                if (Float.isNaN(sy)) {
                    matrix.preScale(sx, sx);
                } else {
                    matrix.preScale(sx, sy);
                }
            } else if (cmd.equals("rotate")) {
                scan.skipWhitespace();
                ang = scan.nextFloat();
                float cx = scan.possibleNextFloat();
                float cy = scan.possibleNextFloat();
                scan.skipWhitespace();
                if (Float.isNaN(ang) || !scan.consume(')')) {
                    throw new SAXException("Invalid transform list: " + val);
                }
                if (Float.isNaN(cx)) {
                    matrix.preRotate(ang);
                } else {
                    if (Float.isNaN(cy)) throw new SAXException("Invalid transform list: " + val);
                    matrix.preRotate(ang, cx, cy);
                }
            } else if (cmd.equals("skewX")) {
                scan.skipWhitespace();
                ang = scan.nextFloat();
                scan.skipWhitespace();
                if (Float.isNaN(ang) || !scan.consume(')')) {
                    throw new SAXException("Invalid transform list: " + val);
                }
                matrix.preSkew((float)Math.tan(Math.toRadians(ang)), 0.0f);
            } else if (cmd.equals("skewY")) {
                scan.skipWhitespace();
                ang = scan.nextFloat();
                scan.skipWhitespace();
                if (Float.isNaN(ang) || !scan.consume(')')) {
                    throw new SAXException("Invalid transform list: " + val);
                }
                matrix.preSkew(0.0f, (float)Math.tan(Math.toRadians(ang)));
            } else if (cmd != null) {
                throw new SAXException("Invalid transform list fn: " + cmd + ")");
            }
            if (scan.empty()) return matrix;
            scan.skipCommaWhitespace();
        }
        return matrix;
    }

    protected static SVG.Length parseLength(String val) throws SAXException {
        if (val.length() == 0) {
            throw new SAXException("Invalid length value (empty string)");
        }
        int end = val.length();
        SVG.Unit unit = SVG.Unit.px;
        char lastChar = val.charAt(end - 1);
        if (lastChar == '%') {
            --end;
            unit = SVG.Unit.percent;
        } else if (end > 2 && Character.isLetter(lastChar) && Character.isLetter(val.charAt(end - 2))) {
            String unitStr = val.substring(end -= 2);
            try {
                unit = SVG.Unit.valueOf(unitStr.toLowerCase(Locale.US));
            }
            catch (IllegalArgumentException e) {
                throw new SAXException("Invalid length unit specifier: " + val);
            }
        }
        try {
            float scalar = SVGParser.parseFloat(val, 0, end);
            return new SVG.Length(scalar, unit);
        }
        catch (NumberFormatException e) {
            throw new SAXException("Invalid length value: " + val, e);
        }
    }

    private static List<SVG.Length> parseLengthList(String val) throws SAXException {
        if (val.length() == 0) {
            throw new SAXException("Invalid length list (empty string)");
        }
        ArrayList<SVG.Length> coords = new ArrayList<SVG.Length>(1);
        TextScanner scan = new TextScanner(val);
        scan.skipWhitespace();
        while (!scan.empty()) {
            float scalar = scan.nextFloat();
            if (Float.isNaN(scalar)) {
                throw new SAXException("Invalid length list value: " + scan.ahead());
            }
            SVG.Unit unit = scan.nextUnit();
            if (unit == null) {
                unit = SVG.Unit.px;
            }
            coords.add(new SVG.Length(scalar, unit));
            scan.skipCommaWhitespace();
        }
        return coords;
    }

    private static float parseFloat(String val) throws SAXException {
        int len = val.length();
        if (len == 0) {
            throw new SAXException("Invalid float value (empty string)");
        }
        return SVGParser.parseFloat(val, 0, len);
    }

    private static float parseFloat(String val, int offset, int len) throws SAXException {
        NumberParser np = new NumberParser();
        float num = np.parseNumber(val, offset, len);
        if (!Float.isNaN(num)) {
            return num;
        }
        throw new SAXException("Invalid float value: " + val);
    }

    private static float parseOpacity(String val) throws SAXException {
        float o = SVGParser.parseFloat(val);
        return o < 0.0f ? 0.0f : (o > 1.0f ? 1.0f : o);
    }

    private static SVG.Box parseViewBox(String val) throws SAXException {
        TextScanner scan = new TextScanner(val);
        scan.skipWhitespace();
        float minX = scan.nextFloat();
        scan.skipCommaWhitespace();
        float minY = scan.nextFloat();
        scan.skipCommaWhitespace();
        float width = scan.nextFloat();
        scan.skipCommaWhitespace();
        float height = scan.nextFloat();
        if (Float.isNaN(minX) || Float.isNaN(minY) || Float.isNaN(width) || Float.isNaN(height)) {
            throw new SAXException("Invalid viewBox definition - should have four numbers");
        }
        if (width < 0.0f) {
            throw new SAXException("Invalid viewBox. width cannot be negative");
        }
        if (height < 0.0f) {
            throw new SAXException("Invalid viewBox. height cannot be negative");
        }
        return new SVG.Box(minX, minY, width, height);
    }

    private static void parsePreserveAspectRatio(SVG.SvgPreserveAspectRatioContainer obj, String val) throws SAXException {
        TextScanner scan = new TextScanner(val);
        scan.skipWhitespace();
        PreserveAspectRatio.Alignment align = null;
        PreserveAspectRatio.Scale scale = null;
        String word = scan.nextToken();
        if ("defer".equals(word)) {
            scan.skipWhitespace();
            word = scan.nextToken();
        }
        align = AspectRatioKeywords.get(word);
        scan.skipWhitespace();
        if (!scan.empty()) {
            String meetOrSlice = scan.nextToken();
            if (meetOrSlice.equals("meet")) {
                scale = PreserveAspectRatio.Scale.Meet;
            } else if (meetOrSlice.equals("slice")) {
                scale = PreserveAspectRatio.Scale.Slice;
            } else {
                throw new SAXException("Invalid preserveAspectRatio definition: " + val);
            }
        }
        obj.preserveAspectRatio = new PreserveAspectRatio(align, scale);
    }

    private static SVG.SvgPaint parsePaintSpecifier(String val, String attrName) throws SAXException {
        if (val.startsWith("url(")) {
            int closeBracket = val.indexOf(")");
            if (closeBracket == -1) {
                throw new SAXException("Bad " + attrName + " attribute. Unterminated url() reference");
            }
            String href = val.substring(4, closeBracket).trim();
            SVG.SvgPaint fallback = null;
            if ((val = val.substring(closeBracket + 1).trim()).length() > 0) {
                fallback = SVGParser.parseColourSpecifer(val);
            }
            return new SVG.PaintReference(href, fallback);
        }
        return SVGParser.parseColourSpecifer(val);
    }

    private static SVG.SvgPaint parseColourSpecifer(String val) throws SAXException {
        if (val.equals(NONE)) {
            return null;
        }
        if (val.equals(CURRENTCOLOR)) {
            return SVG.CurrentColor.getInstance();
        }
        return SVGParser.parseColour(val);
    }

    private static SVG.Colour parseColour(String val) throws SAXException {
        if (val.charAt(0) == '#') {
            IntegerParser ip = IntegerParser.parseHex(val, 1, val.length());
            if (ip == null) {
                throw new SAXException("Bad hex colour value: " + val);
            }
            int pos = ip.getEndPos();
            if (pos == 7) {
                return new SVG.Colour(ip.value());
            }
            if (pos == 4) {
                int threehex = ip.value();
                int h1 = threehex & 0xF00;
                int h2 = threehex & 0xF0;
                int h3 = threehex & 0xF;
                return new SVG.Colour(h1 << 16 | h1 << 12 | h2 << 8 | h2 << 4 | h3 << 4 | h3);
            }
            throw new SAXException("Bad hex colour value: " + val);
        }
        if (val.toLowerCase(Locale.US).startsWith("rgb(")) {
            float blue;
            float green;
            TextScanner scan = new TextScanner(val.substring(4));
            scan.skipWhitespace();
            float red = scan.nextFloat();
            if (!Float.isNaN(red) && scan.consume('%')) {
                red = red * 256.0f / 100.0f;
            }
            if (!Float.isNaN(green = scan.checkedNextFloat(red)) && scan.consume('%')) {
                green = green * 256.0f / 100.0f;
            }
            if (!Float.isNaN(blue = scan.checkedNextFloat(green)) && scan.consume('%')) {
                blue = blue * 256.0f / 100.0f;
            }
            scan.skipWhitespace();
            if (Float.isNaN(blue) || !scan.consume(')')) {
                throw new SAXException("Bad rgb() colour value: " + val);
            }
            return new SVG.Colour(SVGParser.clamp255(red) << 16 | SVGParser.clamp255(green) << 8 | SVGParser.clamp255(blue));
        }
        return SVGParser.parseColourKeyword(val);
    }

    private static int clamp255(float val) {
        return val < 0.0f ? 0 : (val > 255.0f ? 255 : Math.round(val));
    }

    private static SVG.Colour parseColourKeyword(String name) throws SAXException {
        Integer col = ColourKeywords.get(name.toLowerCase(Locale.US));
        if (col == null) {
            throw new SAXException("Invalid colour keyword: " + name);
        }
        return new SVG.Colour(col);
    }

    private static void parseFont(SVG.Style style2, String val) throws SAXException {
        List<String> fontFamily = null;
        SVG.Length fontSize = null;
        Integer fontWeight = null;
        SVG.Style.FontStyle fontStyle = null;
        String fontVariant = null;
        if ("|caption|icon|menu|message-box|small-caption|status-bar|".indexOf('|' + val + '|') != -1) {
            return;
        }
        TextScanner scan = new TextScanner(val);
        String item = null;
        while (true) {
            item = scan.nextToken('/');
            scan.skipWhitespace();
            if (item == null) {
                throw new SAXException("Invalid font style attribute: missing font size and family");
            }
            if (fontWeight != null && fontStyle != null) break;
            if (item.equals("normal") || fontWeight == null && (fontWeight = FontWeightKeywords.get(item)) != null || fontStyle == null && (fontStyle = SVGParser.fontStyleKeyword(item)) != null) continue;
            if (fontVariant != null || !item.equals("small-caps")) break;
            fontVariant = item;
        }
        fontSize = SVGParser.parseFontSize(item);
        if (scan.consume('/')) {
            scan.skipWhitespace();
            item = scan.nextToken();
            if (item == null) {
                throw new SAXException("Invalid font style attribute: missing line-height");
            }
            SVGParser.parseLength(item);
            scan.skipWhitespace();
        }
        fontFamily = SVGParser.parseFontFamily(scan.restOfText());
        style2.fontFamily = fontFamily;
        style2.fontSize = fontSize;
        style2.fontWeight = fontWeight == null ? 400 : fontWeight;
        style2.fontStyle = fontStyle == null ? SVG.Style.FontStyle.Normal : fontStyle;
        style2.specifiedFlags |= 0x1E000L;
    }

    private static List<String> parseFontFamily(String val) throws SAXException {
        ArrayList<String> fonts = null;
        TextScanner scan = new TextScanner(val);
        do {
            String item;
            if ((item = scan.nextQuotedString()) == null) {
                item = scan.nextToken(',');
            }
            if (item == null) break;
            if (fonts == null) {
                fonts = new ArrayList<String>();
            }
            fonts.add(item);
            scan.skipCommaWhitespace();
        } while (!scan.empty());
        return fonts;
    }

    private static SVG.Length parseFontSize(String val) throws SAXException {
        SVG.Length size = FontSizeKeywords.get(val);
        if (size == null) {
            size = SVGParser.parseLength(val);
        }
        return size;
    }

    private static Integer parseFontWeight(String val) throws SAXException {
        Integer wt = FontWeightKeywords.get(val);
        if (wt == null) {
            throw new SAXException("Invalid font-weight property: " + val);
        }
        return wt;
    }

    private static SVG.Style.FontStyle parseFontStyle(String val) throws SAXException {
        SVG.Style.FontStyle fs = SVGParser.fontStyleKeyword(val);
        if (fs != null) {
            return fs;
        }
        throw new SAXException("Invalid font-style property: " + val);
    }

    private static SVG.Style.FontStyle fontStyleKeyword(String val) {
        if ("italic".equals(val)) {
            return SVG.Style.FontStyle.Italic;
        }
        if ("normal".equals(val)) {
            return SVG.Style.FontStyle.Normal;
        }
        if ("oblique".equals(val)) {
            return SVG.Style.FontStyle.Oblique;
        }
        return null;
    }

    private static SVG.Style.TextDecoration parseTextDecoration(String val) throws SAXException {
        if (NONE.equals(val)) {
            return SVG.Style.TextDecoration.None;
        }
        if ("underline".equals(val)) {
            return SVG.Style.TextDecoration.Underline;
        }
        if ("overline".equals(val)) {
            return SVG.Style.TextDecoration.Overline;
        }
        if ("line-through".equals(val)) {
            return SVG.Style.TextDecoration.LineThrough;
        }
        if ("blink".equals(val)) {
            return SVG.Style.TextDecoration.Blink;
        }
        throw new SAXException("Invalid text-decoration property: " + val);
    }

    private static SVG.Style.TextDirection parseTextDirection(String val) throws SAXException {
        if ("ltr".equals(val)) {
            return SVG.Style.TextDirection.LTR;
        }
        if ("rtl".equals(val)) {
            return SVG.Style.TextDirection.RTL;
        }
        throw new SAXException("Invalid direction property: " + val);
    }

    private static SVG.Style.FillRule parseFillRule(String val) throws SAXException {
        if ("nonzero".equals(val)) {
            return SVG.Style.FillRule.NonZero;
        }
        if ("evenodd".equals(val)) {
            return SVG.Style.FillRule.EvenOdd;
        }
        throw new SAXException("Invalid fill-rule property: " + val);
    }

    private static SVG.Style.LineCaps parseStrokeLineCap(String val) throws SAXException {
        if ("butt".equals(val)) {
            return SVG.Style.LineCaps.Butt;
        }
        if ("round".equals(val)) {
            return SVG.Style.LineCaps.Round;
        }
        if ("square".equals(val)) {
            return SVG.Style.LineCaps.Square;
        }
        throw new SAXException("Invalid stroke-linecap property: " + val);
    }

    private static SVG.Style.LineJoin parseStrokeLineJoin(String val) throws SAXException {
        if ("miter".equals(val)) {
            return SVG.Style.LineJoin.Miter;
        }
        if ("round".equals(val)) {
            return SVG.Style.LineJoin.Round;
        }
        if ("bevel".equals(val)) {
            return SVG.Style.LineJoin.Bevel;
        }
        throw new SAXException("Invalid stroke-linejoin property: " + val);
    }

    private static SVG.Length[] parseStrokeDashArray(String val) throws SAXException {
        TextScanner scan = new TextScanner(val);
        scan.skipWhitespace();
        if (scan.empty()) {
            return null;
        }
        SVG.Length dash = scan.nextLength();
        if (dash == null) {
            return null;
        }
        if (dash.isNegative()) {
            throw new SAXException("Invalid stroke-dasharray. Dash segemnts cannot be negative: " + val);
        }
        float sum = dash.floatValue();
        ArrayList<SVG.Length> dashes = new ArrayList<SVG.Length>();
        dashes.add(dash);
        while (!scan.empty()) {
            scan.skipCommaWhitespace();
            dash = scan.nextLength();
            if (dash == null) {
                throw new SAXException("Invalid stroke-dasharray. Non-Length content found: " + val);
            }
            if (dash.isNegative()) {
                throw new SAXException("Invalid stroke-dasharray. Dash segemnts cannot be negative: " + val);
            }
            dashes.add(dash);
            sum += dash.floatValue();
        }
        if (sum == 0.0f) {
            return null;
        }
        return dashes.toArray(new SVG.Length[dashes.size()]);
    }

    private static SVG.Style.TextAnchor parseTextAnchor(String val) throws SAXException {
        if ("start".equals(val)) {
            return SVG.Style.TextAnchor.Start;
        }
        if ("middle".equals(val)) {
            return SVG.Style.TextAnchor.Middle;
        }
        if ("end".equals(val)) {
            return SVG.Style.TextAnchor.End;
        }
        throw new SAXException("Invalid text-anchor property: " + val);
    }

    private static Boolean parseOverflow(String val) throws SAXException {
        if ("visible".equals(val) || "auto".equals(val)) {
            return Boolean.TRUE;
        }
        if ("hidden".equals(val) || "scroll".equals(val)) {
            return Boolean.FALSE;
        }
        throw new SAXException("Invalid toverflow property: " + val);
    }

    private static SVG.CSSClipRect parseClip(String val) throws SAXException {
        if ("auto".equals(val)) {
            return null;
        }
        if (!val.toLowerCase(Locale.US).startsWith("rect(")) {
            throw new SAXException("Invalid clip attribute shape. Only rect() is supported.");
        }
        TextScanner scan = new TextScanner(val.substring(5));
        scan.skipWhitespace();
        SVG.Length top = SVGParser.parseLengthOrAuto(scan);
        scan.skipCommaWhitespace();
        SVG.Length right = SVGParser.parseLengthOrAuto(scan);
        scan.skipCommaWhitespace();
        SVG.Length bottom = SVGParser.parseLengthOrAuto(scan);
        scan.skipCommaWhitespace();
        SVG.Length left = SVGParser.parseLengthOrAuto(scan);
        scan.skipWhitespace();
        if (!scan.consume(')')) {
            throw new SAXException("Bad rect() clip definition: " + val);
        }
        return new SVG.CSSClipRect(top, right, bottom, left);
    }

    private static SVG.Length parseLengthOrAuto(TextScanner scan) {
        if (scan.consume("auto")) {
            return new SVG.Length(0.0f);
        }
        return scan.nextLength();
    }

    private static SVG.Style.VectorEffect parseVectorEffect(String val) throws SAXException {
        if (NONE.equals(val)) {
            return SVG.Style.VectorEffect.None;
        }
        if ("non-scaling-stroke".equals(val)) {
            return SVG.Style.VectorEffect.NonScalingStroke;
        }
        throw new SAXException("Invalid vector-effect property: " + val);
    }

    private static SVG.PathDefinition parsePath(String val) throws SAXException {
        TextScanner scan = new TextScanner(val);
        int pathCommand = 63;
        float currentX = 0.0f;
        float currentY = 0.0f;
        float lastMoveX = 0.0f;
        float lastMoveY = 0.0f;
        float lastControlX = 0.0f;
        float lastControlY = 0.0f;
        SVG.PathDefinition path = new SVG.PathDefinition();
        if (scan.empty()) {
            return path;
        }
        pathCommand = scan.nextChar();
        if (pathCommand != 77 && pathCommand != 109) {
            return path;
        }
        while (true) {
            scan.skipWhitespace();
            switch (pathCommand) {
                case 77: 
                case 109: {
                    float x = scan.nextFloat();
                    float y = scan.checkedNextFloat(x);
                    if (Float.isNaN(y)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 109 && !path.isEmpty()) {
                        x += currentX;
                        y += currentY;
                    }
                    path.moveTo(x, y);
                    lastMoveX = lastControlX = x;
                    currentX = lastControlX;
                    lastMoveY = lastControlY = y;
                    currentY = lastControlY;
                    pathCommand = pathCommand == 109 ? 108 : 76;
                    break;
                }
                case 76: 
                case 108: {
                    float x = scan.nextFloat();
                    float y = scan.checkedNextFloat(x);
                    if (Float.isNaN(y)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 108) {
                        x += currentX;
                        y += currentY;
                    }
                    path.lineTo(x, y);
                    currentX = lastControlX = x;
                    currentY = lastControlY = y;
                    break;
                }
                case 67: 
                case 99: {
                    float x1 = scan.nextFloat();
                    float y1 = scan.checkedNextFloat(x1);
                    float x2 = scan.checkedNextFloat(y1);
                    float y2 = scan.checkedNextFloat(x2);
                    float x = scan.checkedNextFloat(y2);
                    float y = scan.checkedNextFloat(x);
                    if (Float.isNaN(y)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 99) {
                        x += currentX;
                        y += currentY;
                        x1 += currentX;
                        y1 += currentY;
                        x2 += currentX;
                        y2 += currentY;
                    }
                    path.cubicTo(x1, y1, x2, y2, x, y);
                    lastControlX = x2;
                    lastControlY = y2;
                    currentX = x;
                    currentY = y;
                    break;
                }
                case 83: 
                case 115: {
                    float x1 = 2.0f * currentX - lastControlX;
                    float y1 = 2.0f * currentY - lastControlY;
                    float x2 = scan.nextFloat();
                    float y2 = scan.checkedNextFloat(x2);
                    float x = scan.checkedNextFloat(y2);
                    float y = scan.checkedNextFloat(x);
                    if (Float.isNaN(y)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 115) {
                        x += currentX;
                        y += currentY;
                        x2 += currentX;
                        y2 += currentY;
                    }
                    path.cubicTo(x1, y1, x2, y2, x, y);
                    lastControlX = x2;
                    lastControlY = y2;
                    currentX = x;
                    currentY = y;
                    break;
                }
                case 90: 
                case 122: {
                    path.close();
                    currentX = lastControlX = lastMoveX;
                    currentY = lastControlY = lastMoveY;
                    break;
                }
                case 72: 
                case 104: {
                    float x = scan.nextFloat();
                    if (Float.isNaN(x)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 104) {
                        x += currentX;
                    }
                    path.lineTo(x, currentY);
                    currentX = lastControlX = x;
                    break;
                }
                case 86: 
                case 118: {
                    float y = scan.nextFloat();
                    if (Float.isNaN(y)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 118) {
                        y += currentY;
                    }
                    path.lineTo(currentX, y);
                    currentY = lastControlY = y;
                    break;
                }
                case 81: 
                case 113: {
                    float x1 = scan.nextFloat();
                    float y1 = scan.checkedNextFloat(x1);
                    float x = scan.checkedNextFloat(y1);
                    float y = scan.checkedNextFloat(x);
                    if (Float.isNaN(y)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 113) {
                        x += currentX;
                        y += currentY;
                        x1 += currentX;
                        y1 += currentY;
                    }
                    path.quadTo(x1, y1, x, y);
                    lastControlX = x1;
                    lastControlY = y1;
                    currentX = x;
                    currentY = y;
                    break;
                }
                case 84: 
                case 116: {
                    float x1 = 2.0f * currentX - lastControlX;
                    float y1 = 2.0f * currentY - lastControlY;
                    float x = scan.nextFloat();
                    float y = scan.checkedNextFloat(x);
                    if (Float.isNaN(y)) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 116) {
                        x += currentX;
                        y += currentY;
                    }
                    path.quadTo(x1, y1, x, y);
                    lastControlX = x1;
                    lastControlY = y1;
                    currentX = x;
                    currentY = y;
                    break;
                }
                case 65: 
                case 97: {
                    float y;
                    float x;
                    float rx = scan.nextFloat();
                    float ry = scan.checkedNextFloat(rx);
                    float xAxisRotation = scan.checkedNextFloat(ry);
                    Boolean largeArcFlag = scan.checkedNextFlag(Float.valueOf(xAxisRotation));
                    Boolean sweepFlag = scan.checkedNextFlag(largeArcFlag);
                    if (sweepFlag == null) {
                        y = Float.NaN;
                        x = Float.NaN;
                    } else {
                        x = scan.possibleNextFloat();
                        y = scan.checkedNextFloat(x);
                    }
                    if (Float.isNaN(y) || rx < 0.0f || ry < 0.0f) {
                        Log.e((String)TAG, (String)("Bad path coords for " + (char)pathCommand + " path segment"));
                        return path;
                    }
                    if (pathCommand == 97) {
                        x += currentX;
                        y += currentY;
                    }
                    path.arcTo(rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y);
                    currentX = lastControlX = x;
                    currentY = lastControlY = y;
                    break;
                }
                default: {
                    return path;
                }
            }
            scan.skipCommaWhitespace();
            if (scan.empty()) break;
            if (!scan.hasLetter()) continue;
            pathCommand = scan.nextChar();
        }
        return path;
    }

    private static Set<String> parseRequiredFeatures(String val) throws SAXException {
        TextScanner scan = new TextScanner(val);
        HashSet<String> result = new HashSet<String>();
        while (!scan.empty()) {
            String feature = scan.nextToken();
            if (feature.startsWith(FEATURE_STRING_PREFIX)) {
                result.add(feature.substring(FEATURE_STRING_PREFIX.length()));
            } else {
                result.add("UNSUPPORTED");
            }
            scan.skipWhitespace();
        }
        return result;
    }

    private static Set<String> parseSystemLanguage(String val) throws SAXException {
        TextScanner scan = new TextScanner(val);
        HashSet<String> result = new HashSet<String>();
        while (!scan.empty()) {
            String language = scan.nextToken();
            int hyphenPos = language.indexOf(45);
            if (hyphenPos != -1) {
                language = language.substring(0, hyphenPos);
            }
            language = new Locale(language, "", "").getLanguage();
            result.add(language);
            scan.skipWhitespace();
        }
        return result;
    }

    private static Set<String> parseRequiredFormats(String val) throws SAXException {
        TextScanner scan = new TextScanner(val);
        HashSet<String> result = new HashSet<String>();
        while (!scan.empty()) {
            String mimetype = scan.nextToken();
            result.add(mimetype);
            scan.skipWhitespace();
        }
        return result;
    }

    private static String parseFunctionalIRI(String val, String attrName) throws SAXException {
        if (val.equals(NONE)) {
            return null;
        }
        if (!val.startsWith("url(") || !val.endsWith(")")) {
            throw new SAXException("Bad " + attrName + " attribute. Expected \"none\" or \"url()\" format");
        }
        return val.substring(4, val.length() - 1).trim();
    }

    private void style(Attributes attributes) throws SAXException {
        this.debug("<style>", new Object[0]);
        if (this.currentElement == null) {
            throw new SAXException("Invalid document. Root element must be <svg>");
        }
        boolean isTextCSS = true;
        String media = "all";
        block4: for (int i = 0; i < attributes.getLength(); ++i) {
            String val = attributes.getValue(i).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(i))) {
                case type: {
                    isTextCSS = val.equals("text/css");
                    continue block4;
                }
                case media: {
                    media = val;
                    continue block4;
                }
            }
        }
        if (isTextCSS && CSSParser.mediaMatches(media, CSSParser.MediaType.screen)) {
            this.inStyleElement = true;
        } else {
            this.ignoring = true;
            this.ignoreDepth = 1;
        }
    }

    private void parseCSSStyleSheet(String sheet) throws SAXException {
        CSSParser cssp = new CSSParser(CSSParser.MediaType.screen);
        this.svgDocument.addCSSRules(cssp.parse(sheet));
    }

    protected static class TextScanner {
        protected String input;
        protected int position = 0;
        protected int inputLength = 0;
        private NumberParser numberParser = new NumberParser();

        public TextScanner(String input) {
            this.input = input.trim();
            this.inputLength = this.input.length();
        }

        public boolean empty() {
            return this.position == this.inputLength;
        }

        protected boolean isWhitespace(int c) {
            return c == 32 || c == 10 || c == 13 || c == 9;
        }

        public void skipWhitespace() {
            while (this.position < this.inputLength && this.isWhitespace(this.input.charAt(this.position))) {
                ++this.position;
            }
        }

        protected boolean isEOL(int c) {
            return c == 10 || c == 13;
        }

        public boolean skipCommaWhitespace() {
            this.skipWhitespace();
            if (this.position == this.inputLength) {
                return false;
            }
            if (this.input.charAt(this.position) != ',') {
                return false;
            }
            ++this.position;
            this.skipWhitespace();
            return true;
        }

        public float nextFloat() {
            float val = this.numberParser.parseNumber(this.input, this.position, this.inputLength);
            if (!Float.isNaN(val)) {
                this.position = this.numberParser.getEndPos();
            }
            return val;
        }

        public float possibleNextFloat() {
            this.skipCommaWhitespace();
            float val = this.numberParser.parseNumber(this.input, this.position, this.inputLength);
            if (!Float.isNaN(val)) {
                this.position = this.numberParser.getEndPos();
            }
            return val;
        }

        public float checkedNextFloat(float lastRead) {
            if (Float.isNaN(lastRead)) {
                return Float.NaN;
            }
            this.skipCommaWhitespace();
            return this.nextFloat();
        }

        public Integer nextInteger() {
            IntegerParser ip = IntegerParser.parseInt(this.input, this.position, this.inputLength);
            if (ip == null) {
                return null;
            }
            this.position = ip.getEndPos();
            return ip.value();
        }

        public Integer nextChar() {
            if (this.position == this.inputLength) {
                return null;
            }
            return this.input.charAt(this.position++);
        }

        public SVG.Length nextLength() {
            float scalar = this.nextFloat();
            if (Float.isNaN(scalar)) {
                return null;
            }
            SVG.Unit unit = this.nextUnit();
            if (unit == null) {
                return new SVG.Length(scalar, SVG.Unit.px);
            }
            return new SVG.Length(scalar, unit);
        }

        public Boolean nextFlag() {
            if (this.position == this.inputLength) {
                return null;
            }
            char ch = this.input.charAt(this.position);
            if (ch == '0' || ch == '1') {
                ++this.position;
                return ch == '1';
            }
            return null;
        }

        public Boolean checkedNextFlag(Object lastRead) {
            if (lastRead == null) {
                return null;
            }
            this.skipCommaWhitespace();
            return this.nextFlag();
        }

        public boolean consume(char ch) {
            boolean found;
            boolean bl = found = this.position < this.inputLength && this.input.charAt(this.position) == ch;
            if (found) {
                ++this.position;
            }
            return found;
        }

        public boolean consume(String str) {
            boolean found;
            int len = str.length();
            boolean bl = found = this.position <= this.inputLength - len && this.input.substring(this.position, this.position + len).equals(str);
            if (found) {
                this.position += len;
            }
            return found;
        }

        protected int advanceChar() {
            if (this.position == this.inputLength) {
                return -1;
            }
            ++this.position;
            if (this.position < this.inputLength) {
                return this.input.charAt(this.position);
            }
            return -1;
        }

        public String nextToken() {
            return this.nextToken(' ');
        }

        public String nextToken(char terminator) {
            if (this.empty()) {
                return null;
            }
            int ch = this.input.charAt(this.position);
            if (this.isWhitespace(ch) || ch == terminator) {
                return null;
            }
            int start = this.position;
            ch = this.advanceChar();
            while (ch != -1 && ch != terminator && !this.isWhitespace(ch)) {
                ch = this.advanceChar();
            }
            return this.input.substring(start, this.position);
        }

        public String nextFunction() {
            if (this.empty()) {
                return null;
            }
            int start = this.position;
            int ch = this.input.charAt(this.position);
            while (ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90) {
                ch = this.advanceChar();
            }
            int end = this.position;
            while (this.isWhitespace(ch)) {
                ch = this.advanceChar();
            }
            if (ch == 40) {
                ++this.position;
                return this.input.substring(start, end);
            }
            this.position = start;
            return null;
        }

        public String ahead() {
            int start = this.position;
            while (!this.empty() && !this.isWhitespace(this.input.charAt(this.position))) {
                ++this.position;
            }
            String str = this.input.substring(start, this.position);
            this.position = start;
            return str;
        }

        public SVG.Unit nextUnit() {
            if (this.empty()) {
                return null;
            }
            char ch = this.input.charAt(this.position);
            if (ch == '%') {
                ++this.position;
                return SVG.Unit.percent;
            }
            if (this.position > this.inputLength - 2) {
                return null;
            }
            try {
                SVG.Unit result = SVG.Unit.valueOf(this.input.substring(this.position, this.position + 2).toLowerCase(Locale.US));
                this.position += 2;
                return result;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public boolean hasLetter() {
            if (this.position == this.inputLength) {
                return false;
            }
            char ch = this.input.charAt(this.position);
            return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
        }

        public String nextQuotedString() {
            int ch;
            if (this.empty()) {
                return null;
            }
            int start = this.position;
            int endQuote = ch = this.input.charAt(this.position);
            if (ch != 39 && ch != 34) {
                return null;
            }
            ch = this.advanceChar();
            while (ch != -1 && ch != endQuote) {
                ch = this.advanceChar();
            }
            if (ch == -1) {
                this.position = start;
                return null;
            }
            ++this.position;
            return this.input.substring(start + 1, this.position - 1);
        }

        public String restOfText() {
            if (this.empty()) {
                return null;
            }
            int start = this.position;
            this.position = this.inputLength;
            return this.input.substring(start);
        }
    }

    private static class AspectRatioKeywords {
        private static final Map<String, PreserveAspectRatio.Alignment> aspectRatioKeywords = new HashMap<String, PreserveAspectRatio.Alignment>(10);

        private AspectRatioKeywords() {
        }

        public static PreserveAspectRatio.Alignment get(String aspectRatio) {
            return aspectRatioKeywords.get(aspectRatio);
        }

        static {
            aspectRatioKeywords.put(SVGParser.NONE, PreserveAspectRatio.Alignment.None);
            aspectRatioKeywords.put("xMinYMin", PreserveAspectRatio.Alignment.XMinYMin);
            aspectRatioKeywords.put("xMidYMin", PreserveAspectRatio.Alignment.XMidYMin);
            aspectRatioKeywords.put("xMaxYMin", PreserveAspectRatio.Alignment.XMaxYMin);
            aspectRatioKeywords.put("xMinYMid", PreserveAspectRatio.Alignment.XMinYMid);
            aspectRatioKeywords.put("xMidYMid", PreserveAspectRatio.Alignment.XMidYMid);
            aspectRatioKeywords.put("xMaxYMid", PreserveAspectRatio.Alignment.XMaxYMid);
            aspectRatioKeywords.put("xMinYMax", PreserveAspectRatio.Alignment.XMinYMax);
            aspectRatioKeywords.put("xMidYMax", PreserveAspectRatio.Alignment.XMidYMax);
            aspectRatioKeywords.put("xMaxYMax", PreserveAspectRatio.Alignment.XMaxYMax);
        }
    }

    private static class FontWeightKeywords {
        private static final Map<String, Integer> fontWeightKeywords = new HashMap<String, Integer>(13);

        private FontWeightKeywords() {
        }

        public static Integer get(String fontWeight) {
            return fontWeightKeywords.get(fontWeight);
        }

        static {
            fontWeightKeywords.put("normal", 400);
            fontWeightKeywords.put("bold", 700);
            fontWeightKeywords.put("bolder", 1);
            fontWeightKeywords.put("lighter", -1);
            fontWeightKeywords.put("100", 100);
            fontWeightKeywords.put("200", 200);
            fontWeightKeywords.put("300", 300);
            fontWeightKeywords.put("400", 400);
            fontWeightKeywords.put("500", 500);
            fontWeightKeywords.put("600", 600);
            fontWeightKeywords.put("700", 700);
            fontWeightKeywords.put("800", 800);
            fontWeightKeywords.put("900", 900);
        }
    }

    private static class FontSizeKeywords {
        private static final Map<String, SVG.Length> fontSizeKeywords = new HashMap<String, SVG.Length>(9);

        private FontSizeKeywords() {
        }

        public static SVG.Length get(String fontSize) {
            return fontSizeKeywords.get(fontSize);
        }

        static {
            fontSizeKeywords.put("xx-small", new SVG.Length(0.694f, SVG.Unit.pt));
            fontSizeKeywords.put("x-small", new SVG.Length(0.833f, SVG.Unit.pt));
            fontSizeKeywords.put("small", new SVG.Length(10.0f, SVG.Unit.pt));
            fontSizeKeywords.put("medium", new SVG.Length(12.0f, SVG.Unit.pt));
            fontSizeKeywords.put("large", new SVG.Length(14.4f, SVG.Unit.pt));
            fontSizeKeywords.put("x-large", new SVG.Length(17.3f, SVG.Unit.pt));
            fontSizeKeywords.put("xx-large", new SVG.Length(20.7f, SVG.Unit.pt));
            fontSizeKeywords.put("smaller", new SVG.Length(83.33f, SVG.Unit.percent));
            fontSizeKeywords.put("larger", new SVG.Length(120.0f, SVG.Unit.percent));
        }
    }

    private static class ColourKeywords {
        private static final Map<String, Integer> colourKeywords = new HashMap<String, Integer>(47);

        private ColourKeywords() {
        }

        public static Integer get(String colourName) {
            return colourKeywords.get(colourName);
        }

        static {
            colourKeywords.put("aliceblue", 0xF0F8FF);
            colourKeywords.put("antiquewhite", 16444375);
            colourKeywords.put("aqua", 65535);
            colourKeywords.put("aquamarine", 8388564);
            colourKeywords.put("azure", 0xF0FFFF);
            colourKeywords.put("beige", 16119260);
            colourKeywords.put("bisque", 16770244);
            colourKeywords.put("black", 0);
            colourKeywords.put("blanchedalmond", 16772045);
            colourKeywords.put("blue", 255);
            colourKeywords.put("blueviolet", 9055202);
            colourKeywords.put("brown", 0xA52A2A);
            colourKeywords.put("burlywood", 14596231);
            colourKeywords.put("cadetblue", 6266528);
            colourKeywords.put("chartreuse", 0x7FFF00);
            colourKeywords.put("chocolate", 13789470);
            colourKeywords.put("coral", 16744272);
            colourKeywords.put("cornflowerblue", 6591981);
            colourKeywords.put("cornsilk", 16775388);
            colourKeywords.put("crimson", 14423100);
            colourKeywords.put("cyan", 65535);
            colourKeywords.put("darkblue", 139);
            colourKeywords.put("darkcyan", 35723);
            colourKeywords.put("darkgoldenrod", 12092939);
            colourKeywords.put("darkgray", 0xA9A9A9);
            colourKeywords.put("darkgreen", 25600);
            colourKeywords.put("darkgrey", 0xA9A9A9);
            colourKeywords.put("darkkhaki", 12433259);
            colourKeywords.put("darkmagenta", 0x8B008B);
            colourKeywords.put("darkolivegreen", 5597999);
            colourKeywords.put("darkorange", 16747520);
            colourKeywords.put("darkorchid", 10040012);
            colourKeywords.put("darkred", 0x8B0000);
            colourKeywords.put("darksalmon", 15308410);
            colourKeywords.put("darkseagreen", 9419919);
            colourKeywords.put("darkslateblue", 4734347);
            colourKeywords.put("darkslategray", 0x2F4F4F);
            colourKeywords.put("darkslategrey", 0x2F4F4F);
            colourKeywords.put("darkturquoise", 52945);
            colourKeywords.put("darkviolet", 9699539);
            colourKeywords.put("deeppink", 16716947);
            colourKeywords.put("deepskyblue", 49151);
            colourKeywords.put("dimgray", 0x696969);
            colourKeywords.put("dimgrey", 0x696969);
            colourKeywords.put("dodgerblue", 2003199);
            colourKeywords.put("firebrick", 0xB22222);
            colourKeywords.put("floralwhite", 0xFFFAF0);
            colourKeywords.put("forestgreen", 0x228B22);
            colourKeywords.put("fuchsia", 0xFF00FF);
            colourKeywords.put("gainsboro", 0xDCDCDC);
            colourKeywords.put("ghostwhite", 0xF8F8FF);
            colourKeywords.put("gold", 16766720);
            colourKeywords.put("goldenrod", 14329120);
            colourKeywords.put("gray", 0x808080);
            colourKeywords.put("green", 32768);
            colourKeywords.put("greenyellow", 11403055);
            colourKeywords.put("grey", 0x808080);
            colourKeywords.put("honeydew", 0xF0FFF0);
            colourKeywords.put("hotpink", 16738740);
            colourKeywords.put("indianred", 0xCD5C5C);
            colourKeywords.put("indigo", 4915330);
            colourKeywords.put("ivory", 0xFFFFF0);
            colourKeywords.put("khaki", 15787660);
            colourKeywords.put("lavender", 15132410);
            colourKeywords.put("lavenderblush", 0xFFF0F5);
            colourKeywords.put("lawngreen", 8190976);
            colourKeywords.put("lemonchiffon", 16775885);
            colourKeywords.put("lightblue", 11393254);
            colourKeywords.put("lightcoral", 0xF08080);
            colourKeywords.put("lightcyan", 0xE0FFFF);
            colourKeywords.put("lightgoldenrodyellow", 16448210);
            colourKeywords.put("lightgray", 0xD3D3D3);
            colourKeywords.put("lightgreen", 0x90EE90);
            colourKeywords.put("lightgrey", 0xD3D3D3);
            colourKeywords.put("lightpink", 16758465);
            colourKeywords.put("lightsalmon", 16752762);
            colourKeywords.put("lightseagreen", 2142890);
            colourKeywords.put("lightskyblue", 8900346);
            colourKeywords.put("lightslategray", 0x778899);
            colourKeywords.put("lightslategrey", 0x778899);
            colourKeywords.put("lightsteelblue", 11584734);
            colourKeywords.put("lightyellow", 0xFFFFE0);
            colourKeywords.put("lime", 65280);
            colourKeywords.put("limegreen", 3329330);
            colourKeywords.put("linen", 16445670);
            colourKeywords.put("magenta", 0xFF00FF);
            colourKeywords.put("maroon", 0x800000);
            colourKeywords.put("mediumaquamarine", 6737322);
            colourKeywords.put("mediumblue", 205);
            colourKeywords.put("mediumorchid", 12211667);
            colourKeywords.put("mediumpurple", 9662683);
            colourKeywords.put("mediumseagreen", 3978097);
            colourKeywords.put("mediumslateblue", 8087790);
            colourKeywords.put("mediumspringgreen", 64154);
            colourKeywords.put("mediumturquoise", 4772300);
            colourKeywords.put("mediumvioletred", 13047173);
            colourKeywords.put("midnightblue", 1644912);
            colourKeywords.put("mintcream", 0xF5FFFA);
            colourKeywords.put("mistyrose", 16770273);
            colourKeywords.put("moccasin", 16770229);
            colourKeywords.put("navajowhite", 16768685);
            colourKeywords.put("navy", 128);
            colourKeywords.put("oldlace", 16643558);
            colourKeywords.put("olive", 0x808000);
            colourKeywords.put("olivedrab", 7048739);
            colourKeywords.put("orange", 16753920);
            colourKeywords.put("orangered", 16729344);
            colourKeywords.put("orchid", 14315734);
            colourKeywords.put("palegoldenrod", 0xEEE8AA);
            colourKeywords.put("palegreen", 10025880);
            colourKeywords.put("paleturquoise", 0xAFEEEE);
            colourKeywords.put("palevioletred", 14381203);
            colourKeywords.put("papayawhip", 16773077);
            colourKeywords.put("peachpuff", 16767673);
            colourKeywords.put("peru", 13468991);
            colourKeywords.put("pink", 16761035);
            colourKeywords.put("plum", 0xDDA0DD);
            colourKeywords.put("powderblue", 11591910);
            colourKeywords.put("purple", 0x800080);
            colourKeywords.put("red", 0xFF0000);
            colourKeywords.put("rosybrown", 12357519);
            colourKeywords.put("royalblue", 4286945);
            colourKeywords.put("saddlebrown", 9127187);
            colourKeywords.put("salmon", 16416882);
            colourKeywords.put("sandybrown", 16032864);
            colourKeywords.put("seagreen", 3050327);
            colourKeywords.put("seashell", 0xFFF5EE);
            colourKeywords.put("sienna", 10506797);
            colourKeywords.put("silver", 0xC0C0C0);
            colourKeywords.put("skyblue", 8900331);
            colourKeywords.put("slateblue", 6970061);
            colourKeywords.put("slategray", 7372944);
            colourKeywords.put("slategrey", 7372944);
            colourKeywords.put("snow", 0xFFFAFA);
            colourKeywords.put("springgreen", 65407);
            colourKeywords.put("steelblue", 4620980);
            colourKeywords.put("tan", 13808780);
            colourKeywords.put("teal", 32896);
            colourKeywords.put("thistle", 14204888);
            colourKeywords.put("tomato", 16737095);
            colourKeywords.put("turquoise", 4251856);
            colourKeywords.put("violet", 0xEE82EE);
            colourKeywords.put("wheat", 16113331);
            colourKeywords.put("white", 0xFFFFFF);
            colourKeywords.put("whitesmoke", 0xF5F5F5);
            colourKeywords.put("yellow", 0xFFFF00);
            colourKeywords.put("yellowgreen", 10145074);
        }
    }

    private static enum SVGAttr {
        CLASS,
        clip,
        clip_path,
        clipPathUnits,
        clip_rule,
        color,
        cx,
        cy,
        direction,
        dx,
        dy,
        fx,
        fy,
        d,
        display,
        fill,
        fill_rule,
        fill_opacity,
        font,
        font_family,
        font_size,
        font_weight,
        font_style,
        gradientTransform,
        gradientUnits,
        height,
        href,
        id,
        marker,
        marker_start,
        marker_mid,
        marker_end,
        markerHeight,
        markerUnits,
        markerWidth,
        mask,
        maskContentUnits,
        maskUnits,
        media,
        offset,
        opacity,
        orient,
        overflow,
        pathLength,
        patternContentUnits,
        patternTransform,
        patternUnits,
        points,
        preserveAspectRatio,
        r,
        refX,
        refY,
        requiredFeatures,
        requiredExtensions,
        requiredFormats,
        requiredFonts,
        rx,
        ry,
        solid_color,
        solid_opacity,
        spreadMethod,
        startOffset,
        stop_color,
        stop_opacity,
        stroke,
        stroke_dasharray,
        stroke_dashoffset,
        stroke_linecap,
        stroke_linejoin,
        stroke_miterlimit,
        stroke_opacity,
        stroke_width,
        style,
        systemLanguage,
        text_anchor,
        text_decoration,
        transform,
        type,
        vector_effect,
        version,
        viewBox,
        width,
        x,
        y,
        x1,
        y1,
        x2,
        y2,
        viewport_fill,
        viewport_fill_opacity,
        visibility,
        UNSUPPORTED;

        private static final Map<String, SVGAttr> cache;

        public static SVGAttr fromString(String str) {
            SVGAttr attr = cache.get(str);
            if (attr != null) {
                return attr;
            }
            if (str.equals("class")) {
                cache.put(str, CLASS);
                return CLASS;
            }
            if (str.indexOf(95) != -1) {
                cache.put(str, UNSUPPORTED);
                return UNSUPPORTED;
            }
            try {
                attr = SVGAttr.valueOf(str.replace('-', '_'));
                if (attr != CLASS) {
                    cache.put(str, attr);
                    return attr;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            cache.put(str, UNSUPPORTED);
            return UNSUPPORTED;
        }

        static {
            cache = new HashMap<String, SVGAttr>();
        }
    }

    private static enum SVGElem {
        svg,
        a,
        circle,
        clipPath,
        defs,
        desc,
        ellipse,
        g,
        image,
        line,
        linearGradient,
        marker,
        mask,
        path,
        pattern,
        polygon,
        polyline,
        radialGradient,
        rect,
        solidColor,
        stop,
        style,
        SWITCH,
        symbol,
        text,
        textPath,
        title,
        tref,
        tspan,
        use,
        view,
        UNSUPPORTED;

        private static final Map<String, SVGElem> cache;

        public static SVGElem fromString(String str) {
            SVGElem elem = cache.get(str);
            if (elem != null) {
                return elem;
            }
            if (str.equals("switch")) {
                cache.put(str, SWITCH);
                return SWITCH;
            }
            try {
                elem = SVGElem.valueOf(str);
                if (elem != SWITCH) {
                    cache.put(str, elem);
                    return elem;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            cache.put(str, UNSUPPORTED);
            return UNSUPPORTED;
        }

        static {
            cache = new HashMap<String, SVGElem>();
        }
    }
}

