/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.platform.svg;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PathMeasure;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.os.Build;
import android.util.Base64;
import android.util.Log;
import com.guidebee.game.engine.platform.svg.CSSParser;
import com.guidebee.game.engine.platform.svg.PreserveAspectRatio;
import com.guidebee.game.engine.platform.svg.SVG;
import com.guidebee.game.engine.platform.svg.SVGExternalFileResolver;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;

public class SVGAndroidRenderer {
    private static final String TAG = "SVGAndroidRenderer";
    private Canvas canvas;
    private SVG.Box canvasViewPort;
    private float dpi;
    private boolean directRenderingMode;
    private SVG document;
    private RendererState state;
    private Stack<RendererState> stateStack;
    private Stack<SVG.SvgContainer> parentStack;
    private Stack<Matrix> matrixStack;
    private Stack<Canvas> canvasStack;
    private Stack<Bitmap> bitmapStack;
    private static final float BEZIER_ARC_FACTOR = 0.5522848f;
    private static final int LUMINANCE_FACTOR_SHIFT = 15;
    private static final int LUMINANCE_TO_ALPHA_RED = 6963;
    private static final int LUMINANCE_TO_ALPHA_GREEN = 23442;
    private static final int LUMINANCE_TO_ALPHA_BLUE = 2362;
    private static final String DEFAULT_FONT_FAMILY = "sans-serif";
    private static HashSet<String> supportedFeatures = null;

    private void resetState() {
        this.state = new RendererState();
        this.stateStack = new Stack();
        this.updateStyle(this.state, SVG.Style.getDefaultStyle());
        this.state.viewPort = this.canvasViewPort;
        this.state.spacePreserve = false;
        this.state.directRendering = this.directRenderingMode;
        this.stateStack.push((RendererState)this.state.clone());
        this.canvasStack = new Stack();
        this.bitmapStack = new Stack();
        this.matrixStack = new Stack();
        this.parentStack = new Stack();
    }

    protected SVGAndroidRenderer(Canvas canvas, SVG.Box viewPort, float defaultDPI) {
        this.canvas = canvas;
        this.dpi = defaultDPI;
        this.canvasViewPort = viewPort;
    }

    protected float getDPI() {
        return this.dpi;
    }

    protected float getCurrentFontSize() {
        return this.state.fillPaint.getTextSize();
    }

    protected float getCurrentFontXHeight() {
        return this.state.fillPaint.getTextSize() / 2.0f;
    }

    protected SVG.Box getCurrentViewPortInUserUnits() {
        if (this.state.viewBox != null) {
            return this.state.viewBox;
        }
        return this.state.viewPort;
    }

    protected void renderDocument(SVG document, SVG.Box viewBox, PreserveAspectRatio positioning, boolean directRenderingMode) {
        this.document = document;
        this.directRenderingMode = directRenderingMode;
        SVG.Svg rootObj = document.getRootElement();
        if (rootObj == null) {
            SVGAndroidRenderer.warn("Nothing to render. Document is empty.", new Object[0]);
            return;
        }
        this.resetState();
        this.checkXMLSpaceAttribute(rootObj);
        this.render(rootObj, rootObj.width, rootObj.height, viewBox != null ? viewBox : rootObj.viewBox, positioning != null ? positioning : rootObj.preserveAspectRatio);
    }

    private void render(SVG.SvgObject obj) {
        if (obj instanceof SVG.NotDirectlyRendered) {
            return;
        }
        this.statePush();
        this.checkXMLSpaceAttribute(obj);
        if (obj instanceof SVG.Svg) {
            this.render((SVG.Svg)obj);
        } else if (obj instanceof SVG.Use) {
            this.render((SVG.Use)obj);
        } else if (obj instanceof SVG.Switch) {
            this.render((SVG.Switch)obj);
        } else if (obj instanceof SVG.Group) {
            this.render((SVG.Group)obj);
        } else if (obj instanceof SVG.Image) {
            this.render((SVG.Image)obj);
        } else if (obj instanceof SVG.Path) {
            this.render((SVG.Path)obj);
        } else if (obj instanceof SVG.Rect) {
            this.render((SVG.Rect)obj);
        } else if (obj instanceof SVG.Circle) {
            this.render((SVG.Circle)obj);
        } else if (obj instanceof SVG.Ellipse) {
            this.render((SVG.Ellipse)obj);
        } else if (obj instanceof SVG.Line) {
            this.render((SVG.Line)obj);
        } else if (obj instanceof SVG.Polygon) {
            this.render((SVG.Polygon)obj);
        } else if (obj instanceof SVG.PolyLine) {
            this.render((SVG.PolyLine)obj);
        } else if (obj instanceof SVG.Text) {
            this.render((SVG.Text)obj);
        }
        this.statePop();
    }

    private void renderChildren(SVG.SvgContainer obj, boolean isContainer) {
        if (isContainer) {
            this.parentPush(obj);
        }
        for (SVG.SvgObject child : obj.getChildren()) {
            this.render(child);
        }
        if (isContainer) {
            this.parentPop();
        }
    }

    private void statePush() {
        this.canvas.save();
        this.stateStack.push(this.state);
        this.state = (RendererState)this.state.clone();
    }

    private void statePop() {
        this.canvas.restore();
        this.state = this.stateStack.pop();
    }

    private void parentPush(SVG.SvgContainer obj) {
        this.parentStack.push(obj);
        this.matrixStack.push(this.canvas.getMatrix());
    }

    private void parentPop() {
        this.parentStack.pop();
        this.matrixStack.pop();
    }

    private void updateStyleForElement(RendererState state, SVG.SvgElementBase obj) {
        boolean isRootSVG = obj.parent == null;
        state.style.resetNonInheritingProperties(isRootSVG);
        if (obj.baseStyle != null) {
            this.updateStyle(state, obj.baseStyle);
        }
        if (this.document.hasCSSRules()) {
            for (CSSParser.Rule rule : this.document.getCSSRules()) {
                if (!CSSParser.ruleMatch(rule.selector, obj)) continue;
                this.updateStyle(state, rule.style);
            }
        }
        if (obj.style != null) {
            this.updateStyle(state, obj.style);
        }
    }

    private void checkXMLSpaceAttribute(SVG.SvgObject obj) {
        if (!(obj instanceof SVG.SvgElementBase)) {
            return;
        }
        SVG.SvgElementBase bobj = (SVG.SvgElementBase)obj;
        if (bobj.spacePreserve != null) {
            this.state.spacePreserve = bobj.spacePreserve;
        }
    }

    private void doFilledPath(SVG.SvgElement obj, Path path) {
        SVG.SvgObject ref;
        if (this.state.style.fill instanceof SVG.PaintReference && (ref = this.document.resolveIRI(((SVG.PaintReference)this.state.style.fill).href)) instanceof SVG.Pattern) {
            SVG.Pattern pattern = (SVG.Pattern)ref;
            this.fillWithPattern(obj, path, pattern);
            return;
        }
        this.canvas.drawPath(path, this.state.fillPaint);
    }

    private void doStroke(Path path) {
        if (this.state.style.vectorEffect == SVG.Style.VectorEffect.NonScalingStroke) {
            Matrix currentMatrix = this.canvas.getMatrix();
            Path transformedPath = new Path();
            path.transform(currentMatrix, transformedPath);
            this.canvas.setMatrix(new Matrix());
            Shader shader = this.state.strokePaint.getShader();
            Matrix currentShaderMatrix = new Matrix();
            if (shader != null) {
                shader.getLocalMatrix(currentShaderMatrix);
                Matrix newShaderMatrix = new Matrix(currentShaderMatrix);
                newShaderMatrix.postConcat(currentMatrix);
                shader.setLocalMatrix(newShaderMatrix);
            }
            this.canvas.drawPath(transformedPath, this.state.strokePaint);
            this.canvas.setMatrix(currentMatrix);
            if (shader != null) {
                shader.setLocalMatrix(currentShaderMatrix);
            }
        } else {
            this.canvas.drawPath(path, this.state.strokePaint);
        }
    }

    private static void warn(String format, Object ... args) {
        Log.w((String)TAG, (String)String.format(format, args));
    }

    private static void error(String format, Object ... args) {
        Log.e((String)TAG, (String)String.format(format, args));
    }

    private static void debug(String format, Object ... args) {
    }

    private static void info(String format, Object ... args) {
        Log.i((String)TAG, (String)String.format(format, args));
    }

    private void render(SVG.Svg obj) {
        this.render(obj, obj.width, obj.height);
    }

    private void render(SVG.Svg obj, SVG.Length width, SVG.Length height) {
        this.render(obj, width, height, obj.viewBox, obj.preserveAspectRatio);
    }

    private void render(SVG.Svg obj, SVG.Length width, SVG.Length height, SVG.Box viewBox, PreserveAspectRatio positioning) {
        SVGAndroidRenderer.debug("Svg render", new Object[0]);
        if (width != null && width.isZero() || height != null && height.isZero()) {
            return;
        }
        if (positioning == null) {
            positioning = obj.preserveAspectRatio != null ? obj.preserveAspectRatio : PreserveAspectRatio.LETTERBOX;
        }
        this.updateStyleForElement(this.state, obj);
        if (!this.display()) {
            return;
        }
        float _x = 0.0f;
        float _y = 0.0f;
        if (obj.parent != null) {
            _x = obj.x != null ? obj.x.floatValueX(this) : 0.0f;
            _y = obj.y != null ? obj.y.floatValueY(this) : 0.0f;
        }
        SVG.Box viewPortUser = this.getCurrentViewPortInUserUnits();
        float _w = width != null ? width.floatValueX(this) : viewPortUser.width;
        float _h = height != null ? height.floatValueY(this) : viewPortUser.height;
        this.state.viewPort = new SVG.Box(_x, _y, _w, _h);
        if (!this.state.style.overflow.booleanValue()) {
            this.setClipRect(this.state.viewPort.minX, this.state.viewPort.minY, this.state.viewPort.width, this.state.viewPort.height);
        }
        this.checkForClipPath(obj, this.state.viewPort);
        if (viewBox != null) {
            this.canvas.concat(this.calculateViewBoxTransform(this.state.viewPort, viewBox, positioning));
            this.state.viewBox = obj.viewBox;
        } else {
            this.canvas.translate(_x, _y);
        }
        boolean compositing = this.pushLayer();
        this.viewportFill();
        this.renderChildren(obj, true);
        if (compositing) {
            this.popLayer(obj);
        }
        this.updateParentBoundingBox(obj);
    }

    private void render(SVG.Group obj) {
        SVGAndroidRenderer.debug("UIContainer render", new Object[0]);
        this.updateStyleForElement(this.state, obj);
        if (!this.display()) {
            return;
        }
        if (obj.transform != null) {
            this.canvas.concat(obj.transform);
        }
        this.checkForClipPath(obj);
        boolean compositing = this.pushLayer();
        this.renderChildren(obj, true);
        if (compositing) {
            this.popLayer(obj);
        }
        this.updateParentBoundingBox(obj);
    }

    private void updateParentBoundingBox(SVG.SvgElement obj) {
        if (obj.parent == null) {
            return;
        }
        if (obj.boundingBox == null) {
            return;
        }
        Matrix m = new Matrix();
        if (this.matrixStack.peek().invert(m)) {
            float[] pts = new float[]{obj.boundingBox.minX, obj.boundingBox.minY, obj.boundingBox.maxX(), obj.boundingBox.minY, obj.boundingBox.maxX(), obj.boundingBox.maxY(), obj.boundingBox.minX, obj.boundingBox.maxY()};
            m.preConcat(this.canvas.getMatrix());
            m.mapPoints(pts);
            RectF rect = new RectF(pts[0], pts[1], pts[0], pts[1]);
            for (int i = 2; i <= 6; i += 2) {
                if (pts[i] < rect.left) {
                    rect.left = pts[i];
                }
                if (pts[i] > rect.right) {
                    rect.right = pts[i];
                }
                if (pts[i + 1] < rect.top) {
                    rect.top = pts[i + 1];
                }
                if (!(pts[i + 1] > rect.bottom)) continue;
                rect.bottom = pts[i + 1];
            }
            SVG.SvgElement parent = (SVG.SvgElement)((Object)this.parentStack.peek());
            if (parent.boundingBox == null) {
                parent.boundingBox = SVG.Box.fromLimits(rect.left, rect.top, rect.right, rect.bottom);
            } else {
                parent.boundingBox.union(SVG.Box.fromLimits(rect.left, rect.top, rect.right, rect.bottom));
            }
        }
    }

    private boolean pushLayer() {
        if (!this.requiresCompositing()) {
            return false;
        }
        this.canvas.saveLayerAlpha(null, this.clamp255(this.state.style.opacity.floatValue()), 4);
        this.stateStack.push(this.state);
        this.state = (RendererState)this.state.clone();
        if (this.state.style.mask != null && this.state.directRendering) {
            SVG.SvgObject ref = this.document.resolveIRI(this.state.style.mask);
            if (ref == null || !(ref instanceof SVG.Mask)) {
                SVGAndroidRenderer.error("Mask reference '%s' not found", this.state.style.mask);
                this.state.style.mask = null;
                return true;
            }
            this.canvasStack.push(this.canvas);
            this.duplicateCanvas();
        }
        return true;
    }

    private void popLayer(SVG.SvgElement obj) {
        if (this.state.style.mask != null && this.state.directRendering) {
            SVG.SvgObject ref = this.document.resolveIRI(this.state.style.mask);
            this.duplicateCanvas();
            this.renderMask((SVG.Mask)ref, obj);
            Bitmap maskedContent = this.processMaskBitmaps();
            this.canvas = this.canvasStack.pop();
            this.canvas.save();
            this.canvas.setMatrix(new Matrix());
            this.canvas.drawBitmap(maskedContent, 0.0f, 0.0f, this.state.fillPaint);
            maskedContent.recycle();
            this.canvas.restore();
        }
        this.statePop();
    }

    private boolean requiresCompositing() {
        if (this.state.style.mask != null && !this.state.directRendering) {
            SVGAndroidRenderer.warn("Masks are not supported when using getPicture()", new Object[0]);
        }
        return this.state.style.opacity.floatValue() < 1.0f || this.state.style.mask != null && this.state.directRendering;
    }

    private void duplicateCanvas() {
        try {
            Bitmap newBM = Bitmap.createBitmap((int)this.canvas.getWidth(), (int)this.canvas.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.bitmapStack.push(newBM);
            Canvas newCanvas = new Canvas(newBM);
            newCanvas.setMatrix(this.canvas.getMatrix());
            this.canvas = newCanvas;
        }
        catch (OutOfMemoryError e) {
            SVGAndroidRenderer.error("Not enough memory to create temporary bitmaps for mask processing", new Object[0]);
            throw e;
        }
    }

    private Bitmap processMaskBitmaps() {
        Bitmap mask = this.bitmapStack.pop();
        Bitmap maskedContent = this.bitmapStack.pop();
        int w = mask.getWidth();
        int h = mask.getHeight();
        int[] maskBuf = new int[w];
        int[] maskedContentBuf = new int[w];
        for (int y = 0; y < h; ++y) {
            mask.getPixels(maskBuf, 0, w, 0, y, w, 1);
            maskedContent.getPixels(maskedContentBuf, 0, w, 0, y, w, 1);
            for (int x = 0; x < w; ++x) {
                int px = maskBuf[x];
                int b = px & 0xFF;
                int g = px >> 8 & 0xFF;
                int r = px >> 16 & 0xFF;
                int a = px >> 24 & 0xFF;
                if (a == 0) {
                    maskedContentBuf[x] = 0;
                    continue;
                }
                int maskAlpha = (r * 6963 + g * 23442 + b * 2362) * a / 8355840;
                int content = maskedContentBuf[x];
                int contentAlpha = content >> 24 & 0xFF;
                contentAlpha = contentAlpha * maskAlpha / 255;
                maskedContentBuf[x] = content & 0xFFFFFF | contentAlpha << 24;
            }
            maskedContent.setPixels(maskedContentBuf, 0, w, 0, y, w, 1);
        }
        mask.recycle();
        return maskedContent;
    }

    private void render(SVG.Switch obj) {
        SVGAndroidRenderer.debug("Switch render", new Object[0]);
        this.updateStyleForElement(this.state, obj);
        if (!this.display()) {
            return;
        }
        if (obj.transform != null) {
            this.canvas.concat(obj.transform);
        }
        this.checkForClipPath(obj);
        boolean compositing = this.pushLayer();
        this.renderSwitchChild(obj);
        if (compositing) {
            this.popLayer(obj);
        }
        this.updateParentBoundingBox(obj);
    }

    private void renderSwitchChild(SVG.Switch obj) {
        String deviceLanguage = Locale.getDefault().getLanguage();
        SVGExternalFileResolver fileResolver = this.document.getFileResolver();
        block0: for (SVG.SvgObject child : obj.getChildren()) {
            Set<String> reqfonts;
            Set<String> reqfmts;
            Set<String> syslang;
            SVG.SvgConditional condObj;
            if (!(child instanceof SVG.SvgConditional) || (condObj = (SVG.SvgConditional)((Object)child)).getRequiredExtensions() != null || (syslang = condObj.getSystemLanguage()) != null && (syslang.isEmpty() || !syslang.contains(deviceLanguage))) continue;
            Set<String> reqfeat = condObj.getRequiredFeatures();
            if (reqfeat != null) {
                if (supportedFeatures == null) {
                    SVGAndroidRenderer.initialiseSupportedFeaturesMap();
                }
                if (reqfeat.isEmpty() || !supportedFeatures.containsAll(reqfeat)) continue;
            }
            if ((reqfmts = condObj.getRequiredFormats()) != null) {
                if (reqfmts.isEmpty() || fileResolver == null) continue;
                for (String mimeType : reqfmts) {
                    if (fileResolver.isFormatSupported(mimeType)) continue;
                    continue block0;
                }
            }
            if ((reqfonts = condObj.getRequiredFonts()) != null) {
                if (reqfonts.isEmpty() || fileResolver == null) continue;
                for (String fontName : reqfonts) {
                    if (fileResolver.resolveFont(fontName, this.state.style.fontWeight, String.valueOf((Object)this.state.style.fontStyle)) != null) continue;
                    continue block0;
                }
            }
            this.render(child);
            break;
        }
    }

    private static synchronized void initialiseSupportedFeaturesMap() {
        supportedFeatures = new HashSet();
        supportedFeatures.add("Structure");
        supportedFeatures.add("BasicStructure");
        supportedFeatures.add("ConditionalProcessing");
        supportedFeatures.add("Image");
        supportedFeatures.add("Style");
        supportedFeatures.add("ViewportAttribute");
        supportedFeatures.add("Shape");
        supportedFeatures.add("BasicText");
        supportedFeatures.add("PaintAttribute");
        supportedFeatures.add("BasicPaintAttribute");
        supportedFeatures.add("OpacityAttribute");
        supportedFeatures.add("BasicGraphicsAttribute");
        supportedFeatures.add("Marker");
        supportedFeatures.add("Gradient");
        supportedFeatures.add("Pattern");
        supportedFeatures.add("Clip");
        supportedFeatures.add("BasicClip");
        supportedFeatures.add("Mask");
        supportedFeatures.add("View");
    }

    private void render(SVG.Use obj) {
        SVGAndroidRenderer.debug("Use render", new Object[0]);
        if (obj.width != null && obj.width.isZero() || obj.height != null && obj.height.isZero()) {
            return;
        }
        this.updateStyleForElement(this.state, obj);
        if (!this.display()) {
            return;
        }
        SVG.SvgObject ref = obj.document.resolveIRI(obj.href);
        if (ref == null) {
            SVGAndroidRenderer.error("Use reference '%s' not found", obj.href);
            return;
        }
        if (obj.transform != null) {
            this.canvas.concat(obj.transform);
        }
        Matrix m = new Matrix();
        float _x = obj.x != null ? obj.x.floatValueX(this) : 0.0f;
        float _y = obj.y != null ? obj.y.floatValueY(this) : 0.0f;
        m.preTranslate(_x, _y);
        this.canvas.concat(m);
        this.checkForClipPath(obj);
        boolean compositing = this.pushLayer();
        this.parentPush(obj);
        if (ref instanceof SVG.Svg) {
            this.statePush();
            SVG.Svg svgElem = (SVG.Svg)ref;
            SVG.Length _w = obj.width != null ? obj.width : svgElem.width;
            SVG.Length _h = obj.height != null ? obj.height : svgElem.height;
            this.render(svgElem, _w, _h);
            this.statePop();
        } else if (ref instanceof SVG.Symbol) {
            SVG.Length _w = obj.width != null ? obj.width : new SVG.Length(100.0f, SVG.Unit.percent);
            SVG.Length _h = obj.height != null ? obj.height : new SVG.Length(100.0f, SVG.Unit.percent);
            this.statePush();
            this.render((SVG.Symbol)ref, _w, _h);
            this.statePop();
        } else {
            this.render(ref);
        }
        this.parentPop();
        if (compositing) {
            this.popLayer(obj);
        }
        this.updateParentBoundingBox(obj);
    }

    private void render(SVG.Path obj) {
        SVGAndroidRenderer.debug("Path render", new Object[0]);
        if (obj.d == null) {
            return;
        }
        this.updateStyleForElement(this.state, obj);
        if (!this.display()) {
            return;
        }
        if (!this.visible()) {
            return;
        }
        if (!this.state.hasStroke && !this.state.hasFill) {
            return;
        }
        if (obj.transform != null) {
            this.canvas.concat(obj.transform);
        }
        Path path = new PathConverter(obj.d).getPath();
        if (obj.boundingBox == null) {
            obj.boundingBox = this.calculatePathBounds(path);
        }
        this.updateParentBoundingBox(obj);
        this.checkForGradiantsAndPatterns(obj);
        this.checkForClipPath(obj);
        boolean compositing = this.pushLayer();
        if (this.state.hasFill) {
            path.setFillType(this.getFillTypeFromState());
            this.doFilledPath(obj, path);
        }
        if (this.state.hasStroke) {
            this.doStroke(path);
        }
        this.renderMarkers(obj);
        if (compositing) {
            this.popLayer(obj);
        }
    }

    private SVG.Box calculatePathBounds(Path path) {
        RectF pathBounds = new RectF();
        path.computeBounds(pathBounds, true);
        return new SVG.Box(pathBounds.left, pathBounds.top, pathBounds.width(), pathBounds.height());
    }

    private void render(SVG.Rect obj) {
        SVGAndroidRenderer.debug("Rect render", new Object[0]);
        if (obj.width == null || obj.height == null || obj.width.isZero() || obj.height.isZero()) {
            return;
        }
        this.updateStyleForElement(this.state, obj);
        if (!this.display()) {
            return;
        }
        if (!this.visible()) {
            return;
        }
        if (obj.transform != null) {
            this.canvas.concat(obj.transform);
        }
        Path path = this.makePathAndBoundingBox(obj);
        this.updateParentBoundingBox(obj);
        this.checkForGradiantsAndPatterns(obj);
        this.checkForClipPath(obj);
        boolean compositing = this.pushLayer();
        if (this.state.hasFill) {
            this.doFilledPath(obj, path);
        }
        if (this.state.hasStroke) {
            this.doStroke(path);
        }
        if (compositing) {
            this.popLayer(obj);
        }
    }

    private void render(SVG.Circle obj) {
        SVGAndroidRenderer.debug("Circle render", new Object[0]);
        if (obj.r == null || obj.r.isZero()) {
            return;
        }
        this.updateStyleForElement(this.state, obj);
        if (!this.display()) {
            return;
        }
        if (!this.visible()) {
            return;
        }
        if (obj.transform != null) {
            this.canvas.concat(obj.transform);
        }
        Path path = this.makePathAndBoundingBox(obj);
        this.updateParentBoundingBox(obj);
        this.checkForGradiantsAndPatterns(obj);
        this.checkForClipPath(obj);
        boolean compositing = this.pushLayer();
        if (this.state.hasFill) {
            this.doFilledPath(obj, path);
        }
        if (this.state.hasStroke) {
            this.doStroke(path);
        }
        if (compositing) {
            this.popLayer(obj);
        }
    }

    private void render(SVG.Ellipse obj) {
        SVGAndroidRenderer.debug("Ellipse render", new Object[0]);
        if (obj.rx == null || obj.ry == null || obj.rx.isZero() || obj.ry.isZero()) {
            return;
        }
        this.updateStyleForElement(this.state, obj);
        if (!this.display()) {
            return;
        }
        if (!this.visible()) {
            return;
        }
        if (obj.transform != null) {
            this.canvas.concat(obj.transform);
        }
        Path path = this.makePathAndBoundingBox(obj);
        this.updateParentBoundingBox(obj);
        this.checkForGradiantsAndPatterns(obj);
        this.checkForClipPath(obj);
        boolean compositing = this.pushLayer();
        if (this.state.hasFill) {
            this.doFilledPath(obj, path);
        }
        if (this.state.hasStroke) {
            this.doStroke(path);
        }
        if (compositing) {
            this.popLayer(obj);
        }
    }

    private void render(SVG.Line obj) {
        SVGAndroidRenderer.debug("Line render", new Object[0]);
        this.updateStyleForElement(this.state, obj);
        if (!this.display()) {
            return;
        }
        if (!this.visible()) {
            return;
        }
        if (!this.state.hasStroke) {
            return;
        }
        if (obj.transform != null) {
            this.canvas.concat(obj.transform);
        }
        Path path = this.makePathAndBoundingBox(obj);
        this.updateParentBoundingBox(obj);
        this.checkForGradiantsAndPatterns(obj);
        this.checkForClipPath(obj);
        boolean compositing = this.pushLayer();
        this.doStroke(path);
        this.renderMarkers(obj);
        if (compositing) {
            this.popLayer(obj);
        }
    }

    private List<MarkerVector> calculateMarkerPositions(SVG.Line obj) {
        float _x1 = obj.x1 != null ? obj.x1.floatValueX(this) : 0.0f;
        float _y1 = obj.y1 != null ? obj.y1.floatValueY(this) : 0.0f;
        float _x2 = obj.x2 != null ? obj.x2.floatValueX(this) : 0.0f;
        float _y2 = obj.y2 != null ? obj.y2.floatValueY(this) : 0.0f;
        ArrayList<MarkerVector> markers = new ArrayList<MarkerVector>(2);
        markers.add(new MarkerVector(_x1, _y1, _x2 - _x1, _y2 - _y1));
        markers.add(new MarkerVector(_x2, _y2, _x2 - _x1, _y2 - _y1));
        return markers;
    }

    private void render(SVG.PolyLine obj) {
        int numPoints;
        SVGAndroidRenderer.debug("PolyLine render", new Object[0]);
        this.updateStyleForElement(this.state, obj);
        if (!this.display()) {
            return;
        }
        if (!this.visible()) {
            return;
        }
        if (!this.state.hasStroke && !this.state.hasFill) {
            return;
        }
        if (obj.transform != null) {
            this.canvas.concat(obj.transform);
        }
        if ((numPoints = obj.points.length) < 2) {
            return;
        }
        Path path = this.makePathAndBoundingBox(obj);
        this.updateParentBoundingBox(obj);
        this.checkForGradiantsAndPatterns(obj);
        this.checkForClipPath(obj);
        boolean compositing = this.pushLayer();
        if (this.state.hasFill) {
            this.doFilledPath(obj, path);
        }
        if (this.state.hasStroke) {
            this.doStroke(path);
        }
        this.renderMarkers(obj);
        if (compositing) {
            this.popLayer(obj);
        }
    }

    private List<MarkerVector> calculateMarkerPositions(SVG.PolyLine obj) {
        int numPoints = obj.points.length;
        if (numPoints < 2) {
            return null;
        }
        ArrayList<MarkerVector> markers = new ArrayList<MarkerVector>();
        MarkerVector lastPos = new MarkerVector(obj.points[0], obj.points[1], 0.0f, 0.0f);
        float x = 0.0f;
        float y = 0.0f;
        for (int i = 2; i < numPoints; i += 2) {
            MarkerVector newPos;
            x = obj.points[i];
            y = obj.points[i + 1];
            lastPos.add(x, y);
            markers.add(lastPos);
            lastPos = newPos = new MarkerVector(x, y, x - lastPos.x, y - lastPos.y);
        }
        if (obj instanceof SVG.Polygon) {
            if (x != obj.points[0] && y != obj.points[1]) {
                x = obj.points[0];
                y = obj.points[1];
                lastPos.add(x, y);
                markers.add(lastPos);
                MarkerVector newPos = new MarkerVector(x, y, x - lastPos.x, y - lastPos.y);
                newPos.add((MarkerVector)markers.get(0));
                markers.add(newPos);
                markers.set(0, newPos);
            }
        } else {
            markers.add(lastPos);
        }
        return markers;
    }

    private void render(SVG.Polygon obj) {
        int numPoints;
        SVGAndroidRenderer.debug("Polygon render", new Object[0]);
        this.updateStyleForElement(this.state, obj);
        if (!this.display()) {
            return;
        }
        if (!this.visible()) {
            return;
        }
        if (!this.state.hasStroke && !this.state.hasFill) {
            return;
        }
        if (obj.transform != null) {
            this.canvas.concat(obj.transform);
        }
        if ((numPoints = obj.points.length) < 2) {
            return;
        }
        Path path = this.makePathAndBoundingBox(obj);
        this.updateParentBoundingBox(obj);
        this.checkForGradiantsAndPatterns(obj);
        this.checkForClipPath(obj);
        boolean compositing = this.pushLayer();
        if (this.state.hasFill) {
            this.doFilledPath(obj, path);
        }
        if (this.state.hasStroke) {
            this.doStroke(path);
        }
        this.renderMarkers(obj);
        if (compositing) {
            this.popLayer(obj);
        }
    }

    private void render(SVG.Text obj) {
        SVGAndroidRenderer.debug("Text render", new Object[0]);
        this.updateStyleForElement(this.state, obj);
        if (!this.display()) {
            return;
        }
        if (obj.transform != null) {
            this.canvas.concat(obj.transform);
        }
        float x = obj.x == null || obj.x.size() == 0 ? 0.0f : ((SVG.Length)obj.x.get(0)).floatValueX(this);
        float y = obj.y == null || obj.y.size() == 0 ? 0.0f : ((SVG.Length)obj.y.get(0)).floatValueY(this);
        float dx = obj.dx == null || obj.dx.size() == 0 ? 0.0f : ((SVG.Length)obj.dx.get(0)).floatValueX(this);
        float dy = obj.dy == null || obj.dy.size() == 0 ? 0.0f : ((SVG.Length)obj.dy.get(0)).floatValueY(this);
        SVG.Style.TextAnchor anchor = this.getAnchorPosition();
        if (anchor != SVG.Style.TextAnchor.Start) {
            float textWidth = this.calculateTextWidth(obj);
            x = anchor == SVG.Style.TextAnchor.Middle ? (x -= textWidth / 2.0f) : (x -= textWidth);
        }
        if (obj.boundingBox == null) {
            TextBoundsCalculator proc = new TextBoundsCalculator(x, y);
            this.enumerateTextSpans(obj, proc);
            obj.boundingBox = new SVG.Box(proc.bbox.left, proc.bbox.top, proc.bbox.width(), proc.bbox.height());
        }
        this.updateParentBoundingBox(obj);
        this.checkForGradiantsAndPatterns(obj);
        this.checkForClipPath(obj);
        boolean compositing = this.pushLayer();
        this.enumerateTextSpans(obj, new PlainTextDrawer(x + dx, y + dy));
        if (compositing) {
            this.popLayer(obj);
        }
    }

    private SVG.Style.TextAnchor getAnchorPosition() {
        if (this.state.style.direction == SVG.Style.TextDirection.LTR || this.state.style.textAnchor == SVG.Style.TextAnchor.Middle) {
            return this.state.style.textAnchor;
        }
        return this.state.style.textAnchor == SVG.Style.TextAnchor.Start ? SVG.Style.TextAnchor.End : SVG.Style.TextAnchor.Start;
    }

    private void enumerateTextSpans(SVG.TextContainer obj, TextProcessor textprocessor) {
        if (!this.display()) {
            return;
        }
        Iterator iter = obj.children.iterator();
        boolean isFirstChild = true;
        while (iter.hasNext()) {
            SVG.SvgObject child = (SVG.SvgObject)iter.next();
            if (child instanceof SVG.TextSequence) {
                textprocessor.processText(this.textXMLSpaceTransform(((SVG.TextSequence)child).text, isFirstChild, !iter.hasNext()));
            } else {
                this.processTextChild(child, textprocessor);
            }
            isFirstChild = false;
        }
    }

    private void processTextChild(SVG.SvgObject obj, TextProcessor textprocessor) {
        if (!textprocessor.doTextContainer((SVG.TextContainer)obj)) {
            return;
        }
        if (obj instanceof SVG.TextPath) {
            this.statePush();
            this.renderTextPath((SVG.TextPath)obj);
            this.statePop();
        } else if (obj instanceof SVG.TSpan) {
            SVGAndroidRenderer.debug("TSpan render", new Object[0]);
            this.statePush();
            SVG.TSpan tspan = (SVG.TSpan)obj;
            this.updateStyleForElement(this.state, tspan);
            if (this.display()) {
                float x = 0.0f;
                float y = 0.0f;
                float dx = 0.0f;
                float dy = 0.0f;
                if (textprocessor instanceof PlainTextDrawer) {
                    x = tspan.x == null || tspan.x.size() == 0 ? ((PlainTextDrawer)textprocessor).x : ((SVG.Length)tspan.x.get(0)).floatValueX(this);
                    y = tspan.y == null || tspan.y.size() == 0 ? ((PlainTextDrawer)textprocessor).y : ((SVG.Length)tspan.y.get(0)).floatValueY(this);
                    dx = tspan.dx == null || tspan.dx.size() == 0 ? 0.0f : ((SVG.Length)tspan.dx.get(0)).floatValueX(this);
                    dy = tspan.dy == null || tspan.dy.size() == 0 ? 0.0f : ((SVG.Length)tspan.dy.get(0)).floatValueY(this);
                }
                this.checkForGradiantsAndPatterns((SVG.SvgElement)((Object)tspan.getTextRoot()));
                if (textprocessor instanceof PlainTextDrawer) {
                    ((PlainTextDrawer)textprocessor).x = x + dx;
                    ((PlainTextDrawer)textprocessor).y = y + dy;
                }
                boolean compositing = this.pushLayer();
                this.enumerateTextSpans(tspan, textprocessor);
                if (compositing) {
                    this.popLayer(tspan);
                }
            }
            this.statePop();
        } else if (obj instanceof SVG.TRef) {
            this.statePush();
            SVG.TRef tref = (SVG.TRef)obj;
            this.updateStyleForElement(this.state, tref);
            if (this.display()) {
                this.checkForGradiantsAndPatterns((SVG.SvgElement)((Object)tref.getTextRoot()));
                SVG.SvgObject ref = obj.document.resolveIRI(tref.href);
                if (ref != null && ref instanceof SVG.TextContainer) {
                    StringBuilder str = new StringBuilder();
                    this.extractRawText((SVG.TextContainer)ref, str);
                    if (str.length() > 0) {
                        textprocessor.processText(str.toString());
                    }
                } else {
                    SVGAndroidRenderer.error("Tref reference '%s' not found", tref.href);
                }
            }
            this.statePop();
        }
    }

    private void renderTextPath(SVG.TextPath obj) {
        SVGAndroidRenderer.debug("TextPath render", new Object[0]);
        this.updateStyleForElement(this.state, obj);
        if (!this.display()) {
            return;
        }
        if (!this.visible()) {
            return;
        }
        SVG.SvgObject ref = obj.document.resolveIRI(obj.href);
        if (ref == null) {
            SVGAndroidRenderer.error("TextPath reference '%s' not found", obj.href);
            return;
        }
        SVG.Path pathObj = (SVG.Path)ref;
        Path path = new PathConverter(pathObj.d).getPath();
        if (pathObj.transform != null) {
            path.transform(pathObj.transform);
        }
        PathMeasure measure = new PathMeasure(path, false);
        float startOffset = obj.startOffset != null ? obj.startOffset.floatValue(this, measure.getLength()) : 0.0f;
        SVG.Style.TextAnchor anchor = this.getAnchorPosition();
        if (anchor != SVG.Style.TextAnchor.Start) {
            float textWidth = this.calculateTextWidth(obj);
            startOffset = anchor == SVG.Style.TextAnchor.Middle ? (startOffset -= textWidth / 2.0f) : (startOffset -= textWidth);
        }
        this.checkForGradiantsAndPatterns((SVG.SvgElement)((Object)obj.getTextRoot()));
        boolean compositing = this.pushLayer();
        this.enumerateTextSpans(obj, new PathTextDrawer(path, startOffset, 0.0f));
        if (compositing) {
            this.popLayer(obj);
        }
    }

    private float calculateTextWidth(SVG.TextContainer parentTextObj) {
        TextWidthCalculator proc = new TextWidthCalculator();
        this.enumerateTextSpans(parentTextObj, proc);
        return proc.x;
    }

    private void extractRawText(SVG.TextContainer parent, StringBuilder str) {
        Iterator iter = parent.children.iterator();
        boolean isFirstChild = true;
        while (iter.hasNext()) {
            SVG.SvgObject child = (SVG.SvgObject)iter.next();
            if (child instanceof SVG.TextContainer) {
                this.extractRawText((SVG.TextContainer)child, str);
            } else if (child instanceof SVG.TextSequence) {
                str.append(this.textXMLSpaceTransform(((SVG.TextSequence)child).text, isFirstChild, !iter.hasNext()));
            }
            isFirstChild = false;
        }
    }

    private String textXMLSpaceTransform(String text, boolean isFirstChild, boolean isLastChild) {
        if (this.state.spacePreserve) {
            return text.replaceAll("[\\n\\t]", " ");
        }
        text = text.replaceAll("\\n", "");
        text = text.replaceAll("\\t", " ");
        if (isFirstChild) {
            text = text.replaceAll("^\\s+", "");
        }
        if (isLastChild) {
            text = text.replaceAll("\\s+$", "");
        }
        return text.replaceAll("\\s{2,}", " ");
    }

    private void render(SVG.Symbol obj, SVG.Length width, SVG.Length height) {
        SVGAndroidRenderer.debug("Symbol render", new Object[0]);
        if (width != null && width.isZero() || height != null && height.isZero()) {
            return;
        }
        PreserveAspectRatio positioning = obj.preserveAspectRatio != null ? obj.preserveAspectRatio : PreserveAspectRatio.LETTERBOX;
        this.updateStyleForElement(this.state, obj);
        float _w = width != null ? width.floatValueX(this) : this.state.viewPort.width;
        float _h = height != null ? height.floatValueX(this) : this.state.viewPort.height;
        this.state.viewPort = new SVG.Box(0.0f, 0.0f, _w, _h);
        if (!this.state.style.overflow.booleanValue()) {
            this.setClipRect(this.state.viewPort.minX, this.state.viewPort.minY, this.state.viewPort.width, this.state.viewPort.height);
        }
        if (obj.viewBox != null) {
            this.canvas.concat(this.calculateViewBoxTransform(this.state.viewPort, obj.viewBox, positioning));
            this.state.viewBox = obj.viewBox;
        }
        boolean compositing = this.pushLayer();
        this.renderChildren(obj, true);
        if (compositing) {
            this.popLayer(obj);
        }
        this.updateParentBoundingBox(obj);
    }

    private void render(SVG.Image obj) {
        SVGAndroidRenderer.debug("Image render", new Object[0]);
        if (obj.width == null || obj.width.isZero() || obj.height == null || obj.height.isZero()) {
            return;
        }
        if (obj.href == null) {
            return;
        }
        PreserveAspectRatio positioning = obj.preserveAspectRatio != null ? obj.preserveAspectRatio : PreserveAspectRatio.LETTERBOX;
        Bitmap image = this.checkForImageDataURL(obj.href);
        if (image == null) {
            SVGExternalFileResolver fileResolver = this.document.getFileResolver();
            if (fileResolver == null) {
                return;
            }
            image = fileResolver.resolveImage(obj.href);
        }
        if (image == null) {
            SVGAndroidRenderer.error("Could not locate image '%s'", obj.href);
            return;
        }
        this.updateStyleForElement(this.state, obj);
        if (!this.display()) {
            return;
        }
        if (!this.visible()) {
            return;
        }
        if (obj.transform != null) {
            this.canvas.concat(obj.transform);
        }
        float _x = obj.x != null ? obj.x.floatValueX(this) : 0.0f;
        float _y = obj.y != null ? obj.y.floatValueY(this) : 0.0f;
        float _w = obj.width.floatValueX(this);
        float _h = obj.height.floatValueX(this);
        this.state.viewPort = new SVG.Box(_x, _y, _w, _h);
        if (!this.state.style.overflow.booleanValue()) {
            this.setClipRect(this.state.viewPort.minX, this.state.viewPort.minY, this.state.viewPort.width, this.state.viewPort.height);
        }
        obj.boundingBox = new SVG.Box(0.0f, 0.0f, image.getWidth(), image.getHeight());
        this.canvas.concat(this.calculateViewBoxTransform(this.state.viewPort, obj.boundingBox, positioning));
        this.updateParentBoundingBox(obj);
        this.checkForClipPath(obj);
        boolean compositing = this.pushLayer();
        this.viewportFill();
        this.canvas.drawBitmap(image, 0.0f, 0.0f, new Paint());
        if (compositing) {
            this.popLayer(obj);
        }
    }

    private Bitmap checkForImageDataURL(String url) {
        if (!url.startsWith("data:")) {
            return null;
        }
        if (url.length() < 14) {
            return null;
        }
        int comma = url.indexOf(44);
        if (comma == -1 || comma < 12) {
            return null;
        }
        if (!";base64".equals(url.substring(comma - 7, comma))) {
            return null;
        }
        byte[] imageData = Base64.decode((String)url.substring(comma + 1), (int)0);
        return BitmapFactory.decodeByteArray((byte[])imageData, (int)0, (int)imageData.length);
    }

    private boolean display() {
        if (this.state.style.display != null) {
            return this.state.style.display;
        }
        return true;
    }

    private boolean visible() {
        if (this.state.style.visibility != null) {
            return this.state.style.visibility;
        }
        return true;
    }

    private Matrix calculateViewBoxTransform(SVG.Box viewPort, SVG.Box viewBox, PreserveAspectRatio positioning) {
        Matrix m = new Matrix();
        if (positioning == null || positioning.getAlignment() == null) {
            return m;
        }
        float xScale = viewPort.width / viewBox.width;
        float yScale = viewPort.height / viewBox.height;
        float xOffset = -viewBox.minX;
        float yOffset = -viewBox.minY;
        if (positioning.equals(PreserveAspectRatio.STRETCH)) {
            m.preTranslate(viewPort.minX, viewPort.minY);
            m.preScale(xScale, yScale);
            m.preTranslate(xOffset, yOffset);
            return m;
        }
        float scale = positioning.getScale() == PreserveAspectRatio.Scale.Slice ? Math.max(xScale, yScale) : Math.min(xScale, yScale);
        float imageW = viewPort.width / scale;
        float imageH = viewPort.height / scale;
        switch (positioning.getAlignment()) {
            case XMidYMin: 
            case XMidYMid: 
            case XMidYMax: {
                xOffset -= (viewBox.width - imageW) / 2.0f;
                break;
            }
            case XMaxYMin: 
            case XMaxYMid: 
            case XMaxYMax: {
                xOffset -= viewBox.width - imageW;
                break;
            }
        }
        switch (positioning.getAlignment()) {
            case XMidYMid: 
            case XMaxYMid: 
            case XMinYMid: {
                yOffset -= (viewBox.height - imageH) / 2.0f;
                break;
            }
            case XMidYMax: 
            case XMaxYMax: 
            case XMinYMax: {
                yOffset -= viewBox.height - imageH;
                break;
            }
        }
        m.preTranslate(viewPort.minX, viewPort.minY);
        m.preScale(scale, scale);
        m.preTranslate(xOffset, yOffset);
        return m;
    }

    private boolean isSpecified(SVG.Style style2, long flag) {
        return (style2.specifiedFlags & flag) != 0L;
    }

    private void updateStyle(RendererState state, SVG.Style style2) {
        if (this.isSpecified(style2, 4096L)) {
            state.style.color = style2.color;
        }
        if (this.isSpecified(style2, 2048L)) {
            state.style.opacity = style2.opacity;
        }
        if (this.isSpecified(style2, 1L)) {
            state.style.fill = style2.fill;
            boolean bl = state.hasFill = style2.fill != null;
        }
        if (this.isSpecified(style2, 4L)) {
            state.style.fillOpacity = style2.fillOpacity;
        }
        if (this.isSpecified(style2, 6149L)) {
            this.setPaintColour(state, true, state.style.fill);
        }
        if (this.isSpecified(style2, 2L)) {
            state.style.fillRule = style2.fillRule;
        }
        if (this.isSpecified(style2, 8L)) {
            state.style.stroke = style2.stroke;
            boolean bl = state.hasStroke = style2.stroke != null;
        }
        if (this.isSpecified(style2, 16L)) {
            state.style.strokeOpacity = style2.strokeOpacity;
        }
        if (this.isSpecified(style2, 6168L)) {
            this.setPaintColour(state, false, state.style.stroke);
        }
        if (this.isSpecified(style2, 0x800000000L)) {
            state.style.vectorEffect = style2.vectorEffect;
        }
        if (this.isSpecified(style2, 32L)) {
            state.style.strokeWidth = style2.strokeWidth;
            state.strokePaint.setStrokeWidth(state.style.strokeWidth.floatValue(this));
        }
        if (this.isSpecified(style2, 64L)) {
            state.style.strokeLineCap = style2.strokeLineCap;
            switch (style2.strokeLineCap) {
                case Butt: {
                    state.strokePaint.setStrokeCap(Paint.Cap.BUTT);
                    break;
                }
                case Round: {
                    state.strokePaint.setStrokeCap(Paint.Cap.ROUND);
                    break;
                }
                case Square: {
                    state.strokePaint.setStrokeCap(Paint.Cap.SQUARE);
                    break;
                }
            }
        }
        if (this.isSpecified(style2, 128L)) {
            state.style.strokeLineJoin = style2.strokeLineJoin;
            switch (style2.strokeLineJoin) {
                case Miter: {
                    state.strokePaint.setStrokeJoin(Paint.Join.MITER);
                    break;
                }
                case Round: {
                    state.strokePaint.setStrokeJoin(Paint.Join.ROUND);
                    break;
                }
                case Bevel: {
                    state.strokePaint.setStrokeJoin(Paint.Join.BEVEL);
                    break;
                }
            }
        }
        if (this.isSpecified(style2, 256L)) {
            state.style.strokeMiterLimit = style2.strokeMiterLimit;
            state.strokePaint.setStrokeMiter(style2.strokeMiterLimit.floatValue());
        }
        if (this.isSpecified(style2, 512L)) {
            state.style.strokeDashArray = style2.strokeDashArray;
        }
        if (this.isSpecified(style2, 1024L)) {
            state.style.strokeDashOffset = style2.strokeDashOffset;
        }
        if (this.isSpecified(style2, 1536L)) {
            if (state.style.strokeDashArray == null) {
                state.strokePaint.setPathEffect(null);
            } else {
                float intervalSum = 0.0f;
                int n = state.style.strokeDashArray.length;
                int arrayLen = n % 2 == 0 ? n : n * 2;
                float[] intervals = new float[arrayLen];
                for (int i = 0; i < arrayLen; ++i) {
                    intervals[i] = state.style.strokeDashArray[i % n].floatValue(this);
                    intervalSum += intervals[i];
                }
                if (intervalSum == 0.0f) {
                    state.strokePaint.setPathEffect(null);
                } else {
                    float offset = state.style.strokeDashOffset.floatValue(this);
                    if (offset < 0.0f) {
                        offset = intervalSum + offset % intervalSum;
                    }
                    state.strokePaint.setPathEffect((PathEffect)new DashPathEffect(intervals, offset));
                }
            }
        }
        if (this.isSpecified(style2, 16384L)) {
            float currentFontSize = this.getCurrentFontSize();
            state.style.fontSize = style2.fontSize;
            state.fillPaint.setTextSize(style2.fontSize.floatValue(this, currentFontSize));
            state.strokePaint.setTextSize(style2.fontSize.floatValue(this, currentFontSize));
        }
        if (this.isSpecified(style2, 8192L)) {
            state.style.fontFamily = style2.fontFamily;
        }
        if (this.isSpecified(style2, 32768L)) {
            if (style2.fontWeight == -1 && state.style.fontWeight > 100) {
                SVG.Style currentFontSize = state.style;
                currentFontSize.fontWeight = currentFontSize.fontWeight - 100;
            } else if (style2.fontWeight == 1 && state.style.fontWeight < 900) {
                SVG.Style currentFontSize = state.style;
                currentFontSize.fontWeight = currentFontSize.fontWeight + 100;
            } else {
                state.style.fontWeight = style2.fontWeight;
            }
        }
        if (this.isSpecified(style2, 65536L)) {
            state.style.fontStyle = style2.fontStyle;
        }
        if (this.isSpecified(style2, 106496L)) {
            SVGExternalFileResolver fileResolver = null;
            Typeface font = null;
            if (state.style.fontFamily != null && this.document != null) {
                fileResolver = this.document.getFileResolver();
                for (String fontName : state.style.fontFamily) {
                    font = this.checkGenericFont(fontName, state.style.fontWeight, state.style.fontStyle);
                    if (font == null && fileResolver != null) {
                        font = fileResolver.resolveFont(fontName, state.style.fontWeight, String.valueOf((Object)state.style.fontStyle));
                    }
                    if (font == null) continue;
                    break;
                }
            }
            if (font == null) {
                font = this.checkGenericFont(DEFAULT_FONT_FAMILY, state.style.fontWeight, state.style.fontStyle);
            }
            state.fillPaint.setTypeface(font);
            state.strokePaint.setTypeface(font);
        }
        if (this.isSpecified(style2, 131072L)) {
            state.style.textDecoration = style2.textDecoration;
            state.fillPaint.setStrikeThruText(style2.textDecoration == SVG.Style.TextDecoration.LineThrough);
            state.fillPaint.setUnderlineText(style2.textDecoration == SVG.Style.TextDecoration.Underline);
            if (Build.VERSION.SDK_INT >= 17) {
                state.strokePaint.setStrikeThruText(style2.textDecoration == SVG.Style.TextDecoration.LineThrough);
                state.strokePaint.setUnderlineText(style2.textDecoration == SVG.Style.TextDecoration.Underline);
            }
        }
        if (this.isSpecified(style2, 0x1000000000L)) {
            state.style.direction = style2.direction;
        }
        if (this.isSpecified(style2, 262144L)) {
            state.style.textAnchor = style2.textAnchor;
        }
        if (this.isSpecified(style2, 524288L)) {
            state.style.overflow = style2.overflow;
        }
        if (this.isSpecified(style2, 0x200000L)) {
            state.style.markerStart = style2.markerStart;
        }
        if (this.isSpecified(style2, 0x400000L)) {
            state.style.markerMid = style2.markerMid;
        }
        if (this.isSpecified(style2, 0x800000L)) {
            state.style.markerEnd = style2.markerEnd;
        }
        if (this.isSpecified(style2, 0x1000000L)) {
            state.style.display = style2.display;
        }
        if (this.isSpecified(style2, 0x2000000L)) {
            state.style.visibility = style2.visibility;
        }
        if (this.isSpecified(style2, 0x100000L)) {
            state.style.clip = style2.clip;
        }
        if (this.isSpecified(style2, 0x10000000L)) {
            state.style.clipPath = style2.clipPath;
        }
        if (this.isSpecified(style2, 0x20000000L)) {
            state.style.clipRule = style2.clipRule;
        }
        if (this.isSpecified(style2, 0x40000000L)) {
            state.style.mask = style2.mask;
        }
        if (this.isSpecified(style2, 0x4000000L)) {
            state.style.stopColor = style2.stopColor;
        }
        if (this.isSpecified(style2, 0x8000000L)) {
            state.style.stopOpacity = style2.stopOpacity;
        }
        if (this.isSpecified(style2, 0x200000000L)) {
            state.style.viewportFill = style2.viewportFill;
        }
        if (this.isSpecified(style2, 0x400000000L)) {
            state.style.viewportFillOpacity = style2.viewportFillOpacity;
        }
    }

    private void setPaintColour(RendererState state, boolean isFill, SVG.SvgPaint paint) {
        int col;
        float paintOpacity = (isFill ? state.style.fillOpacity : state.style.strokeOpacity).floatValue();
        if (paint instanceof SVG.Colour) {
            col = ((SVG.Colour)paint).colour;
        } else if (paint instanceof SVG.CurrentColor) {
            col = state.style.color.colour;
        } else {
            return;
        }
        col = this.clamp255(paintOpacity) << 24 | col;
        if (isFill) {
            state.fillPaint.setColor(col);
        } else {
            state.strokePaint.setColor(col);
        }
    }

    private Typeface checkGenericFont(String fontName, Integer fontWeight, SVG.Style.FontStyle fontStyle) {
        int typefaceStyle;
        boolean italic;
        Typeface font = null;
        boolean bl = italic = fontStyle == SVG.Style.FontStyle.Italic;
        int n = fontWeight > 500 ? (italic ? 3 : 1) : (typefaceStyle = italic ? 2 : 0);
        if (fontName.equals("serif")) {
            font = Typeface.create((Typeface)Typeface.SERIF, (int)typefaceStyle);
        } else if (fontName.equals(DEFAULT_FONT_FAMILY)) {
            font = Typeface.create((Typeface)Typeface.SANS_SERIF, (int)typefaceStyle);
        } else if (fontName.equals("monospace")) {
            font = Typeface.create((Typeface)Typeface.MONOSPACE, (int)typefaceStyle);
        } else if (fontName.equals("cursive")) {
            font = Typeface.create((Typeface)Typeface.SANS_SERIF, (int)typefaceStyle);
        } else if (fontName.equals("fantasy")) {
            font = Typeface.create((Typeface)Typeface.SANS_SERIF, (int)typefaceStyle);
        }
        return font;
    }

    private int clamp255(float val) {
        int i = (int)(val * 256.0f);
        return i < 0 ? 0 : (i > 255 ? 255 : i);
    }

    private Path.FillType getFillTypeFromState() {
        if (this.state.style.fillRule == null) {
            return Path.FillType.WINDING;
        }
        switch (this.state.style.fillRule) {
            case EvenOdd: {
                return Path.FillType.EVEN_ODD;
            }
        }
        return Path.FillType.WINDING;
    }

    private void setClipRect(float minX, float minY, float width, float height) {
        float left = minX;
        float top = minY;
        float right = minX + width;
        float bottom = minY + height;
        if (this.state.style.clip != null) {
            left += this.state.style.clip.left.floatValueX(this);
            top += this.state.style.clip.top.floatValueY(this);
            right -= this.state.style.clip.right.floatValueX(this);
            bottom -= this.state.style.clip.bottom.floatValueY(this);
        }
        this.canvas.clipRect(left, top, right, bottom);
    }

    private void viewportFill() {
        int col;
        if (this.state.style.viewportFill instanceof SVG.Colour) {
            col = ((SVG.Colour)this.state.style.viewportFill).colour;
        } else if (this.state.style.viewportFill instanceof SVG.CurrentColor) {
            col = this.state.style.color.colour;
        } else {
            return;
        }
        if (this.state.style.viewportFillOpacity != null) {
            col = this.clamp255(this.state.style.viewportFillOpacity.floatValue()) << 24 | col;
        }
        this.canvas.drawColor(col);
    }

    private static void arcTo(float lastX, float lastY, float rx, float ry, float angle, boolean largeArcFlag, boolean sweepFlag, float x, float y, SVG.PathInterface pather) {
        double ry_sq;
        double y1;
        double y1_sq;
        double rx_sq;
        double dy2;
        double sinAngle;
        double dx2;
        if (lastX == x && lastY == y) {
            return;
        }
        if (rx == 0.0f || ry == 0.0f) {
            pather.lineTo(x, y);
            return;
        }
        rx = Math.abs(rx);
        ry = Math.abs(ry);
        float angleRad = (float)Math.toRadians((double)angle % 360.0);
        double cosAngle = Math.cos(angleRad);
        double x1 = cosAngle * (dx2 = (double)(lastX - x) / 2.0) + (sinAngle = Math.sin(angleRad)) * (dy2 = (double)(lastY - y) / 2.0);
        double x1_sq = x1 * x1;
        double radiiCheck = x1_sq / (rx_sq = (double)(rx * rx)) + (y1_sq = (y1 = -sinAngle * dx2 + cosAngle * dy2) * y1) / (ry_sq = (double)(ry * ry));
        if (radiiCheck > 1.0) {
            rx = (float)Math.sqrt(radiiCheck) * rx;
            ry = (float)Math.sqrt(radiiCheck) * ry;
            rx_sq = rx * rx;
            ry_sq = ry * ry;
        }
        double sign = largeArcFlag == sweepFlag ? -1.0 : 1.0;
        double sq = (rx_sq * ry_sq - rx_sq * y1_sq - ry_sq * x1_sq) / (rx_sq * y1_sq + ry_sq * x1_sq);
        sq = sq < 0.0 ? 0.0 : sq;
        double coef = sign * Math.sqrt(sq);
        double cx1 = coef * ((double)rx * y1 / (double)ry);
        double cy1 = coef * -((double)ry * x1 / (double)rx);
        double sx2 = (double)(lastX + x) / 2.0;
        double sy2 = (double)(lastY + y) / 2.0;
        double cx = sx2 + (cosAngle * cx1 - sinAngle * cy1);
        double cy = sy2 + (sinAngle * cx1 + cosAngle * cy1);
        double ux = (x1 - cx1) / (double)rx;
        double uy = (y1 - cy1) / (double)ry;
        double vx = (-x1 - cx1) / (double)rx;
        double vy = (-y1 - cy1) / (double)ry;
        double n = Math.sqrt(ux * ux + uy * uy);
        double p = ux;
        sign = uy < 0.0 ? -1.0 : 1.0;
        double angleStart = Math.toDegrees(sign * Math.acos(p / n));
        n = Math.sqrt((ux * ux + uy * uy) * (vx * vx + vy * vy));
        p = ux * vx + uy * vy;
        sign = ux * vy - uy * vx < 0.0 ? -1.0 : 1.0;
        double angleExtent = Math.toDegrees(sign * Math.acos(p / n));
        if (!sweepFlag && angleExtent > 0.0) {
            angleExtent -= 360.0;
        } else if (sweepFlag && angleExtent < 0.0) {
            angleExtent += 360.0;
        }
        float[] bezierPoints = SVGAndroidRenderer.arcToBeziers(angleStart %= 360.0, angleExtent %= 360.0);
        Matrix m = new Matrix();
        m.postScale(rx, ry);
        m.postRotate(angle);
        m.postTranslate((float)cx, (float)cy);
        m.mapPoints(bezierPoints);
        bezierPoints[bezierPoints.length - 2] = x;
        bezierPoints[bezierPoints.length - 1] = y;
        for (int i = 0; i < bezierPoints.length; i += 6) {
            pather.cubicTo(bezierPoints[i], bezierPoints[i + 1], bezierPoints[i + 2], bezierPoints[i + 3], bezierPoints[i + 4], bezierPoints[i + 5]);
        }
    }

    private static float[] arcToBeziers(double angleStart, double angleExtent) {
        int numSegments = (int)Math.ceil(Math.abs(angleExtent) / 90.0);
        angleStart = Math.toRadians(angleStart);
        angleExtent = Math.toRadians(angleExtent);
        float angleIncrement = (float)(angleExtent / (double)numSegments);
        double controlLength = 1.3333333333333333 * Math.sin((double)angleIncrement / 2.0) / (1.0 + Math.cos((double)angleIncrement / 2.0));
        float[] coords = new float[numSegments * 6];
        int pos = 0;
        for (int i = 0; i < numSegments; ++i) {
            double angle = angleStart + (double)((float)i * angleIncrement);
            double dx = Math.cos(angle);
            double dy = Math.sin(angle);
            coords[pos++] = (float)(dx - controlLength * dy);
            coords[pos++] = (float)(dy + controlLength * dx);
            dx = Math.cos(angle += (double)angleIncrement);
            dy = Math.sin(angle);
            coords[pos++] = (float)(dx + controlLength * dy);
            coords[pos++] = (float)(dy - controlLength * dx);
            coords[pos++] = (float)dx;
            coords[pos++] = (float)dy;
        }
        return coords;
    }

    private void renderMarkers(SVG.GraphicsElement obj) {
        SVG.SvgObject ref;
        if (this.state.style.markerStart == null && this.state.style.markerMid == null && this.state.style.markerEnd == null) {
            return;
        }
        SVG.Marker _markerStart = null;
        SVG.Marker _markerMid = null;
        SVG.Marker _markerEnd = null;
        if (this.state.style.markerStart != null) {
            ref = obj.document.resolveIRI(this.state.style.markerStart);
            if (ref != null) {
                _markerStart = (SVG.Marker)ref;
            } else {
                SVGAndroidRenderer.error("Marker reference '%s' not found", this.state.style.markerStart);
            }
        }
        if (this.state.style.markerMid != null) {
            ref = obj.document.resolveIRI(this.state.style.markerMid);
            if (ref != null) {
                _markerMid = (SVG.Marker)ref;
            } else {
                SVGAndroidRenderer.error("Marker reference '%s' not found", this.state.style.markerMid);
            }
        }
        if (this.state.style.markerEnd != null) {
            ref = obj.document.resolveIRI(this.state.style.markerEnd);
            if (ref != null) {
                _markerEnd = (SVG.Marker)ref;
            } else {
                SVGAndroidRenderer.error("Marker reference '%s' not found", this.state.style.markerEnd);
            }
        }
        List<MarkerVector> markers = null;
        markers = obj instanceof SVG.Path ? new MarkerPositionCalculator(((SVG.Path)obj).d).getMarkers() : (obj instanceof SVG.Line ? this.calculateMarkerPositions((SVG.Line)obj) : this.calculateMarkerPositions((SVG.PolyLine)obj));
        if (markers == null) {
            return;
        }
        int markerCount = markers.size();
        if (markerCount == 0) {
            return;
        }
        this.state.style.markerEnd = null;
        this.state.style.markerMid = null;
        this.state.style.markerStart = null;
        if (_markerStart != null) {
            this.renderMarker(_markerStart, markers.get(0));
        }
        if (_markerMid != null) {
            for (int i = 1; i < markerCount - 1; ++i) {
                this.renderMarker(_markerMid, markers.get(i));
            }
        }
        if (_markerEnd != null) {
            this.renderMarker(_markerEnd, markers.get(markerCount - 1));
        }
    }

    private void renderMarker(SVG.Marker marker, MarkerVector pos) {
        float _markerHeight;
        float angle = 0.0f;
        this.statePush();
        if (marker.orient != null) {
            if (Float.isNaN(marker.orient.floatValue())) {
                if (pos.dx != 0.0f || pos.dy != 0.0f) {
                    angle = (float)Math.toDegrees(Math.atan2(pos.dy, pos.dx));
                }
            } else {
                angle = marker.orient.floatValue();
            }
        }
        float unitsScale = marker.markerUnitsAreUser ? 1.0f : this.state.style.strokeWidth.floatValue(this.dpi);
        this.state = this.findInheritFromAncestorState(marker);
        Matrix m = new Matrix();
        m.preTranslate(pos.x, pos.y);
        m.preRotate(angle);
        m.preScale(unitsScale, unitsScale);
        float _refX = marker.refX != null ? marker.refX.floatValueX(this) : 0.0f;
        float _refY = marker.refY != null ? marker.refY.floatValueY(this) : 0.0f;
        float _markerWidth = marker.markerWidth != null ? marker.markerWidth.floatValueX(this) : 3.0f;
        float f = _markerHeight = marker.markerHeight != null ? marker.markerHeight.floatValueY(this) : 3.0f;
        if (marker.viewBox != null) {
            PreserveAspectRatio positioning;
            float xScale = _markerWidth / marker.viewBox.width;
            float yScale = _markerHeight / marker.viewBox.height;
            PreserveAspectRatio preserveAspectRatio = positioning = marker.preserveAspectRatio != null ? marker.preserveAspectRatio : PreserveAspectRatio.LETTERBOX;
            if (!positioning.equals(PreserveAspectRatio.STRETCH)) {
                float aspectScale;
                xScale = yScale = (aspectScale = positioning.getScale() == PreserveAspectRatio.Scale.Slice ? Math.max(xScale, yScale) : Math.min(xScale, yScale));
            }
            m.preTranslate(-_refX * xScale, -_refY * yScale);
            this.canvas.concat(m);
            float imageW = marker.viewBox.width * xScale;
            float imageH = marker.viewBox.height * yScale;
            float xOffset = 0.0f;
            float yOffset = 0.0f;
            switch (positioning.getAlignment()) {
                case XMidYMin: 
                case XMidYMid: 
                case XMidYMax: {
                    xOffset -= (_markerWidth - imageW) / 2.0f;
                    break;
                }
                case XMaxYMin: 
                case XMaxYMid: 
                case XMaxYMax: {
                    xOffset -= _markerWidth - imageW;
                    break;
                }
            }
            switch (positioning.getAlignment()) {
                case XMidYMid: 
                case XMaxYMid: 
                case XMinYMid: {
                    yOffset -= (_markerHeight - imageH) / 2.0f;
                    break;
                }
                case XMidYMax: 
                case XMaxYMax: 
                case XMinYMax: {
                    yOffset -= _markerHeight - imageH;
                    break;
                }
            }
            if (!this.state.style.overflow.booleanValue()) {
                this.setClipRect(xOffset, yOffset, _markerWidth, _markerHeight);
            }
            m.reset();
            m.preScale(xScale, yScale);
            this.canvas.concat(m);
        } else {
            m.preTranslate(-_refX, -_refY);
            this.canvas.concat(m);
            if (!this.state.style.overflow.booleanValue()) {
                this.setClipRect(0.0f, 0.0f, _markerWidth, _markerHeight);
            }
        }
        boolean compositing = this.pushLayer();
        this.renderChildren(marker, false);
        if (compositing) {
            this.popLayer(marker);
        }
        this.statePop();
    }

    private RendererState findInheritFromAncestorState(SVG.SvgObject obj) {
        RendererState newState = new RendererState();
        this.updateStyle(newState, SVG.Style.getDefaultStyle());
        return this.findInheritFromAncestorState(obj, newState);
    }

    private RendererState findInheritFromAncestorState(SVG.SvgObject obj, RendererState newState) {
        ArrayList<SVG.SvgElementBase> ancestors = new ArrayList<SVG.SvgElementBase>();
        while (true) {
            if (obj instanceof SVG.SvgElementBase) {
                ancestors.add(0, (SVG.SvgElementBase)obj);
            }
            if (obj.parent == null) break;
            obj = (SVG.SvgObject)((Object)obj.parent);
        }
        for (SVG.SvgElementBase ancestor : ancestors) {
            this.updateStyleForElement(newState, ancestor);
        }
        newState.viewBox = this.document.getRootElement().viewBox;
        if (newState.viewBox == null) {
            newState.viewBox = this.canvasViewPort;
        }
        newState.viewPort = this.canvasViewPort;
        newState.directRendering = this.state.directRendering;
        return newState;
    }

    private void checkForGradiantsAndPatterns(SVG.SvgElement obj) {
        if (this.state.style.fill instanceof SVG.PaintReference) {
            this.decodePaintReference(true, obj.boundingBox, (SVG.PaintReference)this.state.style.fill);
        }
        if (this.state.style.stroke instanceof SVG.PaintReference) {
            this.decodePaintReference(false, obj.boundingBox, (SVG.PaintReference)this.state.style.stroke);
        }
    }

    private void decodePaintReference(boolean isFill, SVG.Box boundingBox, SVG.PaintReference paintref) {
        SVG.SvgObject ref = this.document.resolveIRI(paintref.href);
        if (ref == null) {
            SVGAndroidRenderer.error("%s reference '%s' not found", isFill ? "Fill" : "Stroke", paintref.href);
            if (paintref.fallback != null) {
                this.setPaintColour(this.state, isFill, paintref.fallback);
            } else if (isFill) {
                this.state.hasFill = false;
            } else {
                this.state.hasStroke = false;
            }
            return;
        }
        if (ref instanceof SVG.SvgLinearGradient) {
            this.makeLinearGradiant(isFill, boundingBox, (SVG.SvgLinearGradient)ref);
        }
        if (ref instanceof SVG.SvgRadialGradient) {
            this.makeRadialGradiant(isFill, boundingBox, (SVG.SvgRadialGradient)ref);
        }
        if (ref instanceof SVG.SolidColor) {
            this.setSolidColor(isFill, (SVG.SolidColor)ref);
        }
    }

    private void makeLinearGradiant(boolean isFill, SVG.Box boundingBox, SVG.SvgLinearGradient gradient) {
        int numStops;
        float _y2;
        float _x2;
        float _y1;
        float _x1;
        Paint paint;
        if (gradient.href != null) {
            this.fillInChainedGradientFields((SVG.GradientElement)gradient, gradient.href);
        }
        boolean userUnits = gradient.gradientUnitsAreUser != null && gradient.gradientUnitsAreUser != false;
        Paint paint2 = paint = isFill ? this.state.fillPaint : this.state.strokePaint;
        if (userUnits) {
            SVG.Box viewPortUser = this.getCurrentViewPortInUserUnits();
            _x1 = gradient.x1 != null ? gradient.x1.floatValueX(this) : 0.0f;
            _y1 = gradient.y1 != null ? gradient.y1.floatValueY(this) : 0.0f;
            _x2 = gradient.x2 != null ? gradient.x2.floatValueX(this) : viewPortUser.width;
            _y2 = gradient.y2 != null ? gradient.y2.floatValueY(this) : 0.0f;
        } else {
            _x1 = gradient.x1 != null ? gradient.x1.floatValue(this, 1.0f) : 0.0f;
            _y1 = gradient.y1 != null ? gradient.y1.floatValue(this, 1.0f) : 0.0f;
            _x2 = gradient.x2 != null ? gradient.x2.floatValue(this, 1.0f) : 1.0f;
            _y2 = gradient.y2 != null ? gradient.y2.floatValue(this, 1.0f) : 0.0f;
        }
        this.statePush();
        this.state = this.findInheritFromAncestorState(gradient);
        Matrix m = new Matrix();
        if (!userUnits) {
            m.preTranslate(boundingBox.minX, boundingBox.minY);
            m.preScale(boundingBox.width, boundingBox.height);
        }
        if (gradient.gradientTransform != null) {
            m.preConcat(gradient.gradientTransform);
        }
        if ((numStops = gradient.children.size()) == 0) {
            this.statePop();
            if (isFill) {
                this.state.hasFill = false;
            } else {
                this.state.hasStroke = false;
            }
            return;
        }
        int[] colours = new int[numStops];
        float[] positions = new float[numStops];
        int i = 0;
        float lastOffset = -1.0f;
        for (SVG.SvgObject child : gradient.children) {
            SVG.Stop stop = (SVG.Stop)child;
            if (i == 0 || stop.offset.floatValue() >= lastOffset) {
                positions[i] = stop.offset.floatValue();
                lastOffset = stop.offset.floatValue();
            } else {
                positions[i] = lastOffset;
            }
            this.statePush();
            this.updateStyleForElement(this.state, stop);
            SVG.Colour col = (SVG.Colour)this.state.style.stopColor;
            if (col == null) {
                col = SVG.Colour.BLACK;
            }
            colours[i] = this.clamp255(this.state.style.stopOpacity.floatValue()) << 24 | col.colour;
            ++i;
            this.statePop();
        }
        if (_x1 == _x2 && _y1 == _y2 || numStops == 1) {
            this.statePop();
            paint.setColor(colours[numStops - 1]);
            return;
        }
        Shader.TileMode tileMode = Shader.TileMode.CLAMP;
        if (gradient.spreadMethod != null) {
            if (gradient.spreadMethod == SVG.GradientSpread.reflect) {
                tileMode = Shader.TileMode.MIRROR;
            } else if (gradient.spreadMethod == SVG.GradientSpread.repeat) {
                tileMode = Shader.TileMode.REPEAT;
            }
        }
        this.statePop();
        LinearGradient gr = new LinearGradient(_x1, _y1, _x2, _y2, colours, positions, tileMode);
        gr.setLocalMatrix(m);
        paint.setShader((Shader)gr);
    }

    private void makeRadialGradiant(boolean isFill, SVG.Box boundingBox, SVG.SvgRadialGradient gradient) {
        int numStops;
        float _r;
        float _cy;
        float _cx;
        Paint paint;
        if (gradient.href != null) {
            this.fillInChainedGradientFields((SVG.GradientElement)gradient, gradient.href);
        }
        boolean userUnits = gradient.gradientUnitsAreUser != null && gradient.gradientUnitsAreUser != false;
        Paint paint2 = paint = isFill ? this.state.fillPaint : this.state.strokePaint;
        if (userUnits) {
            SVG.Length fiftyPercent = new SVG.Length(50.0f, SVG.Unit.percent);
            _cx = gradient.cx != null ? gradient.cx.floatValueX(this) : fiftyPercent.floatValueX(this);
            _cy = gradient.cy != null ? gradient.cy.floatValueY(this) : fiftyPercent.floatValueY(this);
            _r = gradient.r != null ? gradient.r.floatValue(this) : fiftyPercent.floatValue(this);
        } else {
            _cx = gradient.cx != null ? gradient.cx.floatValue(this, 1.0f) : 0.5f;
            _cy = gradient.cy != null ? gradient.cy.floatValue(this, 1.0f) : 0.5f;
            _r = gradient.r != null ? gradient.r.floatValue(this, 1.0f) : 0.5f;
        }
        this.statePush();
        this.state = this.findInheritFromAncestorState(gradient);
        Matrix m = new Matrix();
        if (!userUnits) {
            m.preTranslate(boundingBox.minX, boundingBox.minY);
            m.preScale(boundingBox.width, boundingBox.height);
        }
        if (gradient.gradientTransform != null) {
            m.preConcat(gradient.gradientTransform);
        }
        if ((numStops = gradient.children.size()) == 0) {
            this.statePop();
            if (isFill) {
                this.state.hasFill = false;
            } else {
                this.state.hasStroke = false;
            }
            return;
        }
        int[] colours = new int[numStops];
        float[] positions = new float[numStops];
        int i = 0;
        float lastOffset = -1.0f;
        for (SVG.SvgObject child : gradient.children) {
            SVG.Stop stop = (SVG.Stop)child;
            if (i == 0 || stop.offset.floatValue() >= lastOffset) {
                positions[i] = stop.offset.floatValue();
                lastOffset = stop.offset.floatValue();
            } else {
                positions[i] = lastOffset;
            }
            this.statePush();
            this.updateStyleForElement(this.state, stop);
            SVG.Colour col = (SVG.Colour)this.state.style.stopColor;
            if (col == null) {
                col = SVG.Colour.BLACK;
            }
            colours[i] = this.clamp255(this.state.style.stopOpacity.floatValue()) << 24 | col.colour;
            ++i;
            this.statePop();
        }
        if (_r == 0.0f || numStops == 1) {
            this.statePop();
            paint.setColor(colours[numStops - 1]);
            return;
        }
        Shader.TileMode tileMode = Shader.TileMode.CLAMP;
        if (gradient.spreadMethod != null) {
            if (gradient.spreadMethod == SVG.GradientSpread.reflect) {
                tileMode = Shader.TileMode.MIRROR;
            } else if (gradient.spreadMethod == SVG.GradientSpread.repeat) {
                tileMode = Shader.TileMode.REPEAT;
            }
        }
        this.statePop();
        RadialGradient gr = new RadialGradient(_cx, _cy, _r, colours, positions, tileMode);
        gr.setLocalMatrix(m);
        paint.setShader((Shader)gr);
    }

    private void fillInChainedGradientFields(SVG.GradientElement gradient, String href) {
        SVG.SvgObject ref = gradient.document.resolveIRI(href);
        if (ref == null) {
            SVGAndroidRenderer.warn("Gradient reference '%s' not found", href);
            return;
        }
        if (!(ref instanceof SVG.GradientElement)) {
            SVGAndroidRenderer.error("Gradient href attributes must point to other gradient elements", new Object[0]);
            return;
        }
        if (ref == gradient) {
            SVGAndroidRenderer.error("Circular reference in gradient href attribute '%s'", href);
            return;
        }
        SVG.GradientElement grRef = (SVG.GradientElement)ref;
        if (gradient.gradientUnitsAreUser == null) {
            gradient.gradientUnitsAreUser = grRef.gradientUnitsAreUser;
        }
        if (gradient.gradientTransform == null) {
            gradient.gradientTransform = grRef.gradientTransform;
        }
        if (gradient.spreadMethod == null) {
            gradient.spreadMethod = grRef.spreadMethod;
        }
        if (gradient.children.isEmpty()) {
            gradient.children = grRef.children;
        }
        try {
            if (gradient instanceof SVG.SvgLinearGradient) {
                this.fillInChainedGradientFields((SVG.SvgLinearGradient)gradient, (SVG.SvgLinearGradient)ref);
            } else {
                this.fillInChainedGradientFields((SVG.SvgRadialGradient)gradient, (SVG.SvgRadialGradient)ref);
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (grRef.href != null) {
            this.fillInChainedGradientFields(gradient, grRef.href);
        }
    }

    private void fillInChainedGradientFields(SVG.SvgLinearGradient gradient, SVG.SvgLinearGradient grRef) {
        if (gradient.x1 == null) {
            gradient.x1 = grRef.x1;
        }
        if (gradient.y1 == null) {
            gradient.y1 = grRef.y1;
        }
        if (gradient.x2 == null) {
            gradient.x2 = grRef.x2;
        }
        if (gradient.y2 == null) {
            gradient.y2 = grRef.y2;
        }
    }

    private void fillInChainedGradientFields(SVG.SvgRadialGradient gradient, SVG.SvgRadialGradient grRef) {
        if (gradient.cx == null) {
            gradient.cx = grRef.cx;
        }
        if (gradient.cy == null) {
            gradient.cy = grRef.cy;
        }
        if (gradient.r == null) {
            gradient.r = grRef.r;
        }
        if (gradient.fx == null) {
            gradient.fx = grRef.fx;
        }
        if (gradient.fy == null) {
            gradient.fy = grRef.fy;
        }
    }

    private void setSolidColor(boolean isFill, SVG.SolidColor ref) {
        if (isFill) {
            if (this.isSpecified(ref.baseStyle, 0x80000000L)) {
                this.state.style.fill = ref.baseStyle.solidColor;
                boolean bl = this.state.hasFill = ref.baseStyle.solidColor != null;
            }
            if (this.isSpecified(ref.baseStyle, 0x100000000L)) {
                this.state.style.fillOpacity = ref.baseStyle.solidOpacity;
            }
            if (this.isSpecified(ref.baseStyle, 0x180000000L)) {
                this.setPaintColour(this.state, isFill, this.state.style.fill);
            }
        } else {
            if (this.isSpecified(ref.baseStyle, 0x80000000L)) {
                this.state.style.stroke = ref.baseStyle.solidColor;
                boolean bl = this.state.hasStroke = ref.baseStyle.solidColor != null;
            }
            if (this.isSpecified(ref.baseStyle, 0x100000000L)) {
                this.state.style.strokeOpacity = ref.baseStyle.solidOpacity;
            }
            if (this.isSpecified(ref.baseStyle, 0x180000000L)) {
                this.setPaintColour(this.state, isFill, this.state.style.stroke);
            }
        }
    }

    private void checkForClipPath(SVG.SvgElement obj) {
        this.checkForClipPath(obj, obj.boundingBox);
    }

    private void checkForClipPath(SVG.SvgElement obj, SVG.Box boundingBox) {
        boolean userUnits;
        if (this.state.style.clipPath == null) {
            return;
        }
        SVG.SvgObject ref = obj.document.resolveIRI(this.state.style.clipPath);
        if (ref == null) {
            SVGAndroidRenderer.error("ClipPath reference '%s' not found", this.state.style.clipPath);
            return;
        }
        SVG.ClipPath clipPath = (SVG.ClipPath)ref;
        if (clipPath.children.isEmpty()) {
            this.canvas.clipRect(0, 0, 0, 0);
            return;
        }
        boolean bl = userUnits = clipPath.clipPathUnitsAreUser == null || clipPath.clipPathUnitsAreUser != false;
        if (obj instanceof SVG.Group && !userUnits) {
            SVGAndroidRenderer.warn("<clipPath clipPathUnits=\"objectBoundingBox\"> is not supported when referenced from container elements (like %s)", obj.getClass().getSimpleName());
            return;
        }
        this.clipStatePush();
        if (!userUnits) {
            Matrix m = new Matrix();
            m.preTranslate(boundingBox.minX, boundingBox.minY);
            m.preScale(boundingBox.width, boundingBox.height);
            this.canvas.concat(m);
        }
        if (clipPath.transform != null) {
            this.canvas.concat(clipPath.transform);
        }
        this.state = this.findInheritFromAncestorState(clipPath);
        this.checkForClipPath(clipPath);
        Path combinedPath = new Path();
        for (SVG.SvgObject child : clipPath.children) {
            this.addObjectToClip(child, true, combinedPath, new Matrix());
        }
        this.canvas.clipPath(combinedPath);
        this.clipStatePop();
    }

    private void addObjectToClip(SVG.SvgObject obj, boolean allowUse, Path combinedPath, Matrix combinedPathMatrix) {
        if (!this.display()) {
            return;
        }
        this.clipStatePush();
        if (obj instanceof SVG.Use) {
            if (allowUse) {
                this.addObjectToClip((SVG.Use)obj, combinedPath, combinedPathMatrix);
            } else {
                SVGAndroidRenderer.error("<use> elements inside a <clipPath> cannot reference another <use>", new Object[0]);
            }
        } else if (obj instanceof SVG.Path) {
            this.addObjectToClip((SVG.Path)obj, combinedPath, combinedPathMatrix);
        } else if (obj instanceof SVG.Text) {
            this.addObjectToClip((SVG.Text)obj, combinedPath, combinedPathMatrix);
        } else if (obj instanceof SVG.GraphicsElement) {
            this.addObjectToClip((SVG.GraphicsElement)obj, combinedPath, combinedPathMatrix);
        } else {
            SVGAndroidRenderer.error("Invalid %s element found in clipPath definition", obj.getClass().getSimpleName());
        }
        this.clipStatePop();
    }

    private void clipStatePush() {
        this.canvas.save(1);
        this.stateStack.push(this.state);
        this.state = (RendererState)this.state.clone();
    }

    private void clipStatePop() {
        this.canvas.restore();
        this.state = this.stateStack.pop();
    }

    private Path.FillType getClipRuleFromState() {
        if (this.state.style.clipRule == null) {
            return Path.FillType.WINDING;
        }
        switch (this.state.style.clipRule) {
            case EvenOdd: {
                return Path.FillType.EVEN_ODD;
            }
        }
        return Path.FillType.WINDING;
    }

    private void addObjectToClip(SVG.Path obj, Path combinedPath, Matrix combinedPathMatrix) {
        this.updateStyleForElement(this.state, obj);
        if (!this.display()) {
            return;
        }
        if (!this.visible()) {
            return;
        }
        if (obj.transform != null) {
            combinedPathMatrix.preConcat(obj.transform);
        }
        Path path = new PathConverter(obj.d).getPath();
        if (obj.boundingBox == null) {
            obj.boundingBox = this.calculatePathBounds(path);
        }
        this.checkForClipPath(obj);
        combinedPath.setFillType(this.getClipRuleFromState());
        combinedPath.addPath(path, combinedPathMatrix);
    }

    private void addObjectToClip(SVG.GraphicsElement obj, Path combinedPath, Matrix combinedPathMatrix) {
        Path path;
        this.updateStyleForElement(this.state, obj);
        if (!this.display()) {
            return;
        }
        if (!this.visible()) {
            return;
        }
        if (obj.transform != null) {
            combinedPathMatrix.preConcat(obj.transform);
        }
        if (obj instanceof SVG.Rect) {
            path = this.makePathAndBoundingBox((SVG.Rect)obj);
        } else if (obj instanceof SVG.Circle) {
            path = this.makePathAndBoundingBox((SVG.Circle)obj);
        } else if (obj instanceof SVG.Ellipse) {
            path = this.makePathAndBoundingBox((SVG.Ellipse)obj);
        } else if (obj instanceof SVG.PolyLine) {
            path = this.makePathAndBoundingBox((SVG.PolyLine)obj);
        } else {
            return;
        }
        this.checkForClipPath(obj);
        combinedPath.setFillType(path.getFillType());
        combinedPath.addPath(path, combinedPathMatrix);
    }

    private void addObjectToClip(SVG.Use obj, Path combinedPath, Matrix combinedPathMatrix) {
        SVG.SvgObject ref;
        this.updateStyleForElement(this.state, obj);
        if (!this.display()) {
            return;
        }
        if (!this.visible()) {
            return;
        }
        if (obj.transform != null) {
            combinedPathMatrix.preConcat(obj.transform);
        }
        if ((ref = obj.document.resolveIRI(obj.href)) == null) {
            SVGAndroidRenderer.error("Use reference '%s' not found", obj.href);
            return;
        }
        this.checkForClipPath(obj);
        this.addObjectToClip(ref, false, combinedPath, combinedPathMatrix);
    }

    private void addObjectToClip(SVG.Text obj, Path combinedPath, Matrix combinedPathMatrix) {
        float dy;
        this.updateStyleForElement(this.state, obj);
        if (!this.display()) {
            return;
        }
        if (obj.transform != null) {
            combinedPathMatrix.preConcat(obj.transform);
        }
        float x = obj.x == null || obj.x.size() == 0 ? 0.0f : ((SVG.Length)obj.x.get(0)).floatValueX(this);
        float y = obj.y == null || obj.y.size() == 0 ? 0.0f : ((SVG.Length)obj.y.get(0)).floatValueY(this);
        float dx = obj.dx == null || obj.dx.size() == 0 ? 0.0f : ((SVG.Length)obj.dx.get(0)).floatValueX(this);
        float f = dy = obj.dy == null || obj.dy.size() == 0 ? 0.0f : ((SVG.Length)obj.dy.get(0)).floatValueY(this);
        if (this.state.style.textAnchor != SVG.Style.TextAnchor.Start) {
            float textWidth = this.calculateTextWidth(obj);
            x = this.state.style.textAnchor == SVG.Style.TextAnchor.Middle ? (x -= textWidth / 2.0f) : (x -= textWidth);
        }
        if (obj.boundingBox == null) {
            TextBoundsCalculator proc = new TextBoundsCalculator(x, y);
            this.enumerateTextSpans(obj, proc);
            obj.boundingBox = new SVG.Box(proc.bbox.left, proc.bbox.top, proc.bbox.width(), proc.bbox.height());
        }
        this.checkForClipPath(obj);
        Path textAsPath = new Path();
        this.enumerateTextSpans(obj, new PlainTextToPath(x + dx, y + dy, textAsPath));
        combinedPath.setFillType(this.getClipRuleFromState());
        combinedPath.addPath(textAsPath, combinedPathMatrix);
    }

    private Path makePathAndBoundingBox(SVG.Line obj) {
        float y2;
        float x1 = obj.x1 == null ? 0.0f : obj.x1.floatValueX(this);
        float y1 = obj.y1 == null ? 0.0f : obj.y1.floatValueY(this);
        float x2 = obj.x2 == null ? 0.0f : obj.x2.floatValueX(this);
        float f = y2 = obj.y2 == null ? 0.0f : obj.y2.floatValueY(this);
        if (obj.boundingBox == null) {
            obj.boundingBox = new SVG.Box(Math.min(x1, y1), Math.min(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1));
        }
        Path p = new Path();
        p.moveTo(x1, y1);
        p.lineTo(x2, y2);
        return p;
    }

    private Path makePathAndBoundingBox(SVG.Rect obj) {
        float ry;
        float rx;
        if (obj.rx == null && obj.ry == null) {
            rx = 0.0f;
            ry = 0.0f;
        } else if (obj.rx == null) {
            rx = ry = obj.ry.floatValueY(this);
        } else if (obj.ry == null) {
            rx = ry = obj.rx.floatValueX(this);
        } else {
            rx = obj.rx.floatValueX(this);
            ry = obj.ry.floatValueY(this);
        }
        rx = Math.min(rx, obj.width.floatValueX(this) / 2.0f);
        ry = Math.min(ry, obj.height.floatValueY(this) / 2.0f);
        float x = obj.x != null ? obj.x.floatValueX(this) : 0.0f;
        float y = obj.y != null ? obj.y.floatValueY(this) : 0.0f;
        float w = obj.width.floatValueX(this);
        float h = obj.height.floatValueY(this);
        if (obj.boundingBox == null) {
            obj.boundingBox = new SVG.Box(x, y, w, h);
        }
        float right = x + w;
        float bottom = y + h;
        Path p = new Path();
        if (rx == 0.0f || ry == 0.0f) {
            p.moveTo(x, y);
            p.lineTo(right, y);
            p.lineTo(right, bottom);
            p.lineTo(x, bottom);
            p.lineTo(x, y);
        } else {
            float cpx = rx * 0.5522848f;
            float cpy = ry * 0.5522848f;
            p.moveTo(x, y + ry);
            p.cubicTo(x, y + ry - cpy, x + rx - cpx, y, x + rx, y);
            p.lineTo(right - rx, y);
            p.cubicTo(right - rx + cpx, y, right, y + ry - cpy, right, y + ry);
            p.lineTo(right, bottom - ry);
            p.cubicTo(right, bottom - ry + cpy, right - rx + cpx, bottom, right - rx, bottom);
            p.lineTo(x + rx, bottom);
            p.cubicTo(x + rx - cpx, bottom, x, bottom - ry + cpy, x, bottom - ry);
            p.lineTo(x, y + ry);
        }
        p.close();
        return p;
    }

    private Path makePathAndBoundingBox(SVG.Circle obj) {
        float cx = obj.cx != null ? obj.cx.floatValueX(this) : 0.0f;
        float cy = obj.cy != null ? obj.cy.floatValueY(this) : 0.0f;
        float r = obj.r.floatValue(this);
        float left = cx - r;
        float top = cy - r;
        float right = cx + r;
        float bottom = cy + r;
        if (obj.boundingBox == null) {
            obj.boundingBox = new SVG.Box(left, top, r * 2.0f, r * 2.0f);
        }
        float cp = r * 0.5522848f;
        Path p = new Path();
        p.moveTo(cx, top);
        p.cubicTo(cx + cp, top, right, cy - cp, right, cy);
        p.cubicTo(right, cy + cp, cx + cp, bottom, cx, bottom);
        p.cubicTo(cx - cp, bottom, left, cy + cp, left, cy);
        p.cubicTo(left, cy - cp, cx - cp, top, cx, top);
        p.close();
        return p;
    }

    private Path makePathAndBoundingBox(SVG.Ellipse obj) {
        float cx = obj.cx != null ? obj.cx.floatValueX(this) : 0.0f;
        float cy = obj.cy != null ? obj.cy.floatValueY(this) : 0.0f;
        float rx = obj.rx.floatValueX(this);
        float ry = obj.ry.floatValueY(this);
        float left = cx - rx;
        float top = cy - ry;
        float right = cx + rx;
        float bottom = cy + ry;
        if (obj.boundingBox == null) {
            obj.boundingBox = new SVG.Box(left, top, rx * 2.0f, ry * 2.0f);
        }
        float cpx = rx * 0.5522848f;
        float cpy = ry * 0.5522848f;
        Path p = new Path();
        p.moveTo(cx, top);
        p.cubicTo(cx + cpx, top, right, cy - cpy, right, cy);
        p.cubicTo(right, cy + cpy, cx + cpx, bottom, cx, bottom);
        p.cubicTo(cx - cpx, bottom, left, cy + cpy, left, cy);
        p.cubicTo(left, cy - cpy, cx - cpx, top, cx, top);
        p.close();
        return p;
    }

    private Path makePathAndBoundingBox(SVG.PolyLine obj) {
        Path path = new Path();
        path.moveTo(obj.points[0], obj.points[1]);
        for (int i = 2; i < obj.points.length; i += 2) {
            path.lineTo(obj.points[i], obj.points[i + 1]);
        }
        if (obj instanceof SVG.Polygon) {
            path.close();
        }
        if (obj.boundingBox == null) {
            obj.boundingBox = this.calculatePathBounds(path);
        }
        path.setFillType(this.getClipRuleFromState());
        return path;
    }

    private void fillWithPattern(SVG.SvgElement obj, Path path, SVG.Pattern pattern) {
        float h;
        float w;
        float y;
        float x;
        boolean patternUnitsAreUser;
        boolean bl = patternUnitsAreUser = pattern.patternUnitsAreUser != null && pattern.patternUnitsAreUser != false;
        if (pattern.href != null) {
            this.fillInChainedPatternFields(pattern, pattern.href);
        }
        if (patternUnitsAreUser) {
            x = pattern.x != null ? pattern.x.floatValueX(this) : 0.0f;
            y = pattern.y != null ? pattern.y.floatValueY(this) : 0.0f;
            w = pattern.width != null ? pattern.width.floatValueX(this) : 0.0f;
            h = pattern.height != null ? pattern.height.floatValueY(this) : 0.0f;
        } else {
            x = pattern.x != null ? pattern.x.floatValue(this, 1.0f) : 0.0f;
            y = pattern.y != null ? pattern.y.floatValue(this, 1.0f) : 0.0f;
            w = pattern.width != null ? pattern.width.floatValue(this, 1.0f) : 0.0f;
            h = pattern.height != null ? pattern.height.floatValue(this, 1.0f) : 0.0f;
            x = obj.boundingBox.minX + x * obj.boundingBox.width;
            y = obj.boundingBox.minY + y * obj.boundingBox.height;
            w *= obj.boundingBox.width;
            h *= obj.boundingBox.height;
        }
        if (w == 0.0f || h == 0.0f) {
            return;
        }
        PreserveAspectRatio positioning = pattern.preserveAspectRatio != null ? pattern.preserveAspectRatio : PreserveAspectRatio.LETTERBOX;
        this.statePush();
        this.canvas.clipPath(path);
        RendererState baseState = new RendererState();
        this.updateStyle(baseState, SVG.Style.getDefaultStyle());
        baseState.style.overflow = false;
        this.state = this.findInheritFromAncestorState(pattern, baseState);
        SVG.Box patternArea = obj.boundingBox;
        if (pattern.patternTransform != null) {
            this.canvas.concat(pattern.patternTransform);
            Matrix inverse = new Matrix();
            if (pattern.patternTransform.invert(inverse)) {
                float[] pts = new float[]{obj.boundingBox.minX, obj.boundingBox.minY, obj.boundingBox.maxX(), obj.boundingBox.minY, obj.boundingBox.maxX(), obj.boundingBox.maxY(), obj.boundingBox.minX, obj.boundingBox.maxY()};
                inverse.mapPoints(pts);
                RectF rect = new RectF(pts[0], pts[1], pts[0], pts[1]);
                for (int i = 2; i <= 6; i += 2) {
                    if (pts[i] < rect.left) {
                        rect.left = pts[i];
                    }
                    if (pts[i] > rect.right) {
                        rect.right = pts[i];
                    }
                    if (pts[i + 1] < rect.top) {
                        rect.top = pts[i + 1];
                    }
                    if (!(pts[i + 1] > rect.bottom)) continue;
                    rect.bottom = pts[i + 1];
                }
                patternArea = new SVG.Box(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
            }
        }
        float originX = x + (float)Math.floor((patternArea.minX - x) / w) * w;
        float originY = y + (float)Math.floor((patternArea.minY - y) / h) * h;
        float right = patternArea.maxX();
        float bottom = patternArea.maxY();
        SVG.Box stepViewBox = new SVG.Box(0.0f, 0.0f, w, h);
        for (float stepY = originY; stepY < bottom; stepY += h) {
            for (float stepX = originX; stepX < right; stepX += w) {
                stepViewBox.minX = stepX;
                stepViewBox.minY = stepY;
                this.statePush();
                if (!this.state.style.overflow.booleanValue()) {
                    this.setClipRect(stepViewBox.minX, stepViewBox.minY, stepViewBox.width, stepViewBox.height);
                }
                if (pattern.viewBox != null) {
                    this.canvas.concat(this.calculateViewBoxTransform(stepViewBox, pattern.viewBox, positioning));
                } else {
                    boolean patternContentUnitsAreUser = pattern.patternContentUnitsAreUser == null || pattern.patternContentUnitsAreUser != false;
                    this.canvas.translate(stepX, stepY);
                    if (!patternContentUnitsAreUser) {
                        this.canvas.scale(obj.boundingBox.width, obj.boundingBox.height);
                    }
                }
                boolean compositing = this.pushLayer();
                for (SVG.SvgObject child : pattern.children) {
                    this.render(child);
                }
                if (compositing) {
                    this.popLayer(pattern);
                }
                this.statePop();
            }
        }
        this.statePop();
    }

    private void fillInChainedPatternFields(SVG.Pattern pattern, String href) {
        SVG.SvgObject ref = pattern.document.resolveIRI(href);
        if (ref == null) {
            SVGAndroidRenderer.warn("Pattern reference '%s' not found", href);
            return;
        }
        if (!(ref instanceof SVG.Pattern)) {
            SVGAndroidRenderer.error("Pattern href attributes must point to other pattern elements", new Object[0]);
            return;
        }
        if (ref == pattern) {
            SVGAndroidRenderer.error("Circular reference in pattern href attribute '%s'", href);
            return;
        }
        SVG.Pattern pRef = (SVG.Pattern)ref;
        if (pattern.patternUnitsAreUser == null) {
            pattern.patternUnitsAreUser = pRef.patternUnitsAreUser;
        }
        if (pattern.patternContentUnitsAreUser == null) {
            pattern.patternContentUnitsAreUser = pRef.patternContentUnitsAreUser;
        }
        if (pattern.patternTransform == null) {
            pattern.patternTransform = pRef.patternTransform;
        }
        if (pattern.x == null) {
            pattern.x = pRef.x;
        }
        if (pattern.y == null) {
            pattern.y = pRef.y;
        }
        if (pattern.width == null) {
            pattern.width = pRef.width;
        }
        if (pattern.height == null) {
            pattern.height = pRef.height;
        }
        if (pattern.children.isEmpty()) {
            pattern.children = pRef.children;
        }
        if (pattern.viewBox == null) {
            pattern.viewBox = pRef.viewBox;
        }
        if (pattern.preserveAspectRatio == null) {
            pattern.preserveAspectRatio = pRef.preserveAspectRatio;
        }
        if (pRef.href != null) {
            this.fillInChainedPatternFields(pattern, pRef.href);
        }
    }

    private void renderMask(SVG.Mask mask, SVG.SvgElement obj) {
        boolean maskContentUnitsAreUser;
        float h;
        float w;
        boolean maskUnitsAreUser;
        SVGAndroidRenderer.debug("Mask render", new Object[0]);
        boolean bl = maskUnitsAreUser = mask.maskUnitsAreUser != null && mask.maskUnitsAreUser != false;
        if (maskUnitsAreUser) {
            w = mask.width != null ? mask.width.floatValueX(this) : obj.boundingBox.width;
            h = mask.height != null ? mask.height.floatValueY(this) : obj.boundingBox.height;
            float x = mask.x != null ? mask.x.floatValueX(this) : (float)((double)obj.boundingBox.minX - 0.1 * (double)obj.boundingBox.width);
            float y = mask.y != null ? mask.y.floatValueY(this) : (float)((double)obj.boundingBox.minY - 0.1 * (double)obj.boundingBox.height);
        } else {
            float x = mask.x != null ? mask.x.floatValue(this, 1.0f) : -0.1f;
            float y = mask.y != null ? mask.y.floatValue(this, 1.0f) : -0.1f;
            w = mask.width != null ? mask.width.floatValue(this, 1.0f) : 1.2f;
            h = mask.height != null ? mask.height.floatValue(this, 1.0f) : 1.2f;
            x = obj.boundingBox.minX + x * obj.boundingBox.width;
            y = obj.boundingBox.minY + y * obj.boundingBox.height;
            w *= obj.boundingBox.width;
            h *= obj.boundingBox.height;
        }
        if (w == 0.0f || h == 0.0f) {
            return;
        }
        this.statePush();
        this.state = this.findInheritFromAncestorState(mask);
        this.state.style.opacity = Float.valueOf(1.0f);
        boolean bl2 = maskContentUnitsAreUser = mask.maskContentUnitsAreUser == null || mask.maskContentUnitsAreUser != false;
        if (!maskContentUnitsAreUser) {
            this.canvas.translate(obj.boundingBox.minX, obj.boundingBox.minY);
            this.canvas.scale(obj.boundingBox.width, obj.boundingBox.height);
        }
        this.renderChildren(mask, false);
        this.statePop();
    }

    private class PlainTextToPath
    extends TextProcessor {
        public float x;
        public float y;
        public Path textAsPath;

        public PlainTextToPath(float x, float y, Path textAsPath) {
            this.x = x;
            this.y = y;
            this.textAsPath = textAsPath;
        }

        @Override
        public boolean doTextContainer(SVG.TextContainer obj) {
            if (obj instanceof SVG.TextPath) {
                SVGAndroidRenderer.warn("Using <textPath> elements in a clip path is not supported.", new Object[0]);
                return false;
            }
            return true;
        }

        @Override
        public void processText(String text) {
            if (SVGAndroidRenderer.this.visible()) {
                Path spanPath = new Path();
                ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.getTextPath(text, 0, text.length(), this.x, this.y, spanPath);
                this.textAsPath.addPath(spanPath);
            }
            this.x += ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.measureText(text);
        }
    }

    private class MarkerPositionCalculator
    implements SVG.PathInterface {
        private List<MarkerVector> markers = new ArrayList<MarkerVector>();
        private float startX;
        private float startY;
        private MarkerVector lastPos = null;
        private boolean startArc = false;
        private boolean normalCubic = true;
        private int subpathStartIndex = -1;
        private boolean closepathReAdjustPending;

        public MarkerPositionCalculator(SVG.PathDefinition pathDef) {
            if (pathDef == null) {
                return;
            }
            pathDef.enumeratePath(this);
            if (this.closepathReAdjustPending) {
                this.lastPos.add(this.markers.get(this.subpathStartIndex));
                this.markers.set(this.subpathStartIndex, this.lastPos);
                this.closepathReAdjustPending = false;
            }
            if (this.lastPos != null) {
                this.markers.add(this.lastPos);
            }
        }

        public List<MarkerVector> getMarkers() {
            return this.markers;
        }

        @Override
        public void moveTo(float x, float y) {
            if (this.closepathReAdjustPending) {
                this.lastPos.add(this.markers.get(this.subpathStartIndex));
                this.markers.set(this.subpathStartIndex, this.lastPos);
                this.closepathReAdjustPending = false;
            }
            if (this.lastPos != null) {
                this.markers.add(this.lastPos);
            }
            this.startX = x;
            this.startY = y;
            this.lastPos = new MarkerVector(x, y, 0.0f, 0.0f);
            this.subpathStartIndex = this.markers.size();
        }

        @Override
        public void lineTo(float x, float y) {
            MarkerVector newPos;
            this.lastPos.add(x, y);
            this.markers.add(this.lastPos);
            this.lastPos = newPos = new MarkerVector(x, y, x - this.lastPos.x, y - this.lastPos.y);
            this.closepathReAdjustPending = false;
        }

        @Override
        public void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            MarkerVector newPos;
            if (this.normalCubic || this.startArc) {
                this.lastPos.add(x1, y1);
                this.markers.add(this.lastPos);
                this.startArc = false;
            }
            this.lastPos = newPos = new MarkerVector(x3, y3, x3 - x2, y3 - y2);
            this.closepathReAdjustPending = false;
        }

        @Override
        public void quadTo(float x1, float y1, float x2, float y2) {
            MarkerVector newPos;
            this.lastPos.add(x1, y1);
            this.markers.add(this.lastPos);
            this.lastPos = newPos = new MarkerVector(x2, y2, x2 - x1, y2 - y1);
            this.closepathReAdjustPending = false;
        }

        @Override
        public void arcTo(float rx, float ry, float xAxisRotation, boolean largeArcFlag, boolean sweepFlag, float x, float y) {
            this.startArc = true;
            this.normalCubic = false;
            SVGAndroidRenderer.arcTo(this.lastPos.x, this.lastPos.y, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y, this);
            this.normalCubic = true;
            this.closepathReAdjustPending = false;
        }

        @Override
        public void close() {
            this.markers.add(this.lastPos);
            this.lineTo(this.startX, this.startY);
            this.closepathReAdjustPending = true;
        }
    }

    private class MarkerVector {
        public float x;
        public float y;
        public float dx = 0.0f;
        public float dy = 0.0f;

        public MarkerVector(float x, float y, float dx, float dy) {
            this.x = x;
            this.y = y;
            double len = Math.sqrt(dx * dx + dy * dy);
            if (len != 0.0) {
                this.dx = (float)((double)dx / len);
                this.dy = (float)((double)dy / len);
            }
        }

        public void add(float x, float y) {
            float dx = x - this.x;
            float dy = y - this.y;
            double len = Math.sqrt(dx * dx + dy * dy);
            if (len != 0.0) {
                this.dx += (float)((double)dx / len);
                this.dy += (float)((double)dy / len);
            }
        }

        public void add(MarkerVector v2) {
            this.dx += v2.dx;
            this.dy += v2.dy;
        }

        public String toString() {
            return "(" + this.x + "," + this.y + " " + this.dx + "," + this.dy + ")";
        }
    }

    private class PathConverter
    implements SVG.PathInterface {
        Path path = new Path();
        float lastX;
        float lastY;

        public PathConverter(SVG.PathDefinition pathDef) {
            if (pathDef == null) {
                return;
            }
            pathDef.enumeratePath(this);
        }

        public Path getPath() {
            return this.path;
        }

        @Override
        public void moveTo(float x, float y) {
            this.path.moveTo(x, y);
            this.lastX = x;
            this.lastY = y;
        }

        @Override
        public void lineTo(float x, float y) {
            this.path.lineTo(x, y);
            this.lastX = x;
            this.lastY = y;
        }

        @Override
        public void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.path.cubicTo(x1, y1, x2, y2, x3, y3);
            this.lastX = x3;
            this.lastY = y3;
        }

        @Override
        public void quadTo(float x1, float y1, float x2, float y2) {
            this.path.quadTo(x1, y1, x2, y2);
            this.lastX = x2;
            this.lastY = y2;
        }

        @Override
        public void arcTo(float rx, float ry, float xAxisRotation, boolean largeArcFlag, boolean sweepFlag, float x, float y) {
            SVGAndroidRenderer.arcTo(this.lastX, this.lastY, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y, this);
            this.lastX = x;
            this.lastY = y;
        }

        @Override
        public void close() {
            this.path.close();
        }
    }

    private class TextBoundsCalculator
    extends TextProcessor {
        float x;
        float y;
        RectF bbox;

        public TextBoundsCalculator(float x, float y) {
            this.bbox = new RectF();
            this.x = x;
            this.y = y;
        }

        @Override
        public boolean doTextContainer(SVG.TextContainer obj) {
            if (obj instanceof SVG.TextPath) {
                SVG.TextPath tpath = (SVG.TextPath)obj;
                SVG.SvgObject ref = obj.document.resolveIRI(tpath.href);
                if (ref == null) {
                    SVGAndroidRenderer.error("TextPath path reference '%s' not found", new Object[]{tpath.href});
                    return false;
                }
                SVG.Path pathObj = (SVG.Path)ref;
                Path path = new PathConverter(pathObj.d).getPath();
                if (pathObj.transform != null) {
                    path.transform(pathObj.transform);
                }
                RectF pathBounds = new RectF();
                path.computeBounds(pathBounds, true);
                this.bbox.union(pathBounds);
                return false;
            }
            return true;
        }

        @Override
        public void processText(String text) {
            if (SVGAndroidRenderer.this.visible()) {
                Rect rect = new Rect();
                ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.getTextBounds(text, 0, text.length(), rect);
                RectF textbounds = new RectF(rect);
                textbounds.offset(this.x, this.y);
                this.bbox.union(textbounds);
            }
            this.x += ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.measureText(text);
        }
    }

    private class TextWidthCalculator
    extends TextProcessor {
        public float x;

        private TextWidthCalculator() {
            this.x = 0.0f;
        }

        @Override
        public void processText(String text) {
            this.x += ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.measureText(text);
        }
    }

    private class PathTextDrawer
    extends PlainTextDrawer {
        private Path path;

        public PathTextDrawer(Path path, float x, float y) {
            super(x, y);
            this.path = path;
        }

        @Override
        public void processText(String text) {
            if (SVGAndroidRenderer.this.visible()) {
                if (((SVGAndroidRenderer)SVGAndroidRenderer.this).state.hasFill) {
                    SVGAndroidRenderer.this.canvas.drawTextOnPath(text, this.path, this.x, this.y, ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint);
                }
                if (((SVGAndroidRenderer)SVGAndroidRenderer.this).state.hasStroke) {
                    SVGAndroidRenderer.this.canvas.drawTextOnPath(text, this.path, this.x, this.y, ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.strokePaint);
                }
            }
            this.x += ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.measureText(text);
        }
    }

    private abstract class TextProcessor {
        private TextProcessor() {
        }

        public boolean doTextContainer(SVG.TextContainer obj) {
            return true;
        }

        public abstract void processText(String var1);
    }

    private class PlainTextDrawer
    extends TextProcessor {
        public float x;
        public float y;

        public PlainTextDrawer(float x, float y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public void processText(String text) {
            SVGAndroidRenderer.debug("TextSequence render", new Object[0]);
            if (SVGAndroidRenderer.this.visible()) {
                if (((SVGAndroidRenderer)SVGAndroidRenderer.this).state.hasFill) {
                    SVGAndroidRenderer.this.canvas.drawText(text, this.x, this.y, ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint);
                }
                if (((SVGAndroidRenderer)SVGAndroidRenderer.this).state.hasStroke) {
                    SVGAndroidRenderer.this.canvas.drawText(text, this.x, this.y, ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.strokePaint);
                }
            }
            this.x += ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.measureText(text);
        }
    }

    private class RendererState
    implements Cloneable {
        public SVG.Style style;
        public boolean hasFill;
        public boolean hasStroke;
        public Paint fillPaint = new Paint();
        public Paint strokePaint;
        public SVG.Box viewPort;
        public SVG.Box viewBox;
        public boolean spacePreserve;
        public boolean directRendering;

        public RendererState() {
            this.fillPaint.setFlags(385);
            this.fillPaint.setStyle(Paint.Style.FILL);
            this.fillPaint.setTypeface(Typeface.DEFAULT);
            this.strokePaint = new Paint();
            this.strokePaint.setFlags(385);
            this.strokePaint.setStyle(Paint.Style.STROKE);
            this.strokePaint.setTypeface(Typeface.DEFAULT);
            this.style = SVG.Style.getDefaultStyle();
        }

        protected Object clone() {
            try {
                RendererState obj = (RendererState)super.clone();
                obj.style = (SVG.Style)this.style.clone();
                obj.fillPaint = new Paint(this.fillPaint);
                obj.strokePaint = new Paint(this.strokePaint);
                return obj;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e.toString());
            }
        }
    }
}

