/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.platform;

import android.content.SharedPreferences;
import java.util.Map;

public class Preferences
implements com.guidebee.game.Preferences {
    SharedPreferences sharedPrefs;
    SharedPreferences.Editor editor;

    public Preferences(SharedPreferences preferences) {
        this.sharedPrefs = preferences;
    }

    @Override
    public com.guidebee.game.Preferences putBoolean(String key, boolean val) {
        this.edit();
        this.editor.putBoolean(key, val);
        return this;
    }

    @Override
    public com.guidebee.game.Preferences putInteger(String key, int val) {
        this.edit();
        this.editor.putInt(key, val);
        return this;
    }

    @Override
    public com.guidebee.game.Preferences putLong(String key, long val) {
        this.edit();
        this.editor.putLong(key, val);
        return this;
    }

    @Override
    public com.guidebee.game.Preferences putFloat(String key, float val) {
        this.edit();
        this.editor.putFloat(key, val);
        return this;
    }

    @Override
    public com.guidebee.game.Preferences putString(String key, String val) {
        this.edit();
        this.editor.putString(key, val);
        return this;
    }

    @Override
    public com.guidebee.game.Preferences put(Map<String, ?> vals) {
        this.edit();
        for (Map.Entry<String, ?> val : vals.entrySet()) {
            if (val.getValue() instanceof Boolean) {
                this.putBoolean(val.getKey(), (Boolean)val.getValue());
            }
            if (val.getValue() instanceof Integer) {
                this.putInteger(val.getKey(), (Integer)val.getValue());
            }
            if (val.getValue() instanceof Long) {
                this.putLong(val.getKey(), (Long)val.getValue());
            }
            if (val.getValue() instanceof String) {
                this.putString(val.getKey(), (String)val.getValue());
            }
            if (!(val.getValue() instanceof Float)) continue;
            this.putFloat(val.getKey(), ((Float)val.getValue()).floatValue());
        }
        return this;
    }

    @Override
    public boolean getBoolean(String key) {
        return this.sharedPrefs.getBoolean(key, false);
    }

    @Override
    public int getInteger(String key) {
        return this.sharedPrefs.getInt(key, 0);
    }

    @Override
    public long getLong(String key) {
        return this.sharedPrefs.getLong(key, 0L);
    }

    @Override
    public float getFloat(String key) {
        return this.sharedPrefs.getFloat(key, 0.0f);
    }

    @Override
    public String getString(String key) {
        return this.sharedPrefs.getString(key, "");
    }

    @Override
    public boolean getBoolean(String key, boolean defValue) {
        return this.sharedPrefs.getBoolean(key, defValue);
    }

    @Override
    public int getInteger(String key, int defValue) {
        return this.sharedPrefs.getInt(key, defValue);
    }

    @Override
    public long getLong(String key, long defValue) {
        return this.sharedPrefs.getLong(key, defValue);
    }

    @Override
    public float getFloat(String key, float defValue) {
        return this.sharedPrefs.getFloat(key, defValue);
    }

    @Override
    public String getString(String key, String defValue) {
        return this.sharedPrefs.getString(key, defValue);
    }

    @Override
    public Map<String, ?> get() {
        return this.sharedPrefs.getAll();
    }

    @Override
    public boolean contains(String key) {
        return this.sharedPrefs.contains(key);
    }

    @Override
    public void clear() {
        this.edit();
        this.editor.clear();
    }

    @Override
    public void flush() {
        if (this.editor != null) {
            this.editor.commit();
            this.editor = null;
        }
    }

    @Override
    public void remove(String key) {
        this.edit();
        this.editor.remove(key);
    }

    private void edit() {
        if (this.editor == null) {
            this.editor = this.sharedPrefs.edit();
        }
    }
}

