/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.platform;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.Vibrator;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.guidebee.game.Application;
import com.guidebee.game.Configuration;
import com.guidebee.game.GameEngine;
import com.guidebee.game.Graphics;
import com.guidebee.game.Input;
import com.guidebee.game.InputProcessor;
import com.guidebee.game.engine.platform.Graphics;
import com.guidebee.game.engine.platform.ITouchHandler;
import com.guidebee.game.engine.platform.MultiTouchHandler;
import com.guidebee.game.engine.platform.OnscreenKeyboard;
import com.guidebee.game.graphics.Pixmap;
import com.guidebee.utils.Pool;
import java.util.ArrayList;
import java.util.Arrays;

public class Input
implements com.guidebee.game.Input,
View.OnKeyListener,
View.OnTouchListener {
    Pool<KeyEvent> usedKeyEvents = new Pool<KeyEvent>(16, 1000){

        @Override
        protected KeyEvent newObject() {
            return new KeyEvent();
        }
    };
    Pool<TouchEvent> usedTouchEvents = new Pool<TouchEvent>(16, 1000){

        @Override
        protected TouchEvent newObject() {
            return new TouchEvent();
        }
    };
    public static final int NUM_TOUCHES = 40;
    ArrayList<View.OnKeyListener> keyListeners = new ArrayList();
    ArrayList<KeyEvent> keyEvents = new ArrayList();
    ArrayList<TouchEvent> touchEvents = new ArrayList();
    int[] touchX = new int[40];
    int[] touchY = new int[40];
    int[] deltaX = new int[40];
    int[] deltaY = new int[40];
    boolean[] touched = new boolean[40];
    int[] realId = new int[40];
    final boolean hasMultitouch;
    private int keyCount = 0;
    private boolean[] keys = new boolean[256];
    private boolean keyJustPressed = false;
    private boolean[] justPressedKeys = new boolean[256];
    private SensorManager manager;
    public boolean accelerometerAvailable = false;
    private final float[] accelerometerValues = new float[3];
    private String text = null;
    private Input.TextInputListener textListener = null;
    private Handler handle;
    final Application app;
    final Context context;
    private final ITouchHandler touchHandler;
    private int sleepTime = 0;
    private boolean catchBack = false;
    private boolean catchMenu = false;
    protected final Vibrator vibrator;
    private boolean compassAvailable = false;
    public boolean keyboardAvailable;
    private final float[] magneticFieldValues = new float[3];
    private float azimuth = 0.0f;
    private float pitch = 0.0f;
    private float roll = 0.0f;
    private float inclination = 0.0f;
    private boolean justTouched = false;
    private InputProcessor processor;
    private final Configuration config;
    private final Input.Orientation nativeOrientation;
    private long currentEventTimeStamp = System.nanoTime();
    private final OnscreenKeyboard onscreenKeyboard;
    private SensorEventListener accelerometerListener;
    private SensorEventListener compassListener;
    boolean requestFocus = true;
    final float[] R = new float[9];
    final float[] orientation = new float[3];

    public Input(Application activity, Context context, Object view, Configuration config) {
        if (view instanceof View) {
            View v = (View)view;
            v.setOnKeyListener((View.OnKeyListener)this);
            v.setOnTouchListener((View.OnTouchListener)this);
            v.setFocusable(true);
            v.setFocusableInTouchMode(true);
            v.requestFocus();
            v.requestFocusFromTouch();
        }
        this.config = config;
        this.onscreenKeyboard = new OnscreenKeyboard(context, new Handler(), this);
        for (int i = 0; i < this.realId.length; ++i) {
            this.realId[i] = -1;
        }
        this.handle = new Handler();
        this.app = activity;
        this.context = context;
        this.sleepTime = config.touchSleepTime;
        this.touchHandler = new MultiTouchHandler();
        this.hasMultitouch = this.touchHandler.supportsMultitouch(context);
        this.vibrator = (Vibrator)context.getSystemService("vibrator");
        int rotation = this.getRotation();
        Graphics.DisplayMode mode = this.app.getGraphics().getDesktopDisplayMode();
        this.nativeOrientation = (rotation == 0 || rotation == 180) && mode.width >= mode.height || (rotation == 90 || rotation == 270) && mode.width <= mode.height ? Input.Orientation.Landscape : Input.Orientation.Portrait;
    }

    @Override
    public float getAccelerometerX() {
        return this.accelerometerValues[0];
    }

    @Override
    public float getAccelerometerY() {
        return this.accelerometerValues[1];
    }

    @Override
    public float getAccelerometerZ() {
        return this.accelerometerValues[2];
    }

    @Override
    public void getTextInput(final Input.TextInputListener listener, final String title, final String text) {
        this.handle.post(new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder alert = new AlertDialog.Builder(Input.this.context);
                alert.setTitle((CharSequence)title);
                final EditText input = new EditText(Input.this.context);
                input.setText((CharSequence)text);
                input.setSingleLine();
                alert.setView((View)input);
                alert.setPositiveButton((CharSequence)Input.this.context.getString(17039370), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        GameEngine.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                listener.input(input.getText().toString());
                            }
                        });
                    }
                });
                alert.setNegativeButton((CharSequence)Input.this.context.getString(0x1040000), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        GameEngine.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                listener.canceled();
                            }
                        });
                    }
                });
                alert.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface arg0) {
                        GameEngine.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                listener.canceled();
                            }
                        });
                    }
                });
                alert.show();
            }
        });
    }

    @Override
    public void getPlaceholderTextInput(final Input.TextInputListener listener, final String title, final String placeholder) {
        this.handle.post(new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder alert = new AlertDialog.Builder(Input.this.context);
                alert.setTitle((CharSequence)title);
                final EditText input = new EditText(Input.this.context);
                input.setHint((CharSequence)placeholder);
                input.setSingleLine();
                alert.setView((View)input);
                alert.setPositiveButton((CharSequence)Input.this.context.getString(17039370), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        GameEngine.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                listener.input(input.getText().toString());
                            }
                        });
                    }
                });
                alert.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface arg0) {
                        GameEngine.app.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                listener.canceled();
                            }
                        });
                    }
                });
                alert.show();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getX() {
        Input input = this;
        synchronized (input) {
            return this.touchX[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getY() {
        Input input = this;
        synchronized (input) {
            return this.touchY[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getX(int pointer) {
        Input input = this;
        synchronized (input) {
            return this.touchX[pointer];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getY(int pointer) {
        Input input = this;
        synchronized (input) {
            return this.touchY[pointer];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTouched(int pointer) {
        Input input = this;
        synchronized (input) {
            return this.touched[pointer];
        }
    }

    @Override
    public synchronized boolean isKeyPressed(int key) {
        if (key == -1) {
            return this.keyCount > 0;
        }
        if (key < 0 || key > 255) {
            return false;
        }
        return this.keys[key];
    }

    @Override
    public synchronized boolean isKeyJustPressed(int key) {
        if (key == -1) {
            return this.keyJustPressed;
        }
        if (key < 0 || key > 255) {
            return false;
        }
        return this.justPressedKeys[key];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTouched() {
        Input input = this;
        synchronized (input) {
            return this.touched[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInputProcessor(InputProcessor processor) {
        Input input = this;
        synchronized (input) {
            this.processor = processor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processEvents() {
        Input input = this;
        synchronized (input) {
            this.justTouched = false;
            if (this.keyJustPressed) {
                this.keyJustPressed = false;
                for (int i = 0; i < this.justPressedKeys.length; ++i) {
                    this.justPressedKeys[i] = false;
                }
            }
            if (this.processor != null) {
                Object e;
                int i;
                InputProcessor processor = this.processor;
                int len = this.keyEvents.size();
                for (i = 0; i < len; ++i) {
                    e = this.keyEvents.get(i);
                    this.currentEventTimeStamp = ((KeyEvent)e).timeStamp;
                    switch (((KeyEvent)e).type) {
                        case 0: {
                            processor.keyDown(((KeyEvent)e).keyCode);
                            this.keyJustPressed = true;
                            this.justPressedKeys[((KeyEvent)e).keyCode] = true;
                            break;
                        }
                        case 1: {
                            processor.keyUp(((KeyEvent)e).keyCode);
                            break;
                        }
                        case 2: {
                            processor.keyTyped(((KeyEvent)e).keyChar);
                        }
                    }
                    this.usedKeyEvents.free((KeyEvent)e);
                }
                len = this.touchEvents.size();
                for (i = 0; i < len; ++i) {
                    e = this.touchEvents.get(i);
                    this.currentEventTimeStamp = ((TouchEvent)e).timeStamp;
                    switch (((TouchEvent)e).type) {
                        case 0: {
                            processor.touchDown(((TouchEvent)e).x, ((TouchEvent)e).y, ((TouchEvent)e).pointer, 0);
                            this.justTouched = true;
                            break;
                        }
                        case 1: {
                            processor.touchUp(((TouchEvent)e).x, ((TouchEvent)e).y, ((TouchEvent)e).pointer, 0);
                            break;
                        }
                        case 2: {
                            processor.touchDragged(((TouchEvent)e).x, ((TouchEvent)e).y, ((TouchEvent)e).pointer);
                        }
                    }
                    this.usedTouchEvents.free((TouchEvent)e);
                }
            } else {
                int i;
                int len = this.touchEvents.size();
                for (i = 0; i < len; ++i) {
                    TouchEvent e = this.touchEvents.get(i);
                    if (e.type == 0) {
                        this.justTouched = true;
                    }
                    this.usedTouchEvents.free(e);
                }
                len = this.keyEvents.size();
                for (i = 0; i < len; ++i) {
                    this.usedKeyEvents.free(this.keyEvents.get(i));
                }
            }
            if (this.touchEvents.size() == 0) {
                for (int i = 0; i < this.deltaX.length; ++i) {
                    this.deltaX[0] = 0;
                    this.deltaY[0] = 0;
                }
            }
            this.keyEvents.clear();
            this.touchEvents.clear();
        }
    }

    public boolean onTouch(View view, MotionEvent event) {
        if (this.requestFocus && view != null) {
            view.requestFocus();
            view.requestFocusFromTouch();
            this.requestFocus = false;
        }
        this.touchHandler.onTouch(event, this);
        if (this.sleepTime != 0) {
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return true;
    }

    public void onTap(int x, int y) {
        this.postTap(x, y);
    }

    public void onDrop(int x, int y) {
        this.postTap(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postTap(int x, int y) {
        Input input = this;
        synchronized (input) {
            TouchEvent event = this.usedTouchEvents.obtain();
            event.timeStamp = System.nanoTime();
            event.pointer = 0;
            event.x = x;
            event.y = y;
            event.type = 0;
            this.touchEvents.add(event);
            event = this.usedTouchEvents.obtain();
            event.timeStamp = System.nanoTime();
            event.pointer = 0;
            event.x = x;
            event.y = y;
            event.type = 1;
            this.touchEvents.add(event);
        }
        GameEngine.app.getGraphics().requestRendering();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onKey(View v, int keyCode, android.view.KeyEvent e) {
        int n = this.keyListeners.size();
        for (int i = 0; i < n; ++i) {
            if (!this.keyListeners.get(i).onKey(v, keyCode, e)) continue;
            return true;
        }
        Input input = this;
        synchronized (input) {
            KeyEvent event = null;
            if (e.getKeyCode() == 0 && e.getAction() == 2) {
                String chars = e.getCharacters();
                for (int i = 0; i < chars.length(); ++i) {
                    event = this.usedKeyEvents.obtain();
                    event.timeStamp = System.nanoTime();
                    event.keyCode = 0;
                    event.keyChar = chars.charAt(i);
                    event.type = 2;
                    this.keyEvents.add(event);
                }
                return false;
            }
            int character = e.getUnicodeChar();
            if (keyCode == 67) {
                character = 8;
            }
            switch (e.getAction()) {
                case 0: {
                    event = this.usedKeyEvents.obtain();
                    event.timeStamp = System.nanoTime();
                    event.keyChar = '\u0000';
                    event.keyCode = e.getKeyCode();
                    event.type = 0;
                    if (keyCode == 4 && e.isAltPressed()) {
                        event.keyCode = keyCode = 255;
                    }
                    this.keyEvents.add(event);
                    if (this.keys[event.keyCode]) break;
                    ++this.keyCount;
                    this.keys[event.keyCode] = true;
                    break;
                }
                case 1: {
                    long timeStamp = System.nanoTime();
                    event = this.usedKeyEvents.obtain();
                    event.timeStamp = timeStamp;
                    event.keyChar = '\u0000';
                    event.keyCode = e.getKeyCode();
                    event.type = 1;
                    if (keyCode == 4 && e.isAltPressed()) {
                        event.keyCode = keyCode = 255;
                    }
                    this.keyEvents.add(event);
                    event = this.usedKeyEvents.obtain();
                    event.timeStamp = timeStamp;
                    event.keyChar = (char)character;
                    event.keyCode = 0;
                    event.type = 2;
                    this.keyEvents.add(event);
                    if (keyCode == 255) {
                        if (!this.keys[255]) break;
                        --this.keyCount;
                        this.keys[255] = false;
                        break;
                    }
                    if (!this.keys[e.getKeyCode()]) break;
                    --this.keyCount;
                    this.keys[e.getKeyCode()] = false;
                }
            }
            this.app.getGraphics().requestRendering();
        }
        if (keyCode == 255) {
            return true;
        }
        if (this.catchBack && keyCode == 4) {
            return true;
        }
        return this.catchMenu && keyCode == 82;
    }

    @Override
    public void setOnscreenKeyboardVisible(final boolean visible) {
        this.handle.post(new Runnable(){

            @Override
            public void run() {
                InputMethodManager manager = (InputMethodManager)Input.this.context.getSystemService("input_method");
                if (visible) {
                    View view = ((Graphics)Input.this.app.getGraphics()).getView();
                    view.setFocusable(true);
                    view.setFocusableInTouchMode(true);
                    manager.showSoftInput(((Graphics)Input.this.app.getGraphics()).getView(), 0);
                } else {
                    manager.hideSoftInputFromWindow(((Graphics)Input.this.app.getGraphics()).getView().getWindowToken(), 0);
                }
            }
        });
    }

    @Override
    public void setCatchBackKey(boolean catchBack) {
        this.catchBack = catchBack;
    }

    @Override
    public void setCatchMenuKey(boolean catchMenu) {
        this.catchMenu = catchMenu;
    }

    @Override
    public void vibrate(int milliseconds) {
        this.vibrator.vibrate((long)milliseconds);
    }

    @Override
    public void vibrate(long[] pattern, int repeat) {
        this.vibrator.vibrate(pattern, repeat);
    }

    @Override
    public void cancelVibrate() {
        this.vibrator.cancel();
    }

    @Override
    public boolean justTouched() {
        return this.justTouched;
    }

    @Override
    public boolean isButtonPressed(int button) {
        if (button == 0) {
            return this.isTouched();
        }
        return false;
    }

    private void updateOrientation() {
        if (SensorManager.getRotationMatrix((float[])this.R, null, (float[])this.accelerometerValues, (float[])this.magneticFieldValues)) {
            SensorManager.getOrientation((float[])this.R, (float[])this.orientation);
            this.azimuth = (float)Math.toDegrees(this.orientation[0]);
            this.pitch = (float)Math.toDegrees(this.orientation[1]);
            this.roll = (float)Math.toDegrees(this.orientation[2]);
        }
    }

    @Override
    public void getRotationMatrix(float[] matrix) {
        SensorManager.getRotationMatrix((float[])matrix, null, (float[])this.accelerometerValues, (float[])this.magneticFieldValues);
    }

    @Override
    public float getAzimuth() {
        if (!this.compassAvailable) {
            return 0.0f;
        }
        this.updateOrientation();
        return this.azimuth;
    }

    @Override
    public float getPitch() {
        if (!this.compassAvailable) {
            return 0.0f;
        }
        this.updateOrientation();
        return this.pitch;
    }

    @Override
    public float getRoll() {
        if (!this.compassAvailable) {
            return 0.0f;
        }
        this.updateOrientation();
        return this.roll;
    }

    void registerSensorListeners() {
        if (this.config.useAccelerometer) {
            this.manager = (SensorManager)this.context.getSystemService("sensor");
            if (this.manager.getSensorList(1).size() == 0) {
                this.accelerometerAvailable = false;
            } else {
                Sensor accelerometer = (Sensor)this.manager.getSensorList(1).get(0);
                this.accelerometerListener = new SensorListener(this.nativeOrientation, this.accelerometerValues, this.magneticFieldValues);
                this.accelerometerAvailable = this.manager.registerListener(this.accelerometerListener, accelerometer, 1);
            }
        } else {
            this.accelerometerAvailable = false;
        }
        if (this.config.useCompass) {
            Sensor sensor;
            if (this.manager == null) {
                this.manager = (SensorManager)this.context.getSystemService("sensor");
            }
            if ((sensor = this.manager.getDefaultSensor(2)) != null) {
                this.compassAvailable = this.accelerometerAvailable;
                if (this.compassAvailable) {
                    this.compassListener = new SensorListener(this.nativeOrientation, this.accelerometerValues, this.magneticFieldValues);
                    this.compassAvailable = this.manager.registerListener(this.compassListener, sensor, 1);
                }
            } else {
                this.compassAvailable = false;
            }
        } else {
            this.compassAvailable = false;
        }
        GameEngine.app.log("Input", "sensor listener setup");
    }

    void unregisterSensorListeners() {
        if (this.manager != null) {
            if (this.accelerometerListener != null) {
                this.manager.unregisterListener(this.accelerometerListener);
                this.accelerometerListener = null;
            }
            if (this.compassListener != null) {
                this.manager.unregisterListener(this.compassListener);
                this.compassListener = null;
            }
            this.manager = null;
        }
        GameEngine.app.log("Input", "sensor listener tear down");
    }

    @Override
    public InputProcessor getInputProcessor() {
        return this.processor;
    }

    @Override
    public boolean isPeripheralAvailable(Input.Peripheral peripheral) {
        if (peripheral == Input.Peripheral.Accelerometer) {
            return this.accelerometerAvailable;
        }
        if (peripheral == Input.Peripheral.Compass) {
            return this.compassAvailable;
        }
        if (peripheral == Input.Peripheral.HardwareKeyboard) {
            return this.keyboardAvailable;
        }
        if (peripheral == Input.Peripheral.OnscreenKeyboard) {
            return true;
        }
        if (peripheral == Input.Peripheral.Vibrator) {
            return this.vibrator != null;
        }
        if (peripheral == Input.Peripheral.MultitouchScreen) {
            return this.hasMultitouch;
        }
        return false;
    }

    public int getFreePointerIndex() {
        int len = this.realId.length;
        for (int i = 0; i < len; ++i) {
            if (this.realId[i] != -1) continue;
            return i;
        }
        this.realId = this.resize(this.realId);
        this.touchX = this.resize(this.touchX);
        this.touchY = this.resize(this.touchY);
        this.deltaX = this.resize(this.deltaX);
        this.deltaY = this.resize(this.deltaY);
        this.touched = this.resize(this.touched);
        return len;
    }

    private int[] resize(int[] orig) {
        int[] tmp = new int[orig.length + 2];
        System.arraycopy(orig, 0, tmp, 0, orig.length);
        return tmp;
    }

    private boolean[] resize(boolean[] orig) {
        boolean[] tmp = new boolean[orig.length + 2];
        System.arraycopy(orig, 0, tmp, 0, orig.length);
        return tmp;
    }

    public int lookUpPointerIndex(int pointerId) {
        int len = this.realId.length;
        for (int i = 0; i < len; ++i) {
            if (this.realId[i] != pointerId) continue;
            return i;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            buf.append(i + ":" + this.realId[i] + " ");
        }
        GameEngine.app.log("Input", "Pointer ID lookup failed: " + pointerId + ", " + buf.toString());
        return -1;
    }

    @Override
    public int getRotation() {
        int orientation = 0;
        orientation = this.context instanceof Activity ? ((Activity)this.context).getWindowManager().getDefaultDisplay().getRotation() : ((WindowManager)this.context.getSystemService("window")).getDefaultDisplay().getRotation();
        switch (orientation) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    @Override
    public Input.Orientation getNativeOrientation() {
        return this.nativeOrientation;
    }

    @Override
    public void setCursorCaught(boolean catched) {
    }

    @Override
    public boolean isCursorCaught() {
        return false;
    }

    @Override
    public int getDeltaX() {
        return this.deltaX[0];
    }

    @Override
    public int getDeltaX(int pointer) {
        return this.deltaX[pointer];
    }

    @Override
    public int getDeltaY() {
        return this.deltaY[0];
    }

    @Override
    public int getDeltaY(int pointer) {
        return this.deltaY[pointer];
    }

    @Override
    public void setCursorPosition(int x, int y) {
    }

    @Override
    public void setCursorImage(Pixmap pixmap, int xHotspot, int yHotspot) {
    }

    @Override
    public long getCurrentEventTime() {
        return this.currentEventTimeStamp;
    }

    public void addKeyListener(View.OnKeyListener listener) {
        this.keyListeners.add(listener);
    }

    public void onPause() {
        this.unregisterSensorListeners();
        Arrays.fill(this.realId, -1);
        Arrays.fill(this.touched, false);
    }

    public void onResume() {
        this.registerSensorListeners();
    }

    private class SensorListener
    implements SensorEventListener {
        final float[] accelerometerValues;
        final float[] magneticFieldValues;
        final Input.Orientation nativeOrientation;

        SensorListener(Input.Orientation nativeOrientation, float[] accelerometerValues, float[] magneticFieldValues) {
            this.accelerometerValues = accelerometerValues;
            this.magneticFieldValues = magneticFieldValues;
            this.nativeOrientation = nativeOrientation;
        }

        public void onAccuracyChanged(Sensor arg0, int arg1) {
        }

        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.getType() == 1) {
                if (this.nativeOrientation == Input.Orientation.Portrait) {
                    System.arraycopy(event.values, 0, this.accelerometerValues, 0, this.accelerometerValues.length);
                } else {
                    this.accelerometerValues[0] = event.values[1];
                    this.accelerometerValues[1] = -event.values[0];
                    this.accelerometerValues[2] = event.values[2];
                }
            }
            if (event.sensor.getType() == 2) {
                System.arraycopy(event.values, 0, this.magneticFieldValues, 0, this.magneticFieldValues.length);
            }
        }
    }

    static class TouchEvent {
        static final int TOUCH_DOWN = 0;
        static final int TOUCH_UP = 1;
        static final int TOUCH_DRAGGED = 2;
        long timeStamp;
        int type;
        int x;
        int y;
        int pointer;

        TouchEvent() {
        }
    }

    static class KeyEvent {
        static final int KEY_DOWN = 0;
        static final int KEY_UP = 1;
        static final int KEY_TYPED = 2;
        long timeStamp;
        int type;
        int keyCode;
        char keyChar;

        KeyEvent() {
        }
    }
}

