/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.platform;

import android.content.res.AssetManager;
import android.os.Environment;
import com.guidebee.game.Files;
import com.guidebee.game.engine.platform.FileHandle;

public class Files
implements com.guidebee.game.Files {
    protected final String sdcard = Environment.getExternalStorageDirectory().getAbsolutePath() + "/";
    protected final String localpath;
    protected final AssetManager assets;

    public Files(AssetManager assets) {
        this.assets = assets;
        this.localpath = this.sdcard;
    }

    public Files(AssetManager assets, String localpath) {
        this.assets = assets;
        this.localpath = localpath.endsWith("/") ? localpath : localpath + "/";
    }

    @Override
    public com.guidebee.game.files.FileHandle getFileHandle(String path, Files.FileType type) {
        return new FileHandle(type == Files.FileType.Internal ? this.assets : null, path, type);
    }

    @Override
    public com.guidebee.game.files.FileHandle classpath(String path) {
        return new FileHandle(null, path, Files.FileType.Classpath);
    }

    @Override
    public com.guidebee.game.files.FileHandle internal(String path) {
        return new FileHandle(this.assets, path, Files.FileType.Internal);
    }

    @Override
    public com.guidebee.game.files.FileHandle external(String path) {
        return new FileHandle(null, path, Files.FileType.External);
    }

    @Override
    public com.guidebee.game.files.FileHandle absolute(String path) {
        return new FileHandle(null, path, Files.FileType.Absolute);
    }

    @Override
    public com.guidebee.game.files.FileHandle local(String path) {
        return new FileHandle(null, path, Files.FileType.Local);
    }

    @Override
    public String getExternalStoragePath() {
        return this.sdcard;
    }

    @Override
    public boolean isExternalStorageAvailable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    @Override
    public String getLocalStoragePath() {
        return this.localpath;
    }

    @Override
    public boolean isLocalStorageAvailable() {
        return true;
    }
}

