/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.platform;

import android.media.AudioRecord;
import com.guidebee.game.GameEngineRuntimeException;

public class AudioRecorder
implements com.guidebee.game.audio.AudioRecorder {
    private AudioRecord recorder;

    public AudioRecorder(int samplingRate, boolean isMono) {
        int channelConfig = isMono ? 16 : 12;
        int minBufferSize = AudioRecord.getMinBufferSize((int)samplingRate, (int)channelConfig, (int)2);
        this.recorder = new AudioRecord(1, samplingRate, channelConfig, 2, minBufferSize);
        if (this.recorder.getState() != 1) {
            throw new GameEngineRuntimeException("Unable to initialize AudioRecorder.\nDo you have the RECORD_AUDIO permission?");
        }
        this.recorder.startRecording();
    }

    @Override
    public void dispose() {
        this.recorder.stop();
        this.recorder.release();
    }

    @Override
    public void read(short[] samples, int offset, int numSamples) {
        for (int read = 0; read != numSamples; read += this.recorder.read(samples, offset + read, numSamples - read)) {
        }
    }
}

