/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.graphics;

import com.guidebee.game.GameEngine;
import com.guidebee.game.GameEngineRuntimeException;
import com.guidebee.game.engine.graphics.GLTexture;
import com.guidebee.game.engine.graphics.opengles.PixmapTextureData;
import com.guidebee.game.files.FileHandle;
import com.guidebee.game.graphics.Pixmap;
import com.guidebee.game.graphics.Texture;
import com.guidebee.game.graphics.TextureData;

public class Cubemap
extends GLTexture {
    protected final TextureData[] data = new TextureData[6];

    public Cubemap() {
        this((TextureData)null, (TextureData)null, (TextureData)null, (TextureData)null, (TextureData)null, (TextureData)null);
    }

    public Cubemap(FileHandle positiveX, FileHandle negativeX, FileHandle positiveY, FileHandle negativeY, FileHandle positiveZ, FileHandle negativeZ) {
        this(positiveX, negativeX, positiveY, negativeY, positiveZ, negativeZ, false);
    }

    public Cubemap(FileHandle positiveX, FileHandle negativeX, FileHandle positiveY, FileHandle negativeY, FileHandle positiveZ, FileHandle negativeZ, boolean useMipMaps) {
        this(Cubemap.createTextureData(positiveX, useMipMaps), Cubemap.createTextureData(negativeX, useMipMaps), Cubemap.createTextureData(positiveY, useMipMaps), Cubemap.createTextureData(negativeY, useMipMaps), Cubemap.createTextureData(positiveZ, useMipMaps), Cubemap.createTextureData(negativeZ, useMipMaps));
    }

    public Cubemap(Pixmap positiveX, Pixmap negativeX, Pixmap positiveY, Pixmap negativeY, Pixmap positiveZ, Pixmap negativeZ) {
        this(positiveX, negativeX, positiveY, negativeY, positiveZ, negativeZ, false);
    }

    public Cubemap(Pixmap positiveX, Pixmap negativeX, Pixmap positiveY, Pixmap negativeY, Pixmap positiveZ, Pixmap negativeZ, boolean useMipMaps) {
        this(positiveX == null ? null : new PixmapTextureData(positiveX, null, useMipMaps, false), negativeX == null ? null : new PixmapTextureData(negativeX, null, useMipMaps, false), positiveY == null ? null : new PixmapTextureData(positiveY, null, useMipMaps, false), negativeY == null ? null : new PixmapTextureData(negativeY, null, useMipMaps, false), positiveZ == null ? null : new PixmapTextureData(positiveZ, null, useMipMaps, false), negativeZ == null ? null : new PixmapTextureData(negativeZ, null, useMipMaps, false));
    }

    public Cubemap(int width, int height, int depth, Pixmap.Format format) {
        this(new PixmapTextureData(new Pixmap(depth, height, format), null, false, true), new PixmapTextureData(new Pixmap(depth, height, format), null, false, true), new PixmapTextureData(new Pixmap(width, depth, format), null, false, true), new PixmapTextureData(new Pixmap(width, depth, format), null, false, true), new PixmapTextureData(new Pixmap(width, height, format), null, false, true), new PixmapTextureData(new Pixmap(width, height, format), null, false, true));
    }

    public Cubemap(TextureData positiveX, TextureData negativeX, TextureData positiveY, TextureData negativeY, TextureData positiveZ, TextureData negativeZ) {
        super(34067);
        this.minFilter = Texture.TextureFilter.Nearest;
        this.magFilter = Texture.TextureFilter.Nearest;
        this.uWrap = Texture.TextureWrap.ClampToEdge;
        this.vWrap = Texture.TextureWrap.ClampToEdge;
        this.load(positiveX, negativeX, positiveY, negativeY, positiveZ, negativeZ);
    }

    public void load(TextureData positiveX, TextureData negativeX, TextureData positiveY, TextureData negativeY, TextureData positiveZ, TextureData negativeZ) {
        this.bind();
        this.unsafeSetFilter(this.minFilter, this.magFilter, true);
        this.unsafeSetWrap(this.uWrap, this.vWrap, true);
        this.unsafeLoad(CubemapSide.PositiveX, positiveX);
        this.unsafeLoad(CubemapSide.NegativeX, negativeX);
        this.unsafeLoad(CubemapSide.PositiveY, positiveY);
        this.unsafeLoad(CubemapSide.NegativeY, negativeY);
        this.unsafeLoad(CubemapSide.PositiveZ, positiveZ);
        this.unsafeLoad(CubemapSide.NegativeZ, negativeZ);
        GameEngine.gl.glBindTexture(this.glTarget, 0);
    }

    @Override
    public boolean isManaged() {
        for (TextureData data : this.data) {
            if (data.isManaged()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void reload() {
        if (!this.isManaged()) {
            throw new GameEngineRuntimeException("Tried to reload an unmanaged Cubemap");
        }
        this.glHandle = Cubemap.createGLHandle();
        this.load(this.data[CubemapSide.PositiveX.index], this.data[CubemapSide.NegativeX.index], this.data[CubemapSide.PositiveY.index], this.data[CubemapSide.NegativeY.index], this.data[CubemapSide.PositiveZ.index], this.data[CubemapSide.NegativeZ.index]);
    }

    public void load(CubemapSide side, FileHandle file) {
        this.load(side, file, false);
    }

    public void load(CubemapSide side, FileHandle file, boolean useMipMaps) {
        this.load(side, Cubemap.createTextureData(file, useMipMaps));
    }

    public void load(CubemapSide side, Pixmap pixmap) {
        this.load(side, pixmap == null ? null : new PixmapTextureData(pixmap, null, false, false));
    }

    public void load(CubemapSide side, Pixmap pixmap, boolean useMipMaps) {
        this.load(side, pixmap == null ? null : new PixmapTextureData(pixmap, null, useMipMaps, false));
    }

    public void load(CubemapSide side, TextureData data) {
        this.bind();
        this.unsafeLoad(side, data);
        GameEngine.gl.glBindTexture(this.glTarget, 0);
    }

    protected void unsafeLoad(CubemapSide side, TextureData data) {
        int idx = side.index;
        if (this.data[idx] != null && data != null && data.isManaged() != this.data[idx].isManaged()) {
            throw new GameEngineRuntimeException("New data must have the same managed status as the old data");
        }
        Cubemap.uploadImageData(side.glEnum, data);
        this.data[idx] = data;
    }

    public boolean isComplete() {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != null) continue;
            return false;
        }
        return true;
    }

    public TextureData getTextureData(CubemapSide side) {
        return this.data[side.index];
    }

    @Override
    public int getWidth() {
        int tmp;
        int width = 0;
        if (this.data[CubemapSide.PositiveZ.index] != null && (tmp = this.data[CubemapSide.PositiveZ.index].getWidth()) > width) {
            width = tmp;
        }
        if (this.data[CubemapSide.NegativeZ.index] != null && (tmp = this.data[CubemapSide.NegativeZ.index].getWidth()) > width) {
            width = tmp;
        }
        if (this.data[CubemapSide.PositiveY.index] != null && (tmp = this.data[CubemapSide.PositiveY.index].getWidth()) > width) {
            width = tmp;
        }
        if (this.data[CubemapSide.NegativeY.index] != null && (tmp = this.data[CubemapSide.NegativeY.index].getWidth()) > width) {
            width = tmp;
        }
        return width;
    }

    @Override
    public int getHeight() {
        int tmp;
        int height = 0;
        if (this.data[CubemapSide.PositiveZ.index] != null && (tmp = this.data[CubemapSide.PositiveZ.index].getHeight()) > height) {
            height = tmp;
        }
        if (this.data[CubemapSide.NegativeZ.index] != null && (tmp = this.data[CubemapSide.NegativeZ.index].getHeight()) > height) {
            height = tmp;
        }
        if (this.data[CubemapSide.PositiveX.index] != null && (tmp = this.data[CubemapSide.PositiveX.index].getHeight()) > height) {
            height = tmp;
        }
        if (this.data[CubemapSide.NegativeX.index] != null && (tmp = this.data[CubemapSide.NegativeX.index].getHeight()) > height) {
            height = tmp;
        }
        return height;
    }

    @Override
    public int getDepth() {
        int tmp;
        int depth = 0;
        if (this.data[CubemapSide.PositiveX.index] != null && (tmp = this.data[CubemapSide.PositiveX.index].getWidth()) > depth) {
            depth = tmp;
        }
        if (this.data[CubemapSide.NegativeX.index] != null && (tmp = this.data[CubemapSide.NegativeX.index].getWidth()) > depth) {
            depth = tmp;
        }
        if (this.data[CubemapSide.PositiveY.index] != null && (tmp = this.data[CubemapSide.PositiveY.index].getHeight()) > depth) {
            depth = tmp;
        }
        if (this.data[CubemapSide.NegativeY.index] != null && (tmp = this.data[CubemapSide.NegativeY.index].getHeight()) > depth) {
            depth = tmp;
        }
        return depth;
    }

    public static enum CubemapSide {
        PositiveX(0, 34069),
        NegativeX(1, 34070),
        PositiveY(2, 34071),
        NegativeY(3, 34072),
        PositiveZ(4, 34073),
        NegativeZ(5, 34074);

        public final int index;
        public final int glEnum;

        private CubemapSide(int index, int glEnum) {
            this.index = index;
            this.glEnum = glEnum;
        }

        public int getGLEnum() {
            return this.glEnum;
        }
    }
}

