/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.drawing.parser;

import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.game.engine.drawing.parser.NumberParser;
import com.guidebee.game.engine.math.MathEx;

public class TransformListParser
extends NumberParser {
    private AffineTransform transform;

    public AffineTransform parseTransformList(String txfStr) {
        this.setString(txfStr);
        this.transform = new AffineTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        this.current = this.read();
        this.skipSpaces();
        block11: while (true) {
            block0 : switch (this.current) {
                case 109: {
                    this.parseMatrix();
                    break;
                }
                case 114: {
                    this.parseRotate();
                    break;
                }
                case 116: {
                    this.parseTranslate();
                    break;
                }
                case 115: {
                    this.current = this.read();
                    switch (this.current) {
                        case 99: {
                            this.parseScale();
                            break block0;
                        }
                        case 107: {
                            this.parseSkew();
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException();
                }
                case -1: {
                    break block11;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.current = this.read();
            this.skipCommaSpaces();
        }
        return this.transform;
    }

    protected final void parseMatrix() {
        this.current = this.read();
        if (this.current != 97) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        if (this.current != 116) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        if (this.current != 114) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        if (this.current != 105) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        if (this.current != 120) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        this.skipSpaces();
        if (this.current != 40) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        this.skipSpaces();
        float a = this.parseNumber();
        this.skipCommaSpaces();
        float b = this.parseNumber();
        this.skipCommaSpaces();
        float c = this.parseNumber();
        this.skipCommaSpaces();
        float d = this.parseNumber();
        this.skipCommaSpaces();
        float e = this.parseNumber();
        this.skipCommaSpaces();
        float f = this.parseNumber();
        this.skipSpaces();
        if (this.current != 41) {
            throw new IllegalArgumentException("Expected ')' and got >" + (char)this.current + "<");
        }
        this.transform.concatenate(new AffineTransform(a, b, c, d, e, f));
    }

    protected final void parseRotate() {
        this.current = this.read();
        if (this.current != 111) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        if (this.current != 116) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        if (this.current != 97) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        if (this.current != 116) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        if (this.current != 101) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        this.skipSpaces();
        if (this.current != 40) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        this.skipSpaces();
        float theta = this.parseNumber();
        this.skipSpaces();
        switch (this.current) {
            case 41: {
                this.transform.rotate(theta);
                return;
            }
            case 44: {
                this.current = this.read();
                this.skipSpaces();
            }
        }
        float cx = this.parseNumber();
        this.skipCommaSpaces();
        float cy = this.parseNumber();
        this.skipSpaces();
        if (this.current != 41) {
            throw new IllegalArgumentException();
        }
        this.transform.translate(cx, cy);
        this.transform.rotate(theta);
        this.transform.translate(-cx, -cy);
    }

    protected final void parseTranslate() {
        this.current = this.read();
        if (this.current != 114) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        if (this.current != 97) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        if (this.current != 110) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        if (this.current != 115) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        if (this.current != 108) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        if (this.current != 97) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        if (this.current != 116) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        if (this.current != 101) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        this.skipSpaces();
        if (this.current != 40) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        this.skipSpaces();
        float tx = this.parseNumber();
        this.skipSpaces();
        switch (this.current) {
            case 41: {
                this.transform.translate(tx, 0.0);
                return;
            }
            case 44: {
                this.current = this.read();
                this.skipSpaces();
            }
        }
        float ty = this.parseNumber();
        this.skipSpaces();
        if (this.current != 41) {
            throw new IllegalArgumentException();
        }
        this.transform.translate(tx, ty);
    }

    protected final void parseScale() {
        this.current = this.read();
        if (this.current != 97) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        if (this.current != 108) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        if (this.current != 101) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        this.skipSpaces();
        if (this.current != 40) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        this.skipSpaces();
        float sx = this.parseNumber();
        this.skipSpaces();
        switch (this.current) {
            case 41: {
                this.transform.scale(sx, sx);
                return;
            }
            case 44: {
                this.current = this.read();
                this.skipSpaces();
            }
        }
        float sy = this.parseNumber();
        this.skipSpaces();
        if (this.current != 41) {
            throw new IllegalArgumentException();
        }
        this.transform.scale(sx, sy);
    }

    protected final void parseSkew() {
        this.current = this.read();
        if (this.current != 101) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        if (this.current != 119) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        boolean skewX = false;
        switch (this.current) {
            case 88: {
                skewX = true;
            }
            case 89: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.current = this.read();
        this.skipSpaces();
        if (this.current != 40) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        this.skipSpaces();
        float sk = this.parseNumber();
        this.skipSpaces();
        if (this.current != 41) {
            throw new IllegalArgumentException();
        }
        float tan = (float)MathEx.tan(MathEx.toRadians(sk));
        if (skewX) {
            AffineTransform shear = new AffineTransform(1.0, 0.0, tan, 1.0, 0.0, 0.0);
            this.transform.concatenate(shear);
        } else {
            AffineTransform shear = new AffineTransform(1.0, tan, 0.0, 1.0, 0.0, 0.0);
            this.transform.concatenate(shear);
        }
    }
}

