/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.drawing.core;

import com.guidebee.game.engine.drawing.core.BrushFP;
import com.guidebee.game.engine.drawing.core.MathFP;
import com.guidebee.game.engine.drawing.core.MatrixFP;
import com.guidebee.game.engine.drawing.core.PointFP;

public class RadialGradientBrushFP
extends BrushFP {
    private static final int RATIO_BITS = 10;
    private static final int RATIO_MAX = 1023;
    private int[] gradientColors = new int[1024];
    private int[] ratios = new int[64];
    private int ratioCount = 0;
    private int ff_radius;
    private int ff_currpos;
    protected PointFP centerPt = new PointFP();
    private final PointFP nextPt = new PointFP(0, 0);

    public RadialGradientBrushFP(int ff_x, int ff_y, int ff_radius, int ff_angle) {
        this.matrix = new MatrixFP();
        this.centerPt.reset(ff_x, ff_y);
        this.matrix.translate(-this.centerPt.x, -this.centerPt.y);
        this.matrix.rotate(-ff_angle);
        this.ff_radius = ff_radius;
    }

    public void setGradientColor(int ratio, int color) {
        int i;
        int n = (ratio >>= 6) < 0 ? 0 : (ratio = ratio > 1023 ? 1023 : ratio);
        if (this.ratioCount == this.ratios.length) {
            int[] rs = new int[this.ratioCount + 16];
            System.arraycopy(this.ratios, 0, rs, 0, this.ratioCount);
            this.ratios = rs;
        }
        this.gradientColors[ratio] = color;
        for (i = this.ratioCount; i > 0 && ratio < this.ratios[i - 1]; --i) {
        }
        if (i <= 0 || ratio != this.ratios[i]) {
            if (i < this.ratioCount) {
                System.arraycopy(this.ratios, i, this.ratios, i + 1, this.ratioCount - i);
            }
            this.ratios[i] = ratio;
            ++this.ratioCount;
        }
    }

    public void updateGradientTable() {
        int i;
        if (this.ratioCount == 0) {
            return;
        }
        for (i = 0; i < this.ratios[0]; ++i) {
            this.gradientColors[i] = this.gradientColors[this.ratios[0]];
        }
        for (i = 1; i < this.ratioCount; ++i) {
            int r1 = this.ratios[i - 1];
            int r2 = this.ratios[i];
            for (int j = r1 + 1; j < r2; ++j) {
                this.gradientColors[j] = RadialGradientBrushFP.interpolate(this.gradientColors[r1], this.gradientColors[r2], 256 * (j - r1) / (r2 - r1));
            }
        }
        for (i = this.ratios[this.ratioCount - 1]; i <= 1023; ++i) {
            this.gradientColors[i] = this.gradientColors[this.ratios[this.ratioCount - 1]];
        }
    }

    @Override
    public boolean isMonoColor() {
        return false;
    }

    @Override
    public int getColorAt(int x, int y, boolean singlePoint) {
        PointFP p = new PointFP(x << 16, y << 16);
        this.nextPt.x = p.x + 65536;
        this.nextPt.y = p.y;
        PointFP newCenterPt = new PointFP(this.centerPt);
        if (this.finalMatrix != null) {
            p.transform(this.finalMatrix);
        }
        this.ff_currpos = MathFP.div(PointFP.distance(p.x - newCenterPt.x, p.y - newCenterPt.y), this.ff_radius);
        int pos = this.ff_currpos >> 6;
        switch (this.fillMode) {
            case 1: {
                pos = (pos %= 2046) < 0 ? pos + 2046 : pos;
                pos = pos < 1023 ? pos : 2046 - pos;
                break;
            }
            case 2: {
                pos = (pos %= 1023) < 0 ? pos + 1023 : pos;
                break;
            }
            case 0: {
                pos = pos < 0 ? 0 : (pos > 1023 ? 1023 : pos);
            }
        }
        return this.gradientColors[pos];
    }

    @Override
    public int getNextColor() {
        PointFP p = new PointFP(this.nextPt);
        this.nextPt.x = p.x + 65536;
        this.nextPt.y = p.y;
        PointFP newCenterPt = new PointFP(this.centerPt);
        if (this.finalMatrix != null) {
            p.transform(this.finalMatrix);
        }
        this.ff_currpos = MathFP.div(PointFP.distance(p.x - newCenterPt.x, p.y - newCenterPt.y), this.ff_radius);
        int pos = this.ff_currpos >> 6;
        switch (this.fillMode) {
            case 1: {
                pos = (pos %= 2046) < 0 ? pos + 2046 : pos;
                pos = pos < 1023 ? pos : 2046 - pos;
                break;
            }
            case 2: {
                pos = (pos %= 1023) < 0 ? pos + 1023 : pos;
                break;
            }
            case 0: {
                pos = pos < 0 ? 0 : (pos > 1023 ? 1023 : pos);
            }
        }
        return this.gradientColors[pos];
    }

    private static int interpolate(int a, int b, int pos) {
        int p2 = pos & 0xFF;
        int p1 = 255 - p2;
        int ca = (a >> 24 & 0xFF) * p1 + (b >> 24 & 0xFF) * p2;
        int cr = (a >> 16 & 0xFF) * p1 + (b >> 16 & 0xFF) * p2;
        int cg = (a >> 8 & 0xFF) * p1 + (b >> 8 & 0xFF) * p2;
        int cb = (a & 0xFF) * p1 + (b & 0xFF) * p2;
        return ca >> 8 << 24 | cr >> 8 << 16 | cg >> 8 << 8 | cb >> 8;
    }
}

