/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.drawing.core;

import com.guidebee.game.engine.drawing.core.BrushFP;
import com.guidebee.game.engine.drawing.core.SolidBrushFP;

public final class PenFP {
    public static final int LINECAP_BUTT = 1;
    public static final int LINECAP_ROUND = 2;
    public static final int LINECAP_SQUARE = 3;
    public static final int LINEJOIN_MITER = 1;
    public static final int LINEJOIN_ROUND = 2;
    public static final int LINEJOIN_BEVEL = 3;
    public int width;
    public int lineJoin;
    public BrushFP brush;
    public int startCap;
    public int endCap;
    public int[] dashArray = null;

    public PenFP(int color) {
        this(color, 65536);
    }

    public PenFP(int color, int ff_width) {
        this(color, ff_width, 1, 1, 1);
    }

    public PenFP(int color, int ff_width, int linecap, int linejoin) {
        this(color, ff_width, linecap, linecap, linejoin);
    }

    public PenFP(BrushFP brush, int ff_width, int linecap, int linejoin) {
        this(brush, ff_width, linecap, linecap, linejoin);
    }

    public PenFP(int color, int ff_width, int startlinecap, int endlinecap, int linejoin) {
        this(new SolidBrushFP(color), ff_width, startlinecap, endlinecap, linejoin);
    }

    public PenFP(BrushFP brush, int ff_width, int startlinecap, int endlinecap, int linejoin) {
        this.brush = brush;
        this.width = ff_width;
        this.startCap = startlinecap;
        this.endCap = endlinecap;
        this.lineJoin = linejoin;
    }

    public void setDashArray(int[] dashArray, int offset) {
        int len = dashArray.length - offset;
        this.dashArray = null;
        if (len > 1) {
            this.dashArray = new int[len];
            System.arraycopy(dashArray, offset, this.dashArray, 0, len);
        }
    }
}

